/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.tregex.parser.ast;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.regex.result.PreCalculatedResultFactory;
import com.oracle.truffle.regex.tregex.util.json.Json;
import com.oracle.truffle.regex.tregex.util.json.JsonArray;
import com.oracle.truffle.regex.tregex.util.json.JsonConvertible;
import com.oracle.truffle.regex.tregex.util.json.JsonValue;
import com.oracle.truffle.regex.util.CompilationFinalBitSet;
import java.util.Objects;
import java.util.PrimitiveIterator;

public class GroupBoundaries
implements JsonConvertible {
    private static final GroupBoundaries EMPTY_INSTANCE = new GroupBoundaries(new CompilationFinalBitSet(0), new CompilationFinalBitSet(0));
    private static final byte[] EMPTY_ARRAY = new byte[0];
    private final CompilationFinalBitSet updateIndices;
    private final CompilationFinalBitSet clearIndices;
    private final int cachedHash;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private byte[] updateArray;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private byte[] clearArray;

    GroupBoundaries(CompilationFinalBitSet updateIndices, CompilationFinalBitSet clearIndices) {
        this.updateIndices = updateIndices;
        this.clearIndices = clearIndices;
        this.cachedHash = Objects.hashCode(updateIndices) * 31 + Objects.hashCode(clearIndices);
    }

    public static GroupBoundaries getEmptyInstance() {
        return EMPTY_INSTANCE;
    }

    public boolean isEmpty() {
        assert (!this.updateIndices.isEmpty() || !this.clearIndices.isEmpty() || this == EMPTY_INSTANCE);
        return this == EMPTY_INSTANCE;
    }

    public byte[] updatesToPartialTransitionArray(int targetArray) {
        return GroupBoundaries.createPartialTransitionArray(targetArray, this.updateIndices);
    }

    public byte[] clearsToPartialTransitionArray(int targetArray) {
        return GroupBoundaries.createPartialTransitionArray(targetArray, this.clearIndices);
    }

    private static byte[] createPartialTransitionArray(int targetArray, CompilationFinalBitSet indices) {
        assert (!indices.isEmpty()) : "should not be called on empty sets";
        byte[] indexUpdate = new byte[indices.numberOfSetBits() + 1];
        indexUpdate[0] = (byte)targetArray;
        GroupBoundaries.writeIndicesToArray(indices, indexUpdate, 1);
        return indexUpdate;
    }

    private static void writeIndicesToArray(CompilationFinalBitSet indices, byte[] array, int offset) {
        int i = offset;
        PrimitiveIterator.OfInt ofInt = indices.iterator();
        while (ofInt.hasNext()) {
            int j = (Integer)ofInt.next();
            assert (j < 256);
            array[i++] = (byte)j;
        }
    }

    public void materializeArrays() {
        if (this != EMPTY_INSTANCE && this.updateArray == null) {
            this.updateArray = GroupBoundaries.indicesToArray(this.updateIndices);
            this.clearArray = GroupBoundaries.indicesToArray(this.clearIndices);
        }
    }

    private static byte[] indicesToArray(CompilationFinalBitSet indices) {
        if (indices.isEmpty()) {
            return EMPTY_ARRAY;
        }
        byte[] array = new byte[indices.numberOfSetBits()];
        GroupBoundaries.writeIndicesToArray(indices, array, 0);
        return array;
    }

    public CompilationFinalBitSet getUpdateIndices() {
        return this.updateIndices;
    }

    public CompilationFinalBitSet getClearIndices() {
        return this.clearIndices;
    }

    public byte[] getUpdateIndicesArray() {
        return this.updateArray;
    }

    public byte[] getClearIndicesArray() {
        return this.clearArray;
    }

    public boolean hasIndexUpdates() {
        return !this.updateIndices.isEmpty();
    }

    public boolean hasIndexClears() {
        return !this.clearIndices.isEmpty();
    }

    public void updateBitSets(CompilationFinalBitSet foreignUpdateIndices, CompilationFinalBitSet foreignClearIndices) {
        foreignUpdateIndices.union(this.updateIndices);
        foreignClearIndices.union(this.clearIndices);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof GroupBoundaries)) {
            return false;
        }
        GroupBoundaries o = (GroupBoundaries)obj;
        return Objects.equals(this.updateIndices, o.updateIndices) && Objects.equals(this.clearIndices, o.clearIndices);
    }

    public int hashCode() {
        return this.cachedHash;
    }

    public void applyToResultFactory(PreCalculatedResultFactory resultFactory, int index) {
        if (this.hasIndexUpdates()) {
            resultFactory.updateIndices(this.updateIndices, index);
        }
    }

    public void apply(int[] array, int offset, int index) {
        if (this == EMPTY_INSTANCE) {
            return;
        }
        for (byte i : this.clearArray) {
            array[offset + Byte.toUnsignedInt((byte)i)] = -1;
        }
        for (byte i : this.updateArray) {
            array[offset + Byte.toUnsignedInt((byte)i)] = index;
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.hasIndexUpdates()) {
            GroupBoundaries.appendBitSet(sb, this.updateIndices, false).append(")(");
            GroupBoundaries.appendBitSet(sb, this.updateIndices, true);
        }
        if (this.hasIndexClears()) {
            sb.append(" clr{");
            GroupBoundaries.appendBitSet(sb, this.clearIndices, false).append(")(");
            GroupBoundaries.appendBitSet(sb, this.clearIndices, true);
            sb.append("}");
        }
        return sb.toString();
    }

    @CompilerDirectives.TruffleBoundary
    private static StringBuilder appendBitSet(StringBuilder sb, CompilationFinalBitSet gbBitSet, boolean entries) {
        boolean first = true;
        if (gbBitSet != null) {
            PrimitiveIterator.OfInt ofInt = gbBitSet.iterator();
            while (ofInt.hasNext()) {
                int i = (Integer)ofInt.next();
                if ((i & 1) != (entries ? 0 : 1)) continue;
                if (first) {
                    first = false;
                } else {
                    sb.append(",");
                }
                sb.append(Json.val(i / 2));
            }
        }
        return sb;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public JsonValue toJson() {
        return Json.obj(Json.prop("updateEnter", GroupBoundaries.gbBitSetGroupEntriesToJsonArray(this.updateIndices)), Json.prop("updateExit", GroupBoundaries.gbBitSetGroupExitsToJsonArray(this.updateIndices)), Json.prop("clearEnter", GroupBoundaries.gbBitSetGroupEntriesToJsonArray(this.clearIndices)), Json.prop("clearExit", GroupBoundaries.gbBitSetGroupExitsToJsonArray(this.clearIndices)));
    }

    @CompilerDirectives.TruffleBoundary
    private static JsonArray gbBitSetGroupEntriesToJsonArray(CompilationFinalBitSet gbArray) {
        return GroupBoundaries.gbBitSetGroupPartToJsonArray(gbArray, true);
    }

    @CompilerDirectives.TruffleBoundary
    private static JsonArray gbBitSetGroupExitsToJsonArray(CompilationFinalBitSet gbArray) {
        return GroupBoundaries.gbBitSetGroupPartToJsonArray(gbArray, false);
    }

    @CompilerDirectives.TruffleBoundary
    private static JsonArray gbBitSetGroupPartToJsonArray(CompilationFinalBitSet gbBitSet, boolean entries) {
        JsonArray array = Json.array(new JsonConvertible[0]);
        if (gbBitSet != null) {
            PrimitiveIterator.OfInt ofInt = gbBitSet.iterator();
            while (ofInt.hasNext()) {
                int i = (Integer)ofInt.next();
                if ((i & 1) != (entries ? 0 : 1)) continue;
                array.append(Json.val(i / 2));
            }
        }
        return array;
    }
}

