/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.classpath;

import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.event.ChangeListener;
import org.apache.maven.model.Resource;
import org.apache.maven.project.MavenProject;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.api.queries.SharabilityQuery;
import org.netbeans.modules.maven.NbMavenProjectImpl;
import org.netbeans.modules.maven.api.FileUtilities;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.classpath.Bundle;
import org.netbeans.modules.maven.spi.nodes.NodeUtils;
import org.netbeans.modules.maven.spi.nodes.OtherSourcesExclude;
import org.netbeans.spi.project.SourceGroupModifierImplementation;
import org.netbeans.spi.project.support.GenericSources;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.ChangeSupport;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.Utilities;

public class MavenSourcesImpl
implements Sources,
SourceGroupModifierImplementation,
OtherSourcesExclude {
    public static final String TYPE_OTHER = "Resources";
    public static final String TYPE_TEST_OTHER = "TestResources";
    public static final String TYPE_GEN_SOURCES = "GeneratedSources";
    public static final String NAME_PROJECTROOT = "ProjectRoot";
    public static final String NAME_XDOCS = "XDocs";
    public static final String NAME_SOURCE = "1SourceRoot";
    public static final String NAME_TESTSOURCE = "2TestSourceRoot";
    public static final String NAME_GENERATED_SOURCE = "6GeneratedSourceRoot";
    public static final String NAME_GENERATED_TEST_SOURCE = "7GeneratedSourceRoot";
    private static final String OTHERS_BADGE = "org/netbeans/modules/maven/others-badge.png";
    private final Project proj;
    private final ChangeSupport cs = new ChangeSupport((Object)this);
    private final PropertyChangeListener pcl = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (((NbMavenProject)MavenSourcesImpl.this.proj.getLookup().lookup(NbMavenProject.class)).isUnloadable()) {
                return;
            }
            if ("RESOURCES".equals(evt.getPropertyName()) || "MavenProject".equals(evt.getPropertyName())) {
                MavenSourcesImpl.this.checkChanges(true, true);
            }
        }
    };
    private final Map<String, SourceGroup> javaGroup;
    private final Map<File, SourceGroup> genSrcGroup;
    private final Map<File, OtherGroup> otherMainGroups;
    private final Map<File, OtherGroup> otherTestGroups;
    private final Object lock = new Object();

    public MavenSourcesImpl(Project proj) {
        this.proj = proj;
        this.javaGroup = new TreeMap<String, SourceGroup>();
        this.genSrcGroup = new TreeMap<File, SourceGroup>();
        this.otherMainGroups = new TreeMap<File, OtherGroup>();
        this.otherTestGroups = new TreeMap<File, OtherGroup>();
    }

    private NbMavenProjectImpl project() {
        return (NbMavenProjectImpl)this.proj.getLookup().lookup(NbMavenProjectImpl.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkChanges(boolean fireChanges, boolean checkAlsoNonJavaStuff) {
        boolean changed = false;
        Object object = this.lock;
        synchronized (object) {
            NbMavenProjectImpl project = this.project();
            MavenProject mp = project.getOriginalMavenProject();
            NbMavenProject watcher = project.getProjectWatcher();
            File folder = FileUtilities.convertStringToFile(mp.getBuild().getSourceDirectory());
            changed |= this.checkSourceGroupCache(folder, NAME_SOURCE, Bundle.SG_Sources(), this.javaGroup, watcher);
            folder = FileUtilities.convertStringToFile(mp.getBuild().getTestSourceDirectory());
            changed |= this.checkSourceGroupCache(folder, NAME_TESTSOURCE, Bundle.SG_Test_Sources(), this.javaGroup, watcher);
            changed |= this.checkGeneratedGroupsCache();
            if (checkAlsoNonJavaStuff) {
                changed |= this.checkOtherGroupsCache(project.getOtherRoots(false), false);
                changed |= this.checkOtherGroupsCache(project.getOtherRoots(true), true);
            }
        }
        if (changed && fireChanges) {
            this.cs.fireChange();
        }
    }

    public void addChangeListener(ChangeListener changeListener) {
        if (!this.cs.hasListeners()) {
            NbMavenProject.addPropertyChangeListener(this.project(), this.pcl);
        }
        this.cs.addChangeListener(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.cs.removeChangeListener(changeListener);
        if (!this.cs.hasListeners()) {
            NbMavenProject.removePropertyChangeListener(this.project(), this.pcl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SourceGroup[] getSourceGroups(String str) {
        if ("generic".equals(str)) {
            return new SourceGroup[]{GenericSources.group((Project)this.proj, (FileObject)this.proj.getProjectDirectory(), (String)NAME_PROJECTROOT, (String)ProjectUtils.getInformation((Project)this.proj).getDisplayName(), null, null)};
        }
        if ("java".equals(str)) {
            ArrayList<SourceGroup> toReturn = new ArrayList<SourceGroup>();
            Object object = this.lock;
            synchronized (object) {
                this.checkChanges(false, false);
                toReturn.addAll(this.javaGroup.values());
            }
            SourceGroup[] grp = new SourceGroup[toReturn.size()];
            grp = toReturn.toArray(grp);
            return grp;
        }
        if (TYPE_GEN_SOURCES.equals(str)) {
            ArrayList<SourceGroup> toReturn = new ArrayList<SourceGroup>();
            SourceGroup[] grp = this.lock;
            synchronized (this.lock) {
                this.checkGeneratedGroupsCache();
                toReturn.addAll(this.genSrcGroup.values());
                // ** MonitorExit[grp] (shouldn't be in output)
                grp = new SourceGroup[toReturn.size()];
                grp = toReturn.toArray(grp);
                return grp;
            }
        }
        if (TYPE_OTHER.equals(str) || TYPE_TEST_OTHER.equals(str)) {
            boolean test = TYPE_TEST_OTHER.equals(str);
            ArrayList<OtherGroup> toReturn = new ArrayList<OtherGroup>();
            File[] roots = this.project().getOtherRoots(test);
            Object object = this.lock;
            synchronized (object) {
                this.checkOtherGroupsCache(roots, test);
                if (test && !this.otherTestGroups.isEmpty()) {
                    toReturn.addAll(this.otherTestGroups.values());
                } else if (!test && !this.otherMainGroups.isEmpty()) {
                    toReturn.addAll(this.otherMainGroups.values());
                }
            }
            SourceGroup[] grp = new SourceGroup[toReturn.size()];
            grp = toReturn.toArray(grp);
            return grp;
        }
        if ("resources".equals(str)) {
            return this.getOrCreateResourceSourceGroup(false, false);
        }
        return new SourceGroup[0];
    }

    private SourceGroup[] getOrCreateResourceSourceGroup(boolean test, boolean create) {
        URI[] uris = this.project().getResources(test);
        if (uris.length > 0) {
            ArrayList<URI> virtuals = new ArrayList<URI>();
            ArrayList<SourceGroup> existing = new ArrayList<SourceGroup>();
            for (URI u : uris) {
                FileObject fo = FileUtilities.convertURItoFileObject(u);
                if (fo == null) {
                    virtuals.add(u);
                    continue;
                }
                if (!fo.isFolder()) continue;
                existing.add(GenericSources.group((Project)this.proj, (FileObject)fo, (String)"resources", (String)Bundle.SG_Project_Resources(), null, null));
            }
            if (create && existing.isEmpty()) {
                File root = Utilities.toFile((URI)((URI)virtuals.get(0)));
                try {
                    FileObject fo = FileUtil.createFolder((File)root);
                    existing.add(GenericSources.group((Project)this.proj, (FileObject)fo, (String)"resources", (String)Bundle.SG_Project_Resources(), null, null));
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            return existing.toArray(new SourceGroup[0]);
        }
        return new SourceGroup[0];
    }

    private boolean checkSourceGroupCache(@NullAllowed File rootF, String name, String displayName, Map<String, SourceGroup> groups, NbMavenProject watcher) {
        FileObject root;
        if (rootF != null) {
            watcher.addWatchedPath(Utilities.toURI((File)rootF));
            root = FileUtil.toFileObject((File)rootF);
        } else {
            root = null;
        }
        SourceGroup group = groups.get(name);
        if ((root == null || root.isData()) && group != null) {
            groups.remove(name);
            return true;
        }
        if (root == null || root.isData()) {
            return false;
        }
        boolean changed = false;
        if (group == null) {
            group = GenericSources.group((Project)this.proj, (FileObject)root, (String)name, (String)displayName, null, null);
            groups.put(name, group);
            changed = true;
        } else if (!group.getRootFolder().equals(root)) {
            group = GenericSources.group((Project)this.proj, (FileObject)root, (String)name, (String)displayName, null, null);
            groups.put(name, group);
            changed = true;
        }
        return changed;
    }

    private boolean checkGeneratedGroupsCache() {
        boolean changed = false;
        ArrayList<File> checked = new ArrayList<File>();
        for (boolean test : new boolean[]{false, true}) {
            for (URI u : this.project().getGeneratedSourceRoots(test)) {
                File file = FileUtil.normalizeFile((File)Utilities.toFile((URI)u));
                FileObject folder = FileUtil.toFileObject((File)file);
                changed |= this.checkGeneratedGroupCache(folder, file, file.getName(), test);
                checked.add(file);
            }
        }
        HashSet<File> currs = new HashSet<File>();
        currs.addAll(this.genSrcGroup.keySet());
        for (File curr : currs) {
            if (checked.contains(curr)) continue;
            this.genSrcGroup.remove(curr);
            changed = true;
        }
        return changed;
    }

    private boolean checkGeneratedGroupCache(FileObject root, File rootFile, String nameSuffix, boolean test) {
        String displayName;
        SourceGroup group = this.genSrcGroup.get(rootFile);
        if ((root == null || root.isData()) && group != null) {
            this.genSrcGroup.remove(rootFile);
            return true;
        }
        if (root == null || root.isData()) {
            return false;
        }
        boolean changed = false;
        String name = (test ? NAME_GENERATED_TEST_SOURCE : NAME_GENERATED_SOURCE) + nameSuffix;
        String string = displayName = test ? Bundle.SG_Generated_Test_Sources(nameSuffix) : Bundle.SG_Generated_Sources(nameSuffix);
        if (group == null) {
            group = new GeneratedGroup(this.project(), root, name, displayName);
            this.genSrcGroup.put(rootFile, group);
            changed = true;
        } else if (!group.getRootFolder().isValid() || !group.getRootFolder().equals(root)) {
            group = new GeneratedGroup(this.project(), root, name, displayName);
            this.genSrcGroup.put(rootFile, group);
            changed = true;
        }
        return changed;
    }

    private boolean checkOtherGroupsCache(File[] roots, boolean test) {
        boolean ch = false;
        HashSet<File> toRemove = new HashSet<File>(test ? this.otherTestGroups.keySet() : this.otherMainGroups.keySet());
        toRemove.removeAll(Arrays.asList(roots));
        URI[] res = this.project().getResources(test);
        HashSet<File> resources = new HashSet<File>();
        for (URI uRI : res) {
            resources.add(Utilities.toFile((URI)uRI));
        }
        for (Comparable<URI> comparable : roots) {
            ch |= this.checkOtherGroup((File)comparable, (Set<File>)resources, test);
        }
        for (File f : toRemove) {
            ch |= this.checkOtherGroup(f, resources, test);
        }
        return ch;
    }

    private boolean checkOtherGroup(File rootFile, Set<File> resourceRoots, boolean test) {
        boolean wasResourceBefore;
        FileObject root = FileUtil.toFileObject((File)rootFile);
        if (root != null && !root.isFolder()) {
            root = null;
        }
        Map<File, OtherGroup> map = test ? this.otherTestGroups : this.otherMainGroups;
        OtherGroup grp = map.get(rootFile);
        boolean isResourceNow = resourceRoots.contains(rootFile);
        boolean bl = wasResourceBefore = grp != null && grp.getResource() != null;
        if (root == null && grp != null || root != null && grp != null && wasResourceBefore && !isResourceNow) {
            map.remove(rootFile);
            return true;
        }
        if (root == null) {
            return false;
        }
        boolean changed = false;
        if (grp == null || !grp.getRootFolder().isValid() || !grp.getRootFolder().equals(root) || isResourceNow != wasResourceBefore) {
            grp = new OtherGroup(this.project(), root, "Resource" + (test ? "Test" : "Main") + root.getNameExt(), root.getName(), test);
            map.put(rootFile, grp);
            changed = true;
        }
        return changed;
    }

    public SourceGroup createSourceGroup(String type, String hint) {
        assert (type != null);
        MavenProject mp = this.project().getOriginalMavenProject();
        File folder = null;
        if ("resources".equals(type)) {
            boolean main = "main".equals(hint);
            SourceGroup[] grps = this.getOrCreateResourceSourceGroup(!main, true);
            if (grps.length > 0) {
                return grps[0];
            }
            return null;
        }
        if ("java".equals(type)) {
            if ("main".equals(hint)) {
                folder = FileUtilities.convertStringToFile(mp.getBuild().getSourceDirectory());
            }
            if ("test".equals(hint)) {
                folder = FileUtilities.convertStringToFile(mp.getBuild().getTestSourceDirectory());
            }
        }
        if (folder != null) {
            SourceGroup[] grps;
            FileObject fo;
            try {
                fo = FileUtil.createFolder(folder);
            }
            catch (IOException x) {
                Logger.getLogger(MavenSourcesImpl.class.getName()).log(Level.INFO, null, x);
                return null;
            }
            for (SourceGroup sg : grps = this.getSourceGroups(type)) {
                if (!fo.equals(sg.getRootFolder())) continue;
                return sg;
            }
        }
        return null;
    }

    public boolean canCreateSourceGroup(String type, String hint) {
        return !(!"resources".equals(type) && !"java".equals(type) || !"main".equals(hint) && !"test".equals(hint));
    }

    @Override
    public Set<Path> excludedFolders() {
        HashSet<Path> result = new HashSet<Path>();
        FileObject mainDir = this.project().getProjectDirectory().getFileObject("src/main/java");
        FileObject testDir = this.project().getProjectDirectory().getFileObject("src/test/java");
        if (mainDir != null) {
            result.add(FileUtil.toFile((FileObject)mainDir).toPath());
        }
        if (testDir != null) {
            result.add(FileUtil.toFile((FileObject)testDir).toPath());
        }
        return result;
    }

    public static final class GeneratedGroup
    implements SourceGroup {
        private final FileObject rootFolder;
        private final String name;
        private final String displayName;
        private final Icon icon = null;
        private final Icon openedIcon = null;
        private NbMavenProjectImpl project;

        GeneratedGroup(NbMavenProjectImpl p, FileObject rootFold, String nm, String displayNm) {
            this.project = p;
            this.rootFolder = rootFold;
            this.name = nm;
            this.displayName = displayNm != null ? displayNm : Bundle.SG_Root_not_defined();
        }

        public FileObject getRootFolder() {
            return this.rootFolder;
        }

        public String getName() {
            return this.name;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public Icon getIcon(boolean opened) {
            return opened ? this.icon : this.openedIcon;
        }

        public boolean contains(FileObject file) {
            if (file != this.rootFolder && !FileUtil.isParentOf((FileObject)this.rootFolder, (FileObject)file)) {
                return false;
            }
            if (this.project != null) {
                if (file.isFolder() && file != this.project.getProjectDirectory() && ProjectManager.getDefault().isProject(file)) {
                    return false;
                }
                if (FileOwnerQuery.getOwner((FileObject)file) != this.project) {
                    return false;
                }
            }
            return true;
        }

        public void addPropertyChangeListener(PropertyChangeListener l) {
        }

        public void removePropertyChangeListener(PropertyChangeListener l) {
        }
    }

    public static final class OtherGroup
    implements SourceGroup {
        private final FileObject rootFolder;
        private final File rootFile;
        private final String name;
        private final String displayName;
        private final Icon icon;
        private final Icon openedIcon;
        private final NbMavenProjectImpl project;
        private final Resource resource;
        private final PropertyChangeSupport support = new PropertyChangeSupport(this);

        OtherGroup(NbMavenProjectImpl p, FileObject rootFold, String nm, String displayNm, boolean test) {
            this.project = p;
            this.rootFolder = rootFold;
            this.rootFile = FileUtil.toFile((FileObject)this.rootFolder);
            this.resource = this.checkResource(rootFold, test ? this.project.getOriginalMavenProject().getTestResources() : this.project.getOriginalMavenProject().getResources());
            if (this.resource != null) {
                Image badge = ImageUtilities.loadImage((String)MavenSourcesImpl.OTHERS_BADGE, (boolean)true);
                this.icon = ImageUtilities.image2Icon((Image)ImageUtilities.mergeImages((Image)NodeUtils.getTreeFolderIcon(false), (Image)badge, (int)8, (int)8));
                this.openedIcon = ImageUtilities.image2Icon((Image)ImageUtilities.mergeImages((Image)NodeUtils.getTreeFolderIcon(true), (Image)badge, (int)8, (int)8));
                this.displayName = this.name = FileUtilities.relativizeFile(FileUtil.toFile((FileObject)this.project.getProjectDirectory()), FileUtilities.convertStringToFile(this.resource.getDirectory()));
            } else {
                this.icon = ImageUtilities.image2Icon((Image)NodeUtils.getTreeFolderIcon(false));
                this.openedIcon = ImageUtilities.image2Icon((Image)NodeUtils.getTreeFolderIcon(true));
                this.name = nm;
                this.displayName = displayNm != null ? displayNm : Bundle.SG_Root_not_defined();
            }
        }

        public FileObject getRootFolder() {
            return this.rootFolder;
        }

        public File getRootFolderFile() {
            return this.rootFile;
        }

        public Resource getResource() {
            return this.resource;
        }

        public String getName() {
            return this.name;
        }

        public String getDisplayName() {
            if (this.resource != null && this.resource.getTargetPath() != null) {
                return this.displayName + " -> " + this.resource.getTargetPath();
            }
            return this.displayName;
        }

        public Icon getIcon(boolean opened) {
            return opened ? this.icon : this.openedIcon;
        }

        public boolean contains(FileObject file) {
            File f;
            if (file != this.rootFolder && !FileUtil.isParentOf((FileObject)this.rootFolder, (FileObject)file)) {
                return false;
            }
            if (this.project != null) {
                if (file.isFolder() && file != this.project.getProjectDirectory() && ProjectManager.getDefault().isProject(file)) {
                    return false;
                }
                if (FileOwnerQuery.getOwner((FileObject)file) != this.project) {
                    return false;
                }
            }
            if ((f = FileUtil.toFile((FileObject)file)) != null) {
                return SharabilityQuery.getSharability((File)f) != 2;
            }
            return true;
        }

        public void addPropertyChangeListener(PropertyChangeListener l) {
            this.support.addPropertyChangeListener(l);
        }

        public void removePropertyChangeListener(PropertyChangeListener l) {
            this.support.removePropertyChangeListener(l);
        }

        private Resource checkResource(FileObject rootFold, List<Resource> list) {
            for (Resource elem : list) {
                URI uri;
                FileObject fo;
                String dir = elem.getDirectory();
                if (dir == null || (fo = FileUtilities.convertURItoFileObject(uri = FileUtilities.getDirURI(this.project.getProjectDirectory(), dir))) == null || !fo.equals(rootFold)) continue;
                return elem;
            }
            return null;
        }
    }
}

