/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.newproject;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.validation.adapters.WizardDescriptorAdapter;
import org.netbeans.modules.maven.api.archetype.Archetype;
import org.netbeans.modules.maven.api.archetype.ArchetypeWizards;
import org.netbeans.modules.maven.newproject.ArchetypeWizardUtils;
import org.netbeans.modules.maven.newproject.BasicWizardPanel;
import org.netbeans.modules.maven.newproject.Bundle;
import org.netbeans.modules.maven.newproject.ChooseWizardPanel;
import org.netbeans.validation.api.ui.ValidationGroup;
import org.netbeans.validation.api.ui.ValidationUI;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;

public class MavenWizardIterator
implements WizardDescriptor.BackgroundInstantiatingIterator<WizardDescriptor> {
    private static final long serialVersionUID = 1L;
    static final String PROPERTY_CUSTOM_CREATOR = "customCreator";
    static final String PROP_ARCHETYPE = "archetype";
    static final String JAVAFX_SAMPLES_TEMPLATE_FOLDER = "Project/Samples/JavaFXMaven";
    private transient int index;
    private transient List<WizardDescriptor.Panel<WizardDescriptor>> panels;
    private transient WizardDescriptor wiz;
    private final Archetype archetype;
    private final AtomicBoolean hasNextCalled = new AtomicBoolean();
    private final String titlename;
    private final Map<String, String> defaultProps;

    public MavenWizardIterator() {
        this(null, null, null);
    }

    public MavenWizardIterator(Archetype archetype, String titleName, Map<String, String> defaultProps) {
        this.archetype = archetype;
        this.titlename = titleName;
        this.defaultProps = defaultProps;
    }

    public static WizardDescriptor.InstantiatingIterator<?> openJFXFML() {
        return MavenWizardIterator.definedFXArchetype("com.raelity.jfx", "javafx-archetype-fxml-netbeans", "0.0.4", Bundle.LBL_Maven_FXML_Archetype());
    }

    public static WizardDescriptor.InstantiatingIterator<?> openJFXSimple() {
        return MavenWizardIterator.definedFXArchetype("com.raelity.jfx", "javafx-archetype-simple-netbeans", "0.0.4", Bundle.LBL_Maven_Simple_Archetype());
    }

    private static WizardDescriptor.InstantiatingIterator<?> definedFXArchetype(String g, String a, String v, String name) {
        HashMap<String, String> props = new HashMap<String, String>();
        if (System.getProperty("java.version").startsWith("1.8")) {
            props.put("javafx-version", "1.8");
        }
        props.put("add-debug-configuration", "Y");
        return ArchetypeWizards.definedArchetype(g, a, v, null, name, props);
    }

    public Set<FileObject> instantiate() throws IOException {
        return ArchetypeWizardUtils.instantiate(this.wiz);
    }

    public void initialize(WizardDescriptor wiz) {
        this.wiz = wiz;
        if (this.titlename != null) {
            wiz.putProperty("NewProjectWizard_Title", (Object)this.titlename);
        }
        this.index = 0;
        ValidationGroup vg = ValidationGroup.create((ValidationUI[])new ValidationUI[]{new WizardDescriptorAdapter(wiz)});
        this.panels = new ArrayList<WizardDescriptor.Panel<WizardDescriptor>>();
        ArrayList<String> steps = new ArrayList<String>();
        if (this.archetype == null) {
            this.panels.add((WizardDescriptor.Panel<WizardDescriptor>)new ChooseWizardPanel());
            steps.add(Bundle.LBL_CreateProjectStep());
        }
        this.panels.add((WizardDescriptor.Panel<WizardDescriptor>)new BasicWizardPanel(vg, null, true, true, this.defaultProps));
        steps.add(Bundle.LBL_CreateProjectStep2());
        for (int i = 0; i < this.panels.size(); ++i) {
            JComponent c = (JComponent)this.panels.get(i).getComponent();
            c.putClientProperty("WizardPanel_contentSelectedIndex", i);
            c.putClientProperty("WizardPanel_contentData", steps.toArray(new String[0]));
        }
        if (this.archetype != null) {
            wiz.putProperty(PROP_ARCHETYPE, (Object)this.archetype);
        }
    }

    public void uninitialize(WizardDescriptor wiz) {
        wiz.putProperty("name", null);
        this.wiz = null;
        this.panels = null;
    }

    public String name() {
        return Bundle.NameFormat(this.index + 1, this.panels.size());
    }

    public boolean hasNext() {
        this.hasNextCalled.set(true);
        return this.hasNextImpl();
    }

    private boolean hasNextImpl() {
        return this.index < this.panels.size() - 1;
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public void nextPanel() {
        boolean hnc = this.hasNextCalled.getAndSet(false);
        if (!this.hasNextImpl()) {
            throw new NoSuchElementException(MessageFormat.format("index: {0}, panels: {1}, called has next: {2}", this.index, this.panels.size(), hnc));
        }
        ++this.index;
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    public WizardDescriptor.Panel<WizardDescriptor> current() {
        return this.panels.get(this.index);
    }

    public void addChangeListener(ChangeListener l) {
    }

    public void removeChangeListener(ChangeListener l) {
    }
}

