/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.interop;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropAccessNode;
import com.oracle.truffle.api.interop.InteropException;
import com.oracle.truffle.api.interop.KnownMessage;
import com.oracle.truffle.api.interop.LegacyToLibraryNode;
import com.oracle.truffle.api.interop.Message;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.interop.impl.ReadOnlyArrayList;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import java.util.List;
import java.util.function.Supplier;

@Deprecated
public final class ForeignAccess {
    private final Factory factory;
    private final Supplier<? extends RootNode> languageCheckSupplier;
    private final Thread initThread;
    static final boolean LEGACY_TO_LIBRARY_BRIDGE = true;

    private ForeignAccess(Factory faf) {
        this(null, faf);
    }

    private ForeignAccess(Supplier<? extends RootNode> languageCheckSupplier, Factory faf) {
        this.factory = faf;
        this.initThread = null;
        this.languageCheckSupplier = languageCheckSupplier;
        CompilerAsserts.neverPartOfCompilation("do not create a ForeignAccess object from compiled code");
    }

    @Deprecated
    public static ForeignAccess create(Class<? extends TruffleObject> baseClass, StandardFactory factory) {
        if (baseClass == null) {
            Factory f = (Factory)((Object)factory);
            assert (f != null);
        }
        return new ForeignAccess(new DelegatingFactory(baseClass, factory));
    }

    @Deprecated
    public static ForeignAccess create(StandardFactory factory, RootNode languageCheck) {
        if (languageCheck == null) {
            Factory f = (Factory)((Object)factory);
            assert (f != null);
        }
        return new ForeignAccess(languageCheck == null ? null : new RootNodeSupplier(languageCheck), new DelegatingFactory(null, factory));
    }

    public static ForeignAccess createAccess(StandardFactory factory, Supplier<? extends RootNode> languageCheckSupplier) {
        if (languageCheckSupplier == null) {
            Factory f = (Factory)((Object)factory);
            assert (f != null);
        }
        return new ForeignAccess(languageCheckSupplier, new DelegatingFactory(null, factory));
    }

    @Deprecated
    public static ForeignAccess create(Factory factory) {
        return new ForeignAccess(factory);
    }

    @Deprecated
    public static Object send(Node foreignNode, TruffleObject receiver, Object ... arguments) throws InteropException {
        try {
            if (foreignNode instanceof LegacyToLibraryNode) {
                return ((LegacyToLibraryNode)foreignNode).send(receiver, arguments);
            }
            return ((InteropAccessNode)foreignNode).execute(receiver, arguments);
        }
        catch (InteropException e) {
            CompilerDirectives.transferToInterpreter();
            throw e;
        }
    }

    @Deprecated
    public static Object sendRead(Node readNode, TruffleObject receiver, Object identifier) throws UnknownIdentifierException, UnsupportedMessageException {
        try {
            assert (((LegacyToLibraryNode)readNode).message == Message.READ);
            return ((LegacyToLibraryNode)readNode).sendRead(receiver, identifier);
        }
        catch (UnsupportedMessageException e) {
            CompilerDirectives.transferToInterpreter();
            throw e;
        }
        catch (UnknownIdentifierException e) {
            CompilerDirectives.transferToInterpreter();
            throw e;
        }
        catch (InteropException e) {
            CompilerDirectives.transferToInterpreter();
            throw new AssertionError("Unexpected exception caught.", e);
        }
    }

    @Deprecated
    public static Object sendWrite(Node writeNode, TruffleObject receiver, Object identifier, Object value) throws UnknownIdentifierException, UnsupportedTypeException, UnsupportedMessageException {
        try {
            assert (((LegacyToLibraryNode)writeNode).message == Message.WRITE);
            ((LegacyToLibraryNode)writeNode).sendWrite(receiver, identifier, value);
            return value;
        }
        catch (UnknownIdentifierException | UnsupportedMessageException | UnsupportedTypeException e) {
            CompilerDirectives.transferToInterpreter();
            throw e;
        }
        catch (InteropException e) {
            CompilerDirectives.transferToInterpreter();
            throw new AssertionError("Unexpected exception caught.", e);
        }
    }

    @Deprecated
    public static boolean sendRemove(Node removeNode, TruffleObject receiver, Object identifier) throws UnknownIdentifierException, UnsupportedMessageException {
        try {
            assert (((LegacyToLibraryNode)removeNode).message == Message.REMOVE);
            return ((LegacyToLibraryNode)removeNode).sendRemove(receiver, identifier);
        }
        catch (UnsupportedTypeException e) {
            throw UnsupportedMessageException.create();
        }
        catch (UnknownIdentifierException | UnsupportedMessageException e) {
            CompilerDirectives.transferToInterpreter();
            throw e;
        }
        catch (InteropException e) {
            CompilerDirectives.transferToInterpreter();
            throw new AssertionError("Unexpected exception caught.", e);
        }
    }

    @Deprecated
    public static Object sendUnbox(Node unboxNode, TruffleObject receiver) throws UnsupportedMessageException {
        try {
            assert (((LegacyToLibraryNode)unboxNode).message == Message.UNBOX);
            return ((LegacyToLibraryNode)unboxNode).sendUnbox(receiver);
        }
        catch (UnsupportedMessageException e) {
            CompilerDirectives.transferToInterpreter();
            throw e;
        }
        catch (InteropException e) {
            CompilerDirectives.transferToInterpreter();
            throw new AssertionError("Unexpected exception caught.", e);
        }
    }

    @Deprecated
    public static boolean sendIsPointer(Node isPointerNode, TruffleObject receiver) {
        try {
            assert (((LegacyToLibraryNode)isPointerNode).message == Message.IS_POINTER);
            return ((LegacyToLibraryNode)isPointerNode).sendIsPointer(receiver);
        }
        catch (InteropException e) {
            CompilerDirectives.transferToInterpreter();
            throw new AssertionError("Unexpected exception caught.", e);
        }
    }

    @Deprecated
    public static long sendAsPointer(Node asPointerNode, TruffleObject receiver) throws UnsupportedMessageException {
        try {
            assert (((LegacyToLibraryNode)asPointerNode).message == Message.AS_POINTER);
            return ((LegacyToLibraryNode)asPointerNode).sendAsPointer(receiver);
        }
        catch (UnsupportedMessageException e) {
            CompilerDirectives.transferToInterpreter();
            throw e;
        }
        catch (InteropException e) {
            CompilerDirectives.transferToInterpreter();
            throw new AssertionError("Unexpected exception caught.", e);
        }
    }

    @Deprecated
    public static Object sendToNative(Node toNativeNode, TruffleObject receiver) throws UnsupportedMessageException {
        try {
            assert (((LegacyToLibraryNode)toNativeNode).message == Message.TO_NATIVE);
            return ((LegacyToLibraryNode)toNativeNode).sendToNative(receiver);
        }
        catch (UnsupportedMessageException e) {
            CompilerDirectives.transferToInterpreter();
            throw e;
        }
        catch (InteropException e) {
            CompilerDirectives.transferToInterpreter();
            throw new AssertionError("Unexpected exception caught.", e);
        }
    }

    @Deprecated
    public static Object sendExecute(Node executeNode, TruffleObject receiver, Object ... arguments) throws UnsupportedTypeException, ArityException, UnsupportedMessageException {
        try {
            assert (((LegacyToLibraryNode)executeNode).message == Message.EXECUTE);
            return ((LegacyToLibraryNode)executeNode).sendExecute(receiver, arguments);
        }
        catch (ArityException | UnsupportedMessageException | UnsupportedTypeException e) {
            CompilerDirectives.transferToInterpreter();
            throw e;
        }
        catch (InteropException e) {
            CompilerDirectives.transferToInterpreter();
            throw new AssertionError("Unexpected exception caught.", e);
        }
    }

    @Deprecated
    public static boolean sendIsExecutable(Node isExecutableNode, TruffleObject receiver) {
        try {
            return ((LegacyToLibraryNode)isExecutableNode).sendIsExecutable(receiver);
        }
        catch (InteropException e) {
            CompilerDirectives.transferToInterpreter();
            throw new AssertionError("Unexpected exception caught.", e);
        }
    }

    @Deprecated
    public static boolean sendIsInstantiable(Node isInstantiableNode, TruffleObject receiver) {
        try {
            return ((LegacyToLibraryNode)isInstantiableNode).sendIsInstantiable(receiver);
        }
        catch (InteropException e) {
            CompilerDirectives.transferToInterpreter();
            throw new AssertionError("Unexpected exception caught.", e);
        }
    }

    @Deprecated
    public static Object sendInvoke(Node invokeNode, TruffleObject receiver, String identifier, Object ... arguments) throws UnsupportedTypeException, ArityException, UnknownIdentifierException, UnsupportedMessageException {
        try {
            return ((LegacyToLibraryNode)invokeNode).sendInvoke(receiver, identifier, arguments);
        }
        catch (ArityException | UnknownIdentifierException | UnsupportedMessageException | UnsupportedTypeException e) {
            CompilerDirectives.transferToInterpreter();
            throw e;
        }
        catch (InteropException e) {
            CompilerDirectives.transferToInterpreter();
            throw new AssertionError("Unexpected exception caught.", e);
        }
    }

    @Deprecated
    public static Object sendNew(Node newNode, TruffleObject receiver, Object ... arguments) throws UnsupportedTypeException, ArityException, UnsupportedMessageException {
        try {
            assert (((LegacyToLibraryNode)newNode).message == Message.NEW);
            return ((LegacyToLibraryNode)newNode).sendNew(receiver, arguments);
        }
        catch (ArityException | UnsupportedMessageException | UnsupportedTypeException e) {
            CompilerDirectives.transferToInterpreter();
            throw e;
        }
        catch (InteropException e) {
            CompilerDirectives.transferToInterpreter();
            throw new AssertionError("Unexpected exception caught.", e);
        }
    }

    @Deprecated
    public static boolean sendIsNull(Node isNullNode, TruffleObject receiver) {
        try {
            assert (((LegacyToLibraryNode)isNullNode).message == Message.IS_NULL);
            return ((LegacyToLibraryNode)isNullNode).sendIsNull(receiver);
        }
        catch (InteropException e) {
            CompilerDirectives.transferToInterpreter();
            throw new AssertionError("Unexpected exception caught.", e);
        }
    }

    @Deprecated
    public static boolean sendHasSize(Node hasSizeNode, TruffleObject receiver) {
        try {
            assert (((LegacyToLibraryNode)hasSizeNode).message == Message.HAS_SIZE);
            return ((LegacyToLibraryNode)hasSizeNode).sendHasSize(receiver);
        }
        catch (InteropException e) {
            CompilerDirectives.transferToInterpreter();
            throw new AssertionError("Unexpected exception caught.", e);
        }
    }

    @Deprecated
    public static Object sendGetSize(Node getSizeNode, TruffleObject receiver) throws UnsupportedMessageException {
        try {
            assert (((LegacyToLibraryNode)getSizeNode).message == Message.GET_SIZE);
            return ((LegacyToLibraryNode)getSizeNode).sendGetSize(receiver);
        }
        catch (UnsupportedMessageException e) {
            CompilerDirectives.transferToInterpreter();
            throw e;
        }
        catch (InteropException e) {
            CompilerDirectives.transferToInterpreter();
            throw new AssertionError("Unexpected exception caught.", e);
        }
    }

    @Deprecated
    public static boolean sendIsBoxed(Node isBoxedNode, TruffleObject receiver) {
        try {
            assert (((LegacyToLibraryNode)isBoxedNode).message == Message.IS_BOXED);
            return ((LegacyToLibraryNode)isBoxedNode).sendIsBoxed(receiver);
        }
        catch (InteropException e) {
            CompilerDirectives.transferToInterpreter();
            throw new AssertionError("Unexpected exception caught.", e);
        }
    }

    @Deprecated
    public static int sendKeyInfo(Node keyInfoNode, TruffleObject receiver, Object identifier) {
        try {
            assert (((LegacyToLibraryNode)keyInfoNode).message == Message.KEY_INFO);
            return ((LegacyToLibraryNode)keyInfoNode).sendKeyInfo(receiver, identifier);
        }
        catch (UnsupportedMessageException ex) {
            CompilerDirectives.transferToInterpreter();
            try {
                TruffleObject keys = ForeignAccess.sendKeys(Message.KEYS.createNode(), receiver, true);
                Number sizeNumber = (Number)ForeignAccess.sendGetSize(Message.GET_SIZE.createNode(), keys);
                int size = sizeNumber.intValue();
                Node readNode = Message.READ.createNode();
                for (int i = 0; i < size; ++i) {
                    Object key = ForeignAccess.sendRead(readNode, keys, i);
                    if (!identifier.equals(key)) continue;
                    return 6;
                }
            }
            catch (UnknownIdentifierException | UnsupportedMessageException keys) {
                // empty catch block
            }
            try {
                boolean hasSize = ForeignAccess.sendHasSize(Message.HAS_SIZE.createNode(), receiver);
                if (hasSize && identifier instanceof Number) {
                    int id = ((Number)identifier).intValue();
                    if (id < 0 || (double)id != ((Number)identifier).doubleValue()) {
                        return 0;
                    }
                    Number sizeNumber = (Number)ForeignAccess.sendGetSize(Message.GET_SIZE.createNode(), receiver);
                    int size = sizeNumber.intValue();
                    if (id < size) {
                        return 6;
                    }
                }
            }
            catch (UnsupportedMessageException unsupportedMessageException) {
                // empty catch block
            }
            return 0;
        }
        catch (InteropException e) {
            CompilerDirectives.transferToInterpreter();
            throw new AssertionError("Unexpected exception caught.", e);
        }
    }

    @Deprecated
    public static boolean sendHasKeys(Node hasKeysNode, TruffleObject receiver) {
        try {
            assert (((LegacyToLibraryNode)hasKeysNode).message == Message.HAS_KEYS);
            return ((LegacyToLibraryNode)hasKeysNode).sendHasKeys(receiver);
        }
        catch (UnsupportedMessageException ex) {
            CompilerDirectives.transferToInterpreter();
            try {
                ForeignAccess.sendKeys(Message.KEYS.createNode(), receiver, true);
                return true;
            }
            catch (UnsupportedMessageException uex) {
                return false;
            }
        }
        catch (InteropException e) {
            CompilerDirectives.transferToInterpreter();
            throw new AssertionError("Unexpected exception caught.", e);
        }
    }

    @Deprecated
    public static TruffleObject sendKeys(Node keysNode, TruffleObject receiver) throws UnsupportedMessageException {
        try {
            assert (((LegacyToLibraryNode)keysNode).message == Message.KEYS);
            return ((LegacyToLibraryNode)keysNode).sendKeys(receiver);
        }
        catch (UnsupportedMessageException ex) {
            CompilerDirectives.transferToInterpreter();
            throw ex;
        }
        catch (InteropException e) {
            CompilerDirectives.transferToInterpreter();
            throw new AssertionError("Unexpected exception caught.", e);
        }
    }

    @Deprecated
    public static TruffleObject sendKeys(Node keysNode, TruffleObject receiver, boolean includeInternal) throws UnsupportedMessageException {
        try {
            assert (((LegacyToLibraryNode)keysNode).message == Message.KEYS);
            return ((LegacyToLibraryNode)keysNode).sendKeys(receiver, includeInternal);
        }
        catch (UnsupportedMessageException ex) {
            CompilerDirectives.transferToInterpreter();
            throw ex;
        }
        catch (InteropException e) {
            CompilerDirectives.transferToInterpreter();
            throw new AssertionError("Unexpected exception caught.", e);
        }
    }

    @Deprecated
    public static List<Object> getArguments(Frame frame) {
        Object[] arr = frame.getArguments();
        return ReadOnlyArrayList.asList(arr, 1, arr.length);
    }

    @Deprecated
    public static TruffleObject getReceiver(Frame frame) {
        return (TruffleObject)frame.getArguments()[0];
    }

    public String toString() {
        Object f = this.factory instanceof DelegatingFactory ? ((DelegatingFactory)this.factory).factory : this.factory;
        return "ForeignAccess[" + f.getClass().getName() + "]";
    }

    CallTarget access(Message message) {
        return this.factory.accessMessage(message);
    }

    CallTarget checkLanguage() {
        if (this.languageCheckSupplier != null) {
            RootNode languageCheck = this.languageCheckSupplier.get();
            return Truffle.getRuntime().createCallTarget(languageCheck);
        }
        return null;
    }

    boolean canHandle(TruffleObject receiver) {
        return this.factory.canHandle(receiver);
    }

    private static final class RootNodeSupplier
    implements Supplier<RootNode> {
        private final RootNode rootNode;

        RootNodeSupplier(RootNode rootNode) {
            assert (rootNode != null) : "The rootNode must be non null.";
            this.rootNode = rootNode;
        }

        @Override
        public RootNode get() {
            return (RootNode)this.rootNode.deepCopy();
        }
    }

    private static class DelegatingFactory
    implements Factory {
        private final Class<?> baseClass;
        private final StandardFactory factory;

        DelegatingFactory(Class<?> baseClass, StandardFactory factory) {
            this.baseClass = baseClass;
            this.factory = factory;
        }

        @Override
        public boolean canHandle(TruffleObject obj) {
            if (this.baseClass == null) {
                return ((Factory)((Object)this.factory)).canHandle(obj);
            }
            return this.baseClass.isInstance(obj);
        }

        @Override
        public CallTarget accessMessage(Message msg) {
            return DelegatingFactory.accessMessage(this.factory, msg);
        }

        private static CallTarget accessMessage(StandardFactory factory, Message msg) {
            if (msg instanceof KnownMessage) {
                switch (msg.hashCode()) {
                    case 423430: {
                        return factory.accessExecute(0);
                    }
                    case 423429: {
                        return factory.accessInvoke(0);
                    }
                    case 423428: {
                        return factory.accessNew(0);
                    }
                    case 423432: {
                        return factory.accessGetSize();
                    }
                    case 423441: {
                        return factory.accessHasKeys();
                    }
                    case 423433: {
                        return factory.accessHasSize();
                    }
                    case 423434: {
                        return factory.accessIsBoxed();
                    }
                    case 423435: {
                        return factory.accessIsExecutable();
                    }
                    case 423442: {
                        return factory.accessIsInstantiable();
                    }
                    case 423436: {
                        return factory.accessIsNull();
                    }
                    case 423438: {
                        return factory.accessRead();
                    }
                    case 423437: {
                        return factory.accessUnbox();
                    }
                    case 423431: {
                        return factory.accessWrite();
                    }
                    case 423443: {
                        return factory.accessRemove();
                    }
                    case 423439: {
                        return factory.accessKeys();
                    }
                    case 423440: {
                        return factory.accessKeyInfo();
                    }
                    case 423531: {
                        return factory.accessIsPointer();
                    }
                    case 423532: {
                        return factory.accessAsPointer();
                    }
                    case 423533: {
                        return factory.accessToNative();
                    }
                }
            }
            return factory.accessMessage(msg);
        }
    }

    @Deprecated
    public static interface StandardFactory {
        default public CallTarget accessIsNull() {
            return null;
        }

        default public CallTarget accessIsExecutable() {
            return null;
        }

        default public CallTarget accessIsInstantiable() {
            return null;
        }

        default public CallTarget accessIsBoxed() {
            return null;
        }

        default public CallTarget accessHasSize() {
            return null;
        }

        default public CallTarget accessGetSize() {
            return null;
        }

        default public CallTarget accessUnbox() {
            return null;
        }

        default public CallTarget accessRead() {
            return null;
        }

        default public CallTarget accessWrite() {
            return null;
        }

        default public CallTarget accessRemove() {
            return null;
        }

        default public CallTarget accessExecute(int argumentsLength) {
            return null;
        }

        default public CallTarget accessInvoke(int argumentsLength) {
            return null;
        }

        default public CallTarget accessNew(int argumentsLength) {
            return null;
        }

        default public CallTarget accessHasKeys() {
            return null;
        }

        default public CallTarget accessKeys() {
            return null;
        }

        default public CallTarget accessKeyInfo() {
            return null;
        }

        default public CallTarget accessIsPointer() {
            return null;
        }

        default public CallTarget accessAsPointer() {
            return null;
        }

        default public CallTarget accessToNative() {
            return null;
        }

        default public CallTarget accessMessage(Message unknown) {
            return null;
        }
    }

    @Deprecated
    public static interface Factory {
        public boolean canHandle(TruffleObject var1);

        public CallTarget accessMessage(Message var1);
    }
}

