/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.api.ejbjar;

import org.netbeans.api.j2ee.core.Profile;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.dd.api.ejb.EjbJarMetadata;
import org.netbeans.modules.j2ee.ejbjar.EjbJarAccessor;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModel;
import org.netbeans.modules.j2ee.spi.ejbjar.EjbJarImplementation;
import org.netbeans.modules.j2ee.spi.ejbjar.EjbJarImplementation2;
import org.netbeans.modules.j2ee.spi.ejbjar.EjbJarProvider;
import org.netbeans.modules.j2ee.spi.ejbjar.EjbJarsInProject;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;

public final class EjbJar {
    private static final Lookup.Result<EjbJarProvider> implementations = Lookup.getDefault().lookup(new Lookup.Template(EjbJarProvider.class));
    private final EjbJarImplementation impl;
    private final EjbJarImplementation2 impl2;

    private EjbJar(EjbJarImplementation impl, EjbJarImplementation2 impl2) {
        assert (impl != null && impl2 == null || impl == null && impl2 != null);
        this.impl = impl;
        this.impl2 = impl2;
    }

    public static EjbJar getEjbJar(FileObject f) {
        if (f == null) {
            throw new NullPointerException("Passed null to EjbJar.getEjbJar(FileObject)");
        }
        for (EjbJarProvider impl : implementations.allInstances()) {
            EjbJar wm = impl.findEjbJar(f);
            if (wm == null) continue;
            return wm;
        }
        return null;
    }

    public static EjbJar[] getEjbJars(Project project) {
        EjbJar[] jars;
        EjbJarsInProject providers = (EjbJarsInProject)project.getLookup().lookup(EjbJarsInProject.class);
        if (providers != null && (jars = providers.getEjbJars()) != null) {
            return jars;
        }
        return new EjbJar[0];
    }

    public String getJ2eePlatformVersion() {
        if (this.impl2 != null) {
            return this.impl2.getJ2eeProfile().toPropertiesString();
        }
        return this.impl.getJ2eePlatformVersion();
    }

    public Profile getJ2eeProfile() {
        if (this.impl2 != null) {
            return this.impl2.getJ2eeProfile();
        }
        return Profile.fromPropertiesString((String)this.impl.getJ2eePlatformVersion());
    }

    public FileObject getDeploymentDescriptor() {
        if (this.impl2 != null) {
            return this.impl2.getDeploymentDescriptor();
        }
        return this.impl.getDeploymentDescriptor();
    }

    public FileObject[] getJavaSources() {
        if (this.impl2 != null) {
            return this.impl2.getJavaSources();
        }
        return this.impl.getJavaSources();
    }

    public FileObject getMetaInf() {
        if (this.impl2 != null) {
            return this.impl2.getMetaInf();
        }
        return this.impl.getMetaInf();
    }

    public MetadataModel<EjbJarMetadata> getMetadataModel() {
        if (this.impl2 != null) {
            return this.impl2.getMetadataModel();
        }
        return this.impl.getMetadataModel();
    }

    static {
        EjbJarAccessor.setDefault(new EjbJarAccessor(){

            @Override
            public EjbJar createEjbJar(EjbJarImplementation spiEjbJar) {
                return new EjbJar(spiEjbJar, null);
            }

            @Override
            public EjbJar createEjbJar(EjbJarImplementation2 spiEjbJar) {
                return new EjbJar(null, spiEjbJar);
            }
        });
    }
}

