/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.ui;

import com.formdev.flatlaf.FlatLaf;
import com.formdev.flatlaf.ui.FlatUIUtils;
import com.formdev.flatlaf.util.UIScale;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyChangeListener;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicMenuItemUI;

public class FlatMenuItemUI
extends BasicMenuItemUI {
    public static ComponentUI createUI(JComponent c) {
        return new FlatMenuItemUI();
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.defaultTextIconGap = UIScale.scale(this.defaultTextIconGap);
    }

    @Override
    protected PropertyChangeListener createPropertyChangeListener(JComponent c) {
        PropertyChangeListener superListener = super.createPropertyChangeListener(c);
        return e -> {
            superListener.propertyChange(e);
            if (e.getPropertyName() == "iconTextGap") {
                this.defaultTextIconGap = UIScale.scale(this.defaultTextIconGap);
            }
        };
    }

    @Override
    protected void paintText(Graphics g, JMenuItem menuItem, Rectangle textRect, String text) {
        FlatMenuItemUI.paintText(g, menuItem, textRect, text, this.disabledForeground, this.selectionForeground);
    }

    public static void paintText(Graphics g, JMenuItem menuItem, Rectangle textRect, String text, Color disabledForeground, Color selectionForeground) {
        FontMetrics fm = menuItem.getFontMetrics(menuItem.getFont());
        int mnemonicIndex = FlatLaf.isShowMnemonics() ? menuItem.getDisplayedMnemonicIndex() : -1;
        ButtonModel model = menuItem.getModel();
        g.setColor(!model.isEnabled() ? disabledForeground : (model.isArmed() || menuItem instanceof JMenu && model.isSelected() ? selectionForeground : menuItem.getForeground()));
        FlatUIUtils.drawStringUnderlineCharAt(menuItem, g, text, mnemonicIndex, textRect.x, textRect.y + fm.getAscent());
    }
}

