/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.ui;

import com.formdev.flatlaf.ui.FlatMenuItemUI;
import com.formdev.flatlaf.ui.FlatUIUtils;
import com.formdev.flatlaf.util.UIScale;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.UIManager;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicMenuUI;

public class FlatMenuUI
extends BasicMenuUI {
    private Color hoverBackground;

    public static ComponentUI createUI(JComponent c) {
        return new FlatMenuUI();
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.menuItem.setRolloverEnabled(true);
        this.hoverBackground = UIManager.getColor("MenuBar.hoverBackground");
        this.defaultTextIconGap = UIScale.scale(this.defaultTextIconGap);
    }

    @Override
    protected void uninstallDefaults() {
        super.uninstallDefaults();
        this.hoverBackground = null;
    }

    @Override
    protected PropertyChangeListener createPropertyChangeListener(JComponent c) {
        PropertyChangeListener superListener = super.createPropertyChangeListener(c);
        return e -> {
            superListener.propertyChange(e);
            if (e.getPropertyName() == "iconTextGap") {
                this.defaultTextIconGap = UIScale.scale(this.defaultTextIconGap);
            }
        };
    }

    @Override
    protected MouseInputListener createMouseInputListener(JComponent c) {
        return new BasicMenuUI.MouseInputHandler(){

            @Override
            public void mouseEntered(MouseEvent e) {
                super.mouseEntered(e);
                this.rollover(e, true);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                super.mouseExited(e);
                this.rollover(e, false);
            }

            private void rollover(MouseEvent e, boolean rollover) {
                JMenu menu = (JMenu)e.getSource();
                if (menu.isTopLevelMenu() && menu.isRolloverEnabled()) {
                    menu.getModel().setRollover(rollover);
                    menu.repaint();
                }
            }
        };
    }

    @Override
    protected void paintBackground(Graphics g, JMenuItem menuItem, Color bgColor) {
        ButtonModel model = menuItem.getModel();
        if (model.isArmed() || model.isSelected()) {
            super.paintBackground(g, menuItem, bgColor);
        } else if (model.isRollover() && model.isEnabled() && ((JMenu)menuItem).isTopLevelMenu()) {
            FlatUIUtils.setColor(g, this.hoverBackground, menuItem.getBackground());
            g.fillRect(0, 0, menuItem.getWidth(), menuItem.getHeight());
        } else {
            super.paintBackground(g, menuItem, bgColor);
        }
    }

    @Override
    protected void paintText(Graphics g, JMenuItem menuItem, Rectangle textRect, String text) {
        FlatMenuItemUI.paintText(g, menuItem, textRect, text, this.disabledForeground, this.selectionForeground);
    }
}

