/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.core.support.java.method;

import java.awt.BorderLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.ui.TypeElementFinder;
import org.netbeans.modules.j2ee.core.api.support.java.method.MethodModel;
import org.netbeans.modules.j2ee.core.support.java.method.ExceptionsPanel;
import org.netbeans.modules.j2ee.core.support.java.method.ParametersPanel;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public final class MethodCustomizerPanel
extends JPanel {
    public static final String NAME = "name";
    public static final String RETURN_TYPE = "returnType";
    public static final String INTERFACES = "interfaces";
    public static final String PARAMETERS = "parameters";
    private final MethodModel methodModel;
    private final ParametersPanel parametersPanel;
    private final ExceptionsPanel exceptionsPanel;
    private final boolean hasInterfaces;
    private final ClasspathInfo cpInfo;
    private final boolean allowsNoInterface;
    private JRadioButton bothRadio;
    private JLabel cardinalityLabel;
    private JPanel cardinalityPanel;
    private JLabel ejbqlLabel;
    private JPanel ejbqlPanel;
    private JScrollPane ejbqlScrollPane;
    private JTextArea ejbqlTextArea;
    private JTabbedPane exceptionAndParameterPane;
    private JPanel exceptionsContainerPanel;
    private ButtonGroup finderCardinalityButtonGroup;
    private ButtonGroup interfaceButtonGroup;
    private JLabel interfaceLabel;
    private JPanel interfacesPanel;
    private JButton jButton1;
    private JLabel jLabel1;
    private JRadioButton localRadio;
    private JRadioButton manyRadioButton;
    private JTextField nameTextField;
    private JRadioButton oneRadioButton;
    private JPanel parametersContainerPanel;
    private JRadioButton remoteRadio;
    private JLabel returnTypeLabel;
    private JTextField returnTypeTextField;

    private MethodCustomizerPanel(MethodModel methodModel, ClasspathInfo cpInfo, boolean hasLocal, boolean hasRemote, boolean selectLocal, boolean selectRemote, boolean hasReturnType, String ejbql, boolean hasFinderCardinality, boolean hasExceptions, boolean hasInterfaces, boolean allowsNoInterface) {
        this.initComponents();
        this.methodModel = methodModel;
        this.hasInterfaces = hasInterfaces;
        this.allowsNoInterface = allowsNoInterface;
        this.cpInfo = cpInfo;
        this.nameTextField.setText(methodModel.getName());
        this.returnTypeTextField.setText(methodModel.getReturnType());
        this.localRadio.setEnabled(hasLocal);
        this.remoteRadio.setEnabled(hasRemote);
        this.bothRadio.setEnabled(hasLocal && hasRemote);
        this.localRadio.setSelected(selectLocal);
        this.remoteRadio.setSelected(selectRemote && !selectLocal);
        if (!hasReturnType) {
            this.disableReturnType();
        }
        if (ejbql == null) {
            this.ejbqlPanel.setVisible(false);
        } else {
            this.ejbqlTextArea.setText(ejbql);
        }
        this.cardinalityPanel.setVisible(hasFinderCardinality);
        this.interfacesPanel.setVisible(hasInterfaces);
        this.parametersPanel = new ParametersPanel(cpInfo, methodModel.getParameters());
        this.parametersContainerPanel.add(this.parametersPanel);
        if (hasExceptions) {
            this.exceptionsPanel = new ExceptionsPanel(methodModel.getExceptions(), cpInfo);
            this.exceptionsContainerPanel.add(this.exceptionsPanel);
        } else {
            this.exceptionsPanel = null;
            this.exceptionsContainerPanel.setVisible(false);
        }
        this.nameTextField.getDocument().addDocumentListener(new SimpleListener(NAME));
        this.returnTypeTextField.getDocument().addDocumentListener(new SimpleListener(RETURN_TYPE));
        this.parametersPanel.addPropertyChangeListener(new SimpleListener(PARAMETERS));
        SimpleListener interfacesListener = new SimpleListener(INTERFACES);
        this.localRadio.addActionListener(interfacesListener);
        this.remoteRadio.addActionListener(interfacesListener);
        this.bothRadio.addActionListener(interfacesListener);
    }

    public static MethodCustomizerPanel create(MethodModel methodModel, ClasspathInfo cpInfo, boolean hasLocal, boolean hasRemote, boolean selectLocal, boolean selectRemote, boolean hasReturnType, String ejbql, boolean hasFinderCardinality, boolean hasExceptions, boolean hasInterfaces, boolean allowsNoInterface) {
        return new MethodCustomizerPanel(methodModel, cpInfo, hasLocal, hasRemote, selectLocal, selectRemote, hasReturnType, ejbql, hasFinderCardinality, hasExceptions, hasInterfaces, allowsNoInterface);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        super.addPropertyChangeListener(listener);
        this.firePropertyChange(NAME, null, null);
        this.firePropertyChange(RETURN_TYPE, null, null);
        this.firePropertyChange(INTERFACES, null, null);
    }

    private void initComponents() {
        this.finderCardinalityButtonGroup = new ButtonGroup();
        this.interfaceButtonGroup = new ButtonGroup();
        this.exceptionAndParameterPane = new JTabbedPane();
        this.parametersContainerPanel = new JPanel();
        this.exceptionsContainerPanel = new JPanel();
        this.returnTypeLabel = new JLabel();
        this.returnTypeTextField = new JTextField();
        this.nameTextField = new JTextField();
        this.jLabel1 = new JLabel();
        this.interfacesPanel = new JPanel();
        this.interfaceLabel = new JLabel();
        this.localRadio = new JRadioButton();
        this.remoteRadio = new JRadioButton();
        this.bothRadio = new JRadioButton();
        this.cardinalityPanel = new JPanel();
        this.cardinalityLabel = new JLabel();
        this.oneRadioButton = new JRadioButton();
        this.manyRadioButton = new JRadioButton();
        this.ejbqlPanel = new JPanel();
        this.ejbqlLabel = new JLabel();
        this.ejbqlScrollPane = new JScrollPane();
        this.ejbqlTextArea = new JTextArea();
        this.jButton1 = new JButton();
        this.parametersContainerPanel.setLayout(new BorderLayout());
        this.exceptionAndParameterPane.addTab(NbBundle.getMessage(MethodCustomizerPanel.class, (String)"MethodCustomizerPanel.parametersContainerPanel.TabConstraints.tabTitle"), this.parametersContainerPanel);
        this.parametersContainerPanel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MethodCustomizerPanel.class, (String)"ACSD_ParametersTab"));
        this.exceptionsContainerPanel.setLayout(new BorderLayout());
        this.exceptionAndParameterPane.addTab(NbBundle.getMessage(MethodCustomizerPanel.class, (String)"MethodCustomizerPanel.exceptionsPanel.TabConstraints.tabTitle"), this.exceptionsContainerPanel);
        this.exceptionsContainerPanel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MethodCustomizerPanel.class, (String)"ACSD_ExceptionsTab"));
        this.returnTypeLabel.setLabelFor(this.returnTypeTextField);
        Mnemonics.setLocalizedText((JLabel)this.returnTypeLabel, (String)NbBundle.getMessage(MethodCustomizerPanel.class, (String)"MethodCustomizerPanel.returnTypeLabel.text"));
        this.returnTypeTextField.setText(NbBundle.getMessage(MethodCustomizerPanel.class, (String)"MethodCustomizerPanel.returnTypeTextField.text"));
        this.returnTypeTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                MethodCustomizerPanel.this.returnTypeTextFieldFocusGained(evt);
            }
        });
        this.nameTextField.setText(NbBundle.getMessage(MethodCustomizerPanel.class, (String)"MethodCustomizerPanel.nameTextField.text"));
        this.nameTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                MethodCustomizerPanel.this.nameTextFieldFocusGained(evt);
            }
        });
        this.jLabel1.setLabelFor(this.nameTextField);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(MethodCustomizerPanel.class, (String)"MethodCustomizerPanel.jLabel1.text"));
        Mnemonics.setLocalizedText((JLabel)this.interfaceLabel, (String)NbBundle.getMessage(MethodCustomizerPanel.class, (String)"MethodCustomizerPanel.interfaceLabel.text"));
        this.interfaceButtonGroup.add(this.localRadio);
        this.localRadio.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.localRadio, (String)NbBundle.getMessage(MethodCustomizerPanel.class, (String)"Iface_type_Local"));
        this.localRadio.setMargin(new Insets(0, 0, 0, 0));
        this.interfaceButtonGroup.add(this.remoteRadio);
        Mnemonics.setLocalizedText((AbstractButton)this.remoteRadio, (String)NbBundle.getMessage(MethodCustomizerPanel.class, (String)"Iface_type_Remote"));
        this.remoteRadio.setMargin(new Insets(0, 0, 0, 0));
        this.interfaceButtonGroup.add(this.bothRadio);
        Mnemonics.setLocalizedText((AbstractButton)this.bothRadio, (String)NbBundle.getMessage(MethodCustomizerPanel.class, (String)"Iface_type_Both"));
        this.bothRadio.setMargin(new Insets(0, 0, 0, 0));
        GroupLayout interfacesPanelLayout = new GroupLayout(this.interfacesPanel);
        this.interfacesPanel.setLayout(interfacesPanelLayout);
        interfacesPanelLayout.setHorizontalGroup(interfacesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(interfacesPanelLayout.createSequentialGroup().addComponent(this.interfaceLabel).addGap(18, 18, 18).addComponent(this.localRadio).addGap(18, 18, 18).addComponent(this.remoteRadio).addGap(18, 18, 18).addComponent(this.bothRadio).addContainerGap(222, Short.MAX_VALUE)));
        interfacesPanelLayout.setVerticalGroup(interfacesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(interfacesPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.interfaceLabel).addComponent(this.localRadio).addComponent(this.remoteRadio).addComponent(this.bothRadio)));
        this.localRadio.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MethodCustomizerPanel.class, (String)"ACSD_LocalRadioButton"));
        this.remoteRadio.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MethodCustomizerPanel.class, (String)"ACSD_RemoteRadioButton"));
        this.bothRadio.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MethodCustomizerPanel.class, (String)"ACSD_BothRadioButton"));
        Mnemonics.setLocalizedText((JLabel)this.cardinalityLabel, (String)NbBundle.getMessage(MethodCustomizerPanel.class, (String)"MethodCustomizerPanel.cardinalityLabel.text"));
        this.finderCardinalityButtonGroup.add(this.oneRadioButton);
        this.oneRadioButton.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.oneRadioButton, (String)NbBundle.getMessage(MethodCustomizerPanel.class, (String)"MethodCustomizerPanel.oneRadioButton.text"));
        this.oneRadioButton.setMargin(new Insets(0, 0, 0, 0));
        this.finderCardinalityButtonGroup.add(this.manyRadioButton);
        Mnemonics.setLocalizedText((AbstractButton)this.manyRadioButton, (String)NbBundle.getMessage(MethodCustomizerPanel.class, (String)"MethodCustomizerPanel.manyRadioButton.text"));
        this.manyRadioButton.setMargin(new Insets(0, 0, 0, 0));
        GroupLayout cardinalityPanelLayout = new GroupLayout(this.cardinalityPanel);
        this.cardinalityPanel.setLayout(cardinalityPanelLayout);
        cardinalityPanelLayout.setHorizontalGroup(cardinalityPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(cardinalityPanelLayout.createSequentialGroup().addComponent(this.cardinalityLabel).addGap(18, 18, 18).addComponent(this.oneRadioButton).addGap(18, 18, 18).addComponent(this.manyRadioButton).addContainerGap(305, Short.MAX_VALUE)));
        cardinalityPanelLayout.setVerticalGroup(cardinalityPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(cardinalityPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cardinalityLabel).addComponent(this.oneRadioButton).addComponent(this.manyRadioButton)));
        this.oneRadioButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MethodCustomizerPanel.class, (String)"ACSD_OneRadioButton"));
        this.manyRadioButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MethodCustomizerPanel.class, (String)"ACSD_ManyRadioButton"));
        this.ejbqlLabel.setLabelFor(this.ejbqlTextArea);
        Mnemonics.setLocalizedText((JLabel)this.ejbqlLabel, (String)NbBundle.getMessage(MethodCustomizerPanel.class, (String)"MethodCustomizerPanel.ejbqlLabel.text"));
        this.ejbqlScrollPane.setBorder(null);
        this.ejbqlTextArea.setColumns(20);
        this.ejbqlTextArea.setRows(5);
        this.ejbqlTextArea.setBorder(BorderFactory.createEtchedBorder());
        this.ejbqlTextArea.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                MethodCustomizerPanel.this.ejbqlTextAreaFocusGained(evt);
            }
        });
        this.ejbqlScrollPane.setViewportView(this.ejbqlTextArea);
        this.ejbqlTextArea.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MethodCustomizerPanel.class, (String)"ACSD_EJB_QL"));
        GroupLayout ejbqlPanelLayout = new GroupLayout(this.ejbqlPanel);
        this.ejbqlPanel.setLayout(ejbqlPanelLayout);
        ejbqlPanelLayout.setHorizontalGroup(ejbqlPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(ejbqlPanelLayout.createSequentialGroup().addComponent(this.ejbqlLabel).addContainerGap(538, Short.MAX_VALUE)).addComponent(this.ejbqlScrollPane, -1, 586, Short.MAX_VALUE));
        ejbqlPanelLayout.setVerticalGroup(ejbqlPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(ejbqlPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.ejbqlLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.ejbqlScrollPane, -1, 88, Short.MAX_VALUE)));
        Mnemonics.setLocalizedText((AbstractButton)this.jButton1, (String)NbBundle.getMessage(MethodCustomizerPanel.class, (String)"MethodCustomizerPanel.jButton1.text"));
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MethodCustomizerPanel.this.jButton1ActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.exceptionAndParameterPane, GroupLayout.Alignment.TRAILING, -2, 586, Short.MAX_VALUE).addComponent(this.ejbqlPanel, -1, -1, Short.MAX_VALUE).addComponent(this.cardinalityPanel, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.interfacesPanel, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel1).addComponent(this.returnTypeLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.returnTypeTextField, -1, 375, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton1)).addComponent(this.nameTextField, -1, 480, Short.MAX_VALUE)))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(26, 26, 26).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.nameTextField, -2, -1, -2).addComponent(this.jLabel1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.returnTypeLabel).addComponent(this.jButton1).addComponent(this.returnTypeTextField, -2, -1, -2)).addGap(18, 18, 18).addComponent(this.exceptionAndParameterPane, -1, 201, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.interfacesPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.cardinalityPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.ejbqlPanel, -1, -1, Short.MAX_VALUE).addContainerGap()));
        this.exceptionAndParameterPane.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MethodCustomizerPanel.class, (String)"ACSD_TabPane"));
        this.returnTypeLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MethodCustomizerPanel.class, (String)"ACSD_ReturnType"));
        this.jLabel1.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MethodCustomizerPanel.class, (String)"ACSD_Name"));
        this.jButton1.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MethodCustomizerPanel.class, (String)"ACSD_MethodCustomizerPanel_Browse"));
    }

    private void nameTextFieldFocusGained(FocusEvent evt) {
        this.nameTextField.selectAll();
    }

    private void returnTypeTextFieldFocusGained(FocusEvent evt) {
        this.returnTypeTextField.selectAll();
    }

    private void ejbqlTextAreaFocusGained(FocusEvent evt) {
        this.ejbqlTextArea.selectAll();
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        ElementHandle handle = TypeElementFinder.find((ClasspathInfo)this.cpInfo, (TypeElementFinder.Customizer)new TypeElementFinder.Customizer(){

            public Set<ElementHandle<TypeElement>> query(ClasspathInfo classpathInfo, String textForQuery, ClassIndex.NameKind nameKind, Set<ClassIndex.SearchScope> searchScopes) {
                return classpathInfo.getClassIndex().getDeclaredTypes(textForQuery, nameKind, searchScopes);
            }

            public boolean accept(ElementHandle<TypeElement> typeHandle) {
                return true;
            }
        });
        if (handle != null) {
            this.returnTypeTextField.setText(handle.getQualifiedName());
        }
    }

    public String getMethodName() {
        return this.nameTextField.getText().trim();
    }

    public String getReturnType() {
        return this.returnTypeTextField.getText().trim();
    }

    public List<MethodModel.Variable> getParameters() {
        return this.parametersPanel.getParameters();
    }

    public List<String> getExceptions() {
        ArrayList<String> result = new ArrayList<String>();
        if (this.exceptionsPanel != null) {
            for (String exception : this.exceptionsPanel.getExceptions()) {
                if ("".equals(exception.trim())) continue;
                result.add(exception);
            }
        }
        return result;
    }

    public Set<Modifier> getModifiers() {
        return this.methodModel.getModifiers();
    }

    public String getMethodBody() {
        return this.methodModel.getBody();
    }

    public boolean supportsInterfacesChecking() {
        return this.hasInterfaces;
    }

    public boolean hasLocal() {
        return this.localRadio.isEnabled() && this.localRadio.isSelected() || this.hasBothInterfaces();
    }

    public boolean hasRemote() {
        return this.remoteRadio.isEnabled() && this.remoteRadio.isSelected() || this.hasBothInterfaces();
    }

    public boolean allowsNoInterface() {
        return this.allowsNoInterface;
    }

    public String getEjbql() {
        if (this.ejbqlTextArea != null) {
            return this.ejbqlTextArea.getText().trim();
        }
        return null;
    }

    public boolean finderReturnIsSingle() {
        return this.oneRadioButton != null ? this.oneRadioButton.isSelected() : false;
    }

    private boolean hasBothInterfaces() {
        return this.localRadio.isEnabled() && this.remoteRadio.isEnabled() && this.bothRadio.isSelected();
    }

    private void disableReturnType() {
        this.returnTypeLabel.setVisible(false);
        this.returnTypeTextField.setVisible(false);
    }

    private class SimpleListener
    implements DocumentListener,
    ActionListener,
    PropertyChangeListener {
        private final String propertyName;

        public SimpleListener(String propertyName) {
            this.propertyName = propertyName;
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            this.fire();
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            this.fire();
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.fire();
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            this.fire();
        }

        private void fire() {
            MethodCustomizerPanel.this.firePropertyChange(this.propertyName, null, null);
        }
    }
}

