/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ant.debugger;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.Session;
import org.netbeans.modules.ant.debugger.AntDebugger;
import org.netbeans.modules.ant.debugger.Bundle;
import org.netbeans.spi.debugger.ui.Constants;
import org.netbeans.spi.viewmodel.ModelEvent;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.TableModel;
import org.netbeans.spi.viewmodel.TableModelFilter;
import org.netbeans.spi.viewmodel.UnknownTypeException;

public class SessionsTableModelFilter
implements TableModelFilter,
Constants {
    private final List<Session> sessionListeners = new ArrayList<Session>();
    private final List<ModelListener> modelListeners = new CopyOnWriteArrayList<ModelListener>();

    public Object getValueAt(TableModel original, Object node, String columnID) throws UnknownTypeException {
        if (node instanceof Session && SessionsTableModelFilter.isANTSession((Session)node)) {
            if ("SessionState".equals(columnID)) {
                return this.getSessionState((Session)node);
            }
            if ("SessionLanguage".equals(columnID)) {
                return node;
            }
            if ("SessionHostName".equals(columnID)) {
                return ((Session)node).getLocationName();
            }
            throw new UnknownTypeException(node);
        }
        return original.getValueAt(node, columnID);
    }

    public boolean isReadOnly(TableModel original, Object node, String columnID) throws UnknownTypeException {
        if (node instanceof Session && SessionsTableModelFilter.isANTSession((Session)node)) {
            if ("SessionState".equals(columnID)) {
                return true;
            }
            if ("SessionLanguage".equals(columnID)) {
                return true;
            }
            if ("SessionHostName".equals(columnID)) {
                return true;
            }
            throw new UnknownTypeException(node);
        }
        return original.isReadOnly(node, columnID);
    }

    public void setValueAt(TableModel original, Object node, String columnID, Object value) throws UnknownTypeException {
        original.setValueAt(node, columnID, value);
    }

    private static boolean isANTSession(Session s) {
        DebuggerEngine e = s.getCurrentEngine();
        if (e == null) {
            return false;
        }
        AntDebugger d = (AntDebugger)((Object)e.lookupFirst(null, AntDebugger.class));
        return d != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getSessionState(Session s) {
        DebuggerEngine e = s.getCurrentEngine();
        if (e == null) {
            return Bundle.MSG_Session_State_Starting();
        }
        AntDebugger d = (AntDebugger)((Object)e.lookupFirst(null, AntDebugger.class));
        if (d.isFinished()) {
            return Bundle.MSG_Session_State_Finished();
        }
        List<Session> list = this.sessionListeners;
        synchronized (list) {
            if (!this.sessionListeners.contains(s)) {
                ANTSessionStateListener asl = new ANTSessionStateListener(s, d);
                d.addStateListener(asl);
                this.sessionListeners.add(s);
            }
        }
        if (d.isSuspended()) {
            return Bundle.MSG_Session_State_Stopped();
        }
        return Bundle.MSG_Session_State_Running();
    }

    private void fireModelChanged(Object node) {
        ModelEvent.TableValueChanged me = new ModelEvent.TableValueChanged((Object)this, node, "SessionState");
        for (ModelListener ml : this.modelListeners) {
            ml.modelChanged((ModelEvent)me);
        }
    }

    public void addModelListener(ModelListener l) {
        this.modelListeners.add(l);
    }

    public void removeModelListener(ModelListener l) {
        this.modelListeners.remove(l);
    }

    private class ANTSessionStateListener
    implements AntDebugger.StateListener {
        private final Session s;
        private final AntDebugger d;

        ANTSessionStateListener(Session s, AntDebugger d) {
            this.s = s;
            this.d = d;
        }

        @Override
        public void suspended(boolean suspended) {
            SessionsTableModelFilter.this.fireModelChanged(this.s);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void finished() {
            SessionsTableModelFilter.this.fireModelChanged(this.s);
            this.d.removeStateListener(this);
            List list = SessionsTableModelFilter.this.sessionListeners;
            synchronized (list) {
                SessionsTableModelFilter.this.sessionListeners.remove(this.s);
            }
        }
    }
}

