/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.symfony2.preferences;

import java.util.prefs.Preferences;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.SuppressWarnings;
import org.netbeans.modules.php.api.phpmodule.PhpModule;
import org.netbeans.modules.php.symfony2.SymfonyPhpFrameworkProvider;
import org.netbeans.modules.php.symfony2.options.SymfonyOptions;

public final class SymfonyPreferences {
    private static final String ENABLED = "enabled";
    private static final String APP_DIR = "appDir-path";
    private static final String IGNORE_CACHE_DIRECTORY = "cacheDir-ignored";
    private static final String DEFAULT_APP_DIR = "app";

    private SymfonyPreferences() {
    }

    @SuppressWarnings(value={"NP_BOOLEAN_RETURN_NULL"})
    @CheckForNull
    public static Boolean isEnabled(PhpModule module) {
        String enabled = SymfonyPreferences.getPreferences(module).get(ENABLED, null);
        if (enabled == null) {
            return null;
        }
        return Boolean.valueOf(enabled);
    }

    public static void setEnabled(PhpModule module, boolean enabled) {
        SymfonyPreferences.getPreferences(module).putBoolean(ENABLED, enabled);
    }

    public static String getAppDir(PhpModule module) {
        return SymfonyPreferences.getPreferences(module).get(APP_DIR, DEFAULT_APP_DIR);
    }

    public static void setAppDir(PhpModule module, String appDir) {
        if (appDir.equals(DEFAULT_APP_DIR)) {
            SymfonyPreferences.getPreferences(module).remove(APP_DIR);
        } else {
            SymfonyPreferences.getPreferences(module).put(APP_DIR, appDir);
        }
    }

    public static boolean isCacheDirIgnored(PhpModule phpModule) {
        String ignored = SymfonyPreferences.getPreferences(phpModule).get(IGNORE_CACHE_DIRECTORY, null);
        if (ignored == null) {
            return SymfonyOptions.getInstance().getIgnoreCache();
        }
        return Boolean.valueOf(ignored);
    }

    public static void setCacheDirIgnored(PhpModule phpModule, boolean ignored) {
        SymfonyPreferences.getPreferences(phpModule).putBoolean(IGNORE_CACHE_DIRECTORY, ignored);
    }

    private static Preferences getPreferences(PhpModule module) {
        return module.getPreferences(SymfonyPhpFrameworkProvider.class, true);
    }
}

