/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.js.parser.ir;

import com.oracle.js.parser.Namespace;
import com.oracle.js.parser.Source;
import com.oracle.js.parser.Token;
import com.oracle.js.parser.ir.Block;
import com.oracle.js.parser.ir.ExportNode;
import com.oracle.js.parser.ir.Flags;
import com.oracle.js.parser.ir.IdentNode;
import com.oracle.js.parser.ir.ImportNode;
import com.oracle.js.parser.ir.LexicalContext;
import com.oracle.js.parser.ir.LexicalContextExpression;
import com.oracle.js.parser.ir.Module;
import com.oracle.js.parser.ir.Node;
import com.oracle.js.parser.ir.visitor.NodeVisitor;
import com.oracle.js.parser.ir.visitor.TranslatorNodeVisitor;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public final class FunctionNode
extends LexicalContextExpression
implements Flags<FunctionNode> {
    private final Source source;
    private final Object endParserState;
    private final IdentNode ident;
    private final Block body;
    private final String name;
    private final Kind kind;
    private final List<IdentNode> parameters;
    private final long firstToken;
    private final long lastToken;
    private final Namespace namespace;
    private final int thisProperties;
    private final int flags;
    private final int lineNumber;
    private final Module module;
    public static final int IS_ANONYMOUS = 1;
    public static final int IS_DECLARED = 2;
    public static final int IS_STRICT = 4;
    public static final int USES_ARGUMENTS = 8;
    public static final int IS_SPLIT = 16;
    public static final int HAS_EVAL = 32;
    public static final int HAS_NESTED_EVAL = 64;
    public static final int HAS_SCOPE_BLOCK = 128;
    public static final int DEFINES_ARGUMENTS = 256;
    public static final int USES_ANCESTOR_SCOPE = 512;
    public static final int HAS_FUNCTION_DECLARATIONS = 1024;
    public static final int HAS_APPLY_TO_CALL_SPECIALIZATION = 4096;
    public static final int IS_PROGRAM = 8192;
    public static final int USES_SELF_SYMBOL = 16384;
    public static final int USES_THIS = 32768;
    private static final int HAS_DEEP_EVAL = 96;
    private static final int HAS_ALL_VARS_IN_SCOPE = 96;
    private static final int MAYBE_NEEDS_ARGUMENTS = 40;
    public static final int NEEDS_PARENT_SCOPE = 8800;
    public static final int HAS_DIRECT_SUPER = 262144;
    public static final int USES_SUPER = 524288;
    public static final int IS_METHOD = 0x100000;
    public static final int IS_CLASS_CONSTRUCTOR = 0x200000;
    public static final int IS_SUBCLASS_CONSTRUCTOR = 0x400000;
    public static final int USES_NEW_TARGET = 0x800000;
    public static final int IS_STATEMENT = 0x1000000;
    public static final int IS_ASYNC = 0x2000000;

    public FunctionNode(Source source, int n, long l, int n2, long l2, long l3, Namespace namespace, IdentNode identNode, String string, List<IdentNode> list, Kind kind, int n3, Block block, Object object, Module module) {
        super(l, n2);
        this.source = source;
        this.lineNumber = n;
        this.ident = identNode;
        this.name = string;
        this.kind = kind;
        this.parameters = list;
        this.firstToken = l2;
        this.lastToken = l3;
        this.namespace = namespace;
        this.flags = n3;
        this.body = block;
        this.thisProperties = 0;
        this.endParserState = object;
        this.module = module;
    }

    private FunctionNode(FunctionNode functionNode, long l, Object object, int n, String string, Block block, List<IdentNode> list, int n2, Source source, Namespace namespace) {
        super(functionNode);
        this.endParserState = object;
        this.lineNumber = functionNode.lineNumber;
        this.flags = n;
        this.name = string;
        this.lastToken = l;
        this.body = block;
        this.parameters = list;
        this.thisProperties = n2;
        this.source = source;
        this.namespace = namespace;
        this.ident = functionNode.ident;
        this.kind = functionNode.kind;
        this.firstToken = functionNode.firstToken;
        this.module = functionNode.module;
    }

    @Override
    public Node accept(LexicalContext lexicalContext, NodeVisitor<? extends LexicalContext> nodeVisitor) {
        if (nodeVisitor.enterFunctionNode(this)) {
            return nodeVisitor.leaveFunctionNode(this.setBody(lexicalContext, (Block)this.body.accept(nodeVisitor)));
        }
        return this;
    }

    @Override
    public <R> R accept(LexicalContext lexicalContext, TranslatorNodeVisitor<? extends LexicalContext, R> translatorNodeVisitor) {
        return translatorNodeVisitor.enterFunctionNode(this);
    }

    public List<IdentNode> visitParameters(NodeVisitor<? extends LexicalContext> nodeVisitor) {
        return Node.accept(nodeVisitor, this.parameters);
    }

    public List<ImportNode> visitImports(NodeVisitor<? extends LexicalContext> nodeVisitor) {
        return Node.accept(nodeVisitor, this.module.getImports());
    }

    public List<ExportNode> visitExports(NodeVisitor<? extends LexicalContext> nodeVisitor) {
        return Node.accept(nodeVisitor, this.module.getExports());
    }

    public Source getSource() {
        return this.source;
    }

    public int getId() {
        return this.isProgram() ? -1 : Token.descPosition(this.firstToken);
    }

    public String getSourceName() {
        return FunctionNode.getSourceName(this.source);
    }

    public static String getSourceName(Source source) {
        String string = source.getExplicitURL();
        return string != null ? string : source.getName();
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    @Override
    public void toString(StringBuilder stringBuilder, boolean bl) {
        if (this.isAsync()) {
            stringBuilder.append("async ");
        }
        stringBuilder.append("function");
        if (this.ident != null) {
            stringBuilder.append(' ');
            this.ident.toString(stringBuilder, bl);
        }
        stringBuilder.append('(');
        Iterator<IdentNode> iterator = this.parameters.iterator();
        while (iterator.hasNext()) {
            IdentNode identNode = iterator.next();
            identNode.toString(stringBuilder, bl);
            if (!iterator.hasNext()) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append(')');
    }

    @Override
    public int getFlags() {
        return this.flags;
    }

    @Override
    public boolean getFlag(int n) {
        return (this.flags & n) != 0;
    }

    @Override
    public FunctionNode setFlags(LexicalContext lexicalContext, int n) {
        if (this.flags == n) {
            return this;
        }
        return Node.replaceInLexicalContext(lexicalContext, this, new FunctionNode(this, this.lastToken, this.endParserState, n, this.name, this.body, this.parameters, this.thisProperties, this.source, this.namespace));
    }

    @Override
    public FunctionNode setFlag(LexicalContext lexicalContext, int n) {
        return this.setFlags(lexicalContext, this.flags | n);
    }

    public boolean isProgram() {
        return this.getFlag(8192);
    }

    public boolean hasEval() {
        return this.getFlag(32);
    }

    public boolean hasNestedEval() {
        return this.getFlag(64);
    }

    public long getFirstToken() {
        return this.firstToken;
    }

    public boolean hasDeclaredFunctions() {
        return this.getFlag(1024);
    }

    public boolean usesThis() {
        return this.getFlag(32768);
    }

    public IdentNode getIdent() {
        return this.ident;
    }

    public Block getBody() {
        return this.body;
    }

    public FunctionNode setBody(LexicalContext lexicalContext, Block block) {
        if (this.body == block) {
            return this;
        }
        return Node.replaceInLexicalContext(lexicalContext, this, new FunctionNode(this, this.lastToken, this.endParserState, this.flags | (block.needsScope() ? 128 : 0), this.name, block, this.parameters, this.thisProperties, this.source, this.namespace));
    }

    public boolean isVarArg() {
        return this.needsArguments();
    }

    public boolean needsDynamicScope() {
        return this.hasEval() && !this.isStrict();
    }

    public boolean needsArguments() {
        return this.getFlag(40) && !this.getFlag(256) && !this.isProgram();
    }

    public boolean needsParentScope() {
        return this.getFlag(8800);
    }

    public int getThisProperties() {
        return this.thisProperties;
    }

    public Kind getKind() {
        return this.kind;
    }

    public long getLastToken() {
        return this.lastToken;
    }

    public Object getEndParserState() {
        return this.endParserState;
    }

    public String getName() {
        return this.name;
    }

    public FunctionNode setName(LexicalContext lexicalContext, String string) {
        if (this.name.equals(string)) {
            return this;
        }
        return Node.replaceInLexicalContext(lexicalContext, this, new FunctionNode(this, this.lastToken, this.endParserState, this.flags, string, this.body, this.parameters, this.thisProperties, this.source, this.namespace));
    }

    public boolean allVarsInScope() {
        return this.getFlag(96);
    }

    public boolean isSplit() {
        return this.getFlag(16);
    }

    public List<IdentNode> getParameters() {
        return Collections.unmodifiableList(this.parameters);
    }

    public int getNumOfParams() {
        return this.parameters.size();
    }

    public IdentNode getParameter(int n) {
        return this.parameters.get(n);
    }

    public boolean isDeclared() {
        return this.getFlag(2);
    }

    public boolean isAnonymous() {
        return this.getFlag(1);
    }

    public boolean isNamedFunctionExpression() {
        return !this.getFlag(8195);
    }

    public boolean isStrict() {
        return this.getFlag(4);
    }

    public boolean isMethod() {
        return this.getFlag(0x100000);
    }

    public boolean usesSuper() {
        return this.getFlag(524288);
    }

    public boolean hasDirectSuper() {
        return this.getFlag(262144);
    }

    public boolean isClassConstructor() {
        return this.getFlag(0x200000);
    }

    public boolean isSubclassConstructor() {
        return this.getFlag(0x400000);
    }

    public boolean usesNewTarget() {
        return this.getFlag(0x800000);
    }

    public boolean isModule() {
        return this.kind == Kind.MODULE;
    }

    public Module getModule() {
        return this.module;
    }

    public boolean isStatement() {
        return this.getFlag(0x1000000);
    }

    public boolean isAsync() {
        return this.getFlag(0x2000000);
    }

    public static enum Kind {
        NORMAL,
        SCRIPT,
        GETTER,
        SETTER,
        ARROW,
        GENERATOR,
        MODULE;

    }
}

