/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.regex.tregex.util.DebugUtil;
import com.oracle.truffle.regex.tregex.util.json.Json;
import com.oracle.truffle.regex.tregex.util.json.JsonConvertible;
import com.oracle.truffle.regex.tregex.util.json.JsonValue;

public final class RegexSource
implements JsonConvertible {
    private final String pattern;
    private final String flags;
    private Source source;
    private boolean hashComputed = false;
    private int cachedHash;

    public RegexSource(String pattern, String flags) {
        this.pattern = pattern;
        this.flags = flags;
    }

    public RegexSource(String pattern) {
        this(pattern, "");
    }

    public String getPattern() {
        return this.pattern;
    }

    public String getFlags() {
        return this.flags;
    }

    public Source getSource() {
        if (this.source == null) {
            String text = this.toString();
            this.source = Source.newBuilder((String)"regex", (CharSequence)text, (String)text).internal(true).name(text).mimeType("application/tregex").build();
        }
        return this.source;
    }

    public int hashCode() {
        if (!this.hashComputed) {
            int prime = 31;
            this.cachedHash = 1;
            this.cachedHash = 31 * this.cachedHash + this.pattern.hashCode();
            this.cachedHash = 31 * this.cachedHash + this.flags.hashCode();
            this.hashComputed = true;
        }
        return this.cachedHash;
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof RegexSource && this.pattern.equals(((RegexSource)obj).pattern) && this.flags.equals(((RegexSource)obj).flags);
    }

    public String toString() {
        return "/" + this.pattern + "/" + this.flags;
    }

    public String toFileName() {
        StringBuilder sb = new StringBuilder(20);
        int i = 0;
        while (i < Math.min(this.pattern.length(), 20)) {
            int c = this.pattern.codePointAt(i);
            if (DebugUtil.isValidCharForFileName(c)) {
                sb.appendCodePoint(c);
            } else {
                sb.append('_');
            }
            if (c > 65535) {
                i += 2;
                continue;
            }
            ++i;
        }
        if (!this.flags.isEmpty()) {
            sb.append('_').append(this.flags);
        }
        return sb.toString();
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public JsonValue toJson() {
        return Json.obj(Json.prop("pattern", this.pattern), Json.prop("flags", this.flags));
    }
}

