/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.charset;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.regex.charset.Constants;
import com.oracle.truffle.regex.charset.ImmutableSortedListOfRanges;
import com.oracle.truffle.regex.charset.RangesBuffer;
import com.oracle.truffle.regex.charset.SortedListOfRanges;
import com.oracle.truffle.regex.tregex.buffer.CompilationBuffer;
import com.oracle.truffle.regex.tregex.buffer.IntRangesBuffer;
import com.oracle.truffle.regex.tregex.util.json.Json;
import com.oracle.truffle.regex.tregex.util.json.JsonConvertible;
import com.oracle.truffle.regex.tregex.util.json.JsonValue;
import java.util.Arrays;

public final class CodePointSet
implements ImmutableSortedListOfRanges,
JsonConvertible {
    private static final CodePointSet CONSTANT_EMPTY;
    private static final CodePointSet CONSTANT_FULL;
    private static final CodePointSet[] CONSTANT_ASCII;
    private static final CodePointSet[] CONSTANT_INVERSE_ASCII;
    private static final CodePointSet[] CONSTANT_CASE_FOLD_ASCII;
    private final int[] ranges;

    private CodePointSet(int[] ranges) {
        this.ranges = ranges;
        assert ((ranges.length & 1) == 0) : "ranges array must have an even length!";
        assert (this.rangesAreSortedAndDisjoint());
    }

    public int[] getRanges() {
        return this.ranges;
    }

    public static CodePointSet getEmpty() {
        return CONSTANT_EMPTY;
    }

    public static CodePointSet getFull() {
        return CONSTANT_FULL;
    }

    public static CodePointSet create(int ... ranges) {
        CodePointSet constant = CodePointSet.checkConstants(ranges, ranges.length);
        if (constant == null) {
            return new CodePointSet(ranges);
        }
        return constant;
    }

    public static CodePointSet createNoDedup(int ... ranges) {
        return new CodePointSet(ranges);
    }

    public static CodePointSet create(IntRangesBuffer buf) {
        CodePointSet constant = CodePointSet.checkConstants(buf.getBuffer(), buf.length());
        if (constant == null) {
            return new CodePointSet(buf.toArray());
        }
        return constant;
    }

    private static CodePointSet checkConstants(int[] ranges, int length) {
        CodePointSet ret;
        if (length == 0) {
            return CONSTANT_EMPTY;
        }
        if (length == 1) {
            if (ranges[0] < 128) {
                return CONSTANT_ASCII[ranges[0]];
            }
            return new CodePointSet(new int[]{ranges[0], ranges[0]});
        }
        if (length == 2) {
            if (ranges[0] == ranges[1] && ranges[0] < 128) {
                return CONSTANT_ASCII[ranges[0]];
            }
            if (ranges[0] == 0 && ranges[1] == 0x10FFFF) {
                return CONSTANT_FULL;
            }
        }
        if (length == 4 && (ret = CodePointSet.checkInverseAndCaseFoldAscii(ranges[0], ranges[1], ranges[2], ranges[3])) != null) {
            return ret;
        }
        for (CodePointSet predefCC : Constants.CONSTANT_CODE_POINT_SETS) {
            if (predefCC.ranges.length != length || !CodePointSet.rangesEqual(predefCC.ranges, ranges, length)) continue;
            return predefCC;
        }
        return null;
    }

    private static boolean rangesEqual(int[] a, int[] b, int length) {
        for (int i = 0; i < length; ++i) {
            if (a[i] == b[i]) continue;
            return false;
        }
        return true;
    }

    private static CodePointSet checkInverseAndCaseFoldAscii(int lo0, int hi0, int lo1, int hi1) {
        if (lo0 == 0 && hi1 == 0x10FFFF && lo1 <= 128 && hi0 + 2 == lo1) {
            return CONSTANT_INVERSE_ASCII[hi0 + 1];
        }
        if (lo0 == hi0 && lo0 >= 65 && lo0 <= 90 && lo1 == hi1 && lo1 == Character.toLowerCase(lo0)) {
            return CONSTANT_CASE_FOLD_ASCII[lo0 - 65];
        }
        return null;
    }

    public CodePointSet createEmpty() {
        return CodePointSet.getEmpty();
    }

    public CodePointSet createFull() {
        return CodePointSet.getFull();
    }

    public CodePointSet create(RangesBuffer buffer) {
        assert (buffer instanceof IntRangesBuffer);
        return CodePointSet.create((IntRangesBuffer)buffer);
    }

    @Override
    public int getMinValue() {
        return 0;
    }

    @Override
    public int getMaxValue() {
        return 0x10FFFF;
    }

    @Override
    public int getLo(int i) {
        return this.ranges[i * 2];
    }

    @Override
    public int getHi(int i) {
        return this.ranges[i * 2 + 1];
    }

    @Override
    public int size() {
        return this.ranges.length / 2;
    }

    @Override
    public IntRangesBuffer getBuffer1(CompilationBuffer compilationBuffer) {
        return compilationBuffer.getIntRangesBuffer1();
    }

    @Override
    public IntRangesBuffer getBuffer2(CompilationBuffer compilationBuffer) {
        return compilationBuffer.getIntRangesBuffer2();
    }

    @Override
    public IntRangesBuffer getBuffer3(CompilationBuffer compilationBuffer) {
        return compilationBuffer.getIntRangesBuffer3();
    }

    @Override
    public IntRangesBuffer createTempBuffer() {
        return new IntRangesBuffer();
    }

    @Override
    public void appendRangesTo(RangesBuffer buffer, int startIndex, int endIndex) {
        int bulkLength = (endIndex - startIndex) * 2;
        if (bulkLength == 0) {
            return;
        }
        assert (buffer instanceof IntRangesBuffer);
        IntRangesBuffer buf = (IntRangesBuffer)buffer;
        int newSize = buf.length() + bulkLength;
        buf.ensureCapacity(newSize);
        assert (buf.isEmpty() || this.rightOf(startIndex, buf, buf.size() - 1));
        System.arraycopy(this.ranges, startIndex * 2, buf.getBuffer(), buf.length(), bulkLength);
        buf.setLength(newSize);
    }

    @Override
    public boolean equalsBuffer(RangesBuffer buffer) {
        assert (buffer instanceof IntRangesBuffer);
        IntRangesBuffer buf = (IntRangesBuffer)buffer;
        return this.ranges.length == buf.length() && CodePointSet.rangesEqual(this.ranges, buf.getBuffer(), this.ranges.length);
    }

    public CodePointSet createInverse() {
        return CodePointSet.createInverse(this);
    }

    public static CodePointSet createInverse(SortedListOfRanges src) {
        assert (src.getMinValue() == 0);
        assert (src.getMaxValue() == 0x10FFFF);
        if (src.matchesNothing()) {
            return CodePointSet.getFull();
        }
        if (src.matchesSingleAscii()) {
            return CONSTANT_INVERSE_ASCII[src.getLo(0)];
        }
        int[] invRanges = new int[src.sizeOfInverse() * 2];
        int i = 0;
        if (src.getLo(0) > src.getMinValue()) {
            CodePointSet.setRange(invRanges, i++, src.getMinValue(), src.getLo(0) - 1);
        }
        for (int ia = 1; ia < src.size(); ++ia) {
            CodePointSet.setRange(invRanges, i++, src.getHi(ia - 1) + 1, src.getLo(ia) - 1);
        }
        if (src.getHi(src.size() - 1) < src.getMaxValue()) {
            CodePointSet.setRange(invRanges, i++, src.getHi(src.size() - 1) + 1, src.getMaxValue());
        }
        return new CodePointSet(invRanges);
    }

    private static void setRange(int[] arr, int i, int lo, int hi) {
        arr[i * 2] = lo;
        arr[i * 2 + 1] = hi;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof CodePointSet) {
            return Arrays.equals(this.ranges, ((CodePointSet)obj).ranges);
        }
        if (obj instanceof SortedListOfRanges) {
            return this.equalsListOfRanges((SortedListOfRanges)obj);
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this.ranges);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public JsonValue toJson() {
        return Json.array(this.ranges);
    }

    @CompilerDirectives.TruffleBoundary
    public String dumpRaw() {
        StringBuilder sb = new StringBuilder(this.size() * 20);
        for (int i = 0; i < this.size(); ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(String.format("0x%06x, 0x%06x", this.getLo(i), this.getHi(i)));
        }
        return sb.toString();
    }

    static {
        int i;
        CONSTANT_EMPTY = new CodePointSet(new int[0]);
        CONSTANT_FULL = new CodePointSet(new int[]{0, 0x10FFFF});
        CONSTANT_ASCII = new CodePointSet[128];
        CONSTANT_INVERSE_ASCII = new CodePointSet[128];
        CONSTANT_CASE_FOLD_ASCII = new CodePointSet[26];
        CodePointSet.CONSTANT_ASCII[0] = new CodePointSet(new int[]{0, 0});
        CodePointSet.CONSTANT_INVERSE_ASCII[0] = new CodePointSet(new int[]{1, 0x10FFFF});
        for (i = 1; i < 128; ++i) {
            CodePointSet.CONSTANT_ASCII[i] = new CodePointSet(new int[]{i, i});
            CodePointSet.CONSTANT_INVERSE_ASCII[i] = new CodePointSet(new int[]{0, i - 1, i + 1, 0x10FFFF});
        }
        for (i = 65; i <= 90; ++i) {
            CodePointSet.CONSTANT_CASE_FOLD_ASCII[i - 65] = new CodePointSet(new int[]{i, i, Character.toLowerCase(i), Character.toLowerCase(i)});
        }
    }
}

