/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.tregex.nodes.input;

import com.oracle.truffle.api.ArrayUtils;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.regex.tregex.nodes.input.InputCharAtNode;
import com.oracle.truffle.regex.tregex.nodes.input.InputIndexOfNodeGen;

public abstract class InputIndexOfNode
extends Node {
    public static InputIndexOfNode create() {
        return InputIndexOfNodeGen.create();
    }

    public abstract int execute(Object var1, int var2, int var3, char[] var4);

    @Specialization
    public int indexOf(String input, int fromIndex, int maxIndex, char[] chars) {
        return ArrayUtils.indexOf((String)input, (int)fromIndex, (int)maxIndex, (char[])chars);
    }

    @Specialization
    public int indexOf(TruffleObject input, int fromIndex, int maxIndex, char[] chars, @Cached(value="create()") InputCharAtNode charAtNode) {
        for (int i = fromIndex; i < maxIndex; ++i) {
            char c = charAtNode.execute(input, i);
            for (char v : chars) {
                if (c != v) continue;
                return i;
            }
        }
        return -1;
    }

    static boolean maskIsZero(char mask) {
        return mask == '\u0000';
    }
}

