/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.tregex.parser;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.regex.RegexFlags;
import com.oracle.truffle.regex.RegexSource;
import com.oracle.truffle.regex.UnsupportedRegexException;
import com.oracle.truffle.regex.tregex.parser.RegexFeatures;
import java.util.Optional;

@FunctionalInterface
public interface RegexFeatureSet {
    public static final RegexFeatureSet DEFAULT = (source, features) -> Optional.empty();
    public static final RegexFeatureSet TREGEX = (source, features) -> {
        if (features.hasBackReferences()) {
            return Optional.of("backreferences not supported");
        }
        if (features.hasLargeCountedRepetitions()) {
            return Optional.of("bounds of range quantifier too high");
        }
        if (features.hasNegativeLookAheadAssertions()) {
            return Optional.of("negative lookahead assertions not supported");
        }
        if (features.hasNonLiteralLookBehindAssertions()) {
            return Optional.of("body of lookbehind assertion too complex");
        }
        if (features.hasNegativeLookBehindAssertions()) {
            return Optional.of("negative lookbehind assertions not supported");
        }
        return Optional.empty();
    };
    public static final RegexFeatureSet JONI = (source, features) -> {
        if (RegexFlags.parseFlags(source.getFlags()).isUnicode()) {
            return Optional.of("unicode mode not supported");
        }
        if (features.hasBackReferencesInLookBehind()) {
            return Optional.of("backreferences inside lookbehind assertions not supported");
        }
        if (features.hasNonTrivialQuantifiersInLookBehind()) {
            return Optional.of("quantifiers inside lookbehind assertions not supported");
        }
        if (features.hasWordBoundaryAssertionsInLookBehind()) {
            return Optional.of("word boundary assertions inside lookbehind assertions not supported");
        }
        if (features.hasEndOfStringAssertionsInLookBehind()) {
            return Optional.of("end of string assertions inside lookbehind assertions not supported");
        }
        if (features.hasNegativeLookBehindAssertionsInLookBehind()) {
            return Optional.of("negative lookbehind assertions inside lookbehind assertions not supported");
        }
        if (features.hasLookAheadAssertionsInLookBehind()) {
            return Optional.of("lookahead assertions inside lookbehind assertions not supported");
        }
        return Optional.empty();
    };
    public static final RegexFeatureSet TREGEX_JONI = (source, features) -> {
        Optional<String> joniBailout;
        Optional<String> tregexBailout = TREGEX.testSupport(source, features);
        if (tregexBailout.isPresent() && (joniBailout = JONI.testSupport(source, features)).isPresent()) {
            String bailoutReasons = String.format("TRegex: %s; Joni: %s", tregexBailout.get(), joniBailout.get());
            throw new UnsupportedRegexException(bailoutReasons, source);
        }
        return Optional.empty();
    };

    public Optional<String> testSupport(RegexSource var1, RegexFeatures var2);

    @CompilerDirectives.TruffleBoundary
    default public void checkSupport(RegexSource source, RegexFeatures features) throws UnsupportedRegexException {
        Optional<String> maybeError = this.testSupport(source, features);
        if (maybeError.isPresent()) {
            throw new UnsupportedRegexException(maybeError.get(), source);
        }
    }
}

