/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.navigation;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.DirectiveTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModuleTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.ModuleElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.ElementUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.TypeUtilities;
import org.netbeans.api.java.source.support.ErrorAwareTreePathScanner;
import org.netbeans.modules.java.navigation.ClassMemberPanel;
import org.netbeans.modules.java.navigation.ClassMemberPanelUI;
import org.netbeans.modules.java.navigation.ElementNode;
import org.netbeans.modules.java.navigation.actions.OpenAction;
import org.netbeans.modules.java.navigation.base.Utils;
import org.netbeans.modules.java.preprocessorbridge.api.ModuleUtilities;
import org.openide.filesystems.FileObject;
import org.openide.util.Parameters;

public class ElementScanningTask
implements CancellableTask<CompilationInfo> {
    private static final Logger LOG = Logger.getLogger(ElementScanningTask.class.getName());
    private final ClassMemberPanelUI ui;
    private final AtomicBoolean canceled = new AtomicBoolean();

    public ElementScanningTask(@NonNull ClassMemberPanelUI ui) {
        Parameters.notNull((CharSequence)"ui", (Object)ui);
        this.ui = ui;
    }

    public void cancel() {
        this.canceled.set(true);
    }

    public void run(CompilationInfo info) throws Exception {
        this.runImpl(info, false);
    }

    void runImpl(@NonNull CompilationInfo info, boolean userAction) throws Exception {
        List<Element> elements;
        this.ui.start();
        this.canceled.set(false);
        long start = System.currentTimeMillis();
        if (ClassMemberPanel.compareAndSetLastUsedFile(info.getFileObject()) && info.getChangedTree() != null) {
            long end = System.currentTimeMillis();
            Logger.getLogger("TIMER").log(Level.FINE, "Element Scanning Task", new Object[]{info.getFileObject(), end - start});
            return;
        }
        ElementNode.Description rootDescription = ElementNode.Description.root(this.ui);
        rootDescription.fileObject = info.getFileObject();
        rootDescription.subs = new HashSet<ElementNode.Description>();
        CompilationUnitTree cuTree = info.getCompilationUnit();
        Context ctx = null;
        if (!this.canceled.get()) {
            ctx = new PositionVisitor(info, this.canceled).scan((Tree)cuTree, null);
        }
        boolean fqn = this.ui.getFilters().isFqn();
        if (ElementScanningTask.isModuleInfo(info.getFileObject())) {
            if (cuTree != null) {
                Element me;
                List<? extends Tree> typeDecls = cuTree.getTypeDecls();
                elements = typeDecls.size() == 1 && (me = info.getTrees().getElement(TreePath.getPath(cuTree, typeDecls.get(0)))) instanceof ModuleElement ? Collections.singletonList(me) : Collections.emptyList();
            } else {
                TypeElement e = ModuleUtilities.get((Object)JavaSource.forFileObject((FileObject)info.getFileObject())).readClassFile();
                ModuleElement module = e == null ? null : (ModuleElement)e.getEnclosingElement();
                elements = module != null ? Collections.singletonList(module) : Collections.emptyList();
            }
        } else {
            elements = info.getTopLevelElements();
        }
        if (!this.canceled.get() && elements != null) {
            for (Element element : elements) {
                ElementNode.Description topLevel = this.element2description(element, null, false, info, ctx, fqn);
                if (null == topLevel) continue;
                if (!rootDescription.subs.add(topLevel)) {
                    LOG.log(Level.INFO, "Duplicate top level class: {0}", topLevel.name);
                }
                if (element.getKind().isClass() || element.getKind().isInterface()) {
                    this.addMembers((TypeElement)element, topLevel, info, ctx, fqn);
                    continue;
                }
                if (element.getKind() != ElementKind.MODULE) continue;
                this.addModuleDirectives((ModuleElement)element, topLevel, ctx, info, fqn);
            }
        }
        if (!this.canceled.get()) {
            this.ui.refresh(rootDescription, userAction);
        }
        long end = System.currentTimeMillis();
        Logger.getLogger("TIMER").log(Level.FINE, "Element Scanning Task", new Object[]{info.getFileObject(), end - start});
    }

    private void addMembers(TypeElement e, ElementNode.Description parentDescription, CompilationInfo info, Context ctx, boolean fqn) {
        List<? extends Element> members = info.getElements().getAllMembers(e);
        for (Element element : members) {
            ElementNode.Description d;
            if (this.canceled.get()) {
                return;
            }
            if (element.getKind() == ElementKind.STATIC_INIT || null == (d = this.element2description(element, e, parentDescription.isInherited, info, ctx, fqn))) continue;
            if (!parentDescription.subs.add(d)) {
                LOG.log(Level.INFO, "Duplicate enclosed element: {0}", d.name);
            }
            if (!(element instanceof TypeElement) || d.isInherited) continue;
            this.addMembers((TypeElement)element, d, info, ctx, fqn);
        }
    }

    private ElementNode.Description element2description(Element e, Element parent, boolean isParentInherited, CompilationInfo info, Context ctx, boolean fqn) {
        ExecutableElement overriden;
        ElementUtilities eu = info.getElementUtilities();
        if (info.getElements().getOrigin(e) == Elements.Origin.SYNTHETIC) {
            return null;
        }
        boolean inherited = isParentInherited || null != parent && !parent.equals(e.getEnclosingElement());
        Element encElement = e.getEnclosingElement();
        TypeElement overridenFrom = null;
        if (e.getKind() == ElementKind.METHOD && (overriden = eu.getOverriddenMethod((ExecutableElement)e)) != null) {
            overridenFrom = (TypeElement)overriden.getEnclosingElement();
        }
        boolean isModule = e.getKind() == ElementKind.MODULE;
        Set<Modifier> mods = e.getModifiers();
        if (isModule) {
            EnumSet<Modifier> tmp = EnumSet.of(Modifier.PUBLIC);
            tmp.addAll(mods);
            mods = tmp;
        }
        ElementNode.Description d = ElementNode.Description.element(this.ui, ElementScanningTask.getSimpleName(e), (ElementHandle<? extends Element>)ElementHandle.create((Element)e), info.getClasspathInfo(), mods, ctx.getStartPosition(e), inherited, encElement != null && encElement.getKind() == ElementKind.PACKAGE);
        if (e instanceof TypeElement) {
            d.subs = new HashSet<ElementNode.Description>();
            d.htmlHeader = this.createHtmlHeader(info, (TypeElement)e, info.getElements().isDeprecated(e), d.isInherited, fqn);
        } else if (e instanceof ExecutableElement) {
            d.htmlHeader = this.createHtmlHeader(info, (ExecutableElement)e, info.getElements().isDeprecated(e), d.isInherited, fqn, overridenFrom);
        } else if (e instanceof VariableElement) {
            if (e.getKind() != ElementKind.FIELD && e.getKind() != ElementKind.ENUM_CONSTANT && !e.getKind().name().equals("STATE_COMPONENT")) {
                return null;
            }
            d.htmlHeader = this.createHtmlHeader(info, (VariableElement)e, info.getElements().isDeprecated(e), d.isInherited, fqn);
        } else if (isModule) {
            ModuleElement me = (ModuleElement)e;
            d.htmlHeader = me.getQualifiedName().toString();
        }
        return d;
    }

    private void addModuleDirectives(@NonNull ModuleElement module, @NonNull ElementNode.Description target, @NonNull Context ctx, @NonNull CompilationInfo info, boolean fqn) {
        target.subs = new HashSet<ElementNode.Description>();
        for (ModuleElement.Directive directive : module.getDirectives()) {
            ElementNode.Description dirDesc;
            if (!ElementScanningTask.isImportant(directive)) continue;
            ClasspathInfo cpInfo = info.getClasspathInfo();
            if (ctx.isSource) {
                DirectiveTree dt = ctx.getDirectiveTree(directive);
                TreePathHandle treePathHandle = TreePathHandle.create((TreePath)TreePath.getPath(info.getCompilationUnit(), (Tree)dt), (CompilationInfo)info);
                String name = ElementScanningTask.getDirectiveName(directive, fqn);
                dirDesc = ElementNode.Description.directive(this.ui, name, treePathHandle, directive.getKind(), cpInfo, ctx.getStartPosition(directive), OpenAction.openable(treePathHandle, ctx.getFileObject(), name));
            } else {
                dirDesc = ElementNode.Description.directive(this.ui, ElementScanningTask.getDirectiveName(directive, fqn), directive.getKind(), cpInfo, OpenAction.openable(module, directive, cpInfo));
            }
            dirDesc.htmlHeader = this.createHtmlHeader(info, directive, fqn);
            target.subs.add(dirDesc);
        }
    }

    private static String getSimpleName(@NonNull Element e) {
        if (e.getKind() == ElementKind.CONSTRUCTOR) {
            return e.getEnclosingElement().getSimpleName().toString();
        }
        return e.getSimpleName().toString();
    }

    private static boolean isModuleInfo(@NullAllowed FileObject file) {
        return file != null && "module-info".equals(file.getName());
    }

    private static boolean isImportant(@NonNull ModuleElement.Directive directive) {
        if (directive instanceof ModuleElement.RequiresDirective) {
            try {
                Set flags = (Set)directive.getClass().getField("flags").get(directive);
                int expectedSize = 0;
                if (((ModuleElement.RequiresDirective)directive).isStatic()) {
                    ++expectedSize;
                }
                if (((ModuleElement.RequiresDirective)directive).isTransitive()) {
                    ++expectedSize;
                }
                return flags.size() == expectedSize;
            }
            catch (ReflectiveOperationException e) {
                throw new IllegalStateException(e);
            }
        }
        return true;
    }

    @NonNull
    private static String getDirectiveName(@NonNull ModuleElement.Directive directive, boolean fqn) {
        StringBuilder sb = new StringBuilder();
        switch (directive.getKind()) {
            case EXPORTS: {
                sb.append(((ModuleElement.ExportsDirective)directive).getPackage().getQualifiedName());
                break;
            }
            case OPENS: {
                sb.append(((ModuleElement.OpensDirective)directive).getPackage().getQualifiedName());
                break;
            }
            case REQUIRES: {
                sb.append(((ModuleElement.RequiresDirective)directive).getDependency().getQualifiedName());
                break;
            }
            case USES: {
                TypeElement service = ((ModuleElement.UsesDirective)directive).getService();
                sb.append(fqn ? service.getQualifiedName() : service.getSimpleName());
                break;
            }
            case PROVIDES: {
                TypeElement impl = ((ModuleElement.ProvidesDirective)directive).getService();
                sb.append(fqn ? impl.getQualifiedName() : impl.getSimpleName());
                break;
            }
            default: {
                throw new IllegalArgumentException(directive.toString());
            }
        }
        return sb.toString();
    }

    private String createHtmlHeader(CompilationInfo info, ExecutableElement e, boolean isDeprecated, boolean isInherited, boolean fqn, TypeElement overridenFrom) {
        TypeMirror rt;
        StringBuilder sb = new StringBuilder();
        if (isDeprecated) {
            sb.append("<s>");
        }
        if (isInherited) {
            sb.append("<font color=" + this.ui.getInheritedColor() + ">");
        }
        Name name = e.getKind() == ElementKind.CONSTRUCTOR ? e.getEnclosingElement().getSimpleName() : e.getSimpleName();
        sb.append(Utils.escape(name.toString()));
        if (isDeprecated) {
            sb.append("</s>");
        }
        sb.append("(");
        List<? extends VariableElement> params = e.getParameters();
        Iterator<? extends VariableElement> it = params.iterator();
        while (it.hasNext()) {
            VariableElement param = it.next();
            sb.append("<font color=" + this.ui.getTypeColor() + ">");
            boolean vararg = !it.hasNext() && e.isVarArgs();
            sb.append(this.printArg(info, param.asType(), vararg, fqn));
            sb.append("</font>");
            sb.append(" ");
            sb.append(Utils.escape(param.getSimpleName().toString()));
            if (!it.hasNext()) continue;
            sb.append(", ");
        }
        sb.append(")");
        if (e.getKind() != ElementKind.CONSTRUCTOR && (rt = e.getReturnType()).getKind() != TypeKind.VOID) {
            sb.append(" : ");
            sb.append("<font color=" + this.ui.getTypeColor() + ">");
            sb.append(this.print(info, e.getReturnType(), fqn));
            sb.append("</font>");
        }
        if (!isInherited && overridenFrom != null) {
            sb.append(" \u2191 ");
            sb.append(this.print(info, overridenFrom.asType(), fqn));
        }
        return sb.toString();
    }

    private String createHtmlHeader(CompilationInfo info, VariableElement e, boolean isDeprecated, boolean isInherited, boolean fqn) {
        StringBuilder sb = new StringBuilder();
        if (isDeprecated) {
            sb.append("<s>");
        }
        if (isInherited) {
            sb.append("<font color=" + this.ui.getInheritedColor() + ">");
        }
        sb.append(Utils.escape(e.getSimpleName().toString()));
        if (isDeprecated) {
            sb.append("</s>");
        }
        if (e.getKind() != ElementKind.ENUM_CONSTANT) {
            sb.append(" : ");
            sb.append("<font color=" + this.ui.getTypeColor() + ">");
            sb.append(this.print(info, e.asType(), fqn));
            sb.append("</font>");
        }
        return sb.toString();
    }

    @NonNull
    private String createHtmlHeader(@NonNull CompilationInfo info, @NonNull ModuleElement.Directive directive, boolean fqn) {
        StringBuilder sb = new StringBuilder();
        switch (directive.getKind()) {
            case REQUIRES: {
                sb.append(((ModuleElement.RequiresDirective)directive).getDependency().getQualifiedName());
                break;
            }
            case EXPORTS: {
                sb.append(((ModuleElement.ExportsDirective)directive).getPackage().getQualifiedName());
                break;
            }
            case OPENS: {
                sb.append(((ModuleElement.OpensDirective)directive).getPackage().getQualifiedName());
                break;
            }
            case USES: {
                TypeElement service = ((ModuleElement.UsesDirective)directive).getService();
                sb.append(fqn ? service.getQualifiedName() : service.getSimpleName());
                break;
            }
            case PROVIDES: {
                TypeElement intf = ((ModuleElement.ProvidesDirective)directive).getService();
                sb.append(fqn ? intf.getQualifiedName() : intf.getSimpleName());
                break;
            }
            default: {
                throw new IllegalArgumentException(directive.toString());
            }
        }
        return sb.toString();
    }

    private String createHtmlHeader(CompilationInfo info, TypeElement e, boolean isDeprecated, boolean isInherited, boolean fqn) {
        List<? extends TypeParameterElement> typeParams;
        StringBuilder sb = new StringBuilder();
        if (isDeprecated) {
            sb.append("<s>");
        }
        if (isInherited) {
            sb.append("<font color=" + this.ui.getInheritedColor() + ">");
        }
        sb.append(Utils.escape(fqn ? e.getQualifiedName().toString() : e.getSimpleName().toString()));
        if (isDeprecated) {
            sb.append("</s>");
        }
        if ((typeParams = e.getTypeParameters()) != null && !typeParams.isEmpty()) {
            sb.append("&lt;");
            Iterator<? extends TypeParameterElement> it = typeParams.iterator();
            while (it.hasNext()) {
                TypeParameterElement tp = it.next();
                sb.append(Utils.escape(tp.getSimpleName().toString()));
                try {
                    List<? extends TypeMirror> bounds = tp.getBounds();
                    if (!bounds.isEmpty()) {
                        sb.append(this.printBounds(info, bounds, fqn));
                    }
                }
                catch (NullPointerException npe) {
                    System.err.println("El " + e);
                    npe.printStackTrace();
                }
                if (!it.hasNext()) continue;
                sb.append(", ");
            }
            sb.append("&gt;");
        }
        TypeMirror sc = e.getSuperclass();
        String scName = this.print(info, sc, fqn);
        if (sc == null || e.getKind() == ElementKind.ENUM || e.getKind() == ElementKind.ANNOTATION_TYPE || "Object".equals(scName) || "<none>".equals(scName)) {
            scName = null;
        }
        List<? extends TypeMirror> ifaces = e.getInterfaces();
        if (!(scName == null && ifaces.isEmpty() || e.getKind() == ElementKind.ANNOTATION_TYPE)) {
            sb.append(" :: ");
            if (scName != null) {
                sb.append("<font color=" + this.ui.getTypeColor() + ">");
                sb.append(scName);
                sb.append("</font>");
            }
            if (!ifaces.isEmpty()) {
                if (scName != null) {
                    sb.append(" : ");
                }
                Iterator<? extends TypeMirror> it = ifaces.iterator();
                while (it.hasNext()) {
                    TypeMirror typeMirror = it.next();
                    sb.append("<font color=" + this.ui.getTypeColor() + ">");
                    sb.append(this.print(info, typeMirror, fqn));
                    sb.append("</font>");
                    if (!it.hasNext()) continue;
                    sb.append(", ");
                }
            }
        }
        return sb.toString();
    }

    private String printBounds(CompilationInfo info, List<? extends TypeMirror> bounds, boolean fqn) {
        if (bounds.size() == 1 && "java.lang.Object".equals(bounds.get(0).toString())) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(" extends ");
        Iterator<? extends TypeMirror> it = bounds.iterator();
        while (it.hasNext()) {
            TypeMirror bound = it.next();
            sb.append(this.print(info, bound, fqn));
            if (!it.hasNext()) continue;
            sb.append(" & ");
        }
        return sb.toString();
    }

    private String printArg(CompilationInfo info, TypeMirror tm, boolean varArg, boolean fqn) {
        if (varArg) {
            if (tm.getKind() == TypeKind.ARRAY) {
                ArrayType at = (ArrayType)tm;
                StringBuilder sb = new StringBuilder(this.print(info, at.getComponentType(), fqn));
                sb.append("...");
                return sb.toString();
            }
            assert (false) : "Expected array: " + tm.toString() + " ( " + (Object)((Object)tm.getKind()) + " )";
        }
        return this.print(info, tm, fqn);
    }

    private String print(CompilationInfo info, TypeMirror tm, boolean fqn) {
        return Utils.escape(fqn ? info.getTypeUtilities().getTypeName(tm, new TypeUtilities.TypeNameOptions[]{TypeUtilities.TypeNameOptions.PRINT_FQN}).toString() : info.getTypeUtilities().getTypeName(tm, new TypeUtilities.TypeNameOptions[0]).toString());
    }

    private static class PositionVisitor
    extends ErrorAwareTreePathScanner<Context, Void> {
        private final Trees trees;
        private final SourcePositions sourcePositions;
        private final AtomicBoolean canceled;
        private final Context ctx;
        private CompilationUnitTree cu;

        public PositionVisitor(@NonNull CompilationInfo info, @NonNull AtomicBoolean canceled) {
            assert (canceled != null);
            this.trees = info.getTrees();
            this.sourcePositions = this.trees.getSourcePositions();
            this.canceled = canceled;
            this.ctx = new Context(info.getFileObject(), info.getCompilationUnit() != null);
        }

        public Context visitCompilationUnit(CompilationUnitTree node, Void p) {
            this.cu = node;
            return (Context)super.visitCompilationUnit(node, (Object)p);
        }

        public Context visitClass(ClassTree node, Void p) {
            Element e = this.trees.getElement(this.getCurrentPath());
            if (e != null) {
                long pos = this.sourcePositions.getStartPosition(this.cu, node);
                this.ctx.pos.put(e, pos);
            }
            return (Context)super.visitClass(node, (Object)p);
        }

        public Context visitMethod(MethodTree node, Void p) {
            Element e = this.trees.getElement(this.getCurrentPath());
            if (e != null) {
                long pos = this.sourcePositions.getStartPosition(this.cu, node);
                this.ctx.pos.put(e, pos);
            }
            return null;
        }

        public Context visitVariable(VariableTree node, Void p) {
            Element e = this.trees.getElement(this.getCurrentPath());
            if (e != null) {
                long pos = this.sourcePositions.getStartPosition(this.cu, node);
                this.ctx.pos.put(e, pos);
            }
            return null;
        }

        public Context visitModule(ModuleTree node, Void p) {
            ModuleElement module = (ModuleElement)this.trees.getElement(this.getCurrentPath());
            if (module != null) {
                this.ctx.pos.put(module, this.sourcePositions.getStartPosition(this.cu, node));
                List<? extends ModuleElement.Directive> de = module.getDirectives();
                List<? extends DirectiveTree> dt = node.getDirectives();
                int j = 0;
                for (int i = 0; i < de.size(); ++i) {
                    if (!ElementScanningTask.isImportant(de.get(i))) continue;
                    this.ctx.directives.put(de.get(i), dt.get(j));
                    this.ctx.pos.put(de.get(i), this.sourcePositions.getStartPosition(this.cu, dt.get(j)));
                    ++j;
                }
            }
            return (Context)super.visitModule(node, (Object)p);
        }

        public Context scan(Tree tree, Void p) {
            if (!this.canceled.get()) {
                super.scan(tree, (Object)p);
                return this.ctx;
            }
            return null;
        }
    }

    private static final class Context {
        private final FileObject file;
        private final boolean isSource;
        private final Map<Object, Long> pos = new HashMap<Object, Long>();
        private final Map<ModuleElement.Directive, DirectiveTree> directives = new HashMap<ModuleElement.Directive, DirectiveTree>();

        Context(@NonNull FileObject file, boolean isSource) {
            this.file = file;
            this.isSource = isSource;
        }

        @NonNull
        FileObject getFileObject() {
            return this.file;
        }

        boolean isSourceFile() {
            return this.isSource;
        }

        long getStartPosition(@NonNull Element element) {
            Long res = this.pos.get(element);
            return res == null ? -1L : res;
        }

        long getStartPosition(@NonNull ModuleElement.Directive directive) {
            Long res = this.pos.get(directive);
            return res == null ? -1L : res;
        }

        @CheckForNull
        DirectiveTree getDirectiveTree(@NonNull ModuleElement.Directive directive) {
            return this.directives.get(directive);
        }
    }
}

