/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.ProtectionDomain;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.objectweb.asm.ClassWriter;

public class NoJavacHelper {
    private static final AtomicReference<Boolean> hasWorkingJavac = new AtomicReference();

    public static boolean hasWorkingJavac() {
        Boolean res = hasWorkingJavac.get();
        if (res != null) {
            return res;
        }
        try {
            Class.forName("javax.lang.model.element.ModuleElement");
            res = true;
        }
        catch (ClassNotFoundException ex) {
            res = false;
        }
        hasWorkingJavac.compareAndSet(null, res);
        return hasWorkingJavac.get();
    }

    public static boolean hasNbJavac() {
        try {
            Class.forName("com.sun.tools.javac.comp.Repair");
            return true;
        }
        catch (ClassNotFoundException ex) {
            return false;
        }
    }

    public static class FixClasses
    implements Runnable {
        @Override
        public void run() {
            if (!NoJavacHelper.hasWorkingJavac()) {
                String JavaVersion = System.getProperty("java.specification.version");
                boolean isJdkVer8OrBelow = true;
                if (!JavaVersion.startsWith("1.")) {
                    isJdkVer8OrBelow = false;
                }
                if (isJdkVer8OrBelow) {
                    ClassWriter w = new ClassWriter(0);
                    w.visit(52, 1025, "com/sun/tools/javac/code/Scope$WriteableScope", null, "com/sun/tools/javac/code/Scope", null);
                    byte[] classData = w.toByteArray();
                    this.defineClass("com.sun.tools.javac.code.Scope$WriteableScope", "com.sun.tools.javac.code.Scope", classData);
                    w = new ClassWriter(0);
                    w.visit(52, 1537, "javax/lang/model/element/ModuleElement", null, "java/lang/Object", new String[]{"javax/lang/model/element/Element"});
                    classData = w.toByteArray();
                    this.defineClass("javax.lang.model.element.ModuleElement", "com.sun.tools.javac.code.Scope", classData);
                }
            }
        }

        private void defineClass(String fqn, String injectToClass, byte[] classData) {
            try {
                Class<?> unsafeClass = Class.forName("sun.misc.Unsafe");
                Field theUnsafe = unsafeClass.getDeclaredField("theUnsafe");
                theUnsafe.setAccessible(true);
                Object unsafe = theUnsafe.get(null);
                Class<?> targetClass = Class.forName(injectToClass);
                Method defineClass = unsafeClass.getDeclaredMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE, ClassLoader.class, ProtectionDomain.class);
                defineClass.invoke(unsafe, fqn, classData, 0, classData.length, targetClass.getClassLoader(), targetClass.getProtectionDomain());
            }
            catch (Throwable t) {
                Logger.getLogger(NoJavacHelper.class.getName()).log(Level.WARNING, null, t);
            }
        }
    }
}

