/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.parsing;

import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Scope;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.api.JavacScope;
import com.sun.tools.javac.api.JavacTaskImpl;
import com.sun.tools.javac.api.JavacTrees;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.comp.Attr;
import com.sun.tools.javac.comp.AttrContext;
import com.sun.tools.javac.comp.Enter;
import com.sun.tools.javac.comp.Env;
import com.sun.tools.javac.comp.Flow;
import com.sun.tools.javac.comp.TypeEnter;
import com.sun.tools.javac.parser.JavacParser;
import com.sun.tools.javac.parser.LazyDocCommentTable;
import com.sun.tools.javac.parser.Scanner;
import com.sun.tools.javac.parser.ScannerFactory;
import com.sun.tools.javac.tree.EndPosTable;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeInfo;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Names;
import com.sun.tools.javac.util.Options;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.CharBuffer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticListener;
import javax.tools.JavaFileObject;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.lib.nbjavac.services.CancelService;
import org.netbeans.lib.nbjavac.services.NBLog;
import org.netbeans.lib.nbjavac.services.NBParserFactory;
import org.netbeans.modules.java.source.JavaSourceAccessor;
import org.netbeans.modules.java.source.parsing.CompilationInfoImpl;
import org.netbeans.modules.java.source.parsing.FindAnonymousVisitor;
import org.netbeans.modules.java.source.parsing.JavacFlowListener;
import org.netbeans.modules.java.source.parsing.JavacParser;
import org.netbeans.modules.java.source.parsing.TranslatePositionsVisitor;
import org.netbeans.modules.parsing.api.Snapshot;
import org.openide.filesystems.FileObject;

public class VanillaPartialReparser
implements JavacParser.PartialReparser {
    private static final Logger LOGGER = Logger.getLogger(VanillaPartialReparser.class.getName());
    private final Method unenter;
    private final Field lazyDocCommentsTable;
    private final Field parserDocComments;
    private final Method lineMapBuild;
    private final boolean allowPartialReparse;

    public VanillaPartialReparser() {
        Method lineMapBuild;
        Field parserDocComments;
        Field lazyDocCommentsTable;
        Method unenter;
        try {
            unenter = Enter.class.getDeclaredMethod("unenter", JCTree.JCCompilationUnit.class, JCTree.class);
        }
        catch (NoSuchMethodException ex) {
            unenter = null;
        }
        this.unenter = unenter;
        try {
            lazyDocCommentsTable = LazyDocCommentTable.class.getDeclaredField("table");
            lazyDocCommentsTable.setAccessible(true);
        }
        catch (NoSuchFieldException | SecurityException ex) {
            lazyDocCommentsTable = null;
        }
        this.lazyDocCommentsTable = lazyDocCommentsTable;
        try {
            parserDocComments = com.sun.tools.javac.parser.JavacParser.class.getDeclaredField("docComments");
            parserDocComments.setAccessible(true);
        }
        catch (NoSuchFieldException | SecurityException ex) {
            parserDocComments = null;
        }
        this.parserDocComments = parserDocComments;
        try {
            Class<?> lineMapImpl = Class.forName("com.sun.tools.javac.util.Position$LineMapImpl");
            lineMapBuild = lineMapImpl.getDeclaredMethod("build", char[].class, Integer.TYPE);
            lineMapBuild.setAccessible(true);
        }
        catch (ClassNotFoundException | NoSuchMethodException ex) {
            lineMapBuild = null;
        }
        this.lineMapBuild = lineMapBuild;
        this.allowPartialReparse = unenter != null && lazyDocCommentsTable != null && parserDocComments != null && lineMapBuild != null && Boolean.getBoolean("java.enable.partial.reparse");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean reparseMethod(CompilationInfoImpl ci, Snapshot snapshot, MethodTree orig, String newBody) throws IOException {
        JavaSource.Phase currentPhase;
        if (!this.allowPartialReparse) {
            return false;
        }
        assert (ci != null);
        FileObject fo = ci.getFileObject();
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.log(Level.FINER, "Reparse method in: {0}", fo);
        }
        if (JavaSource.Phase.PARSED.compareTo(currentPhase = ci.getPhase()) > 0) {
            return false;
        }
        try {
            CompilationUnitTree cu = ci.getCompilationUnit();
            if (cu == null) return false;
            if (newBody == null) return false;
            if (orig.getBody() == null) {
                return false;
            }
            JavacTaskImpl task = ci.getJavacTask();
            if (Options.instance(task.getContext()).isSet("lombokDetected")) {
                return false;
            }
            CompilationInfo info = JavaSourceAccessor.getINSTANCE().createCompilationInfo(ci);
            TreePath methodPath = info.getTreeUtilities().pathFor(((JCTree.JCMethodDecl)orig).pos);
            if (methodPath.getLeaf().getKind() != Tree.Kind.METHOD) {
                return false;
            }
            Scope methodScope = info.getTrees().getScope(new TreePath(methodPath, ((MethodTree)methodPath.getLeaf()).getBody()));
            JavacTrees jt = JavacTrees.instance(task);
            int origStartPos = (int)jt.getSourcePositions().getStartPosition(cu, orig.getBody());
            int origEndPos = (int)jt.getSourcePositions().getEndPosition(cu, orig.getBody());
            if (origStartPos < 0) {
                LOGGER.log(Level.WARNING, "Javac returned startpos: {0} < 0", new Object[]{origStartPos});
                return false;
            }
            if (origStartPos > origEndPos) {
                LOGGER.log(Level.WARNING, "Javac returned startpos: {0} > endpos: {1}", new Object[]{origStartPos, origEndPos});
                return false;
            }
            FindAnonymousVisitor fav = new FindAnonymousVisitor();
            fav.scan(orig.getBody(), null);
            if (fav.hasLocalClass) {
                if (!LOGGER.isLoggable(Level.FINER)) return false;
                LOGGER.log(Level.FINER, "Skeep reparse method (old local classes): {0}", fo);
                return false;
            }
            int noInner = fav.noInner;
            Context ctx = task.getContext();
            NBLog l = NBLog.instance((Context)ctx);
            l.startPartialReparse(cu.getSourceFile());
            JavaFileObject prevLogged = l.useSource(cu.getSourceFile());
            try {
                DiagnosticListener<JavaFileObject> dl = ci.getDiagnosticListener();
                assert (dl instanceof CompilationInfoImpl.DiagnosticListenerImpl);
                ((CompilationInfoImpl.DiagnosticListenerImpl)dl).startPartialReparse(origStartPos, origEndPos);
                long start = System.currentTimeMillis();
                HashMap<JCTree, Object> docComments = new HashMap<JCTree, Object>();
                JCTree.JCBlock block = this.reparseMethodBody(ctx, cu, orig, newBody + " ", docComments);
                EndPosTable endPos = ((JCTree.JCCompilationUnit)cu).endPositions;
                LOGGER.log(Level.FINER, "Reparsed method in: {0}", fo);
                if (block == null) {
                    LOGGER.log(Level.FINER, "Skeep reparse method, invalid position, newBody: ", newBody);
                    boolean bl = false;
                    return bl;
                }
                int newEndPos = (int)jt.getSourcePositions().getEndPosition(cu, block);
                if (newEndPos != origStartPos + newBody.length()) {
                    boolean bl = false;
                    return bl;
                }
                fav.reset();
                fav.scan(block, null);
                int newNoInner = fav.noInner;
                if (fav.hasLocalClass || noInner != newNoInner) {
                    if (LOGGER.isLoggable(Level.FINER)) {
                        LOGGER.log(Level.FINER, "Skeep reparse method (new local classes): {0}", fo);
                    }
                    boolean bl = false;
                    return bl;
                }
                Map docCommentsTable = (Map)this.lazyDocCommentsTable.get(((JCTree.JCCompilationUnit)cu).docComments);
                docCommentsTable.keySet().removeAll(fav.docOwners);
                docCommentsTable.putAll(docComments);
                long end = System.currentTimeMillis();
                if (fo != null) {
                    JavacParser.logTime(fo, JavaSource.Phase.PARSED, end - start);
                }
                int delta = newEndPos - origEndPos;
                TranslatePositionsVisitor tpv = new TranslatePositionsVisitor(orig, endPos, delta);
                tpv.scan((Tree)cu, null);
                if (this.unenter != null) {
                    this.unenter.invoke((Object)Enter.instance(ctx), cu, ((JCTree.JCMethodDecl)orig).body);
                }
                ((JCTree.JCMethodDecl)orig).body = block;
                if (JavaSource.Phase.RESOLVED.compareTo(currentPhase) <= 0) {
                    JavacFlowListener fl;
                    start = System.currentTimeMillis();
                    this.reattrMethodBody(ctx, methodScope, orig, block);
                    if (LOGGER.isLoggable(Level.FINER)) {
                        LOGGER.log(Level.FINER, "Resolved method in: {0}", fo);
                    }
                    if (!((CompilationInfoImpl.DiagnosticListenerImpl)dl).hasPartialReparseErrors() && (fl = JavacFlowListener.instance(ctx)) != null && fl.hasFlowCompleted(fo)) {
                        java.util.List<Diagnostic> diag;
                        if (LOGGER.isLoggable(Level.FINER) && !(diag = ci.getDiagnostics()).isEmpty()) {
                            LOGGER.log(Level.FINER, "Reflow with errors: {0} {1}", new Object[]{fo, diag});
                        }
                        TreePath tp = TreePath.getPath(cu, (Tree)orig);
                        Tree t = tp.getParentPath().getLeaf();
                        this.reflowMethodBody(ctx, cu, (ClassTree)t, orig);
                        if (LOGGER.isLoggable(Level.FINER)) {
                            LOGGER.log(Level.FINER, "Reflowed method in: {0}", fo);
                        }
                    }
                    end = System.currentTimeMillis();
                    if (fo != null) {
                        JavacParser.logTime(fo, JavaSource.Phase.ELEMENTS_RESOLVED, 0L);
                        JavacParser.logTime(fo, JavaSource.Phase.RESOLVED, end - start);
                    }
                }
                long startM = System.currentTimeMillis();
                char[] chars = snapshot.getText().toString().toCharArray();
                if (this.lineMapBuild != null) {
                    this.lineMapBuild.invoke((Object)cu.getLineMap(), chars, chars.length);
                }
                LOGGER.log(Level.FINER, "Rebuilding LineMap took: {0}", System.currentTimeMillis() - startM);
                ((CompilationInfoImpl.DiagnosticListenerImpl)dl).endPartialReparse(delta);
            }
            finally {
                l.endPartialReparse(cu.getSourceFile());
                l.useSource(prevLogged);
            }
            ci.update(snapshot);
            return true;
        }
        catch (Throwable t) {
            if (t instanceof ThreadDeath) {
                throw (ThreadDeath)t;
            }
            boolean a = false;
            if (!$assertionsDisabled) {
                a = true;
            }
            if (a) {
                JavacParser.dumpSource(ci, t);
            }
            t.printStackTrace();
            return false;
        }
    }

    public JCTree.JCBlock reparseMethodBody(Context ctx, CompilationUnitTree topLevel, MethodTree methodToReparse, String newBodyText, Map<JCTree, Object> docComments) throws IllegalArgumentException, IllegalAccessException {
        int startPos = ((JCTree.JCBlock)methodToReparse.getBody()).pos;
        char[] body = new char[startPos + newBodyText.length() + 1];
        Arrays.fill(body, 0, startPos, ' ');
        for (int i = 0; i < newBodyText.length(); ++i) {
            body[startPos + i] = newBodyText.charAt(i);
        }
        body[startPos + newBodyText.length()] = '\u0000';
        CharBuffer buf = CharBuffer.wrap(body, 0, body.length - 1);
        com.sun.tools.javac.parser.JavacParser parser = this.newParser(ctx, buf, ((JCTree.JCBlock)methodToReparse.getBody()).pos, ((JCTree.JCCompilationUnit)topLevel).endPositions);
        JCTree.JCStatement statement = parser.parseStatement();
        if (statement.getKind() == Tree.Kind.BLOCK) {
            if (docComments != null) {
                docComments.putAll((Map)this.lazyDocCommentsTable.get(this.parserDocComments.get(parser)));
            }
            return (JCTree.JCBlock)statement;
        }
        return null;
    }

    private com.sun.tools.javac.parser.JavacParser newParser(Context context, CharSequence input, int startPos, final EndPosTable endPos) {
        NBParserFactory parserFactory = (NBParserFactory)NBParserFactory.instance((Context)context);
        ScannerFactory scannerFactory = ScannerFactory.instance(context);
        CancelService cancelService = CancelService.instance((Context)context);
        Scanner lexer = scannerFactory.newScanner(input, true);
        if (endPos instanceof NBParserFactory.NBJavacParser.EndPosTableImpl) {
            ((NBParserFactory.NBJavacParser.EndPosTableImpl)endPos).resetErrorEndPos();
        }
        return new NBParserFactory.NBJavacParser(parserFactory, lexer, true, false, true, false, cancelService){

            protected JavacParser.AbstractEndPosTable newEndPosTable(boolean keepEndPositions) {
                return new JavacParser.AbstractEndPosTable((com.sun.tools.javac.parser.JavacParser)((Object)this)){

                    @Override
                    public void storeEnd(JCTree tree, int endpos) {
                        ((NBParserFactory.NBJavacParser.EndPosTableImpl)endPos).storeEnd(tree, endpos);
                    }

                    @Override
                    protected <T extends JCTree> T to(T t) {
                        this.storeEnd(t, (this).token.endPos);
                        return t;
                    }

                    @Override
                    protected <T extends JCTree> T toP(T t) {
                        this.storeEnd(t, (this).S.prevToken().endPos);
                        return t;
                    }

                    @Override
                    public int getEndPos(JCTree tree) {
                        return endPos.getEndPos(tree);
                    }

                    @Override
                    public int replaceTree(JCTree oldtree, JCTree newtree) {
                        return endPos.replaceTree(oldtree, newtree);
                    }

                    @Override
                    public void setErrorEndPos(int errPos) {
                        super.setErrorEndPos(errPos);
                        ((NBParserFactory.NBJavacParser.EndPosTableImpl)endPos).setErrorEndPos(errPos);
                    }
                };
            }
        };
    }

    public BlockTree reattrMethodBody(Context context, Scope scope, MethodTree methodToReparse, BlockTree block) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Attr attr = Attr.instance(context);
        JCTree.JCMethodDecl tree = (JCTree.JCMethodDecl)methodToReparse;
        Names names = Names.instance(context);
        Symtab syms = Symtab.instance(context);
        TypeEnter typeEnter = TypeEnter.instance(context);
        Log log = Log.instance(context);
        TreeMaker make = TreeMaker.instance(context);
        Env<AttrContext> env = ((JavacScope)scope).getEnv();
        Symbol.ClassSymbol owner = env.enclClass.sym;
        if (tree.name == names.init && !owner.type.isErroneous() && owner.type != syms.objectType) {
            JCTree.JCBlock body = tree.body;
            if (body.stats.isEmpty() || !TreeInfo.isSelfCall((JCTree)body.stats.head)) {
                body.stats = body.stats.prepend(make.at(body.pos).Exec(make.Apply(List.nil(), make.Ident(names._super), List.nil())));
            } else if ((env.enclClass.sym.flags() & 0x4000L) != 0L && (tree.mods.flags & 0x1000000000L) == 0L && TreeInfo.isSuperCall((JCTree)body.stats.head)) {
                log.error(((JCTree.JCStatement)tree.body.stats.head).pos(), new JCDiagnostic.Error("compiler", "call.to.super.not.allowed.in.enum.ctor", env.enclClass.sym));
            }
        }
        attr.attribStat((JCTree.JCBlock)block, env);
        return block;
    }

    public BlockTree reflowMethodBody(Context context, CompilationUnitTree topLevel, ClassTree ownerClass, MethodTree methodToReparse) {
        Flow flow = Flow.instance(context);
        TreeMaker make = TreeMaker.instance(context);
        Enter enter = Enter.instance(context);
        flow.analyzeTree(enter.getEnv(((JCTree.JCClassDecl)ownerClass).sym), make);
        return methodToReparse.getBody();
    }
}

