/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.jemmy.drivers.scrolling;

import org.netbeans.jemmy.drivers.LightSupportiveDriver;
import org.netbeans.jemmy.drivers.ScrollDriver;
import org.netbeans.jemmy.drivers.scrolling.ScrollAdjuster;
import org.netbeans.jemmy.operators.ComponentOperator;
import org.netbeans.jemmy.operators.JButtonOperator;
import org.netbeans.jemmy.operators.JSpinnerOperator;

public class JSpinnerDriver
extends LightSupportiveDriver
implements ScrollDriver {
    public JSpinnerDriver() {
        super(new String[]{"org.netbeans.jemmy.operators.JSpinnerOperator"});
    }

    @Override
    public void scrollToMinimum(final ComponentOperator oper, int orientation) {
        Object minimum = ((JSpinnerOperator)oper).getMinimum();
        if (minimum == null) {
            throw new JSpinnerOperator.SpinnerModelException("Impossible to get a minimum of JSpinner model.", oper.getSource());
        }
        this.scroll(oper, new ScrollAdjuster(){

            @Override
            public int getScrollOrientation() {
                return 1;
            }

            @Override
            public String getDescription() {
                return "Spin to minimum";
            }

            @Override
            public int getScrollDirection() {
                if (((JSpinnerOperator)oper).getModel().getPreviousValue() != null) {
                    return -1;
                }
                return 0;
            }
        });
    }

    @Override
    public void scrollToMaximum(final ComponentOperator oper, int orientation) {
        Object maximum = ((JSpinnerOperator)oper).getMaximum();
        if (maximum == null) {
            throw new JSpinnerOperator.SpinnerModelException("Impossible to get a maximum of JSpinner model.", oper.getSource());
        }
        this.scroll(oper, new ScrollAdjuster(){

            @Override
            public int getScrollOrientation() {
                return 1;
            }

            @Override
            public String getDescription() {
                return "Spin to maximum";
            }

            @Override
            public int getScrollDirection() {
                if (((JSpinnerOperator)oper).getModel().getNextValue() != null) {
                    return 1;
                }
                return 0;
            }
        });
    }

    @Override
    public void scroll(ComponentOperator oper, ScrollAdjuster adj) {
        JButtonOperator increaseButton = ((JSpinnerOperator)oper).getIncreaseOperator();
        JButtonOperator decreaseButton = ((JSpinnerOperator)oper).getDecreaseOperator();
        if (adj.getScrollDirection() == 0) {
            return;
        }
        int originalDirection = adj.getScrollDirection();
        while (adj.getScrollDirection() == originalDirection) {
            if (originalDirection == 1) {
                increaseButton.push();
                continue;
            }
            decreaseButton.push();
        }
    }
}

