/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cpplite.debugger;

import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.modules.cpplite.debugger.breakpoints.CPPLiteBreakpoint;
import org.netbeans.spi.debugger.ui.BreakpointAnnotation;
import org.openide.text.Annotatable;
import org.openide.util.NbBundle;

public class DebuggerBreakpointAnnotation
extends BreakpointAnnotation {
    public static final String BREAKPOINT_ANNOTATION_TYPE = "Breakpoint";
    public static final String DISABLED_BREAKPOINT_ANNOTATION_TYPE = "DisabledBreakpoint";
    public static final String CONDITIONAL_BREAKPOINT_ANNOTATION_TYPE = "CondBreakpoint";
    public static final String DISABLED_CONDITIONAL_BREAKPOINT_ANNOTATION_TYPE = "DisabledCondBreakpoint";
    private Annotatable annotatable;
    private String type;
    private CPPLiteBreakpoint breakpoint;

    public DebuggerBreakpointAnnotation(String type, CPPLiteBreakpoint b) {
        this.type = type;
        this.annotatable = b.getLine();
        this.breakpoint = b;
        this.attach(this.annotatable);
    }

    public String getAnnotationType() {
        return this.type;
    }

    public String getShortDescription() {
        if (this.type == BREAKPOINT_ANNOTATION_TYPE) {
            return NbBundle.getMessage(DebuggerBreakpointAnnotation.class, (String)"TOOLTIP_BREAKPOINT");
        }
        if (this.type == DISABLED_BREAKPOINT_ANNOTATION_TYPE) {
            return NbBundle.getMessage(DebuggerBreakpointAnnotation.class, (String)"TOOLTIP_DISABLED_BREAKPOINT");
        }
        if (this.type == CONDITIONAL_BREAKPOINT_ANNOTATION_TYPE) {
            return NbBundle.getMessage(DebuggerBreakpointAnnotation.class, (String)"TOOLTIP_CONDITIONAL_BREAKPOINT");
        }
        if (this.type == DISABLED_CONDITIONAL_BREAKPOINT_ANNOTATION_TYPE) {
            return NbBundle.getMessage(DebuggerBreakpointAnnotation.class, (String)"TOOLTIP_DISABLED_CONDITIONAL_BREAKPOINT");
        }
        return null;
    }

    public Breakpoint getBreakpoint() {
        return this.breakpoint;
    }
}

