/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ant.debugger.breakpoints;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerManagerAdapter;
import org.netbeans.modules.ant.debugger.DebuggerBreakpointAnnotation;
import org.netbeans.modules.ant.debugger.breakpoints.AntBreakpoint;

public class BreakpointAnnotationListener
extends DebuggerManagerAdapter
implements PropertyChangeListener {
    private Map breakpointToAnnotation = new HashMap();

    public String[] getProperties() {
        return new String[]{"breakpoints"};
    }

    public void breakpointAdded(Breakpoint b) {
        if (!(b instanceof AntBreakpoint)) {
            return;
        }
        this.addAnnotation((AntBreakpoint)b);
    }

    public void breakpointRemoved(Breakpoint b) {
        if (!(b instanceof AntBreakpoint)) {
            return;
        }
        this.removeAnnotation(b);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName() != "enabled") {
            return;
        }
        this.removeAnnotation((Breakpoint)evt.getSource());
        this.addAnnotation((AntBreakpoint)((Object)evt.getSource()));
    }

    private void addAnnotation(AntBreakpoint b) {
        this.breakpointToAnnotation.put(b, new DebuggerBreakpointAnnotation(b.isEnabled() ? "Breakpoint" : "DisabledBreakpoint", b));
        b.addPropertyChangeListener("enabled", this);
    }

    private void removeAnnotation(Breakpoint b) {
        DebuggerBreakpointAnnotation annotation = (DebuggerBreakpointAnnotation)((Object)this.breakpointToAnnotation.remove(b));
        if (annotation == null) {
            return;
        }
        annotation.detach();
        b.removePropertyChangeListener("enabled", (PropertyChangeListener)this);
    }
}

