/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.ui;

import com.formdev.flatlaf.ui.FlatUIUtils;
import com.formdev.flatlaf.util.UIScale;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Path2D;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicArrowButton;

public class FlatArrowButton
extends BasicArrowButton
implements UIResource {
    public static final int DEFAULT_ARROW_WIDTH = 8;
    private final boolean chevron;
    private final Color foreground;
    private final Color disabledForeground;
    private final Color hoverForeground;
    private final Color hoverBackground;
    private int arrowWidth = 8;
    private int xOffset = 0;
    private int yOffset = 0;
    private boolean hover;

    public FlatArrowButton(int direction, String type, Color foreground, Color disabledForeground, Color hoverForeground, Color hoverBackground) {
        super(direction, Color.WHITE, Color.WHITE, Color.WHITE, Color.WHITE);
        this.chevron = "chevron".equals(type);
        this.foreground = foreground;
        this.disabledForeground = disabledForeground;
        this.hoverForeground = hoverForeground;
        this.hoverBackground = hoverBackground;
        this.setOpaque(false);
        this.setBorder(null);
        if (hoverForeground != null || hoverBackground != null) {
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent e) {
                    FlatArrowButton.this.hover = true;
                    FlatArrowButton.this.repaint();
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    FlatArrowButton.this.hover = false;
                    FlatArrowButton.this.repaint();
                }
            });
        }
    }

    public int getArrowWidth() {
        return this.arrowWidth;
    }

    public void setArrowWidth(int arrowWidth) {
        this.arrowWidth = arrowWidth;
    }

    protected boolean isHover() {
        return this.hover;
    }

    public int getXOffset() {
        return this.xOffset;
    }

    public void setXOffset(int xOffset) {
        this.xOffset = xOffset;
    }

    public int getYOffset() {
        return this.yOffset;
    }

    public void setYOffset(int yOffset) {
        this.yOffset = yOffset;
    }

    @Override
    public Dimension getPreferredSize() {
        return UIScale.scale(super.getPreferredSize());
    }

    @Override
    public Dimension getMinimumSize() {
        return UIScale.scale(super.getMinimumSize());
    }

    @Override
    public void paint(Graphics g) {
        int direction;
        Graphics2D g2 = (Graphics2D)g;
        FlatUIUtils.setRenderingHints(g2);
        int width = this.getWidth();
        int height = this.getHeight();
        boolean enabled = this.isEnabled();
        if (enabled && this.isHover() && this.hoverBackground != null) {
            g.setColor(this.hoverBackground);
            g.fillRect(0, 0, width, height);
        }
        boolean vert = (direction = this.getDirection()) == 1 || direction == 5;
        int w = UIScale.scale(this.arrowWidth + (this.chevron ? 0 : 1));
        int h = UIScale.scale(this.arrowWidth / 2 + (this.chevron ? 0 : 1));
        int rw = vert ? w : h;
        int rh = vert ? h : w;
        int x = Math.round((float)(width - rw) / 2.0f + UIScale.scale((float)this.xOffset));
        int y = Math.round((float)(height - rh) / 2.0f + UIScale.scale((float)this.yOffset));
        if (x + rw >= width && x > 0) {
            --x;
        }
        if (y + rh >= height && y > 0) {
            --y;
        }
        g.setColor(enabled ? (this.isHover() && this.hoverForeground != null ? this.hoverForeground : this.foreground) : this.disabledForeground);
        g.translate(x, y);
        Shape arrowShape = FlatArrowButton.createArrowShape(direction, this.chevron, w, h);
        if (this.chevron) {
            g2.setStroke(new BasicStroke(UIScale.scale(1.0f)));
            g2.draw(arrowShape);
        } else {
            g2.fill(arrowShape);
        }
        g.translate(-x, -y);
    }

    public static Shape createArrowShape(int direction, boolean chevron, float w, float h) {
        switch (direction) {
            case 1: {
                return FlatUIUtils.createPath(!chevron, 0.0, h, w / 2.0f, 0.0, w, h);
            }
            case 5: {
                return FlatUIUtils.createPath(!chevron, 0.0, 0.0, w / 2.0f, h, w, 0.0);
            }
            case 7: {
                return FlatUIUtils.createPath(!chevron, h, 0.0, 0.0, w / 2.0f, h, w);
            }
            case 3: {
                return FlatUIUtils.createPath(!chevron, 0.0, 0.0, h, w / 2.0f, 0.0, w);
            }
        }
        return new Path2D.Float();
    }
}

