/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.codestructure;

import java.beans.PropertyEditor;
import org.netbeans.modules.form.FormProperty;
import org.netbeans.modules.form.RADComponent;
import org.netbeans.modules.form.codestructure.CodeExpression;
import org.netbeans.modules.form.codestructure.CodeExpressionOrigin;
import org.netbeans.modules.form.codestructure.CodeStatement;
import org.netbeans.modules.form.codestructure.CodeStructure;
import org.openide.ErrorManager;
import org.openide.nodes.Node;

public class FormCodeSupport {
    public static CodeExpressionOrigin createOrigin(Node.Property property) {
        if (property instanceof FormProperty) {
            return new FormPropertyValueOrigin((FormProperty)property);
        }
        return new PropertyValueOrigin(property);
    }

    public static CodeExpressionOrigin createOrigin(Class type, PropertyEditor prEd) {
        return new PropertyEditorOrigin(type, prEd);
    }

    public static CodeExpressionOrigin createOrigin(RADComponent component) {
        return new RADComponentOrigin(component);
    }

    public static void readPropertyExpression(CodeExpression expression, Node.Property property, boolean allowChangeFiring) {
        FormProperty fProperty;
        FormProperty formProperty = fProperty = property instanceof FormProperty ? (FormProperty)property : null;
        if (fProperty != null) {
            Object metaOrigin;
            if (!allowChangeFiring) {
                if (fProperty.isChangeFiring()) {
                    fProperty.setChangeFiring(false);
                } else {
                    allowChangeFiring = true;
                }
            }
            if ((metaOrigin = expression.getOrigin().getMetaObject()) instanceof PropertyEditor) {
                fProperty.setCurrentEditor((PropertyEditor)metaOrigin);
            }
        }
        try {
            property.setValue(expression.getOrigin().getValue());
        }
        catch (Exception ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
        }
        expression.setOrigin(FormCodeSupport.createOrigin(property));
        if (fProperty != null && !allowChangeFiring) {
            fProperty.setChangeFiring(true);
        }
    }

    public static void readPropertyStatement(CodeStatement statement, Node.Property property, boolean allowChangeFiring) {
        CodeExpression[] params = statement.getStatementParameters();
        if (params.length != 1) {
            throw new IllegalArgumentException();
        }
        FormCodeSupport.readPropertyExpression(params[0], property, allowChangeFiring);
    }

    static final class RADComponentOrigin
    implements CodeExpressionOrigin {
        private RADComponent component;

        public RADComponentOrigin(RADComponent component) {
            this.component = component;
        }

        @Override
        public Class getType() {
            return this.component.getBeanClass();
        }

        @Override
        public CodeExpression getParentExpression() {
            return null;
        }

        @Override
        public Object getMetaObject() {
            return this.component;
        }

        @Override
        public Object getValue() {
            return this.component.getBeanInstance();
        }

        @Override
        public CodeExpression[] getCreationParameters() {
            return CodeStructure.EMPTY_PARAMS;
        }

        @Override
        public String getJavaCodeString(String parentStr, String[] paramsStr) {
            if (this.component == this.component.getFormModel().getTopRADComponent()) {
                return "this";
            }
            StringBuilder buf = new StringBuilder();
            buf.append("new ");
            buf.append(this.component.getBeanClass().getName().replace('&', '.'));
            buf.append("()");
            return buf.toString();
        }
    }

    static final class PropertyEditorOrigin
    implements CodeExpressionOrigin {
        private Class type;
        private PropertyEditor propertyEditor;

        public PropertyEditorOrigin(Class type, PropertyEditor prEd) {
            this.type = type;
            this.propertyEditor = prEd;
        }

        @Override
        public Class getType() {
            return this.type;
        }

        @Override
        public CodeExpression getParentExpression() {
            return null;
        }

        @Override
        public Object getValue() {
            return this.propertyEditor.getValue();
        }

        @Override
        public Object getMetaObject() {
            return this.propertyEditor;
        }

        @Override
        public String getJavaCodeString(String parentStr, String[] paramsStr) {
            return this.propertyEditor.getJavaInitializationString();
        }

        @Override
        public CodeExpression[] getCreationParameters() {
            return CodeStructure.EMPTY_PARAMS;
        }
    }

    static final class FormPropertyValueOrigin
    implements CodeExpressionOrigin {
        private FormProperty property;

        public FormPropertyValueOrigin(FormProperty property) {
            this.property = property;
        }

        @Override
        public Class getType() {
            return this.property.getValueType();
        }

        @Override
        public CodeExpression getParentExpression() {
            return null;
        }

        @Override
        public Object getValue() {
            try {
                return this.property.getRealValue();
            }
            catch (Exception exception) {
                return null;
            }
        }

        @Override
        public Object getMetaObject() {
            return this.property;
        }

        @Override
        public String getJavaCodeString(String parentStr, String[] paramsStr) {
            return this.property.getJavaInitializationString();
        }

        @Override
        public CodeExpression[] getCreationParameters() {
            return CodeStructure.EMPTY_PARAMS;
        }
    }

    static final class PropertyValueOrigin
    implements CodeExpressionOrigin {
        private Node.Property property;

        public PropertyValueOrigin(Node.Property property) {
            this.property = property;
        }

        @Override
        public Class getType() {
            return this.property.getValueType();
        }

        @Override
        public CodeExpression getParentExpression() {
            return null;
        }

        @Override
        public Object getValue() {
            try {
                return this.property.getValue();
            }
            catch (Exception exception) {
                return null;
            }
        }

        @Override
        public Object getMetaObject() {
            return this.property;
        }

        @Override
        public String getJavaCodeString(String parentStr, String[] paramsStr) {
            try {
                PropertyEditor pred = this.property.getPropertyEditor();
                pred.setValue(this.property.getValue());
                return pred.getJavaInitializationString();
            }
            catch (Exception exception) {
                return null;
            }
        }

        @Override
        public CodeExpression[] getCreationParameters() {
            return CodeStructure.EMPTY_PARAMS;
        }
    }
}

