/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.javaee.web.newproject;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;
import javax.swing.AbstractButton;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.j2ee.core.Profile;
import org.netbeans.modules.gradle.javaee.api.ui.support.DisplayNameListCellRenderer;
import org.netbeans.modules.gradle.javaee.api.ui.support.JavaEEServerComboBoxModel;
import org.netbeans.modules.gradle.javaee.web.newproject.Bundle;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eePlatform;
import org.netbeans.modules.j2ee.deployment.devmodules.api.ServerManager;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class ServerSelectionPanelVisual
extends JPanel {
    final J2eeModule.Type type;
    final DefaultComboBoxModel<Profile> profiles = new DefaultComboBoxModel();
    final List<ChangeListener> listeners = new LinkedList<ChangeListener>();
    private JButton btAddServerButton;
    private JComboBox<J2eePlatform> cbServer;
    private JComboBox<Profile> cbVersion;
    private JLabel lbServer;
    private JLabel lbVersion;

    public ServerSelectionPanelVisual(J2eeModule.Type type) {
        this.type = type;
        this.initComponents();
        this.cbServer.setRenderer(new DisplayNameListCellRenderer<J2eePlatform>(this.cbServer.getRenderer()));
        this.cbVersion.setRenderer(new DisplayNameListCellRenderer<Profile>(this.cbVersion.getRenderer()));
        ComboBoxModel<J2eePlatform> model = JavaEEServerComboBoxModel.createJavaEEServerComboBoxModel(null, type, null);
        this.cbVersion.setModel(this.profiles);
        this.cbServer.setModel(model);
        if (model.getSize() > 0) {
            this.cbServer.setSelectedIndex(0);
        }
    }

    private void initComponents() {
        this.lbServer = new JLabel();
        this.cbServer = new JComboBox();
        this.btAddServerButton = new JButton();
        this.lbVersion = new JLabel();
        this.cbVersion = new JComboBox();
        this.lbServer.setLabelFor(this.cbServer);
        Mnemonics.setLocalizedText((JLabel)this.lbServer, (String)NbBundle.getMessage(ServerSelectionPanelVisual.class, (String)"ServerSelectionPanelVisual.lbServer.text"));
        this.cbServer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ServerSelectionPanelVisual.this.cbServerActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.btAddServerButton, (String)NbBundle.getMessage(ServerSelectionPanelVisual.class, (String)"ServerSelectionPanelVisual.btAddServerButton.text"));
        this.btAddServerButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ServerSelectionPanelVisual.this.btAddServerButtonActionPerformed(evt);
            }
        });
        this.lbVersion.setLabelFor(this.cbVersion);
        Mnemonics.setLocalizedText((JLabel)this.lbVersion, (String)NbBundle.getMessage(ServerSelectionPanelVisual.class, (String)"ServerSelectionPanelVisual.lbVersion.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.lbVersion, -1, -1, Short.MAX_VALUE).addComponent(this.lbServer, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.cbServer, 0, 192, Short.MAX_VALUE).addComponent(this.cbVersion, 0, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btAddServerButton).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lbServer).addComponent(this.cbServer, -2, -1, -2).addComponent(this.btAddServerButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lbVersion).addComponent(this.cbVersion, -2, -1, -2)).addContainerGap(232, Short.MAX_VALUE)));
    }

    @Override
    public String getName() {
        return Bundle.ServerSelectionPanel();
    }

    private void btAddServerButtonActionPerformed(ActionEvent evt) {
        String newServerId = ServerManager.showAddServerInstanceWizard();
        if (newServerId != null) {
            ComboBoxModel<J2eePlatform> model = JavaEEServerComboBoxModel.createJavaEEServerComboBoxModel(newServerId, this.type, null);
            this.cbServer.setModel(model);
            this.cbServerActionPerformed(null);
        }
        this.fireStateChange();
    }

    private void cbServerActionPerformed(ActionEvent evt) {
        J2eePlatform platform;
        Object previousItem = this.cbVersion.getSelectedItem();
        this.profiles.removeAllElements();
        int selectedServer = this.cbServer.getSelectedIndex();
        if (selectedServer >= 0 && (platform = (J2eePlatform)this.cbServer.getModel().getElementAt(selectedServer)) != null) {
            TreeSet<Profile> availableProfiles = new TreeSet<Profile>(Profile.UI_COMPARATOR);
            for (Profile profile : platform.getSupportedProfiles(this.type)) {
                if (this.type != J2eeModule.Type.WAR ? profile == Profile.JAVA_EE_6_WEB || profile == Profile.JAVA_EE_7_WEB || profile == Profile.JAVA_EE_8_WEB || profile == Profile.JAKARTA_EE_8_WEB : profile == Profile.JAVA_EE_6_FULL || profile == Profile.JAVA_EE_7_FULL || profile == Profile.JAVA_EE_8_FULL || profile == Profile.JAKARTA_EE_8_FULL) continue;
                if (profile == Profile.J2EE_13 || profile == Profile.J2EE_14) continue;
                availableProfiles.add(profile);
            }
            for (Profile profile : availableProfiles) {
                this.profiles.addElement(profile);
            }
            if (previousItem != null && availableProfiles.contains(previousItem)) {
                this.cbVersion.setSelectedItem(previousItem);
            } else {
                this.cbVersion.setSelectedIndex(0);
            }
        }
    }

    void read(WizardDescriptor settings) {
        String profileId;
        String instanceId = (String)settings.getProperty("platformId");
        if (instanceId != null) {
            this.cbServer.setModel(JavaEEServerComboBoxModel.createJavaEEServerComboBoxModel(instanceId, this.type, null));
        }
        if ((profileId = (String)settings.getProperty("profileId")) != null) {
            Profile profile = Profile.fromPropertiesString((String)profileId);
            this.cbVersion.setSelectedItem(profile);
        }
    }

    void write(WizardDescriptor settings) {
        if (this.cbVersion.getSelectedIndex() >= 0) {
            settings.putProperty("profileId", (Object)this.cbVersion.getItemAt(this.cbVersion.getSelectedIndex()).toPropertiesString());
        }
        if (this.cbServer.getSelectedIndex() >= 0) {
            String instanceId = JavaEEServerComboBoxModel.getServerInstanceID(this.cbServer.getItemAt(this.cbServer.getSelectedIndex()));
            settings.putProperty("platformId", (Object)instanceId);
        }
    }

    boolean isValidSelection() {
        return this.cbVersion.getSelectedItem() != null && this.cbServer.getSelectedItem() != null;
    }

    public void fireStateChange() {
        ChangeEvent evt = new ChangeEvent(this);
        for (ChangeListener listener : this.listeners) {
            listener.stateChanged(evt);
        }
    }

    public void addChangeListener(ChangeListener l) {
        this.listeners.add(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.listeners.remove(l);
    }
}

