/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ide.ergonomics.fod;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import org.netbeans.api.autoupdate.UpdateElement;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.ide.ergonomics.fod.BrokenProjectInfo;
import org.netbeans.modules.ide.ergonomics.fod.FeatureInfo;
import org.netbeans.modules.ide.ergonomics.fod.FeatureManager;
import org.netbeans.modules.ide.ergonomics.fod.FindComponentModules;
import org.netbeans.modules.ide.ergonomics.fod.ModulesInstaller;
import org.netbeans.modules.ide.ergonomics.fod.ProgressMonitor;
import org.openide.awt.Mnemonics;
import org.openide.modules.ModuleInfo;
import org.openide.modules.SpecificationVersion;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.TaskListener;

public class ConfigurationPanel
extends JPanel {
    private static final long serialVersionUID = 27938464212508L;
    final DownloadProgressMonitor progressMonitor = new DownloadProgressMonitor();
    private FeatureInfo featureInfo;
    private Callable<JComponent> callable;
    private Collection<UpdateElement> featureInstall;
    private final SpecificationVersion jdk = new SpecificationVersion(System.getProperty("java.specification.version"));
    private HashSet<FeatureInfo.ExtraModuleInfo> extrasFilter;
    private JButton activateButton;
    private JButton downloadButton;
    private JLabel downloadLabel;
    private JEditorPane errorLabel;
    private JLabel infoLabel;
    private JPanel progressPanel;
    private JPanel selectionsPanel;

    public ConfigurationPanel(String displayName, Callable<JComponent> callable, FeatureInfo info) {
        this(callable);
        this.setInfo(info, displayName, Collections.emptyList(), Collections.emptyList(), Collections.emptyMap(), false);
    }

    public ConfigurationPanel(Callable<JComponent> callable) {
        assert (EventQueue.isDispatchThread());
        this.initComponents();
        this.featureInfo = null;
        this.callable = callable;
        this.setError(" ");
    }

    public void setInfo(FeatureInfo info, String displayName, Collection<UpdateElement> toInstall, Collection<FeatureInfo.ExtraModuleInfo> missingModules, Map<FeatureInfo.ExtraModuleInfo, FeatureInfo> extrasMap, boolean required) {
        this.extrasFilter = new HashSet();
        this.featureInfo = info;
        this.featureInstall = toInstall;
        boolean activateNow = toInstall.isEmpty() && missingModules.isEmpty();
        Set<FeatureInfo.ExtraModuleInfo> extraModules = this.featureInfo.getExtraModules();
        Collection lookupAll = Lookup.getDefault().lookupAll(ModuleInfo.class);
        FindComponentModules findModules = new FindComponentModules(info, new FeatureInfo[0]);
        Collection<UpdateElement> modulesToInstall = findModules.getModulesForInstall();
        this.selectionsPanel.removeAll();
        for (FeatureInfo.ExtraModuleInfo extraModule : extraModules) {
            JCheckBox jCheckBox = new JCheckBox(extraModule.displayName());
            for (ModuleInfo moduleInfo : lookupAll) {
                if (!extraModule.matches(moduleInfo.getCodeName())) continue;
                jCheckBox.setText(moduleInfo.getDisplayName());
            }
            for (UpdateElement updateElement : modulesToInstall) {
                if (!extraModule.matches(updateElement.getCodeName())) continue;
                jCheckBox.setText(updateElement.getDisplayName());
            }
            if (extraModule.isRequiredFor(this.jdk)) {
                jCheckBox.setSelected(true);
                this.extrasFilter.add(extraModule);
            }
            jCheckBox.addActionListener(e -> {
                if (jCheckBox.isSelected()) {
                    this.extrasFilter.add(extraModule);
                } else {
                    this.extrasFilter.remove(extraModule);
                }
            });
            this.selectionsPanel.add(jCheckBox);
        }
        if (activateNow) {
            this.infoLabel.setVisible(false);
            this.downloadLabel.setVisible(false);
            this.activateButton.setVisible(false);
            this.downloadButton.setVisible(false);
            this.activateButtonActionPerformed(null);
        } else {
            FeatureManager.logUI("ERGO_QUESTION", this.featureInfo.clusterName, displayName);
            this.infoLabel.setVisible(true);
            this.downloadLabel.setVisible(true);
            this.activateButton.setVisible(true);
            this.downloadButton.setVisible(true);
            List<String> downloadStringList = this.collectExtraModulesTextsFromFeatures(extrasMap.values(), required);
            String lblDownloadMsg = this.generateDownloadMessageFromExtraModulesTexts(downloadStringList);
            if (required) {
                this.activateButton.setEnabled(false);
            } else {
                this.activateButton.setEnabled(true);
            }
            if (!missingModules.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                for (FeatureInfo.ExtraModuleInfo s : missingModules) {
                    if (sb.length() > 0) {
                        sb.append(", ");
                    }
                    sb.append(s.displayName());
                }
                String list = sb.toString();
                if (required) {
                    lblDownloadMsg = NbBundle.getMessage(ConfigurationPanel.class, (String)"MSG_MissingRequiredModules", (Object)displayName, (Object)list);
                    this.activateButton.setEnabled(false);
                } else {
                    lblDownloadMsg = NbBundle.getMessage(ConfigurationPanel.class, (String)"MSG_MissingRecommendedModules", (Object)displayName, (Object)list);
                }
                this.downloadButton.setEnabled(false);
            } else {
                this.downloadButton.setEnabled(true);
            }
            String lblActivateMsg = NbBundle.getMessage(ConfigurationPanel.class, (String)"LBL_EnableInfo", (Object)displayName);
            String btnActivateMsg = NbBundle.getMessage(ConfigurationPanel.class, (String)"LBL_Enable");
            String btnDownloadMsg = NbBundle.getMessage(ConfigurationPanel.class, (String)"LBL_Download");
            Mnemonics.setLocalizedText((JLabel)this.infoLabel, (String)lblActivateMsg);
            Mnemonics.setLocalizedText((AbstractButton)this.activateButton, (String)btnActivateMsg);
            Mnemonics.setLocalizedText((JLabel)this.downloadLabel, (String)lblDownloadMsg);
            Mnemonics.setLocalizedText((AbstractButton)this.downloadButton, (String)btnDownloadMsg);
        }
    }

    protected List<String> collectExtraModulesTextsFromFeatures(Collection<FeatureInfo> features, boolean required) {
        ArrayList<String> descriptionsList = new ArrayList<String>();
        for (FeatureInfo fi : features) {
            String s = required ? fi.getExtraModulesRequiredText() : fi.getExtraModulesRecommendedText();
            if (!Objects.nonNull(s) || descriptionsList.contains(s)) continue;
            descriptionsList.add(s);
        }
        return descriptionsList;
    }

    protected String generateDownloadMessageFromExtraModulesTexts(List<String> extraModulesTexts) {
        StringBuilder sbDownload = new StringBuilder();
        if (!extraModulesTexts.isEmpty()) {
            sbDownload.append("<html><body>");
            for (int i = 0; i < extraModulesTexts.size(); ++i) {
                sbDownload.append(extraModulesTexts.get(i));
                if (extraModulesTexts.size() <= 1 || i >= extraModulesTexts.size() - 1) continue;
                sbDownload.append("<br>");
            }
            sbDownload.append("</body></html>");
        }
        return sbDownload.toString();
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        FeatureManager.logUI("ERGO_CLOSE", new Object[0]);
    }

    public void setUpdateErrors(Collection<IOException> errors) {
        if (errors.isEmpty()) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<html>");
        for (IOException ex : errors) {
            sb.append("<br/>");
            sb.append(ex.getLocalizedMessage());
        }
        sb.append("</html>");
        String updateError = NbBundle.getMessage(ConfigurationPanel.class, (String)"ERR_UpdateComponents", (Object)sb.toString());
        SwingUtilities.invokeLater(() -> {
            this.remove(this.errorLabel);
            this.progressPanel.removeAll();
            this.progressPanel.add(this.errorLabel);
            this.setError(updateError);
            this.progressPanel.revalidate();
            this.progressPanel.repaint();
        });
    }

    void setError(String msg) {
        assert (SwingUtilities.isEventDispatchThread());
        this.errorLabel.setText(msg);
    }

    private void initComponents() {
        this.errorLabel = BrokenProjectInfo.getErrorPane("dummy");
        this.infoLabel = new JLabel();
        this.activateButton = new JButton();
        this.progressPanel = new JPanel();
        this.downloadLabel = new JLabel();
        this.downloadButton = new JButton();
        this.selectionsPanel = new JPanel();
        Mnemonics.setLocalizedText((JLabel)this.infoLabel, (String)"dummy");
        Mnemonics.setLocalizedText((AbstractButton)this.activateButton, (String)"dummy");
        this.activateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConfigurationPanel.this.activateButtonActionPerformed(evt);
            }
        });
        this.progressPanel.setLayout(new BoxLayout(this.progressPanel, 3));
        Mnemonics.setLocalizedText((JLabel)this.downloadLabel, (String)NbBundle.getMessage(ConfigurationPanel.class, (String)"ConfigurationPanel.downloadLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.downloadButton, (String)NbBundle.getMessage(ConfigurationPanel.class, (String)"ConfigurationPanel.downloadButton.text"));
        this.downloadButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConfigurationPanel.this.downloadButtonActionPerformed(evt);
            }
        });
        this.selectionsPanel.setLayout(new BoxLayout(this.selectionsPanel, 3));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.progressPanel, -1, 374, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.errorLabel, -2, -1, -2).addGroup(layout.createSequentialGroup().addComponent(this.downloadButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.activateButton)).addComponent(this.downloadLabel).addComponent(this.infoLabel).addComponent(this.selectionsPanel, -2, -1, -2)).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.errorLabel, -1, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.infoLabel).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.downloadLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.selectionsPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.activateButton).addComponent(this.downloadButton)).addGap(19, 19, 19).addComponent(this.progressPanel, -1, -1, Short.MAX_VALUE).addContainerGap()));
    }

    private void activateButtonActionPerformed(ActionEvent evt) {
        FeatureManager.logUI("ERGO_DOWNLOAD", new Object[0]);
        this.activateButton.setEnabled(false);
        this.downloadButton.setEnabled(false);
        this.selectionsPanel.setEnabled(false);
        RequestProcessor.Task task = FeatureManager.getInstance().create(() -> ModulesInstaller.activateModules(false, this.progressMonitor, this.featureInfo, this.featureInstall, this.extrasFilter));
        task.addTaskListener(this.onActivationFinished());
        task.schedule(0);
    }

    private void downloadButtonActionPerformed(ActionEvent evt) {
        FeatureManager.logUI("ERGO_DOWNLOAD", new Object[0]);
        this.activateButton.setEnabled(false);
        this.downloadButton.setEnabled(false);
        this.selectionsPanel.setEnabled(false);
        RequestProcessor.Task task = FeatureManager.getInstance().create(() -> ModulesInstaller.activateModules(true, this.progressMonitor, this.featureInfo, Collections.emptyList(), this.extrasFilter));
        task.addTaskListener(this.onActivationFinished());
        task.schedule(0);
    }

    private TaskListener onActivationFinished() {
        return task -> {
            if (!this.progressMonitor.error) {
                SwingUtilities.invokeLater(new Runnable(){
                    private String msg;

                    @Override
                    public void run() {
                        ConfigurationPanel.this.removeAll();
                        ConfigurationPanel.this.setLayout(new BorderLayout());
                        try {
                            ConfigurationPanel.this.add((Component)ConfigurationPanel.this.callable.call(), "Center");
                        }
                        catch (Exception ex) {
                            Exceptions.attachSeverity((Throwable)ex, (Level)Level.INFO);
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                        ConfigurationPanel.this.invalidate();
                        ConfigurationPanel.this.revalidate();
                        ConfigurationPanel.this.repaint();
                        if (ConfigurationPanel.this.featureInfo != null && !ConfigurationPanel.this.featureInfo.isEnabled()) {
                            this.msg = ConfigurationPanel.this.featureInfo.isPresent() ? NbBundle.getMessage(ConfigurationPanel.class, (String)"MSG_EnableFailed") : NbBundle.getMessage(ConfigurationPanel.class, (String)"MSG_DownloadFailed");
                            ConfigurationPanel.this.progressMonitor.onError(this.msg);
                            return;
                        }
                        ConfigurationPanel.this.activateButton.setEnabled(true);
                        ConfigurationPanel.this.progressPanel.removeAll();
                        ConfigurationPanel.this.progressPanel.revalidate();
                        ConfigurationPanel.this.progressPanel.repaint();
                    }
                });
            }
        };
    }

    private final class DownloadProgressMonitor
    implements ProgressMonitor {
        boolean error = false;

        private DownloadProgressMonitor() {
        }

        @Override
        public void onDownload(ProgressHandle progressHandle) {
            this.updateProgress(progressHandle);
        }

        @Override
        public void onValidate(ProgressHandle progressHandle) {
            this.updateProgress(progressHandle);
        }

        @Override
        public void onInstall(ProgressHandle progressHandle) {
            this.updateProgress(progressHandle);
        }

        @Override
        public void onEnable(ProgressHandle progressHandle) {
            this.updateProgress(progressHandle);
        }

        private void updateProgress(ProgressHandle progressHandle) {
            final JLabel tmpMainLabel = ProgressHandleFactory.createMainLabelComponent((ProgressHandle)progressHandle);
            final JComponent tmpProgressPanel = ProgressHandleFactory.createProgressComponent((ProgressHandle)progressHandle);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ConfigurationPanel.this.progressPanel.removeAll();
                    ConfigurationPanel.this.progressPanel.add(tmpMainLabel);
                    ConfigurationPanel.this.progressPanel.add(Box.createRigidArea(new Dimension(0, 5)));
                    ConfigurationPanel.this.progressPanel.add(tmpProgressPanel);
                    ConfigurationPanel.this.progressPanel.revalidate();
                    ConfigurationPanel.this.progressPanel.repaint();
                }
            });
        }

        @Override
        public void onError(final String message) {
            this.error = true;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ConfigurationPanel.this.setError("<html>" + message + "</html>");
                    ConfigurationPanel.this.progressPanel.removeAll();
                    ConfigurationPanel.this.progressPanel.add(ConfigurationPanel.this.errorLabel);
                    ConfigurationPanel.this.downloadButton.setEnabled(true);
                }
            });
        }
    }
}

