/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.config.metro.dev;

import com.sun.istack.logging.Logger;
import com.sun.xml.ws.config.metro.dev.FeatureReader;
import com.sun.xml.ws.config.metro.util.ParserUtil;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.WebServiceFeature;

public abstract class SimpleFeatureReader<T extends WebServiceFeature>
implements FeatureReader {
    private static final Logger LOGGER = Logger.getLogger(SimpleFeatureReader.class);

    @Override
    public T parse(XMLEventReader reader) throws WebServiceException {
        try {
            StartElement element = reader.nextEvent().asStartElement();
            boolean attributeEnabled = true;
            QName elementName = element.getName();
            Iterator<Attribute> iterator = element.getAttributes();
            while (iterator.hasNext()) {
                Attribute nextAttribute = iterator.next();
                QName attributeName = nextAttribute.getName();
                if (ENABLED_ATTRIBUTE_NAME.equals(attributeName)) {
                    attributeEnabled = ParserUtil.parseBooleanValue(nextAttribute.getValue());
                    continue;
                }
                throw LOGGER.logSevereException(new WebServiceException("Unexpected attribute, was " + nextAttribute));
            }
            block10: while (reader.hasNext()) {
                try {
                    XMLEvent event = reader.nextEvent();
                    switch (event.getEventType()) {
                        case 5: {
                            break;
                        }
                        case 4: {
                            if (event.asCharacters().isWhiteSpace()) break;
                            throw LOGGER.logSevereException(new WebServiceException("No character data allowed, was " + event.asCharacters()));
                        }
                        case 2: {
                            EndElement endElement = event.asEndElement();
                            if (elementName.equals(endElement.getName())) break block10;
                            throw LOGGER.logSevereException(new WebServiceException("Expected end element"));
                        }
                        default: {
                            throw LOGGER.logSevereException(new WebServiceException("Unexpected event, was " + event));
                        }
                    }
                }
                catch (XMLStreamException e) {
                    throw LOGGER.logSevereException(new WebServiceException("Failed to unmarshal XML document", e));
                }
            }
            return this.createFeature(attributeEnabled);
        }
        catch (XMLStreamException e) {
            throw LOGGER.logSevereException(new WebServiceException("Failed to unmarshal XML document", e));
        }
    }

    protected abstract T createFeature(boolean var1) throws WebServiceException;
}

