/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.config.metro.parser;

import com.sun.istack.logging.Logger;
import com.sun.xml.ws.config.metro.dev.ElementFeatureMapping;
import com.sun.xml.ws.config.metro.dev.FeatureReader;
import com.sun.xml.ws.config.metro.parser.ParsedElement;
import com.sun.xml.ws.policy.privateutil.PolicyUtils;
import com.sun.xml.ws.policy.sourcemodel.wspolicy.NamespaceVersion;
import com.sun.xml.ws.policy.sourcemodel.wspolicy.XmlToken;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.WebServiceFeature;

class MetroWsParser {
    private static final Logger LOGGER = Logger.getLogger(MetroWsParser.class);
    private static final XMLInputFactory inputFactory = XMLInputFactory.newInstance();
    private static final String CONFIG_NAMESPACE = "http://metro.dev.java.net/xmlns/metro-webservices";
    private static final QName CONFIG_ROOT_ELEMENT = new QName("http://metro.dev.java.net/xmlns/metro-webservices", "metro-webservices");
    private static final QName PORT_COMPONENT_ELEMENT = new QName("http://metro.dev.java.net/xmlns/metro-webservices", "port-component");
    private static final QName PORT_COMPONENT_REF_ELEMENT = new QName("http://metro.dev.java.net/xmlns/metro-webservices", "port-component-ref");
    private static final QName OPERATION_ELEMENT = new QName("http://metro.dev.java.net/xmlns/metro-webservices", "operation");
    private static final QName INPUT_ELEMENT = new QName("http://metro.dev.java.net/xmlns/metro-webservices", "input");
    private static final QName OUTPUT_ELEMENT = new QName("http://metro.dev.java.net/xmlns/metro-webservices", "output");
    private static final QName FAULT_ELEMENT = new QName("http://metro.dev.java.net/xmlns/metro-webservices", "fault");
    private static final QName NAME_ATTRIBUTE = new QName("name");
    private static final QName WSDL_NAME_ATTRIBUTE = new QName("wsdl-name");
    private static final QName TCP_TRANSPORT_ELEMENT_NAME = new QName("http://metro.dev.java.net/xmlns/metro-webservices", "tcp-transport");
    private static final QName TUBELINE_ELEMENT_NAME = new QName("http://metro.dev.java.net/xmlns/metro-webservices", "tubeline");
    private static final Map<QName, FeatureReader<?>> nameToReader = new HashMap();

    private static FeatureReader instantiateFeatureReader(String className) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        return Class.forName(className).asSubclass(FeatureReader.class).newInstance();
    }

    public MetroWsParser() throws WebServiceException {
        if (nameToReader == null || nameToReader.isEmpty()) {
            throw LOGGER.logSevereException(new WebServiceException("Failed to initialize feature readers"));
        }
    }

    public List<ParsedElement> unmarshal(XMLStreamReader reader) throws WebServiceException {
        try {
            XMLEventReader eventReader = inputFactory.createXMLEventReader(reader);
            return this.unmarshal(eventReader);
        }
        catch (XMLStreamException e) {
            throw LOGGER.logSevereException(new WebServiceException(e));
        }
    }

    protected List<ParsedElement> unmarshal(XMLEventReader reader) throws WebServiceException {
        LinkedList<ParsedElement> configElements = new LinkedList<ParsedElement>();
        block7: while (reader.hasNext()) {
            try {
                XMLEvent event = reader.nextEvent();
                switch (event.getEventType()) {
                    case 5: 
                    case 7: {
                        break;
                    }
                    case 4: {
                        this.processCharacters(event.asCharacters(), null);
                        break;
                    }
                    case 1: {
                        if (CONFIG_ROOT_ELEMENT.equals(event.asStartElement().getName())) {
                            this.unmarshalComponents(configElements, reader);
                            break block7;
                        }
                        throw LOGGER.logSevereException(new WebServiceException("metro-webservice element expected, instead got " + event));
                    }
                    default: {
                        throw LOGGER.logSevereException(new WebServiceException("metro-webservice element expected, instead got " + event));
                    }
                }
            }
            catch (XMLStreamException e) {
                throw LOGGER.logSevereException(new WebServiceException("Failed to unmarshal XML document", e));
            }
        }
        return configElements;
    }

    private void unmarshalComponents(final List<ParsedElement> configElements, XMLEventReader reader) throws WebServiceException {
        this.unmarshal(configElements, CONFIG_ROOT_ELEMENT, reader, new ElementParser(){

            @Override
            public void parse(XMLEventReader reader) {
                block6: {
                    try {
                        StartElement element = reader.peek().asStartElement();
                        if (PORT_COMPONENT_ELEMENT.equals(element.getName())) {
                            Attribute nameAttribute = element.getAttributeByName(NAME_ATTRIBUTE);
                            if (nameAttribute != null) {
                                reader.next();
                                MetroWsParser.this.unmarshalPortComponent(configElements, nameAttribute.getValue(), reader);
                                break block6;
                            }
                            throw LOGGER.logSevereException(new WebServiceException("Expected name attribute"));
                        }
                        if (PORT_COMPONENT_REF_ELEMENT.equals(element.getName())) {
                            Attribute nameAttribute = element.getAttributeByName(NAME_ATTRIBUTE);
                            if (nameAttribute != null) {
                                reader.next();
                                MetroWsParser.this.unmarshalPortComponentRef(configElements, nameAttribute.getValue(), reader);
                                break block6;
                            }
                            throw LOGGER.logSevereException(new WebServiceException("Expected name attribute"));
                        }
                        throw new WebServiceException("Expected component element, got " + element);
                    }
                    catch (XMLStreamException e) {
                        throw LOGGER.logSevereException(new WebServiceException("Failed to unmarshal", e));
                    }
                }
            }
        });
    }

    private void unmarshalPortComponent(final List<ParsedElement> configElements, final String componentName, XMLEventReader reader) throws WebServiceException {
        this.unmarshal(configElements, PORT_COMPONENT_ELEMENT, reader, new ElementParser(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public void parse(XMLEventReader reader) {
                try {
                    StartElement element = reader.peek().asStartElement();
                    if (OPERATION_ELEMENT.equals(element.getName())) {
                        Attribute nameAttribute = element.getAttributeByName(WSDL_NAME_ATTRIBUTE);
                        if (nameAttribute == null) throw LOGGER.logSevereException(new WebServiceException("Expected wsdl-name attribute"));
                        reader.next();
                        MetroWsParser.this.unmarshalPortComponentOperation(configElements, componentName, nameAttribute.getValue(), reader);
                        return;
                    } else {
                        WebServiceFeature feature = MetroWsParser.this.parseElement(reader);
                        configElements.add(ParsedElement.createPortComponentElement(componentName, feature));
                    }
                    return;
                }
                catch (XMLStreamException e) {
                    throw LOGGER.logSevereException(new WebServiceException("Failed to unmarshal", e));
                }
            }
        });
    }

    private void unmarshalPortComponentRef(final List<ParsedElement> configElements, final String componentName, XMLEventReader reader) throws WebServiceException {
        this.unmarshal(configElements, PORT_COMPONENT_REF_ELEMENT, reader, new ElementParser(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public void parse(XMLEventReader reader) {
                try {
                    StartElement element = reader.peek().asStartElement();
                    if (OPERATION_ELEMENT.equals(element.getName())) {
                        Attribute nameAttribute = element.getAttributeByName(WSDL_NAME_ATTRIBUTE);
                        if (nameAttribute == null) throw LOGGER.logSevereException(new WebServiceException("Expected wsdl-name attribute"));
                        reader.next();
                        MetroWsParser.this.unmarshalPortComponentRefOperation(configElements, componentName, nameAttribute.getValue(), reader);
                        return;
                    } else {
                        WebServiceFeature feature = MetroWsParser.this.parseElement(reader);
                        configElements.add(ParsedElement.createPortComponentRefElement(componentName, feature));
                    }
                    return;
                }
                catch (XMLStreamException e) {
                    throw LOGGER.logSevereException(new WebServiceException("Failed to unmarshal", e));
                }
            }
        });
    }

    private void unmarshalPortComponentOperation(final List<ParsedElement> configElements, final String componentName, final String operationName, XMLEventReader reader) throws WebServiceException {
        this.unmarshal(configElements, OPERATION_ELEMENT, reader, new ElementParser(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public void parse(XMLEventReader reader) {
                try {
                    StartElement element = reader.peek().asStartElement();
                    QName childName = element.getName();
                    if (INPUT_ELEMENT.equals(childName)) {
                        reader.next();
                        MetroWsParser.this.unmarshalPortComponentInput(configElements, componentName, operationName, reader);
                        return;
                    } else if (OUTPUT_ELEMENT.equals(childName)) {
                        reader.next();
                        MetroWsParser.this.unmarshalPortComponentOutput(configElements, componentName, operationName, reader);
                        return;
                    } else if (FAULT_ELEMENT.equals(childName)) {
                        Attribute nameAttribute = element.getAttributeByName(WSDL_NAME_ATTRIBUTE);
                        if (nameAttribute == null) throw LOGGER.logSevereException(new WebServiceException("Expected wsdl-name attribute"));
                        reader.next();
                        MetroWsParser.this.unmarshalPortComponentFault(configElements, componentName, operationName, nameAttribute.getValue(), reader);
                        return;
                    } else {
                        WebServiceFeature feature = MetroWsParser.this.parseElement(reader);
                        configElements.add(ParsedElement.createPortComponentOperationElement(componentName, operationName, feature));
                    }
                    return;
                }
                catch (XMLStreamException e) {
                    throw LOGGER.logSevereException(new WebServiceException("Failed to unmarshal", e));
                }
            }
        });
    }

    private void unmarshalPortComponentRefOperation(final List<ParsedElement> configElements, final String componentName, final String operationName, XMLEventReader reader) throws WebServiceException {
        this.unmarshal(configElements, OPERATION_ELEMENT, reader, new ElementParser(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public void parse(XMLEventReader reader) {
                try {
                    StartElement element = reader.peek().asStartElement();
                    QName childName = element.getName();
                    if (INPUT_ELEMENT.equals(childName)) {
                        reader.next();
                        MetroWsParser.this.unmarshalPortComponentRefInput(configElements, componentName, operationName, reader);
                        return;
                    } else if (OUTPUT_ELEMENT.equals(childName)) {
                        reader.next();
                        MetroWsParser.this.unmarshalPortComponentRefOutput(configElements, componentName, operationName, reader);
                        return;
                    } else if (FAULT_ELEMENT.equals(childName)) {
                        Attribute nameAttribute = element.getAttributeByName(WSDL_NAME_ATTRIBUTE);
                        if (nameAttribute == null) throw LOGGER.logSevereException(new WebServiceException("Expected wsdl-name attribute"));
                        reader.next();
                        MetroWsParser.this.unmarshalPortComponentRefFault(configElements, componentName, operationName, nameAttribute.getValue(), reader);
                        return;
                    } else {
                        WebServiceFeature feature = MetroWsParser.this.parseElement(reader);
                        configElements.add(ParsedElement.createPortComponentRefOperationElement(componentName, operationName, feature));
                    }
                    return;
                }
                catch (XMLStreamException e) {
                    throw LOGGER.logSevereException(new WebServiceException("Failed to unmarshal", e));
                }
            }
        });
    }

    private void unmarshalPortComponentInput(final List<ParsedElement> configElements, final String componentName, final String operationName, XMLEventReader reader) throws WebServiceException {
        this.unmarshal(configElements, INPUT_ELEMENT, reader, new ElementParser(){

            @Override
            public void parse(XMLEventReader reader) {
                WebServiceFeature feature = MetroWsParser.this.parseElement(reader);
                configElements.add(ParsedElement.createPortComponentInputElement(componentName, operationName, feature));
            }
        });
    }

    private void unmarshalPortComponentOutput(final List<ParsedElement> configElements, final String componentName, final String operationName, XMLEventReader reader) throws WebServiceException {
        this.unmarshal(configElements, OUTPUT_ELEMENT, reader, new ElementParser(){

            @Override
            public void parse(XMLEventReader reader) {
                WebServiceFeature feature = MetroWsParser.this.parseElement(reader);
                configElements.add(ParsedElement.createPortComponentOutputElement(componentName, operationName, feature));
            }
        });
    }

    private void unmarshalPortComponentFault(final List<ParsedElement> configElements, final String componentName, final String operationName, final String faultName, XMLEventReader reader) throws WebServiceException {
        this.unmarshal(configElements, FAULT_ELEMENT, reader, new ElementParser(){

            @Override
            public void parse(XMLEventReader reader) {
                WebServiceFeature feature = MetroWsParser.this.parseElement(reader);
                configElements.add(ParsedElement.createPortComponentFaultElement(componentName, operationName, faultName, feature));
            }
        });
    }

    private void unmarshalPortComponentRefInput(final List<ParsedElement> configElements, final String componentName, final String operationName, XMLEventReader reader) throws WebServiceException {
        this.unmarshal(configElements, INPUT_ELEMENT, reader, new ElementParser(){

            @Override
            public void parse(XMLEventReader reader) {
                WebServiceFeature feature = MetroWsParser.this.parseElement(reader);
                configElements.add(ParsedElement.createPortComponentRefInputElement(componentName, operationName, feature));
            }
        });
    }

    private void unmarshalPortComponentRefOutput(final List<ParsedElement> configElements, final String componentName, final String operationName, XMLEventReader reader) throws WebServiceException {
        this.unmarshal(configElements, OUTPUT_ELEMENT, reader, new ElementParser(){

            @Override
            public void parse(XMLEventReader reader) {
                WebServiceFeature feature = MetroWsParser.this.parseElement(reader);
                configElements.add(ParsedElement.createPortComponentRefOutputElement(componentName, operationName, feature));
            }
        });
    }

    private void unmarshalPortComponentRefFault(final List<ParsedElement> configElements, final String componentName, final String operationName, final String faultName, XMLEventReader reader) throws WebServiceException {
        this.unmarshal(configElements, FAULT_ELEMENT, reader, new ElementParser(){

            @Override
            public void parse(XMLEventReader reader) {
                WebServiceFeature feature = MetroWsParser.this.parseElement(reader);
                configElements.add(ParsedElement.createPortComponentRefFaultElement(componentName, operationName, faultName, feature));
            }
        });
    }

    private void unmarshal(List<ParsedElement> configElements, QName endTag, XMLEventReader reader, ElementParser parser) throws WebServiceException {
        block8: while (reader.hasNext()) {
            try {
                XMLEvent xmlParserEvent = reader.peek();
                switch (xmlParserEvent.getEventType()) {
                    case 5: {
                        reader.next();
                        break;
                    }
                    case 4: {
                        this.processCharacters(reader.nextEvent().asCharacters(), null);
                        break;
                    }
                    case 2: {
                        this.checkEndTagName(endTag, reader.nextEvent().asEndElement());
                        break block8;
                    }
                    case 1: {
                        parser.parse(reader);
                        break;
                    }
                    default: {
                        throw LOGGER.logSevereException(new WebServiceException("expected XML element"));
                    }
                }
            }
            catch (XMLStreamException e) {
                throw LOGGER.logSevereException(new WebServiceException("unmarshalling failed", e));
            }
        }
    }

    private WebServiceFeature parseElement(XMLEventReader reader) throws WebServiceException {
        try {
            StartElement element = reader.peek().asStartElement();
            QName elementName = element.getName();
            FeatureReader<?> featureReader = nameToReader.get(elementName);
            if (featureReader != null) {
                return featureReader.parse(reader);
            }
            throw LOGGER.logSevereException(new WebServiceException("unknown element " + element));
        }
        catch (XMLStreamException e) {
            throw LOGGER.logSevereException(new WebServiceException("failed to parse", e));
        }
    }

    private void checkEndTagName(QName expected, EndElement element) throws WebServiceException {
        QName actual = element.getName();
        if (!expected.equals(actual)) {
            throw LOGGER.logSevereException(new WebServiceException("end tag does not match start tag"));
        }
    }

    private StringBuilder processCharacters(Characters characters, StringBuilder currentValueBuffer) throws WebServiceException {
        if (characters.isWhiteSpace()) {
            return currentValueBuffer;
        }
        throw LOGGER.logSevereException(new WebServiceException("No character data allowed"));
    }

    static {
        try {
            nameToReader.put(NamespaceVersion.v1_5.asQName(XmlToken.Policy), MetroWsParser.instantiateFeatureReader("com.sun.xml.ws.policy.config.PolicyFeatureReader"));
            nameToReader.put(TCP_TRANSPORT_ELEMENT_NAME, MetroWsParser.instantiateFeatureReader("com.sun.xml.ws.transport.tcp.dev.TcpTransportFeatureReader"));
            nameToReader.put(TUBELINE_ELEMENT_NAME, MetroWsParser.instantiateFeatureReader("com.sun.xml.ws.runtime.config.TubelineFeatureReader"));
            ElementFeatureMapping[] elementFeatureMappings = PolicyUtils.ServiceProvider.load(ElementFeatureMapping.class);
            if (elementFeatureMappings != null) {
                for (int i = 0; i < elementFeatureMappings.length; ++i) {
                    ElementFeatureMapping elementFeatureMapping = elementFeatureMappings[i];
                    QName elementName = elementFeatureMapping.getElementName();
                    if (nameToReader.containsKey(elementName)) {
                        throw LOGGER.logSevereException(new WebServiceException("duplicate registration of reader ... for element ..."));
                    }
                    nameToReader.put(elementName, elementFeatureMapping.getFeatureReader());
                }
            }
        }
        catch (ClassNotFoundException ex) {
            LOGGER.logSevereException(new WebServiceException("Failed to initialize feature readers", ex));
        }
        catch (InstantiationException ex) {
            LOGGER.logSevereException(new WebServiceException("Failed to initialize feature readers", ex));
        }
        catch (IllegalAccessException ex) {
            LOGGER.logSevereException(new WebServiceException("Failed to initialize feature readers", ex));
        }
    }

    private static interface ElementParser {
        public void parse(XMLEventReader var1) throws WebServiceException;
    }
}

