/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.context;

import java.io.File;
import java.io.FilePermission;
import java.net.URL;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Policy;
import java.security.ProtectionDomain;
import java.util.Enumeration;
import java.util.PropertyPermission;
import org.apache.tomcat.core.BaseInterceptor;
import org.apache.tomcat.core.Context;
import org.apache.tomcat.core.ContextManager;
import org.apache.tomcat.core.TomcatException;

public class PolicyInterceptor
extends BaseInterceptor {
    String securityManagerClass = "java.lang.SecurityManager";
    String policyFile = null;

    public void setSecurityManagerClass(String cls) {
        this.securityManagerClass = cls;
    }

    public void setPolicyFile(String pf) {
        this.policyFile = pf;
    }

    public void engineInit(ContextManager cm) throws TomcatException {
        if (System.getSecurityManager() != null) {
            return;
        }
        try {
            Class<?> c = Class.forName(this.securityManagerClass);
            Object o = c.newInstance();
            System.setSecurityManager((SecurityManager)o);
        }
        catch (ClassNotFoundException ex) {
            System.out.println("SecurityManager Class not found: " + this.securityManagerClass);
        }
        catch (Exception ex) {
            System.out.println("SecurityManager Class could not be loaded: " + this.securityManagerClass);
        }
    }

    protected void addDefaultPermissions(Context context, String base, Permissions p) {
        PropertyPermission pp;
        FilePermission fp = new FilePermission(base + File.separator + "-", "read");
        if (fp != null) {
            p.add(fp);
        }
        if ((pp = new PropertyPermission("line.separator", "read")) != null) {
            p.add(pp);
        }
        if ((pp = new PropertyPermission("file.separator", "read")) != null) {
            p.add(pp);
        }
        if ((pp = new PropertyPermission("path.separator", "read")) != null) {
            p.add(pp);
        }
    }

    public void contextInit(Context context) throws TomcatException {
        ContextManager cm = context.getContextManager();
        String base = context.getDocBase();
        try {
            Permissions perms;
            File dir = cm.getAbsolute(new File(base));
            URL url = new URL("file:" + dir.getAbsolutePath());
            CodeSource cs = new CodeSource(url, null);
            Permissions p = (Permissions)context.getPermissions();
            if (p == null) {
                p = new Permissions();
            }
            if ((perms = (Permissions)cm.getPermissions()) != null) {
                Enumeration<Permission> enumeration = perms.elements();
                while (enumeration.hasMoreElements()) {
                    p.add(enumeration.nextElement());
                }
            }
            this.addDefaultPermissions(context, dir.getAbsolutePath(), p);
            Policy.getPolicy().refresh();
            PermissionCollection pFileP = Policy.getPolicy().getPermissions(cs);
            if (pFileP != null) {
                Enumeration<Permission> enumeration = pFileP.elements();
                while (enumeration.hasMoreElements()) {
                    p.add(enumeration.nextElement());
                }
            }
            ProtectionDomain pd = new ProtectionDomain(cs, p);
            context.setProtectionDomain(pd);
            context.setPermissions(p);
        }
        catch (Exception ex) {
            System.out.println("Security init for Context " + base + " failed");
        }
    }
}

