/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.tomcat.core.Context;
import org.apache.tomcat.util.FileUtil;

public class WARUtil {
    public static void expand(File dir, URL war) throws MalformedURLException, IOException {
        String s = WARUtil.trim(war.getFile(), "/");
        URL u = new URL(s);
        ZipInputStream zis = new ZipInputStream(u.openStream());
        ZipEntry ze = null;
        while ((ze = zis.getNextEntry()) != null) {
            try {
                File f = new File(dir, ze.getName());
                if (ze.isDirectory()) {
                    f.mkdirs();
                    continue;
                }
                byte[] buffer = new byte[1024];
                int length = 0;
                FileOutputStream fos = new FileOutputStream(f);
                while ((length = zis.read(buffer)) >= 0) {
                    fos.write(buffer, 0, length);
                }
                fos.close();
            }
            catch (FileNotFoundException ex) {
                System.out.println("WARUtil: FileNotFoundException: " + ze.getName() + " / " + s);
            }
        }
        zis.close();
    }

    private static String trim(String s, String t) {
        if (s.startsWith(t)) {
            s = s.substring(t.length());
        }
        if (s.endsWith(t)) {
            s = s.substring(0, s.length() - t.length());
        }
        return s;
    }

    public static URL createURL(Context ctx, String mappedPath) throws MalformedURLException {
        URL docBase = ctx.getDocumentBase();
        URL url = null;
        if (ctx.isWARExpanded()) {
            File f = new File(ctx.getWARDir().toString());
            String absPath = f.getAbsolutePath();
            if (!(absPath = FileUtil.patch(absPath)).startsWith("/")) {
                absPath = "/" + absPath;
            }
            url = new URL("file://localhost" + absPath + "/" + mappedPath);
        } else {
            String documentBase = docBase.toString();
            if (documentBase.endsWith("/")) {
                documentBase = documentBase.substring(0, documentBase.length() - 1);
            }
            url = new URL(documentBase + "!" + mappedPath);
        }
        return url;
    }
}

