/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seproject.ui;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.Project;
import org.netbeans.modules.java.api.common.SourceRoots;
import org.netbeans.modules.java.api.common.ant.UpdateHelper;
import org.netbeans.modules.java.api.common.classpath.ClassPathSupport;
import org.netbeans.modules.java.api.common.project.ui.LibrariesNode;
import org.netbeans.modules.java.api.common.project.ui.ProjectUISupport;
import org.netbeans.modules.java.j2seproject.J2SEProject;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.netbeans.spi.project.ui.support.NodeFactory;
import org.netbeans.spi.project.ui.support.NodeList;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Node;
import org.openide.util.ChangeSupport;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;
import org.openide.util.Utilities;

public final class LibrariesNodeFactory
implements NodeFactory {
    public NodeList createNodes(Project p) {
        J2SEProject project = (J2SEProject)p.getLookup().lookup(J2SEProject.class);
        assert (project != null);
        return new LibrariesNodeList(project);
    }

    private static class LibrariesNodeList
    implements NodeList<String>,
    PropertyChangeListener {
        private static final String LIBRARIES = "Libs";
        private static final String TEST_LIBRARIES = "TestLibs";
        private final J2SEProject project;
        private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
        private PropertyEvaluator evaluator;
        private UpdateHelper helper;
        private ReferenceHelper resolver;
        private final ClassPathSupport cs;

        LibrariesNodeList(@NonNull J2SEProject proj) {
            Parameters.notNull((CharSequence)"proj", (Object)proj);
            this.project = proj;
            this.evaluator = this.project.evaluator();
            this.helper = this.project.getUpdateHelper();
            this.resolver = this.project.getReferenceHelper();
            this.cs = new ClassPathSupport(this.evaluator, this.resolver, this.helper.getAntProjectHelper(), this.helper, null);
        }

        public List<String> keys() {
            ArrayList<String> result = new ArrayList<String>();
            result.add(LIBRARIES);
            URL[] testRoots = this.project.getTestSourceRoots().getRootURLs();
            boolean addTestSources = false;
            for (int i = 0; i < testRoots.length; ++i) {
                File f = Utilities.toFile((URI)URI.create(testRoots[i].toExternalForm()));
                if (!f.exists()) continue;
                addTestSources = true;
                break;
            }
            if (addTestSources) {
                result.add(TEST_LIBRARIES);
            }
            return result;
        }

        public void addChangeListener(ChangeListener l) {
            this.changeSupport.addChangeListener(l);
        }

        public void removeChangeListener(ChangeListener l) {
            this.changeSupport.removeChangeListener(l);
        }

        public Node node(String key) {
            if (key == LIBRARIES) {
                return new LibrariesNode.Builder((Project)this.project, this.evaluator, this.helper, this.resolver, this.cs).setName(NbBundle.getMessage(LibrariesNodeFactory.class, (String)"CTL_LibrariesNode")).addClassPathProperties(new String[]{"run.classpath"}).addClassPathIgnoreRefs(new String[]{"build.classes.dir"}).setBootPath(ClassPath.getClassPath((FileObject)this.project.getProjectDirectory(), (String)"classpath/boot")).setPlatformProperty("platform.active").addLibrariesNodeActions(new Action[]{LibrariesNode.createAddProjectAction((Project)this.project, (SourceRoots)this.project.getSourceRoots()), LibrariesNode.createAddLibraryAction((ReferenceHelper)this.project.getReferenceHelper(), (SourceRoots)this.project.getSourceRoots(), null), LibrariesNode.createAddFolderAction((AntProjectHelper)this.project.getAntProjectHelper(), (SourceRoots)this.project.getSourceRoots()), null, ProjectUISupport.createPreselectPropertiesAction((Project)this.project, (String)"Libraries", (String)"COMPILE")}).addModulePathProperties(new String[]{"run.modulepath"}).addModulePathIgnoreRefs(new String[]{"build.classes.dir"}).setModuleInfoBasedPath(this.project.getClassPathProvider().getProjectClassPaths("classpath/execute")[0]).setSourcePath(this.project.getClassPathProvider().getProjectClassPaths("classpath/source")[0]).build();
            }
            if (key == TEST_LIBRARIES) {
                return new LibrariesNode.Builder((Project)this.project, this.evaluator, this.helper, this.resolver, this.cs).setName(NbBundle.getMessage(LibrariesNodeFactory.class, (String)"CTL_TestLibrariesNode")).addClassPathProperties(new String[]{"run.test.classpath"}).addClassPathIgnoreRefs(new String[]{"build.test.classes.dir", "javac.classpath", "build.classes.dir"}).addLibrariesNodeActions(new Action[]{LibrariesNode.createAddProjectAction((Project)this.project, (SourceRoots)this.project.getTestSourceRoots()), LibrariesNode.createAddLibraryAction((ReferenceHelper)this.project.getReferenceHelper(), (SourceRoots)this.project.getTestSourceRoots(), null), LibrariesNode.createAddFolderAction((AntProjectHelper)this.project.getAntProjectHelper(), (SourceRoots)this.project.getTestSourceRoots()), null, ProjectUISupport.createPreselectPropertiesAction((Project)this.project, (String)"Libraries", (String)"COMPILE_TESTS")}).addModulePathProperties(new String[]{"run.test.modulepath"}).addModulePathIgnoreRefs(new String[]{"build.test.classes.dir", "javac.modulepath", "build.classes.dir"}).setModuleInfoBasedPath(this.project.getClassPathProvider().getProjectClassPaths("classpath/execute")[1]).setSourcePath(this.project.getClassPathProvider().getProjectClassPaths("classpath/source")[1]).build();
            }
            assert (false) : "No node for key: " + key;
            return null;
        }

        public void addNotify() {
            this.project.getTestSourceRoots().addPropertyChangeListener((PropertyChangeListener)this);
        }

        public void removeNotify() {
            this.project.getTestSourceRoots().removePropertyChangeListener((PropertyChangeListener)this);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    changeSupport.fireChange();
                }
            });
        }
    }
}

