/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seproject.ui.wizards;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.api.annotations.common.NonNull;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

class ImportFoldersPanel
extends JPanel {
    private final File projDir;
    private final JButton okOption;
    private JTextField distFolder;
    private JTextField distName;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JPanel jPanel1;
    private JLabel message;

    public ImportFoldersPanel(@NonNull File projDir, @NonNull File distDir, @NonNull String newName, @NonNull JButton okOption) {
        this.projDir = projDir;
        this.okOption = okOption;
        this.initComponents();
        this.message.setText(NbBundle.getMessage(ImportFoldersPanel.class, (String)"MSG_ImportFolders", (Object)distDir.getAbsolutePath()));
        this.distName.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent de) {
                ImportFoldersPanel.this.updateDistFolder();
            }

            @Override
            public void removeUpdate(DocumentEvent de) {
                ImportFoldersPanel.this.updateDistFolder();
            }

            @Override
            public void changedUpdate(DocumentEvent de) {
                ImportFoldersPanel.this.updateDistFolder();
            }
        });
        this.distName.setText(newName);
        this.resize();
    }

    public String getDistFolder() {
        return this.distName.getText();
    }

    private void updateDistFolder() {
        boolean valid = false;
        String name = this.distName.getText().trim();
        if (name.length() > 0) {
            File dist = new File(this.projDir, name);
            this.distFolder.setText(dist.getAbsolutePath());
            valid = !dist.exists();
        } else {
            this.distFolder.setText(this.projDir.getAbsolutePath());
        }
        this.okOption.setEnabled(valid);
    }

    private void resize() {
        int width = new Double(this.message.getFontMetrics(this.message.getFont()).getStringBounds(this.message.getText(), this.getGraphics()).getWidth() / 2.7).intValue() + 40;
        int height = this.message.getFont().getSize() * 5 + 100;
        if (width < 400) {
            width = 400;
        }
        if (height < 160) {
            height = 160;
        }
        Dimension dim = new Dimension(width, height);
        this.setMinimumSize(dim);
        this.setPreferredSize(dim);
    }

    private void initComponents() {
        this.message = new JLabel();
        this.jLabel2 = new JLabel();
        this.distName = new JTextField();
        this.jLabel3 = new JLabel();
        this.distFolder = new JTextField();
        this.jPanel1 = new JPanel();
        this.setLayout(new GridBagLayout());
        this.message.setText(NbBundle.getMessage(ImportFoldersPanel.class, (String)"ImportFoldersPanel.message.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 12, 0, 12);
        this.add((Component)this.message, gridBagConstraints);
        this.jLabel2.setLabelFor(this.distName);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(ImportFoldersPanel.class, (String)"TXT_BuildArtifactName"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 12, 0, 6);
        this.add((Component)this.jLabel2, gridBagConstraints);
        this.distName.setText(NbBundle.getMessage(ImportFoldersPanel.class, (String)"ImportFoldersPanel.distName.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 0, 0, 12);
        this.add((Component)this.distName, gridBagConstraints);
        this.distName.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ImportFoldersPanel.class, (String)"AD_BuildArtifactName"));
        this.jLabel3.setLabelFor(this.distFolder);
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(ImportFoldersPanel.class, (String)"TXT_BuildArtifactFile"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 12, 12, 6);
        this.add((Component)this.jLabel3, gridBagConstraints);
        this.distFolder.setEditable(false);
        this.distFolder.setText(NbBundle.getMessage(ImportFoldersPanel.class, (String)"ImportFoldersPanel.distFolder.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 0, 12, 12);
        this.add((Component)this.distFolder, gridBagConstraints);
        this.distFolder.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ImportFoldersPanel.class, (String)"AD_BuildArtifactFile"));
        this.jPanel1.setLayout(new GridLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jPanel1, gridBagConstraints);
    }
}

