/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.components;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.HierarchyBoundsListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JApplet;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JPopupMenu;
import javax.swing.JToolTip;
import javax.swing.JWindow;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;
import org.netbeans.lib.profiler.global.Platform;
import org.netbeans.lib.profiler.ui.components.CellTipAware;

public class CellTipManager
implements MouseListener,
MouseMotionListener,
MouseWheelListener {
    private static final CellTipManager sharedInstance = new CellTipManager();
    private JComponent cellTipComponent;
    private JToolTip cellTip;
    private transient Popup cellTipPopup;
    private MouseMotionListener moveBeforeEnterListener = new MoveBeforeEnterListener();
    private Rectangle popupFrameRect;
    private Rectangle popupRect;
    private UniversalCellTipListener universalCellTipListener = new UniversalCellTipListener();
    private Window cellTipWindow;
    private boolean enabled = true;
    private boolean heavyweightPopupClosed = false;
    private boolean internalMousePressed = false;

    public static CellTipManager sharedInstance() {
        return sharedInstance;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        if (!enabled) {
            this.hideCellTip();
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void hideCellTip() {
        this.hideCellTipWindow();
        this.cellTipComponent = null;
    }

    @Override
    public void mouseClicked(MouseEvent event) {
    }

    @Override
    public void mouseDragged(MouseEvent event) {
    }

    @Override
    public void mouseEntered(MouseEvent event) {
        this.initiateCellTip(event);
    }

    @Override
    public void mouseExited(MouseEvent event) {
        Window win;
        boolean shouldHide = true;
        if (this.cellTipWindow != null && event.getSource() == this.cellTipWindow) {
            Container cellTipComponentWindow = this.cellTipComponent.getTopLevelAncestor();
            Point location = event.getPoint();
            SwingUtilities.convertPointToScreen(location, this.cellTipWindow);
            location.x -= cellTipComponentWindow.getX();
            location.y -= cellTipComponentWindow.getY();
            location = SwingUtilities.convertPoint(null, location, this.cellTipComponent);
            shouldHide = location.x < 0 || location.x >= this.cellTipComponent.getWidth() || location.y < 0 || location.y >= this.cellTipComponent.getHeight();
        } else if (event.getSource() == this.cellTipComponent && this.cellTipPopup != null && (win = SwingUtilities.getWindowAncestor(this.cellTipComponent)) != null) {
            Point location = SwingUtilities.convertPoint(this.cellTipComponent, event.getPoint(), win);
            Rectangle bounds = this.cellTipComponent.getTopLevelAncestor().getBounds();
            location.x += bounds.x;
            location.y += bounds.y;
            Point loc = new Point(0, 0);
            SwingUtilities.convertPointToScreen(loc, this.cellTip);
            bounds.x = loc.x;
            bounds.y = loc.y;
            bounds.width = this.cellTip.getWidth();
            bounds.height = this.cellTip.getHeight();
            shouldHide = location.x < bounds.x || location.x >= bounds.x + bounds.width || location.y < bounds.y || location.y >= bounds.y + bounds.height;
        }
        if (shouldHide) {
            if (this.cellTipComponent != null) {
                this.cellTipComponent.removeMouseMotionListener(this);
            }
            this.hideCellTip();
        }
    }

    @Override
    public void mouseMoved(MouseEvent event) {
        JComponent component;
        if (this.heavyweightPopupClosed) {
            this.heavyweightPopupClosed = false;
            return;
        }
        this.cellTipComponent = component = (JComponent)event.getSource();
        this.showCellTipWindow();
    }

    @Override
    public void mousePressed(MouseEvent event) {
        if (this.internalMousePressed) {
            return;
        }
        JComponent component = this.cellTipComponent;
        this.hideCellTip();
        Object source = event.getSource();
        if (source instanceof Component && !JComponent.isLightweightComponent((Component)source)) {
            this.heavyweightPopupClosed = true;
            this.internalMousePressed = true;
            ((CellTipAware)((Object)component)).processMouseEvent(SwingUtilities.convertMouseEvent((Component)source, event, component));
            MouseEvent event2 = new MouseEvent((Component)source, 502, event.getWhen() + 1L, event.getModifiers(), event.getX(), event.getY(), event.getClickCount(), event.isPopupTrigger());
            ((CellTipAware)((Object)component)).processMouseEvent(SwingUtilities.convertMouseEvent((Component)source, event2, component));
            this.internalMousePressed = false;
        } else {
            this.heavyweightPopupClosed = false;
        }
    }

    @Override
    public void mouseReleased(MouseEvent event) {
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        if (this.cellTipComponent instanceof CellTipAware) {
            ((CellTipAware)((Object)this.cellTipComponent)).processMouseEvent(SwingUtilities.convertMouseEvent((Component)e.getSource(), e, this.cellTipComponent));
        }
    }

    public void registerComponent(JComponent component) {
        if (Platform.isMac()) {
            return;
        }
        if (!(component instanceof CellTipAware)) {
            throw new RuntimeException("Only components implementing org.netbeans.lib.profiler.ui.components.CellTipAware interface can be registered!");
        }
        this.unregisterComponent(component);
        component.addMouseListener(this);
        component.addMouseMotionListener(this.moveBeforeEnterListener);
        this.universalCellTipListener.registerForComponent(component);
    }

    public void unregisterComponent(JComponent component) {
        if (Platform.isMac()) {
            return;
        }
        if (!(component instanceof CellTipAware)) {
            throw new RuntimeException("Only components implementing org.netbeans.lib.profiler.ui.components.CellTipAware interface can be unregistered!");
        }
        component.removeMouseListener(this);
        component.removeMouseMotionListener(this.moveBeforeEnterListener);
        this.universalCellTipListener.unregisterForComponent(component);
    }

    private static Frame frameForComponent(Component component) {
        while (!(component instanceof Frame)) {
            component = component.getParent();
        }
        return (Frame)component;
    }

    private int getHeightAdjust(Rectangle a, Rectangle b) {
        if (b.y >= a.y && b.y + b.height <= a.y + a.height) {
            return 0;
        }
        return b.y + b.height - (a.y + a.height) + 5;
    }

    private int getPopupFitHeight(Rectangle popupRectInScreen, Component invoker) {
        if (invoker != null) {
            for (Container parent = invoker.getParent(); parent != null; parent = parent.getParent()) {
                if (parent instanceof JFrame || parent instanceof JDialog || parent instanceof JWindow) {
                    return this.getHeightAdjust(parent.getBounds(), popupRectInScreen);
                }
                if (!(parent instanceof JApplet) && !(parent instanceof JInternalFrame)) continue;
                if (this.popupFrameRect == null) {
                    this.popupFrameRect = new Rectangle();
                }
                Point p = parent.getLocationOnScreen();
                this.popupFrameRect.setBounds(p.x, p.y, parent.getBounds().width, parent.getBounds().height);
                return this.getHeightAdjust(this.popupFrameRect, popupRectInScreen);
            }
        }
        return 0;
    }

    private int getPopupFitWidth(Rectangle popupRectInScreen, Component invoker) {
        if (invoker != null) {
            for (Container parent = invoker.getParent(); parent != null; parent = parent.getParent()) {
                if (parent instanceof JFrame || parent instanceof JDialog || parent instanceof JWindow) {
                    return this.getWidthAdjust(parent.getBounds(), popupRectInScreen);
                }
                if (!(parent instanceof JApplet) && !(parent instanceof JInternalFrame)) continue;
                if (this.popupFrameRect == null) {
                    this.popupFrameRect = new Rectangle();
                }
                Point p = parent.getLocationOnScreen();
                this.popupFrameRect.setBounds(p.x, p.y, parent.getBounds().width, parent.getBounds().height);
                return this.getWidthAdjust(this.popupFrameRect, popupRectInScreen);
            }
        }
        return 0;
    }

    private int getWidthAdjust(Rectangle a, Rectangle b) {
        if (b.x >= a.x && b.x + b.width <= a.x + a.width) {
            return 0;
        }
        return b.x + b.width - (a.x + a.width) + 5;
    }

    private void hideCellTipWindow() {
        if (this.cellTipPopup != null) {
            if (this.cellTipWindow != null) {
                this.cellTipWindow.removeMouseListener(this);
                this.cellTipWindow.removeMouseWheelListener(this);
                this.cellTipWindow = null;
            }
            this.cellTipPopup.hide();
            this.cellTipPopup = null;
            this.cellTip = null;
        }
    }

    private void initiateCellTip(MouseEvent event) {
        if (event.getSource() == this.cellTipWindow) {
            return;
        }
        JComponent component = (JComponent)event.getSource();
        component.removeMouseMotionListener(this.moveBeforeEnterListener);
        Point location = event.getPoint();
        if (location.x < 0 || location.x >= component.getWidth() || location.y < 0 || location.y >= component.getHeight()) {
            return;
        }
        component.removeMouseMotionListener(this);
        component.addMouseMotionListener(this);
        boolean sameComponent = this.cellTipComponent == component;
        this.cellTipComponent = component;
        if (this.cellTipPopup != null && !sameComponent) {
            this.showCellTipWindow();
        }
    }

    private void showCellTipWindow() {
        if (this.cellTipComponent == null || !this.cellTipComponent.isShowing()) {
            return;
        }
        for (Container p = this.cellTipComponent.getParent(); p != null && !(p instanceof JPopupMenu); p = p.getParent()) {
            if (!(p instanceof Window)) continue;
            if (((Window)p).isFocused()) break;
            return;
        }
        if (this.enabled) {
            Point screenLocation = this.cellTipComponent.getLocationOnScreen();
            Point location = new Point();
            Rectangle sBounds = this.cellTipComponent.getGraphicsConfiguration().getBounds();
            this.hideCellTipWindow();
            if (!(this.cellTipComponent instanceof CellTipAware)) {
                return;
            }
            CellTipAware cellTipAware = (CellTipAware)((Object)this.cellTipComponent);
            Point cellTipLocation = cellTipAware.getCellTipLocation();
            if (cellTipLocation == null) {
                return;
            }
            this.cellTip = cellTipAware.getCellTip();
            Dimension size = this.cellTip.getPreferredSize();
            location.x = screenLocation.x + cellTipLocation.x;
            location.y = screenLocation.y + cellTipLocation.y;
            if (this.popupRect == null) {
                this.popupRect = new Rectangle();
            }
            this.popupRect.setBounds(location.x, location.y, size.width, size.height);
            if (location.x < sBounds.x) {
                location.x = sBounds.x;
            } else if (location.x - sBounds.x + size.width > sBounds.width) {
                location.x = sBounds.x + Math.max(0, sBounds.width - size.width);
            }
            if (location.y < sBounds.y) {
                location.y = sBounds.y;
            } else if (location.y - sBounds.y + size.height > sBounds.height) {
                location.y = sBounds.y + Math.max(0, sBounds.height - size.height);
            }
            PopupFactory popupFactory = PopupFactory.getSharedInstance();
            this.cellTipPopup = popupFactory.getPopup(this.cellTipComponent, this.cellTip, location.x, location.y);
            this.cellTipPopup.show();
            Window componentWindow = SwingUtilities.windowForComponent(this.cellTipComponent);
            this.cellTipWindow = SwingUtilities.windowForComponent(this.cellTip);
            if (this.cellTipWindow != null && this.cellTipWindow != componentWindow) {
                this.cellTipWindow.addMouseListener(this);
                this.cellTipWindow.addMouseWheelListener(this);
            } else {
                this.cellTipWindow = null;
            }
        }
    }

    private class UniversalCellTipListener
    implements ComponentListener,
    KeyListener,
    FocusListener,
    PropertyChangeListener,
    HierarchyListener,
    HierarchyBoundsListener {
        private UniversalCellTipListener() {
        }

        @Override
        public void ancestorMoved(HierarchyEvent e) {
            this.hideCellTipForOwner(e.getSource());
        }

        @Override
        public void ancestorResized(HierarchyEvent e) {
            this.hideCellTipForOwner(e.getSource());
        }

        @Override
        public void componentHidden(ComponentEvent e) {
            this.hideCellTipForOwner(e.getSource());
        }

        @Override
        public void componentMoved(ComponentEvent e) {
            this.hideCellTipForOwner(e.getSource());
        }

        @Override
        public void componentResized(ComponentEvent e) {
            this.hideCellTipForOwner(e.getSource());
        }

        @Override
        public void componentShown(ComponentEvent e) {
            this.hideCellTipForOwner(e.getSource());
        }

        @Override
        public void focusGained(FocusEvent e) {
        }

        @Override
        public void focusLost(FocusEvent e) {
            this.hideCellTipForOwner(e.getSource());
        }

        @Override
        public void hierarchyChanged(HierarchyEvent e) {
            this.hideCellTipForOwner(e.getSource());
        }

        @Override
        public void keyPressed(KeyEvent e) {
            this.hideCellTipAlways();
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            this.hideCellTipForOwner(e.getSource());
        }

        void registerForComponent(JComponent component) {
            if (component == null) {
                return;
            }
            component.addComponentListener(this);
            component.addKeyListener(this);
            component.addFocusListener(this);
            component.addPropertyChangeListener(this);
            component.addHierarchyListener(this);
            component.addHierarchyBoundsListener(this);
        }

        void unregisterForComponent(JComponent component) {
            if (component == null) {
                return;
            }
            component.removeComponentListener(this);
            component.removeKeyListener(this);
            component.removeFocusListener(this);
            component.removePropertyChangeListener(this);
            component.removeHierarchyListener(this);
            component.removeHierarchyBoundsListener(this);
        }

        private void hideCellTipAlways() {
            CellTipManager.this.hideCellTip();
        }

        private void hideCellTipForOwner(Object owner) {
            if (CellTipManager.this.cellTipComponent == owner) {
                CellTipManager.this.hideCellTip();
            }
        }
    }

    private class MoveBeforeEnterListener
    extends MouseMotionAdapter {
        private MoveBeforeEnterListener() {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            CellTipManager.this.initiateCellTip(e);
        }
    }
}

