/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.results;

import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingWorker;
import org.netbeans.lib.profiler.filters.GenericFilter;
import org.netbeans.lib.profiler.ui.results.ColoredFilter;
import org.netbeans.modules.profiler.api.ProfilerIDESettings;
import org.netbeans.modules.profiler.api.ProfilerStorage;

public final class PackageColorer {
    private static final ResourceBundle messages = ResourceBundle.getBundle("org.netbeans.lib.profiler.ui.results.Bundle");
    private static final String FILTERS_REFLECTION = messages.getString("PackageColorer_FiltersReflection");
    private static final String FILTERS_JPA = messages.getString("PackageColorer_FiltersJpa");
    private static final String FILTERS_SERVERS = messages.getString("PackageColorer_FiltersServers");
    private static final String FILTERS_JAVASE = messages.getString("PackageColorer_FiltersJavaSe");
    private static final String FILTERS_JAVAEE = messages.getString("PackageColorer_FiltersJavaEe");
    private static final String FILTERS_FILE = "filters";
    private static final List<ColoredFilter> COLORS = PackageColorer.loadColors();

    public static boolean registerColor(ColoredFilter color) {
        if (COLORS.contains((Object)color)) {
            return false;
        }
        return COLORS.add(color);
    }

    public static boolean unregisterColor(ColoredFilter color) {
        return COLORS.remove((Object)color);
    }

    public static boolean hasRegisteredColors() {
        return !COLORS.isEmpty();
    }

    public static List<ColoredFilter> getRegisteredColors() {
        ArrayList<ColoredFilter> colors = new ArrayList<ColoredFilter>();
        for (ColoredFilter color : COLORS) {
            colors.add(new ColoredFilter(color));
        }
        return colors;
    }

    public static void setRegisteredColors(List<ColoredFilter> colors) {
        if (!COLORS.equals(colors)) {
            COLORS.clear();
            COLORS.addAll(colors);
        }
    }

    public static Color getForeground(String pkg) {
        if (!ProfilerIDESettings.getInstance().isSourcesColoringEnabled()) {
            return null;
        }
        for (ColoredFilter color : COLORS) {
            if (!color.passes(pkg)) continue;
            return color.getColor();
        }
        return null;
    }

    private static List<ColoredFilter> loadColors() {
        ArrayList<ColoredFilter> colors = new ArrayList<ColoredFilter>(){

            @Override
            public boolean add(ColoredFilter e) {
                boolean ret = super.add(e);
                if (ret && COLORS != null) {
                    PackageColorer.storeColors();
                }
                return ret;
            }

            @Override
            public boolean addAll(Collection<? extends ColoredFilter> c) {
                boolean ret = super.addAll(c);
                if (ret && COLORS != null) {
                    PackageColorer.storeColors();
                }
                return ret;
            }

            @Override
            public boolean remove(Object o) {
                boolean ret = super.remove(o);
                if (ret && COLORS != null) {
                    PackageColorer.storeColors();
                }
                return ret;
            }
        };
        Properties properties = new Properties();
        try {
            ProfilerStorage.loadGlobalProperties((Properties)properties, (String)FILTERS_FILE);
        }
        catch (IOException e) {
            Logger.getLogger(PackageColorer.class.getName()).log(Level.INFO, null, e);
        }
        if (!properties.isEmpty()) {
            int i = 0;
            try {
                while (true) {
                    colors.add(new ColoredFilter(properties, Integer.toString(i++) + "_"));
                }
            }
            catch (GenericFilter.InvalidFilterIdException e) {
                // empty catch block
            }
        }
        if (colors.isEmpty()) {
            PackageColorer.createDefaultFilters((List<ColoredFilter>)colors);
        }
        return colors;
    }

    private static void storeColors() {
        final Properties properties = new Properties();
        final List<ColoredFilter> colors = PackageColorer.getRegisteredColors();
        new SwingWorker(){

            protected Object doInBackground() throws Exception {
                for (int i = 0; i < colors.size(); ++i) {
                    try {
                        ((ColoredFilter)((Object)colors.get(i))).store(properties, Integer.toString(i) + "_");
                        continue;
                    }
                    catch (Throwable t) {
                        Logger.getLogger(PackageColorer.class.getName()).log(Level.INFO, null, t);
                    }
                }
                try {
                    ProfilerStorage.saveGlobalProperties((Properties)properties, (String)PackageColorer.FILTERS_FILE);
                }
                catch (IOException e) {
                    Logger.getLogger(PackageColorer.class.getName()).log(Level.INFO, null, e);
                }
                return null;
            }
        }.execute();
    }

    private static void createDefaultFilters(List<ColoredFilter> colors) {
        String jpa = new String("org.eclipse.persistence., org.hibernate., org.apache.openjpa.");
        colors.add(new ColoredFilter(FILTERS_JPA, jpa, new Color(135, 135, 135)));
        String javaee = new String("javax.servlet., com.sun.enterprise., com.sun.ejb., org.jboss.weld., org.jboss.logging., org.springframework.");
        colors.add(new ColoredFilter(FILTERS_JAVAEE, javaee, new Color(135, 135, 135)));
        String servers = new String("org.glassfish., com.sun.appserv., com.sun.gjc., weblogic., com.oracle.weblogic., com.bea., org.apache.tomcat., org.apache.catalina., org.jboss.as., org.eclipse.jetty.");
        colors.add(new ColoredFilter(FILTERS_SERVERS, servers, new Color(135, 135, 135)));
        String reflection = new String("java.lang.reflect., sun.reflect., com.sun.proxy.");
        colors.add(new ColoredFilter(FILTERS_REFLECTION, reflection, new Color(180, 180, 180)));
        String javase = new String("apple.laf., apple.awt., com.apple., com.sun., java., javax., sun., sunw., org.omg.");
        colors.add(new ColoredFilter(FILTERS_JAVASE, javase, new Color(135, 135, 135)));
    }
}

