/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visual.graph.layout.hierarchicalsupport;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.netbeans.modules.visual.graph.layout.hierarchicalsupport.DirectedGraph;

public class LayeredGraph {
    private DirectedGraph originalGraph;
    private List<List<DirectedGraph.Vertex>> layers;

    protected LayeredGraph(DirectedGraph originalGraph) {
        this.originalGraph = originalGraph;
        this.layers = new ArrayList<List<DirectedGraph.Vertex>>();
    }

    public static LayeredGraph createGraph(DirectedGraph originalGraph) {
        LayeredGraph graph = new LayeredGraph(originalGraph);
        graph.createGraph();
        return graph;
    }

    protected void createGraph() {
        Collection<DirectedGraph.Vertex> rootVertices = this.originalGraph.getRootVertices();
        for (DirectedGraph.Vertex rootVertex : rootVertices) {
            this.assignLayers(rootVertex, 0);
        }
    }

    public DirectedGraph getOriginalGraph() {
        return this.originalGraph;
    }

    private void assignLayers(DirectedGraph.Vertex vertex, int index) {
        this.assignLayer(vertex, index);
        Collection<DirectedGraph.Vertex> vertices = vertex.getLowerNeighbors();
        for (DirectedGraph.Vertex nv : vertices) {
            int nvIndex = nv.getNumber();
            if (nvIndex > index) continue;
            this.assignLayers(nv, index + 1);
        }
    }

    public void assignLayer(DirectedGraph.Vertex vertex, int index) {
        List<DirectedGraph.Vertex> layer;
        int prevIndex = vertex.getNumber();
        if (prevIndex != -1) {
            layer = this.getLayer(prevIndex);
            layer.remove(vertex);
        }
        layer = this.getLayer(index);
        layer.add(vertex);
        vertex.setNumber(index);
        vertex.setY(index);
        vertex.setX(layer.size());
    }

    public List<List<DirectedGraph.Vertex>> getLayers() {
        return this.layers;
    }

    public List<DirectedGraph.Vertex> getLayer(int index) {
        int size = this.layers.size();
        if (index >= size) {
            for (int i = size; i <= index; ++i) {
                this.layers.add(new ArrayList());
            }
        }
        return this.layers.get(index);
    }

    public boolean[][] computeAdjacencyMatrix(int upperLayerIndex) {
        List<DirectedGraph.Vertex> upperLayer = this.layers.get(upperLayerIndex);
        List<DirectedGraph.Vertex> lowerLayer = this.layers.get(upperLayerIndex + 1);
        int upperLayerSize = upperLayer.size();
        int lowerLayerSize = lowerLayer.size();
        boolean[][] matrix = new boolean[upperLayerSize][lowerLayerSize];
        for (int j = 0; j < upperLayerSize; ++j) {
            DirectedGraph.Vertex v = upperLayer.get(j);
            if (v == null) continue;
            Collection<DirectedGraph.Vertex> vertices = v.getLowerNeighbors();
            for (DirectedGraph.Vertex nv : vertices) {
                int k = lowerLayer.indexOf(nv);
                if (k <= -1) continue;
                matrix[j][k] = true;
            }
        }
        return matrix;
    }

    public float[] computeLowerBarycenters(int upperLayerIndex) {
        boolean[][] matrix = this.computeAdjacencyMatrix(upperLayerIndex);
        List<DirectedGraph.Vertex> upperLayer = this.layers.get(upperLayerIndex);
        List<DirectedGraph.Vertex> lowerLayer = this.layers.get(upperLayerIndex + 1);
        int upperLayerSize = upperLayer.size();
        int lowerLayerSize = lowerLayer.size();
        float[] lowerBarycenters = new float[lowerLayerSize];
        float[] barycenters = new float[lowerLayerSize];
        for (int k = 0; k < lowerLayerSize; ++k) {
            float sum = 0.0f;
            float count = 0.0f;
            for (int j = 0; j < upperLayerSize; ++j) {
                if (!matrix[j][k]) continue;
                DirectedGraph.Vertex jv = upperLayer.get(j);
                sum += (float)jv.getX();
                count += 1.0f;
            }
            DirectedGraph.Vertex kv = lowerLayer.get(k);
            lowerBarycenters[k] = sum / count;
        }
        return lowerBarycenters;
    }

    public float[] computeUpperBarycenters(int upperLayerIndex) {
        boolean[][] matrix = this.computeAdjacencyMatrix(upperLayerIndex);
        List<DirectedGraph.Vertex> upperLayer = this.layers.get(upperLayerIndex);
        List<DirectedGraph.Vertex> lowerLayer = this.layers.get(upperLayerIndex + 1);
        int upperLayerSize = upperLayer.size();
        int lowerLayerSize = lowerLayer.size();
        float[] upperBarycenters = new float[upperLayerSize];
        for (int j = 0; j < upperLayerSize; ++j) {
            float sum = 0.0f;
            float count = 0.0f;
            for (int k = 0; k < lowerLayerSize; ++k) {
                if (!matrix[j][k]) continue;
                DirectedGraph.Vertex kv = lowerLayer.get(k);
                sum += (float)kv.getX();
                count += 1.0f;
            }
            DirectedGraph.Vertex jv = upperLayer.get(j);
            upperBarycenters[j] = sum / count;
        }
        return upperBarycenters;
    }
}

