/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.truffle;

import com.sun.jdi.ArrayReference;
import com.sun.jdi.ArrayType;
import com.sun.jdi.BooleanValue;
import com.sun.jdi.ByteValue;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.ClassObjectReference;
import com.sun.jdi.ClassType;
import com.sun.jdi.Field;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.InvocationException;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.StringReference;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.Value;
import com.sun.jdi.VirtualMachine;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.locks.Lock;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.api.debugger.jpda.MethodBreakpoint;
import org.netbeans.api.debugger.jpda.event.JPDABreakpointEvent;
import org.netbeans.api.debugger.jpda.event.JPDABreakpointListener;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.jdi.ArrayReferenceWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ArrayTypeWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ClassNotPreparedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ClassObjectReferenceWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ClassTypeWrapper;
import org.netbeans.modules.debugger.jpda.jdi.IllegalThreadStateExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.InternalExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ObjectCollectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ObjectReferenceWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ReferenceTypeWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ThreadReferenceWrapper;
import org.netbeans.modules.debugger.jpda.jdi.UnsupportedOperationExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VMDisconnectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VirtualMachineWrapper;
import org.netbeans.modules.debugger.jpda.models.JPDAThreadImpl;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakSet;

public final class RemoteServices {
    private static final Logger logger = Logger.getLogger(RemoteServices.class.getName());
    static final String REMOTE_CLASSES_ZIPFILE = "/org/netbeans/modules/debugger/jpda/truffle/resources/JPDATruffleBackend.jar";
    private static final Map<JPDADebugger, ClassObjectReference> remoteServiceClasses = new WeakHashMap<JPDADebugger, ClassObjectReference>();
    private static final Map<JPDADebugger, ThreadReference> remoteServiceAccess = new WeakHashMap<JPDADebugger, ThreadReference>();
    private static final RequestProcessor AUTORESUME_AFTER_SUSPEND_RP = new RequestProcessor("Autoresume after suspend", 1);
    private static final Set<PropertyChangeListener> serviceListeners = new WeakSet();
    private static final Map<JPDAThread, RequestProcessor.Task> tasksByThreads = new WeakHashMap<JPDAThread, RequestProcessor.Task>();
    private static final Map<JPDADebugger, LoggingListeners> loggingListeners = new WeakHashMap<JPDADebugger, LoggingListeners>();

    private RemoteServices() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addServiceListener(PropertyChangeListener listener) {
        Set<PropertyChangeListener> set = serviceListeners;
        synchronized (set) {
            serviceListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void fireServiceClass(JPDADebugger debugger) {
        PropertyChangeEvent pche = new PropertyChangeEvent(RemoteServices.class, "serviceClass", null, debugger);
        PropertyChangeListener[] propertyChangeListenerArray = serviceListeners;
        synchronized (serviceListeners) {
            PropertyChangeListener[] listeners = serviceListeners.toArray(new PropertyChangeListener[0]);
            // ** MonitorExit[var3_2] (shouldn't be in output)
            for (PropertyChangeListener l : listeners) {
                l.propertyChange(pche);
            }
            return;
        }
    }

    private static ObjectReference getTruffleClassLoader(ThreadReference tawt, VirtualMachine vm) throws InvalidTypeException, ClassNotLoadedException, IncompatibleThreadStateException, InvocationException, IOException, PropertyVetoException, InternalExceptionWrapper, VMDisconnectedExceptionWrapper, ObjectCollectedExceptionWrapper, UnsupportedOperationExceptionWrapper, ClassNotPreparedExceptionWrapper {
        ClassType truffleLocatorClass = RemoteServices.getClass(vm, "com.oracle.truffle.api.impl.TruffleLocator");
        return truffleLocatorClass.classLoader();
    }

    private static ObjectReference getBootstrapClassLoader(ThreadReference tawt, VirtualMachine vm) throws InvalidTypeException, ClassNotLoadedException, IncompatibleThreadStateException, InvocationException, IOException, PropertyVetoException, InternalExceptionWrapper, VMDisconnectedExceptionWrapper, ObjectCollectedExceptionWrapper, UnsupportedOperationExceptionWrapper, ClassNotPreparedExceptionWrapper {
        ObjectReference bcl;
        ClassType classLoaderClass = RemoteServices.getClass(vm, ClassLoader.class.getName());
        Method getSystemClassLoader = ClassTypeWrapper.concreteMethodByName((ClassType)classLoaderClass, (String)"getSystemClassLoader", (String)"()Ljava/lang/ClassLoader;");
        ObjectReference cl = (ObjectReference)ClassTypeWrapper.invokeMethod((ClassType)classLoaderClass, (ThreadReference)tawt, (Method)getSystemClassLoader, Collections.emptyList(), (int)1);
        Method getParent = ClassTypeWrapper.concreteMethodByName((ClassType)classLoaderClass, (String)"getParent", (String)"()Ljava/lang/ClassLoader;");
        do {
            bcl = cl;
        } while (!"sun.misc.Launcher$AppClassLoader".equals(cl.referenceType().name()) && (cl = (ObjectReference)ObjectReferenceWrapper.invokeMethod((ObjectReference)cl, (ThreadReference)tawt, (Method)getParent, Collections.emptyList(), (int)1)) != null);
        return bcl;
    }

    private static ObjectReference getContextClassLoader(ThreadReference tawt, VirtualMachine vm) throws InvalidTypeException, ClassNotLoadedException, IncompatibleThreadStateException, InvocationException, IOException, PropertyVetoException, InternalExceptionWrapper, VMDisconnectedExceptionWrapper, ObjectCollectedExceptionWrapper, UnsupportedOperationExceptionWrapper, ClassNotPreparedExceptionWrapper {
        ReferenceType threadType = tawt.referenceType();
        Method getContextCl = ClassTypeWrapper.concreteMethodByName((ClassType)((ClassType)threadType), (String)"getContextClassLoader", (String)"()Ljava/lang/ClassLoader;");
        ObjectReference cl = (ObjectReference)ObjectReferenceWrapper.invokeMethod((ObjectReference)tawt, (ThreadReference)tawt, (Method)getContextCl, Collections.emptyList(), (int)1);
        ClassType classLoaderClass = null;
        if (cl == null) {
            classLoaderClass = RemoteServices.getClass(vm, ClassLoader.class.getName());
            Method getSystemClassLoader = ClassTypeWrapper.concreteMethodByName((ClassType)classLoaderClass, (String)"getSystemClassLoader", (String)"()Ljava/lang/ClassLoader;");
            cl = (ObjectReference)ClassTypeWrapper.invokeMethod((ClassType)classLoaderClass, (ThreadReference)tawt, (Method)getSystemClassLoader, Collections.emptyList(), (int)1);
        }
        return cl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ClassObjectReference uploadBasicClasses(JPDAThreadImpl t, String basicClassName) throws InvalidTypeException, ClassNotLoadedException, IncompatibleThreadStateException, InvocationException, IOException, PropertyVetoException, InternalExceptionWrapper, VMDisconnectedExceptionWrapper, ObjectCollectedExceptionWrapper, UnsupportedOperationExceptionWrapper, ClassNotPreparedExceptionWrapper {
        ThreadReference tawt = t.getThreadReference();
        VirtualMachine vm = tawt.virtualMachine();
        t.notifyMethodInvoking();
        try {
            Map<JPDADebugger, ClassObjectReference> map;
            Object basicClass = null;
            t.accessLock.writeLock().lock();
            try {
                List<RemoteClass> remoteClasses = RemoteServices.getRemoteClasses();
                for (RemoteClass rc : remoteClasses) {
                    String className = rc.name;
                    if (basicClass != null || !className.endsWith(basicClassName) || className.indexOf(36) >= 0) continue;
                    List classesByName = VirtualMachineWrapper.classesByName((VirtualMachine)vm, (String)className);
                    if (classesByName.isEmpty()) break;
                    basicClass = ReferenceTypeWrapper.classObject((ReferenceType)((ReferenceType)classesByName.get(0)));
                    break;
                }
                if (basicClass == null) {
                    ObjectReference cl = RemoteServices.getTruffleClassLoader(tawt, vm);
                    if (cl == null) {
                        cl = RemoteServices.getBootstrapClassLoader(tawt, vm);
                    }
                    if (cl == null) {
                        cl = RemoteServices.getContextClassLoader(tawt, vm);
                    }
                    ClassType classLoaderClass = (ClassType)ObjectReferenceWrapper.referenceType((ObjectReference)cl);
                    ByteValue[] mirrorBytesCache = new ByteValue[256];
                    for (RemoteClass rc : remoteClasses) {
                        String className = rc.name;
                        ArrayReference byteArray = RemoteServices.createTargetBytes(vm, rc.bytes, mirrorBytesCache);
                        StringReference nameMirror = null;
                        try {
                            Method defineClass = ClassTypeWrapper.concreteMethodByName((ClassType)classLoaderClass, (String)"defineClass", (String)"(Ljava/lang/String;[BII)Ljava/lang/Class;");
                            boolean uploaded = false;
                            while (!uploaded) {
                                nameMirror = VirtualMachineWrapper.mirrorOf((VirtualMachine)vm, (String)className);
                                try {
                                    ObjectReferenceWrapper.disableCollection((ObjectReference)nameMirror);
                                    uploaded = true;
                                }
                                catch (ObjectCollectedExceptionWrapper objectCollectedExceptionWrapper) {}
                            }
                            uploaded = false;
                            while (!uploaded) {
                                ClassObjectReference theUploadedClass = (ClassObjectReference)ObjectReferenceWrapper.invokeMethod((ObjectReference)cl, (ThreadReference)tawt, (Method)defineClass, Arrays.asList(nameMirror, byteArray, vm.mirrorOf(0), vm.mirrorOf(rc.bytes.length)), (int)1);
                                if (basicClass == null && rc.name.indexOf(36) < 0 && rc.name.endsWith("Accessor")) {
                                    try {
                                        ObjectReferenceWrapper.disableCollection((ObjectReference)theUploadedClass);
                                        basicClass = theUploadedClass;
                                        uploaded = true;
                                    }
                                    catch (ObjectCollectedExceptionWrapper objectCollectedExceptionWrapper) {}
                                    continue;
                                }
                                uploaded = true;
                            }
                        }
                        catch (Throwable throwable) {
                            ObjectReferenceWrapper.enableCollection((ObjectReference)byteArray);
                            if (nameMirror != null) {
                                ObjectReferenceWrapper.enableCollection(nameMirror);
                            }
                            throw throwable;
                        }
                        ObjectReferenceWrapper.enableCollection((ObjectReference)byteArray);
                        if (nameMirror == null) continue;
                        ObjectReferenceWrapper.enableCollection((ObjectReference)nameMirror);
                    }
                }
                if (basicClass != null) {
                    ClassType theClass = RemoteServices.getClass(vm, Class.class.getName());
                    Method newInstance = ClassTypeWrapper.concreteMethodByName((ClassType)theClass, (String)"newInstance", (String)"()Ljava/lang/Object;");
                    ObjectReference objectReference = (ObjectReference)ObjectReferenceWrapper.invokeMethod(basicClass, (ThreadReference)tawt, (Method)newInstance, Collections.emptyList(), (int)1);
                }
            }
            finally {
                t.accessLock.writeLock().unlock();
            }
            if (basicClass != null) {
                map = remoteServiceClasses;
                synchronized (map) {
                    remoteServiceClasses.put((JPDADebugger)t.getDebugger(), (ClassObjectReference)basicClass);
                    t.getDebugger().addPropertyChangeListener((PropertyChangeListener)new RemoteServiceDebuggerListener());
                }
                RemoteServices.fireServiceClass((JPDADebugger)t.getDebugger());
            }
            map = basicClass;
            return map;
        }
        finally {
            t.notifyMethodInvokeDone();
        }
    }

    private static void runOnBreakpoint(JPDAThread awtThread, String bpClass, String bpMethod, Runnable runnable, CountDownLatch latch) {
        MethodBreakpoint mb = MethodBreakpoint.create((String)bpClass, (String)bpMethod);
        JPDADebuggerImpl dbg = ((JPDAThreadImpl)awtThread).getDebugger();
        PropertyChangeListener[] listenerPtr = new PropertyChangeListener[]{null};
        mb.setBreakpointType(1);
        mb.setSuspend(1);
        mb.setHidden(true);
        mb.setThreadFilters((JPDADebugger)dbg, new JPDAThread[]{awtThread});
        mb.addJPDABreakpointListener(new JPDABreakpointListener((JPDADebugger)dbg, mb, listenerPtr, awtThread, runnable, latch){
            final /* synthetic */ JPDADebugger val$dbg;
            final /* synthetic */ MethodBreakpoint val$mb;
            final /* synthetic */ PropertyChangeListener[] val$listenerPtr;
            final /* synthetic */ JPDAThread val$awtThread;
            final /* synthetic */ Runnable val$runnable;
            final /* synthetic */ CountDownLatch val$latch;
            {
                this.val$dbg = jPDADebugger;
                this.val$mb = methodBreakpoint;
                this.val$listenerPtr = propertyChangeListenerArray;
                this.val$awtThread = jPDAThread;
                this.val$runnable = runnable;
                this.val$latch = countDownLatch;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void breakpointReached(JPDABreakpointEvent event) {
                block8: {
                    if (this.val$dbg.equals(event.getDebugger())) {
                        try {
                            DebuggerManager.getDebuggerManager().removeBreakpoint((Breakpoint)this.val$mb);
                            PropertyChangeListener listener = this.val$listenerPtr[0];
                            if (listener != null) {
                                this.val$dbg.removePropertyChangeListener("state", listener);
                                this.val$listenerPtr[0] = null;
                            }
                            try {
                                ((JPDAThreadImpl)this.val$awtThread).notifyMethodInvoking();
                                this.val$runnable.run();
                            }
                            catch (PropertyVetoException propertyVetoException) {
                                ((JPDAThreadImpl)this.val$awtThread).notifyMethodInvokeDone();
                                break block8;
                            }
                            catch (Throwable throwable) {
                                ((JPDAThreadImpl)this.val$awtThread).notifyMethodInvokeDone();
                                throw throwable;
                            }
                            ((JPDAThreadImpl)this.val$awtThread).notifyMethodInvokeDone();
                        }
                        finally {
                            event.resume();
                            this.val$latch.countDown();
                        }
                    }
                }
            }
        });
        PropertyChangeListener listener = new PropertyChangeListener((JPDADebugger)dbg, mb, listenerPtr, latch){
            final /* synthetic */ JPDADebugger val$dbg;
            final /* synthetic */ MethodBreakpoint val$mb;
            final /* synthetic */ PropertyChangeListener[] val$listenerPtr;
            final /* synthetic */ CountDownLatch val$latch;
            {
                this.val$dbg = jPDADebugger;
                this.val$mb = methodBreakpoint;
                this.val$listenerPtr = propertyChangeListenerArray;
                this.val$latch = countDownLatch;
            }

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (this.val$dbg.getState() == 4) {
                    DebuggerManager.getDebuggerManager().removeBreakpoint((Breakpoint)this.val$mb);
                    this.val$dbg.removePropertyChangeListener("state", (PropertyChangeListener)this);
                    this.val$listenerPtr[0] = null;
                    this.val$latch.countDown();
                }
            }
        };
        dbg.addPropertyChangeListener("state", listener);
        listenerPtr[0] = listener;
        if (dbg.getState() != 4) {
            DebuggerManager.getDebuggerManager().addBreakpoint((Breakpoint)mb);
        } else {
            dbg.removePropertyChangeListener("state", listener);
            latch.countDown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runOnStoppedThread(JPDAThread thread, Runnable run) throws PropertyVetoException {
        block29: {
            JPDAThreadImpl t = (JPDAThreadImpl)thread;
            Lock lock = t.accessLock.writeLock();
            lock.lock();
            try {
                RequestProcessor.Task autoresumeTask;
                ThreadReference threadReference = t.getThreadReference();
                boolean wasSuspended = t.isSuspended();
                if (!t.isSuspended() || !threadReference.isAtBreakpoint()) {
                    // empty if block
                }
                if (!t.isSuspended()) {
                    ClassObjectReference serviceClassObject;
                    CountDownLatch latch = new CountDownLatch(1);
                    lock.unlock();
                    lock = null;
                    VirtualMachine vm = ((JPDAThreadImpl)thread).getThreadReference().virtualMachine();
                    Map<JPDADebugger, ClassObjectReference> map = remoteServiceClasses;
                    synchronized (map) {
                        serviceClassObject = remoteServiceClasses.get(((JPDAThreadImpl)thread).getDebugger());
                    }
                    if (serviceClassObject == null) {
                        return;
                    }
                    RemoteServices.runOnBreakpoint(thread, "org.netbeans.modules.debugger.jpda.visual.remote.RemoteAWTService", "calledInAWT", run, latch);
                    try {
                        ClassType serviceClass = (ClassType)ClassObjectReferenceWrapper.reflectedType((ClassObjectReference)serviceClassObject);
                        Field awtAccess = ReferenceTypeWrapper.fieldByName((ReferenceType)serviceClass, (String)"awtAccess");
                        ClassTypeWrapper.setValue((ClassType)serviceClass, (Field)awtAccess, (Value)VirtualMachineWrapper.mirrorOf((VirtualMachine)vm, (boolean)true));
                    }
                    catch (InternalExceptionWrapper serviceClass) {
                    }
                    catch (VMDisconnectedExceptionWrapper serviceClass) {
                    }
                    catch (Exception ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                    try {
                        latch.await();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                    break block29;
                }
                if (!wasSuspended) {
                    AutoresumeTask resumeTask = new AutoresumeTask(t);
                    autoresumeTask = AUTORESUME_AFTER_SUSPEND_RP.create((Runnable)resumeTask);
                    Map<JPDAThread, RequestProcessor.Task> map = tasksByThreads;
                    synchronized (map) {
                        tasksByThreads.put(thread, autoresumeTask);
                    }
                }
                Map<JPDAThread, RequestProcessor.Task> map = tasksByThreads;
                synchronized (map) {
                    autoresumeTask = tasksByThreads.get(thread);
                }
                t.notifyMethodInvoking();
                if (autoresumeTask != null) {
                    autoresumeTask.schedule(Integer.MAX_VALUE);
                }
                try {
                    run.run();
                }
                finally {
                    t.notifyMethodInvokeDone();
                    if (autoresumeTask != null) {
                        autoresumeTask.schedule(500);
                    }
                }
            }
            finally {
                if (lock != null) {
                    lock.unlock();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void setAccessLoopStarted(JPDADebugger debugger, ThreadReference accessThread) {
        Map<JPDADebugger, ThreadReference> map = remoteServiceAccess;
        synchronized (map) {
            remoteServiceAccess.put(debugger, accessThread);
        }
        RemoteServices.fireServiceClass(debugger);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean interruptServiceAccessThread(JPDADebugger debugger) {
        ClassObjectReference serviceClass = RemoteServices.getServiceClass(debugger);
        if (serviceClass != null) {
            ThreadReference accessThread;
            Map<JPDADebugger, ThreadReference> map = remoteServiceAccess;
            synchronized (map) {
                accessThread = remoteServiceAccess.get(debugger);
            }
            if (accessThread == null) {
                return false;
            }
            logger.fine("RemoteServices.interruptServiceAccessThread()");
            try {
                ClassType serviceClassType = (ClassType)ClassObjectReferenceWrapper.reflectedType((ClassObjectReference)serviceClass);
                Field accessLoopSleepingField = ReferenceTypeWrapper.fieldByName((ReferenceType)serviceClassType, (String)"accessLoopSleeping");
                ThreadReference threadReference = accessThread;
                synchronized (threadReference) {
                    BooleanValue sleepingValue;
                    boolean isSleeping;
                    int repeatCheck = 10;
                    while (!(isSleeping = (sleepingValue = (BooleanValue)serviceClassType.getValue(accessLoopSleepingField)).booleanValue()) && --repeatCheck >= 0) {
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        logger.log(Level.FINE, "  isSleeping = {0}", isSleeping);
                        if (!isSleeping) continue;
                    }
                    if (isSleeping) {
                        ThreadReferenceWrapper.interrupt((ThreadReference)accessThread);
                        return true;
                    }
                }
            }
            catch (ClassNotPreparedExceptionWrapper | IllegalThreadStateExceptionWrapper | InternalExceptionWrapper | ObjectCollectedExceptionWrapper | VMDisconnectedExceptionWrapper ex) {
                logger.log(Level.FINE, "  NOT interrupted: ", ex);
            }
            logger.fine("  NOT Interrupted.");
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ClassObjectReference getServiceClass(JPDADebugger debugger) {
        Map<JPDADebugger, ClassObjectReference> map = remoteServiceClasses;
        synchronized (map) {
            return remoteServiceClasses.get(debugger);
        }
    }

    static ClassType getClass(VirtualMachine vm, String name) throws InternalExceptionWrapper, VMDisconnectedExceptionWrapper, ObjectCollectedExceptionWrapper {
        List classList = VirtualMachineWrapper.classesByName((VirtualMachine)vm, (String)name);
        ReferenceType clazz = null;
        for (ReferenceType c : classList) {
            if (ReferenceTypeWrapper.classLoader((ReferenceType)c) != null) continue;
            clazz = c;
            break;
        }
        if (clazz == null && classList.size() > 0) {
            clazz = (ReferenceType)classList.get(0);
        }
        return (ClassType)clazz;
    }

    static ArrayType getArrayClass(VirtualMachine vm, String name) throws InternalExceptionWrapper, VMDisconnectedExceptionWrapper, ObjectCollectedExceptionWrapper {
        List classList = VirtualMachineWrapper.classesByName((VirtualMachine)vm, (String)name);
        ReferenceType clazz = null;
        for (ReferenceType c : classList) {
            if (ReferenceTypeWrapper.classLoader((ReferenceType)c) != null) continue;
            clazz = c;
            break;
        }
        return (ArrayType)clazz;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<RemoteClass> getRemoteClasses() throws IOException {
        try (InputStream in = RemoteServices.openRemoteClasses();){
            ZipEntry ze;
            ZipInputStream zin = new ZipInputStream(in);
            ArrayList<RemoteClass> rcl = new ArrayList<RemoteClass>();
            while ((ze = zin.getNextEntry()) != null) {
                int r;
                String name;
                int baseStart;
                String fileName = ze.getName();
                if (!fileName.endsWith(".class") || (baseStart = (name = fileName.substring(0, fileName.length() - ".class".length())).lastIndexOf(47)) < 0) continue;
                RemoteClass rc = new RemoteClass();
                rc.name = name.replace('/', '.');
                int l = (int)ze.getSize();
                byte[] bytes = new byte[l];
                for (int num = 0; num < l; num += r) {
                    r = zin.read(bytes, num, l - num);
                    if (r >= 0) continue;
                    Exceptions.printStackTrace((Throwable)new IllegalStateException("Can not read full content of " + name + " entry. Length = " + l + ", read num = " + num));
                    break;
                }
                RemoteClass.access$102(rc, bytes);
                rcl.add(rc);
            }
            ArrayList<RemoteClass> arrayList = rcl;
            return arrayList;
        }
    }

    static InputStream openRemoteClasses() {
        return RemoteServices.class.getResourceAsStream(REMOTE_CLASSES_ZIPFILE);
    }

    private static ArrayReference createTargetBytes(VirtualMachine vm, byte[] bytes, ByteValue[] mirrorBytesCache) throws InvalidTypeException, ClassNotLoadedException, InternalExceptionWrapper, VMDisconnectedExceptionWrapper, ObjectCollectedExceptionWrapper, UnsupportedOperationExceptionWrapper {
        ArrayType bytesArrayClass = RemoteServices.getArrayClass(vm, "byte[]");
        ArrayReference array = null;
        boolean disabledCollection = false;
        while (!disabledCollection) {
            array = ArrayTypeWrapper.newInstance((ArrayType)bytesArrayClass, (int)bytes.length);
            try {
                ObjectReferenceWrapper.disableCollection((ObjectReference)array);
                disabledCollection = true;
            }
            catch (ObjectCollectedExceptionWrapper objectCollectedExceptionWrapper) {}
        }
        ArrayList<ByteValue> values = new ArrayList<ByteValue>(bytes.length);
        for (int i = 0; i < bytes.length; ++i) {
            byte b = bytes[i];
            ByteValue mb = mirrorBytesCache[128 + b];
            if (mb == null) {
                mirrorBytesCache[128 + b] = mb = VirtualMachineWrapper.mirrorOf((VirtualMachine)vm, (byte)b);
            }
            values.add(mb);
        }
        ArrayReferenceWrapper.setValues((ArrayReference)array, values);
        return array;
    }

    private static class AutoresumeTask
    implements Runnable,
    PropertyChangeListener {
        private static final int WAIT_TIME = 500;
        private volatile JPDAThreadImpl t;

        public AutoresumeTask(JPDAThreadImpl t) {
            this.t = t;
            t.addPropertyChangeListener((PropertyChangeListener)this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            JPDAThreadImpl thread = this.t;
            if (thread == null) {
                return;
            }
            if ("suspended".equals(evt.getPropertyName()) && !"methodInvoke".equals(evt.getPropagationId())) {
                thread.removePropertyChangeListener((PropertyChangeListener)this);
                logger.fine("AutoresumeTask: autoresume canceled, thread changed suspended state: suspended = " + thread.isSuspended());
                Map map = tasksByThreads;
                synchronized (map) {
                    tasksByThreads.remove(thread);
                }
                this.t = null;
            }
        }

        @Override
        public void run() {
            JPDAThreadImpl thread = this.t;
            this.t = null;
            if (thread != null) {
                thread.removePropertyChangeListener((PropertyChangeListener)this);
                thread.resume();
            }
        }
    }

    public static interface LoggingListenerCallBack {
        public void eventsData(String[] var1, String[] var2);
    }

    public static class RemoteListener {
        private String type;
        private List<String> allTypesList;
        private String[] allTypes;
        private ObjectReference l;

        public RemoteListener(String type, ObjectReference l) {
            this.type = type;
            this.l = l;
        }

        public String getType() {
            return this.type;
        }

        public void setAllTypes(String[] allTypes) {
            this.allTypes = allTypes;
        }

        private void addType(String listenerType) {
            if (this.allTypesList == null) {
                this.allTypesList = new ArrayList<String>();
                this.allTypesList.add(this.type);
            }
            this.allTypesList.add(listenerType);
        }

        public String[] getTypes() {
            if (this.allTypes == null) {
                this.allTypes = this.allTypesList != null ? this.allTypesList.toArray(new String[0]) : new String[]{this.type};
            }
            return this.allTypes;
        }

        public ObjectReference getListener() {
            return this.l;
        }

        public String toString() {
            return "RemoteListener(" + this.type + ")[" + this.l + "]";
        }
    }

    private static class RemoteClass {
        private String name;
        private byte[] bytes;

        private RemoteClass() {
        }

        static /* synthetic */ byte[] access$102(RemoteClass x0, byte[] x1) {
            x0.bytes = x1;
            return x1;
        }
    }

    private static class RemoteServiceDebuggerListener
    implements PropertyChangeListener {
        private RemoteServiceDebuggerListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            JPDADebugger d;
            if ("state".equals(evt.getPropertyName()) && 4 == (d = (JPDADebugger)evt.getSource()).getState()) {
                d.removePropertyChangeListener((PropertyChangeListener)this);
                Map map = remoteServiceClasses;
                synchronized (map) {
                    remoteServiceClasses.remove(d);
                }
            }
        }
    }

    private static final class LoggingListeners {
        private final Map<ObjectReference, Map<ClassObjectReference, Set<LoggingListenerCallBack>>> componentListeners = new HashMap<ObjectReference, Map<ClassObjectReference, Set<LoggingListenerCallBack>>>();

        private LoggingListeners() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static LoggingListeners get(JPDADebugger dbg) {
            Map map = loggingListeners;
            synchronized (map) {
                return (LoggingListeners)loggingListeners.get(dbg);
            }
        }

        private synchronized boolean add(ObjectReference component, ClassObjectReference listenerClass, LoggingListenerCallBack listener) {
            Set<LoggingListenerCallBack> lcb;
            Map<ClassObjectReference, Set<LoggingListenerCallBack>> listeners = this.componentListeners.get(component);
            if (listeners == null) {
                listeners = new HashMap<ClassObjectReference, Set<LoggingListenerCallBack>>();
                this.componentListeners.put(component, listeners);
            }
            if ((lcb = listeners.get(listenerClass)) == null) {
                lcb = new HashSet<LoggingListenerCallBack>();
                listeners.put(listenerClass, lcb);
            }
            return lcb.add(listener);
        }

        private synchronized boolean remove(ObjectReference component, ClassObjectReference listenerClass, LoggingListenerCallBack listener) {
            Map<ClassObjectReference, Set<LoggingListenerCallBack>> listeners = this.componentListeners.get(component);
            if (listeners == null) {
                return false;
            }
            Set<LoggingListenerCallBack> lcb = listeners.get(listenerClass);
            if (lcb == null) {
                return false;
            }
            boolean removed = lcb.remove(listener);
            if (removed && lcb.isEmpty()) {
                listeners.remove(listenerClass);
                if (listeners.isEmpty()) {
                    this.componentListeners.remove(component);
                }
            }
            return removed;
        }

        synchronized Set<LoggingListenerCallBack> getListeners(ObjectReference component, ClassObjectReference listenerClass) {
            Map<ClassObjectReference, Set<LoggingListenerCallBack>> listeners = this.componentListeners.get(component);
            if (listeners == null) {
                return null;
            }
            return listeners.get(listenerClass);
        }

        private synchronized boolean isEmpty() {
            return this.componentListeners.isEmpty();
        }
    }
}

