/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.fish.payara.micro.project;

import java.util.ArrayList;
import java.util.Optional;
import java.util.prefs.Preferences;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.fish.payara.micro.project.MicroApplication;
import org.netbeans.modules.fish.payara.micro.project.MicroVersion;
import org.netbeans.modules.fish.payara.micro.project.VersionRepository;
import org.netbeans.modules.maven.api.customizer.ModelHandle2;
import org.netbeans.modules.maven.api.customizer.support.ComboBoxUpdater;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class MicroPropertiesPanel
extends JPanel {
    private static final MicroVersion DEFAULT_VERSION = new MicroVersion("", "", "defined in pom.xml");
    private final Preferences pref;
    private final ComboBoxUpdater<MicroVersion> microVersionComboBoxUpdater;
    private MicroVersion selectedMicroVersion;
    private JComboBox microVersionCombobox;
    private JLabel microVersionLabel;

    public MicroPropertiesPanel(ModelHandle2 handle, Project project) {
        this.pref = ProjectUtils.getPreferences((Project)project, MicroApplication.class, (boolean)true);
        this.initComponents();
        String microVersionText = this.pref.get("version", "");
        final Optional<MicroVersion> microVersionOptional = VersionRepository.toMicroVersion(microVersionText);
        this.microVersionComboBoxUpdater = new ComboBoxUpdater<MicroVersion>(this.microVersionCombobox, this.microVersionLabel){

            public MicroVersion getValue() {
                return microVersionOptional.orElse(DEFAULT_VERSION);
            }

            public MicroVersion getDefaultValue() {
                return DEFAULT_VERSION;
            }

            public void setValue(MicroVersion microVersion) {
                MicroPropertiesPanel.this.selectedMicroVersion = microVersion;
            }
        };
    }

    private MicroVersion[] getMicroVersion() {
        ArrayList<MicroVersion> microVersions = new ArrayList<MicroVersion>();
        microVersions.add(DEFAULT_VERSION);
        microVersions.addAll(VersionRepository.getInstance().getMicroVersion());
        return microVersions.toArray(new MicroVersion[0]);
    }

    private void initComponents() {
        this.microVersionLabel = new JLabel();
        this.microVersionCombobox = new JComboBox();
        Mnemonics.setLocalizedText((JLabel)this.microVersionLabel, (String)NbBundle.getMessage(MicroPropertiesPanel.class, (String)"MicroPropertiesPanel.microVersionLabel.text"));
        this.microVersionCombobox.setModel(new DefaultComboBoxModel<MicroVersion>(this.getMicroVersion()));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.microVersionLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.microVersionCombobox, 0, 272, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.microVersionCombobox, -2, -1, -2).addComponent(this.microVersionLabel)).addContainerGap(117, Short.MAX_VALUE)));
    }

    public void applyChanges() {
        this.pref.put("version", this.selectedMicroVersion.getVersion());
    }
}

