/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.docker.api;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import javax.swing.event.ChangeListener;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.modules.docker.DockerEventBus;
import org.netbeans.modules.docker.api.DockerEvent;
import org.netbeans.modules.docker.api.DockerSupport;
import org.openide.filesystems.FileUtil;
import org.openide.util.ChangeSupport;
import org.openide.util.NbPreferences;

public class DockerInstance {
    static final String INSTANCES_KEY = "instances";
    private static final Logger LOGGER = Logger.getLogger(DockerInstance.class.getName());
    private static final String DISPLAY_NAME_KEY = "display_name";
    private static final String URL_KEY = "url";
    private static final String CA_CERTIFICATE_PATH_KEY = "ca_certificate";
    private static final String CERTIFICATE_PATH_KEY = "certificate";
    private static final String KEY_PATH_KEY = "key";
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private final InstanceListener listener = new InstanceListener();
    private final String url;
    private String displayName;
    private File caCertificate;
    private File certificate;
    private File key;
    private Preferences prefs;
    private final DockerEventBus eventBus = new DockerEventBus(this);

    private DockerInstance(String url, String displayName, File caCertificate, File certificate, File key) {
        this.url = url;
        this.displayName = displayName;
        this.caCertificate = caCertificate;
        this.certificate = certificate;
        this.key = key;
    }

    @NonNull
    public static DockerInstance getInstance(@NonNull String url, @NullAllowed String displayName, @NullAllowed File caCertificate, @NullAllowed File certificate, @NullAllowed File key) {
        return new DockerInstance(url, displayName, caCertificate, certificate, key);
    }

    public String getUrl() {
        return this.url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDisplayName() {
        DockerInstance dockerInstance = this;
        synchronized (dockerInstance) {
            return this.displayName;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File getCaCertificateFile() {
        DockerInstance dockerInstance = this;
        synchronized (dockerInstance) {
            return this.caCertificate;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File getCertificateFile() {
        DockerInstance dockerInstance = this;
        synchronized (dockerInstance) {
            return this.certificate;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File getKeyFile() {
        DockerInstance dockerInstance = this;
        synchronized (dockerInstance) {
            return this.key;
        }
    }

    public void addConnectionListener(ConnectionListener listener) {
        this.eventBus.addConnectionListener(listener);
    }

    public void removeConnectionListener(ConnectionListener listener) {
        this.eventBus.removeConnectionListener(listener);
    }

    public void addImageListener(DockerEvent.Listener listener) {
        this.eventBus.addImageListener(listener);
    }

    public void removeImageListener(DockerEvent.Listener listener) {
        this.eventBus.removeImageListener(listener);
    }

    public void addContainerListener(DockerEvent.Listener listener) {
        this.eventBus.addContainerListener(listener);
    }

    public void removeContainerListener(DockerEvent.Listener listener) {
        this.eventBus.removeContainerListener(listener);
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeSupport.addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changeSupport.removeChangeListener(listener);
    }

    public int hashCode() {
        int hash = 5;
        hash = 61 * hash + Objects.hashCode(this.url);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DockerInstance other = (DockerInstance)obj;
        return Objects.equals(this.url, other.url);
    }

    public String toString() {
        return "DockerInstance{url=" + this.url + '}';
    }

    static Collection<? extends DockerInstance> loadAll() {
        Preferences global = NbPreferences.forModule(DockerInstance.class).node(INSTANCES_KEY);
        assert (global != null);
        ArrayList<DockerInstance> instances = new ArrayList<DockerInstance>();
        try {
            String[] names = global.childrenNames();
            if (names.length == 0) {
                LOGGER.log(Level.INFO, "No preferences nodes");
            }
            for (String name : names) {
                Preferences p = global.node(name);
                String displayName = p.get(DISPLAY_NAME_KEY, null);
                String url = p.get(URL_KEY, null);
                if (displayName != null && url != null && (!url.startsWith("file:") || DockerSupport.getDefault().isSocketSupported())) {
                    DockerInstance instance = new DockerInstance(url, null, null, null, null);
                    instance.load(p);
                    instances.add(instance);
                    continue;
                }
                LOGGER.log(Level.INFO, "Invalid Docker instance {0}", name);
            }
            LOGGER.log(Level.FINE, "Loaded {0} Docker instances", instances.size());
        }
        catch (BackingStoreException ex) {
            LOGGER.log(Level.WARNING, null, ex);
        }
        return instances;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void save() {
        DockerInstance dockerInstance = this;
        synchronized (dockerInstance) {
            if (this.prefs != null) {
                throw new IllegalStateException();
            }
            Preferences global = NbPreferences.forModule(DockerInstance.class).node(INSTANCES_KEY);
            Preferences p = null;
            int suffix = 0;
            while ((p = global.node(DockerInstance.escapeUrl(this.url) + suffix)).get(URL_KEY, null) != null && ++suffix < Integer.MAX_VALUE) {
            }
            p.put(DISPLAY_NAME_KEY, this.displayName);
            p.put(URL_KEY, this.url);
            if (this.caCertificate != null) {
                p.put(CA_CERTIFICATE_PATH_KEY, FileUtil.normalizeFile((File)this.caCertificate).getAbsolutePath());
            }
            if (this.certificate != null) {
                p.put(CERTIFICATE_PATH_KEY, FileUtil.normalizeFile((File)this.certificate).getAbsolutePath());
            }
            if (this.key != null) {
                p.put(KEY_PATH_KEY, FileUtil.normalizeFile((File)this.key).getAbsolutePath());
            }
            try {
                p.flush();
            }
            catch (BackingStoreException ex) {
                throw new IllegalStateException(ex);
            }
            this.prefs = p;
            this.prefs.addPreferenceChangeListener(this.listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void delete() {
        DockerInstance dockerInstance = this;
        synchronized (dockerInstance) {
            if (this.prefs == null) {
                throw new IllegalStateException();
            }
            try {
                this.prefs.removePreferenceChangeListener(this.listener);
                this.prefs.removeNode();
            }
            catch (BackingStoreException ex) {
                LOGGER.log(Level.WARNING, null, ex);
            }
            this.prefs = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void load(Preferences p) {
        DockerInstance dockerInstance = this;
        synchronized (dockerInstance) {
            if (this.prefs != null) {
                throw new IllegalStateException();
            }
            this.prefs = p;
            this.prefs.addPreferenceChangeListener(this.listener);
            this.refresh();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refresh() {
        DockerInstance dockerInstance = this;
        synchronized (dockerInstance) {
            if (this.prefs == null) {
                return;
            }
            this.displayName = this.prefs.get(DISPLAY_NAME_KEY, null);
            String caCertPath = this.prefs.get(CA_CERTIFICATE_PATH_KEY, null);
            this.caCertificate = caCertPath == null ? null : new File(caCertPath);
            String certPath = this.prefs.get(CERTIFICATE_PATH_KEY, null);
            this.certificate = certPath == null ? null : new File(certPath);
            String keyPath = this.prefs.get(KEY_PATH_KEY, null);
            this.key = keyPath == null ? null : new File(keyPath);
        }
    }

    final DockerEventBus getEventBus() {
        return this.eventBus;
    }

    private static String escapeUrl(String url) {
        return url.replaceAll("[:/]", "_");
    }

    private class InstanceListener
    implements PreferenceChangeListener {
        private InstanceListener() {
        }

        @Override
        public void preferenceChange(PreferenceChangeEvent evt) {
            DockerInstance.this.refresh();
            DockerInstance.this.changeSupport.fireChange();
        }
    }

    public static interface ConnectionListener
    extends EventListener {
        public void onConnect();

        public void onDisconnect();
    }
}

