/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.common.actions;

import java.awt.event.ActionEvent;
import java.util.Collection;
import org.netbeans.modules.glassfish.common.actions.AbstractOutputAction;
import org.netbeans.modules.glassfish.common.nodes.actions.RefreshModulesCookie;
import org.netbeans.modules.glassfish.spi.GlassfishModule;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;

public class RefreshAction
extends NodeAction {
    protected void performAction(Node[] activatedNodes) {
        for (Node node : activatedNodes) {
            Collection cookies = node.getLookup().lookupAll(RefreshModulesCookie.class);
            for (RefreshModulesCookie cookie : cookies) {
                cookie.refresh();
            }
        }
    }

    private static void performActionImpl(GlassfishModule commonSupport) {
        if (commonSupport instanceof RefreshModulesCookie) {
            ((RefreshModulesCookie)((Object)commonSupport)).refresh();
        }
    }

    protected boolean enable(Node[] activatedNodes) {
        boolean result = false;
        if (activatedNodes != null && activatedNodes.length > 0) {
            Node node;
            GlassfishModule commonSupport;
            Node[] nodeArray = activatedNodes;
            int n = nodeArray.length;
            for (int i = 0; i < n && (result = (commonSupport = (GlassfishModule)(node = nodeArray[i]).getLookup().lookup(GlassfishModule.class)) != null ? RefreshAction.enableImpl(commonSupport) : false); ++i) {
            }
        }
        return result;
    }

    private static boolean enableImpl(GlassfishModule commonSupport) {
        return commonSupport instanceof RefreshModulesCookie;
    }

    protected boolean asynchronous() {
        return false;
    }

    public String getName() {
        return NbBundle.getMessage(RefreshAction.class, (String)"LBL_Refresh");
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    public static class OutputAction
    extends AbstractOutputAction {
        private static final String ICON = "org/netbeans/modules/glassfish/common/resources/refresh.png";

        public OutputAction(GlassfishModule commonSupport) {
            super(commonSupport, NbBundle.getMessage(RefreshAction.class, (String)"LBL_RefreshOutput"), NbBundle.getMessage(RefreshAction.class, (String)"LBL_RefreshOutputDesc"), ICON);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            RefreshAction.performActionImpl(this.commonSupport);
        }

        @Override
        public boolean isEnabled() {
            return RefreshAction.enableImpl(this.commonSupport);
        }
    }
}

