/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cpplite.project;

import java.io.File;
import java.util.List;
import java.util.stream.Collectors;
import org.netbeans.api.extexecution.ExecutionDescriptor;
import org.netbeans.api.extexecution.ExecutionService;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.cpplite.debugger.api.Debugger;
import org.netbeans.modules.cpplite.project.BuildConfiguration;
import org.netbeans.modules.cpplite.project.CPPLiteProject;
import org.netbeans.modules.cpplite.project.runner.Runner;
import org.netbeans.spi.project.ActionProvider;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.Lookup;

public class ActionProviderImpl
implements ActionProvider {
    private static final String[] SUPPORTED_ACTIONS = new String[]{"build", "rebuild", "run", "debug"};
    private final CPPLiteProject prj;

    public ActionProviderImpl(CPPLiteProject prj) {
        this.prj = prj;
    }

    public String[] getSupportedActions() {
        return SUPPORTED_ACTIONS;
    }

    public void invokeAction(String command, Lookup context) throws IllegalArgumentException {
        BuildConfiguration config = this.prj.getActiveBuildConfiguration();
        File module = InstalledFileLocator.getDefault().locate("modules/org-netbeans-modules-cpplite-project.jar", "org.netbeans.modules.cpplite.project", false);
        ExecutionService.newService(() -> {
            if ("debug".equals(command)) {
                List<List<String>> executablesFor = config.executablesFor("run");
                return Debugger.startInDebugger(executablesFor.get(0));
            }
            List<List<String>> executablesFor = config.executablesFor(command);
            String arg = executablesFor.stream().map(c -> this.quote(c.stream().map(p -> this.quote((String)p)).collect(Collectors.joining(" ")))).collect(Collectors.joining(" "));
            return new ProcessBuilder("java", "-classpath", module.getAbsolutePath(), Runner.class.getName(), arg).directory(FileUtil.toFile((FileObject)this.prj.getProjectDirectory())).start();
        }, (ExecutionDescriptor)new ExecutionDescriptor(), (String)(ProjectUtils.getInformation((Project)this.prj).getDisplayName() + " - " + command)).run();
    }

    private String quote(String s) {
        return s.replace("_", "_u_").replace(" ", "_s_");
    }

    public boolean isActionEnabled(String command, Lookup context) throws IllegalArgumentException {
        if ("debug".equals(command)) {
            command = "run";
        }
        return this.prj.getActiveBuildConfiguration().executablesFor(command) != null;
    }
}

