/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.startup.layers;

import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.filesystems.AbstractFileSystem;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.LocalFileSystem;

public final class LocalFileSystemEx
extends LocalFileSystem {
    private static final HashMap<String, FileObject> allLocks = new HashMap(7);
    private static final HashSet<String> pLocks = new HashSet(7);
    private static final Logger LOGGER = Logger.getLogger(LocalFileSystemEx.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] getLocks() {
        LinkedList<String> l = new LinkedList<String>();
        HashSet<String> pLocksCopy = new HashSet<String>();
        HashMap<String, FileObject> hashMap = allLocks;
        synchronized (hashMap) {
            l.addAll(allLocks.keySet());
            pLocksCopy.addAll(pLocks);
        }
        Set<String> invalid = LocalFileSystemEx.getInvalid(pLocksCopy);
        pLocksCopy.removeAll(invalid);
        l.addAll(pLocksCopy);
        HashMap<String, FileObject> hashMap2 = allLocks;
        synchronized (hashMap2) {
            pLocks.removeAll(invalid);
        }
        return l.toArray(new String[l.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hasLocks() {
        boolean allLocksEmpty;
        HashSet<String> pLocksCopy = new HashSet<String>();
        HashMap<String, FileObject> hashMap = allLocks;
        synchronized (hashMap) {
            allLocksEmpty = allLocks.isEmpty();
            pLocksCopy.addAll(pLocks);
        }
        Set<String> invalid = LocalFileSystemEx.getInvalid(pLocksCopy);
        pLocksCopy.removeAll(invalid);
        HashMap<String, FileObject> hashMap2 = allLocks;
        synchronized (hashMap2) {
            pLocks.removeAll(invalid);
        }
        return !allLocksEmpty || !pLocksCopy.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void potentialLock(String name) {
        HashMap<String, FileObject> hashMap = allLocks;
        synchronized (hashMap) {
            pLocks.add(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void potentialLock(String o, String n) {
        HashMap<String, FileObject> hashMap = allLocks;
        synchronized (hashMap) {
            if (pLocks.remove(o)) {
                pLocks.add(n);
            }
        }
    }

    private static Set<String> getInvalid(Set names) {
        LOGGER.finest("133616 - checking invalid");
        HashSet<String> invalid = new HashSet<String>();
        for (String name : names) {
            FileObject fo = FileUtil.getConfigFile((String)name);
            if (null != fo && fo.isLocked()) continue;
            invalid.add(name);
        }
        return invalid;
    }

    public LocalFileSystemEx() {
        this(false);
    }

    LocalFileSystemEx(boolean supportRemoveWritablesAttr) {
        if (supportRemoveWritablesAttr) {
            this.attr = new DelegatingAttributes(this.attr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void lock(String name) throws IOException {
        LOGGER.finest("133616 - in lock");
        super.lock(name);
        HashMap<String, FileObject> hashMap = allLocks;
        synchronized (hashMap) {
            FileObject fo = this.findResource(name);
            allLocks.put(name, fo);
            pLocks.remove(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unlock(String name) {
        HashMap<String, FileObject> hashMap = allLocks;
        synchronized (hashMap) {
            if (allLocks.containsKey(name)) {
                allLocks.remove(name);
            } else {
                FileObject fo = this.findResource(name);
                if (fo != null) {
                    for (Map.Entry<String, FileObject> entry : allLocks.entrySet()) {
                        if (!fo.equals(entry.getValue())) continue;
                        allLocks.remove(entry.getKey());
                        break;
                    }
                } else {
                    Logger.getLogger(LocalFileSystemEx.class.getName()).log(Level.WARNING, null, new Throwable("Can't unlock file " + name + ", it's lock was not found or it wasn't locked."));
                }
            }
        }
        super.unlock(name);
    }

    private class WritableRemover
    implements Callable<Void> {
        private String name;

        public WritableRemover(String name) {
            this.name = name;
        }

        @Override
        public Void call() throws IOException {
            FileObject fo = LocalFileSystemEx.this.findResource(this.name);
            if (null != fo) {
                fo.delete();
            }
            return null;
        }
    }

    private class DelegatingAttributes
    implements AbstractFileSystem.Attr {
        private AbstractFileSystem.Attr a;

        public DelegatingAttributes(AbstractFileSystem.Attr a) {
            this.a = a;
        }

        public Object readAttribute(String name, String attrName) {
            if ("removeWritables".equals(attrName)) {
                return new WritableRemover(name);
            }
            return this.a.readAttribute(name, attrName);
        }

        public void writeAttribute(String name, String attrName, Object value) throws IOException {
            this.a.writeAttribute(name, attrName, value);
        }

        public Enumeration<String> attributes(String name) {
            return this.a.attributes(name);
        }

        public void renameAttributes(String oldName, String newName) {
            this.a.renameAttributes(oldName, newName);
        }

        public void deleteAttributes(String name) {
            this.a.deleteAttributes(name);
        }
    }
}

