/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.InteropException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.js.builtins.JSBuiltinsContainer;
import com.oracle.truffle.js.builtins.ObjectFunctionBuiltinsFactory;
import com.oracle.truffle.js.builtins.ObjectPrototypeBuiltins;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.access.CreateObjectNode;
import com.oracle.truffle.js.nodes.access.EnumerableOwnPropertyNamesNode;
import com.oracle.truffle.js.nodes.access.GetIteratorNode;
import com.oracle.truffle.js.nodes.access.GetPrototypeNode;
import com.oracle.truffle.js.nodes.access.IsExtensibleNode;
import com.oracle.truffle.js.nodes.access.IsJSObjectNode;
import com.oracle.truffle.js.nodes.access.IteratorCloseNode;
import com.oracle.truffle.js.nodes.access.IteratorStepNode;
import com.oracle.truffle.js.nodes.access.IteratorValueNode;
import com.oracle.truffle.js.nodes.access.JSGetOwnPropertyNode;
import com.oracle.truffle.js.nodes.access.ReadElementNode;
import com.oracle.truffle.js.nodes.access.RequireObjectCoercibleNode;
import com.oracle.truffle.js.nodes.access.ToPropertyDescriptorNode;
import com.oracle.truffle.js.nodes.access.WriteElementNode;
import com.oracle.truffle.js.nodes.binary.JSIdenticalNode;
import com.oracle.truffle.js.nodes.cast.JSToPropertyKeyNode;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.nodes.interop.ForeignObjectPrototypeNode;
import com.oracle.truffle.js.nodes.interop.JSForeignToJSTypeNode;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.Boundaries;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.LargeInteger;
import com.oracle.truffle.js.runtime.Symbol;
import com.oracle.truffle.js.runtime.array.ScriptArray;
import com.oracle.truffle.js.runtime.builtins.BuiltinEnum;
import com.oracle.truffle.js.runtime.builtins.JSArray;
import com.oracle.truffle.js.runtime.builtins.JSClass;
import com.oracle.truffle.js.runtime.builtins.JSUserObject;
import com.oracle.truffle.js.runtime.objects.IteratorRecord;
import com.oracle.truffle.js.runtime.objects.JSAttributes;
import com.oracle.truffle.js.runtime.objects.JSLazyString;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.Null;
import com.oracle.truffle.js.runtime.objects.PropertyDescriptor;
import com.oracle.truffle.js.runtime.objects.Undefined;
import com.oracle.truffle.js.runtime.util.JSClassProfile;
import com.oracle.truffle.js.runtime.util.Pair;
import com.oracle.truffle.js.runtime.util.SimpleArrayList;
import com.oracle.truffle.js.runtime.util.UnmodifiableArrayList;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Iterator;

public final class ObjectFunctionBuiltins
extends JSBuiltinsContainer.SwitchEnum<ObjectFunction> {
    protected ObjectFunctionBuiltins() {
        super("Object", ObjectFunction.class);
    }

    @Override
    protected Object createNode(JSContext context, JSBuiltin builtin, boolean construct, boolean newTarget, ObjectFunction builtinEnum) {
        switch (builtinEnum) {
            case create: {
                return ObjectFunctionBuiltinsFactory.ObjectCreateNodeGen.create(context, builtin, ObjectFunctionBuiltins.args().fixedArgs(2).createArgumentNodes(context));
            }
            case defineProperties: {
                return ObjectFunctionBuiltinsFactory.ObjectDefinePropertiesNodeGen.create(context, builtin, ObjectFunctionBuiltins.args().fixedArgs(2).createArgumentNodes(context));
            }
            case defineProperty: {
                return ObjectFunctionBuiltinsFactory.ObjectDefinePropertyNodeGen.create(context, builtin, ObjectFunctionBuiltins.args().fixedArgs(3).createArgumentNodes(context));
            }
            case freeze: {
                return ObjectFunctionBuiltinsFactory.ObjectSetIntegrityLevelNodeGen.create(context, builtin, true, ObjectFunctionBuiltins.args().fixedArgs(1).createArgumentNodes(context));
            }
            case getOwnPropertyDescriptor: {
                return ObjectFunctionBuiltinsFactory.ObjectGetOwnPropertyDescriptorNodeGen.create(context, builtin, ObjectFunctionBuiltins.args().fixedArgs(2).createArgumentNodes(context));
            }
            case getOwnPropertyDescriptors: {
                return ObjectFunctionBuiltinsFactory.ObjectGetOwnPropertyDescriptorsNodeGen.create(context, builtin, ObjectFunctionBuiltins.args().fixedArgs(1).createArgumentNodes(context));
            }
            case getOwnPropertyNames: {
                return ObjectFunctionBuiltinsFactory.ObjectGetOwnPropertyNamesOrSymbolsNodeGen.create(context, builtin, false, ObjectFunctionBuiltins.args().fixedArgs(1).createArgumentNodes(context));
            }
            case getPrototypeOf: {
                return ObjectFunctionBuiltinsFactory.ObjectGetPrototypeOfNodeGen.create(context, builtin, ObjectFunctionBuiltins.args().fixedArgs(1).createArgumentNodes(context));
            }
            case isExtensible: {
                return ObjectFunctionBuiltinsFactory.ObjectIsExtensibleNodeGen.create(context, builtin, ObjectFunctionBuiltins.args().fixedArgs(1).createArgumentNodes(context));
            }
            case isFrozen: {
                return ObjectFunctionBuiltinsFactory.ObjectTestIntegrityLevelNodeGen.create(context, builtin, true, ObjectFunctionBuiltins.args().fixedArgs(1).createArgumentNodes(context));
            }
            case isSealed: {
                return ObjectFunctionBuiltinsFactory.ObjectTestIntegrityLevelNodeGen.create(context, builtin, false, ObjectFunctionBuiltins.args().fixedArgs(1).createArgumentNodes(context));
            }
            case keys: {
                return ObjectFunctionBuiltinsFactory.ObjectKeysNodeGen.create(context, builtin, ObjectFunctionBuiltins.args().fixedArgs(1).createArgumentNodes(context));
            }
            case preventExtensions: {
                return ObjectFunctionBuiltinsFactory.ObjectPreventExtensionsNodeGen.create(context, builtin, ObjectFunctionBuiltins.args().fixedArgs(1).createArgumentNodes(context));
            }
            case seal: {
                return ObjectFunctionBuiltinsFactory.ObjectSetIntegrityLevelNodeGen.create(context, builtin, false, ObjectFunctionBuiltins.args().fixedArgs(1).createArgumentNodes(context));
            }
            case setPrototypeOf: {
                return ObjectFunctionBuiltinsFactory.ObjectSetPrototypeOfNodeGen.create(context, builtin, ObjectFunctionBuiltins.args().fixedArgs(2).createArgumentNodes(context));
            }
            case is: {
                return ObjectFunctionBuiltinsFactory.ObjectIsNodeGen.create(context, builtin, ObjectFunctionBuiltins.args().fixedArgs(2).createArgumentNodes(context));
            }
            case getOwnPropertySymbols: {
                return ObjectFunctionBuiltinsFactory.ObjectGetOwnPropertyNamesOrSymbolsNodeGen.create(context, builtin, true, ObjectFunctionBuiltins.args().fixedArgs(1).createArgumentNodes(context));
            }
            case assign: {
                return ObjectFunctionBuiltinsFactory.ObjectAssignNodeGen.create(context, builtin, ObjectFunctionBuiltins.args().fixedArgs(1).varArgs().createArgumentNodes(context));
            }
            case values: {
                return ObjectFunctionBuiltinsFactory.ObjectValuesOrEntriesNodeGen.create(context, builtin, false, ObjectFunctionBuiltins.args().fixedArgs(1).createArgumentNodes(context));
            }
            case entries: {
                return ObjectFunctionBuiltinsFactory.ObjectValuesOrEntriesNodeGen.create(context, builtin, true, ObjectFunctionBuiltins.args().fixedArgs(1).createArgumentNodes(context));
            }
            case fromEntries: {
                return ObjectFunctionBuiltinsFactory.ObjectFromEntriesNodeGen.create(context, builtin, ObjectFunctionBuiltins.args().fixedArgs(1).createArgumentNodes(context));
            }
        }
        return null;
    }

    public static abstract class ObjectFromEntriesNode
    extends ObjectPrototypeBuiltins.ObjectOperation {
        @Node.Child
        private RequireObjectCoercibleNode requireObjectCoercibleNode = RequireObjectCoercibleNode.create();
        @Node.Child
        private GetIteratorNode getIteratorNode;
        @Node.Child
        private IteratorStepNode iteratorStepNode;
        @Node.Child
        private IteratorValueNode iteratorValueNode;
        @Node.Child
        private IsJSObjectNode isObjectNode = IsJSObjectNode.create();
        @Node.Child
        private IteratorCloseNode iteratorCloseNode;
        @Node.Child
        private JSToPropertyKeyNode toPropertyKeyNode = JSToPropertyKeyNode.create();
        @Node.Child
        private ReadElementNode readElementNode;
        private final BranchProfile errorBranch = BranchProfile.create();

        public ObjectFromEntriesNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
            this.getIteratorNode = GetIteratorNode.create(context);
            this.iteratorStepNode = IteratorStepNode.create(context);
            this.iteratorValueNode = IteratorValueNode.create(context);
            this.readElementNode = ReadElementNode.create(context);
        }

        @Specialization
        protected DynamicObject entries(Object iterable) {
            this.requireObjectCoercibleNode.executeVoid(iterable);
            DynamicObject obj = JSUserObject.create(this.getContext());
            return this.addEntriesFromIterable(obj, iterable);
        }

        private DynamicObject addEntriesFromIterable(DynamicObject target, Object iterable) {
            assert (!JSRuntime.isNullOrUndefined(target));
            IteratorRecord iteratorRecord = this.getIteratorNode.execute(iterable);
            try {
                while (true) {
                    Object next;
                    if ((next = this.iteratorStepNode.execute(iteratorRecord)) == Boolean.FALSE) {
                        return target;
                    }
                    Object nextItem = this.iteratorValueNode.execute((DynamicObject)next);
                    if (!this.isObjectNode.executeBoolean(nextItem)) {
                        this.errorBranch.enter();
                        throw Errors.createTypeErrorIteratorResultNotObject(nextItem, this);
                    }
                    Object k = this.readElementNode.executeWithTargetAndIndex(nextItem, 0);
                    Object v = this.readElementNode.executeWithTargetAndIndex(nextItem, 1);
                    this.createDataPropertyOnObject(target, k, v);
                }
            }
            catch (Exception ex) {
                this.errorBranch.enter();
                this.iteratorCloseAbrupt(iteratorRecord.getIterator());
                throw ex;
            }
        }

        private void createDataPropertyOnObject(DynamicObject thisObject, Object key, Object value) {
            assert (JSRuntime.isObject(thisObject));
            Object propertyKey = this.toPropertyKeyNode.execute(key);
            JSRuntime.createDataPropertyOrThrow(thisObject, propertyKey, value);
        }

        private void iteratorCloseAbrupt(DynamicObject iterator) {
            if (this.iteratorCloseNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.iteratorCloseNode = (IteratorCloseNode)this.insert(IteratorCloseNode.create(this.getContext()));
            }
            this.iteratorCloseNode.executeAbrupt(iterator);
        }
    }

    public static abstract class ObjectValuesOrEntriesNode
    extends ObjectPrototypeBuiltins.ObjectOperation {
        protected final boolean entries;
        @Node.Child
        private EnumerableOwnPropertyNamesNode enumerableOwnPropertyNamesNode;
        @Node.Child
        private InteropLibrary asString;

        public ObjectValuesOrEntriesNode(JSContext context, JSBuiltin builtin, boolean entries) {
            super(context, builtin);
            this.entries = entries;
        }

        protected abstract DynamicObject executeEvaluated(Object var1);

        @Specialization(guards={"isJSObject(obj)"})
        protected DynamicObject valuesOrEntriesJSObject(DynamicObject obj, @Cached(value="createBinaryProfile()") ConditionProfile lengthZero) {
            UnmodifiableArrayList<? extends Object> list = this.enumerableOwnPropertyNames(obj);
            int len = list.size();
            if (lengthZero.profile(len == 0)) {
                return JSArray.createEmptyChecked(this.getContext(), 0L);
            }
            return JSArray.createConstant(this.getContext(), list.toArray());
        }

        protected UnmodifiableArrayList<? extends Object> enumerableOwnPropertyNames(DynamicObject obj) {
            if (this.enumerableOwnPropertyNamesNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.enumerableOwnPropertyNamesNode = (EnumerableOwnPropertyNamesNode)this.insert(this.entries ? EnumerableOwnPropertyNamesNode.createKeysValues(this.getContext()) : EnumerableOwnPropertyNamesNode.createValues(this.getContext()));
            }
            return this.enumerableOwnPropertyNamesNode.execute(obj);
        }

        @Specialization(guards={"isForeignObject(thisObj)"}, limit="3")
        protected DynamicObject enumerableOwnPropertyNamesForeign(Object thisObj, @CachedLibrary(value="thisObj") InteropLibrary interop, @CachedLibrary(limit="3") InteropLibrary members, @Cached JSForeignToJSTypeNode importValue, @Cached BranchProfile growProfile) {
            try {
                Object keysObj = interop.getMembers(thisObj);
                long size = members.getArraySize(keysObj);
                if (size < 0L || size >= Integer.MAX_VALUE) {
                    throw Errors.createRangeErrorInvalidArrayLength();
                }
                SimpleArrayList<Object> values = SimpleArrayList.create(size);
                int i = 0;
                while ((long)i < size) {
                    Object key = members.readArrayElement(keysObj, (long)i);
                    String stringKey = this.asStringKey(key);
                    Object value = importValue.executeWithTarget(interop.readMember(thisObj, stringKey));
                    if (this.entries) {
                        value = JSArray.createConstant(this.getContext(), new Object[]{key, value});
                    }
                    values.add(value, growProfile);
                    ++i;
                }
                return JSArray.createConstant(this.getContext(), values.toArray());
            }
            catch (InvalidArrayIndexException | UnknownIdentifierException | UnsupportedMessageException e) {
                return JSArray.createEmptyZeroLength(this.getContext());
            }
        }

        @Specialization(guards={"!isJSObject(obj)", "!isForeignObject(obj)"})
        protected DynamicObject valuesOrEntriesGeneric(Object obj, @Cached(value="createRecursive()") ObjectValuesOrEntriesNode recursive) {
            TruffleObject thisObj = this.toTruffleObject(obj);
            return recursive.executeEvaluated(thisObj);
        }

        private String asStringKey(Object key) throws UnsupportedMessageException {
            assert (((InteropLibrary)InteropLibrary.getFactory().getUncached()).isString(key));
            if (key instanceof String) {
                return (String)key;
            }
            if (this.asString == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.asString = (InteropLibrary)this.insert((Node)InteropLibrary.getFactory().createDispatched(3));
            }
            return this.asString.asString(key);
        }

        ObjectValuesOrEntriesNode createRecursive() {
            return ObjectFunctionBuiltinsFactory.ObjectValuesOrEntriesNodeGen.create(this.getContext(), this.getBuiltin(), this.entries, new JavaScriptNode[0]);
        }
    }

    public static abstract class ObjectAssignNode
    extends ObjectPrototypeBuiltins.ObjectOperation {
        protected static final boolean STRICT = true;

        public ObjectAssignNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected Object assign(Object target, Object[] sources, @Cached(value="create(getContext())") ReadElementNode read, @Cached(value="create(getContext(), STRICT)") WriteElementNode write, @Cached JSGetOwnPropertyNode getOwnProperty, @Cached BranchProfile listProfile, @Cached BranchProfile elementProfile, @Cached JSClassProfile classProfile, @Cached BranchProfile notAJSObjectBranch) {
            TruffleObject to = this.toTruffleObject(target);
            if (sources.length == 0) {
                return to;
            }
            for (Object o : sources) {
                if (o == Undefined.instance || o == Null.instance) continue;
                listProfile.enter();
                DynamicObject from = JSRuntime.expectJSObject((TruffleObject)this.toObject(o), notAJSObjectBranch);
                Iterator<Object> iterator = Boundaries.iterator(JSObject.ownPropertyKeys(from, classProfile));
                while (Boundaries.iteratorHasNext(iterator)) {
                    Object nextKey = Boundaries.iteratorNext(iterator);
                    assert (JSRuntime.isPropertyKey(nextKey));
                    PropertyDescriptor desc = getOwnProperty.execute(from, nextKey);
                    if (desc == null || !desc.getEnumerable()) continue;
                    elementProfile.enter();
                    Object propValue = read.executeWithTargetAndIndex((Object)from, nextKey);
                    write.executeWithTargetAndIndexAndValue((Object)to, nextKey, propValue);
                }
            }
            return to;
        }
    }

    public static abstract class ObjectIsNode
    extends ObjectPrototypeBuiltins.ObjectOperation {
        public ObjectIsNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected boolean isInt(int a, int b) {
            return a == b;
        }

        @Specialization
        protected boolean isDouble(double a, double b) {
            if (a == 0.0 && b == 0.0) {
                return JSRuntime.isNegativeZero(a) == JSRuntime.isNegativeZero(b);
            }
            if (Double.isNaN(a)) {
                return Double.isNaN(b);
            }
            return a == b;
        }

        @Specialization(guards={"isNumberNumber(a,b)"})
        protected boolean isNumberNumber(Number a, Number b, @Cached(value="createSameValue()") JSIdenticalNode doIdenticalNode) {
            return doIdenticalNode.executeBoolean(JSRuntime.doubleValue(a), JSRuntime.doubleValue(b));
        }

        @Specialization(guards={"!isNumberNumber(a, b)"})
        protected boolean isObject(Object a, Object b, @Cached(value="createSameValue()") JSIdenticalNode doIdenticalNode) {
            return doIdenticalNode.executeBoolean(a, b);
        }

        protected boolean isNumberNumber(Object a, Object b) {
            return a instanceof Number && b instanceof Number;
        }
    }

    public static abstract class ObjectSetPrototypeOfNode
    extends ObjectPrototypeBuiltins.ObjectOperation {
        @Node.Child
        private RequireObjectCoercibleNode objectCoercibleNode;
        private final ConditionProfile isObjectProfile = ConditionProfile.createBinaryProfile();
        private final BranchProfile errorBranch = BranchProfile.create();
        private final JSClassProfile classProfile = JSClassProfile.create();

        public ObjectSetPrototypeOfNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization(guards={"isJSObject(newProto)"})
        protected Object setPrototypeOf(Object thisObj, DynamicObject newProto) {
            return this.setPrototypeOfImpl(thisObj, newProto);
        }

        @Specialization(guards={"isJSNull(newProto)"})
        protected Object setPrototypeOfNull(Object thisObj, DynamicObject newProto) {
            return this.setPrototypeOfImpl(thisObj, Null.instance);
        }

        private Object setPrototypeOfImpl(Object thisObj, DynamicObject newProto) {
            this.requireObjectCoercible(thisObj);
            if (this.isObjectProfile.profile(JSObject.isDynamicObject(thisObj))) {
                DynamicObject object = this.asObject(thisObj);
                if (!JSObject.setPrototype(object, newProto, this.classProfile)) {
                    this.errorBranch.enter();
                    throw Errors.createTypeError("setPrototype failed");
                }
                return object;
            }
            return thisObj;
        }

        @Specialization(guards={"!isJSObject(newProto)", "!isJSNull(newProto)"})
        protected Object setPrototypeOfInvalidNewProto(Object thisObj, Object newProto) {
            assert (newProto != null);
            this.asObject(thisObj);
            throw Errors.createTypeErrorInvalidPrototype(newProto);
        }

        protected final void requireObjectCoercible(Object target) {
            if (this.objectCoercibleNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.objectCoercibleNode = (RequireObjectCoercibleNode)this.insert(RequireObjectCoercibleNode.create());
            }
            this.objectCoercibleNode.executeVoid(target);
        }
    }

    public static abstract class ObjectKeysNode
    extends ObjectPrototypeBuiltins.ObjectOperation {
        @Node.Child
        private EnumerableOwnPropertyNamesNode enumerableOwnPropertyNamesNode;
        @Node.Child
        private InteropLibrary asString;
        private final ConditionProfile hasElements = ConditionProfile.createBinaryProfile();

        public ObjectKeysNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization(guards={"isJSType(thisObj)"})
        protected DynamicObject keysDynamicObject(DynamicObject thisObj) {
            UnmodifiableArrayList<? extends Object> keyList = this.enumerableOwnPropertyNames(this.toOrAsObject(thisObj));
            int len = keyList.size();
            if (this.hasElements.profile(len > 0)) {
                assert (keyList.stream().allMatch(String.class::isInstance));
                return JSArray.createConstant(this.getContext(), keyList.toArray());
            }
            return JSArray.createEmptyChecked(this.getContext(), 0L);
        }

        @Specialization
        protected DynamicObject keys(Symbol symbol) {
            return this.keysDynamicObject(this.toOrAsObject(symbol));
        }

        @Specialization
        protected DynamicObject keys(JSLazyString string) {
            return this.keysDynamicObject(this.toOrAsObject(string));
        }

        @Specialization
        protected DynamicObject keys(LargeInteger largeInteger) {
            return this.keysDynamicObject(this.toOrAsObject(largeInteger));
        }

        @Specialization
        protected DynamicObject keys(BigInt bigInt) {
            return this.keysDynamicObject(this.toOrAsObject(bigInt));
        }

        @Specialization(guards={"!isTruffleObject(thisObj)"})
        protected DynamicObject keys(Object thisObj) {
            return this.keysDynamicObject(this.toOrAsObject(thisObj));
        }

        @Specialization(guards={"isForeignObject(obj)"}, limit="3")
        protected DynamicObject keys(Object obj, @CachedLibrary(value="obj") InteropLibrary interop, @CachedLibrary(limit="3") InteropLibrary members, @Cached BranchProfile growProfile) {
            if (interop.hasMembers(obj)) {
                try {
                    Object keysObj = interop.getMembers(obj);
                    long size = members.getArraySize(keysObj);
                    if (size < 0L || size >= Integer.MAX_VALUE) {
                        throw Errors.createRangeErrorInvalidArrayLength();
                    }
                    if (size > 0L) {
                        SimpleArrayList<String> keys = SimpleArrayList.create(size);
                        int i = 0;
                        while ((long)i < size) {
                            Object key = members.readArrayElement(keysObj, (long)i);
                            assert (((InteropLibrary)InteropLibrary.getFactory().getUncached()).isString(key));
                            keys.add(this.asStringKey(key), growProfile);
                            ++i;
                        }
                        return JSArray.createConstant(this.getContext(), keys.toArray());
                    }
                }
                catch (InvalidArrayIndexException | UnsupportedMessageException throwable) {
                    // empty catch block
                }
            }
            return JSArray.createEmptyZeroLength(this.getContext());
        }

        private UnmodifiableArrayList<? extends Object> enumerableOwnPropertyNames(DynamicObject obj) {
            if (this.enumerableOwnPropertyNamesNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.enumerableOwnPropertyNamesNode = (EnumerableOwnPropertyNamesNode)this.insert(EnumerableOwnPropertyNamesNode.createKeys(this.getContext()));
            }
            return this.enumerableOwnPropertyNamesNode.execute(obj);
        }

        private String asStringKey(Object key) throws UnsupportedMessageException {
            assert (((InteropLibrary)InteropLibrary.getFactory().getUncached()).isString(key));
            if (key instanceof String) {
                return (String)key;
            }
            if (this.asString == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.asString = (InteropLibrary)this.insert((Node)InteropLibrary.getFactory().createDispatched(3));
            }
            return this.asString.asString(key);
        }
    }

    public static abstract class ObjectSetIntegrityLevelNode
    extends ObjectPrototypeBuiltins.ObjectOperation {
        private final boolean freeze;
        private final ConditionProfile isObject = ConditionProfile.createBinaryProfile();

        public ObjectSetIntegrityLevelNode(JSContext context, JSBuiltin builtin, boolean freeze) {
            super(context, builtin);
            this.freeze = freeze;
        }

        @Specialization
        protected Object setIntegrityLevel(Object thisObj) {
            if (this.isObject.profile(JSRuntime.isObject(thisObj))) {
                JSObject.setIntegrityLevel((DynamicObject)thisObj, this.freeze);
            } else if (this.getContext().getEcmaScriptVersion() < 6) {
                throw this.createTypeErrorCalledOnNonObject(thisObj);
            }
            return thisObj;
        }
    }

    public static abstract class ObjectTestIntegrityLevelNode
    extends ObjectPrototypeBuiltins.ObjectOperation {
        private final boolean frozen;
        private final ConditionProfile isObject = ConditionProfile.createBinaryProfile();

        public ObjectTestIntegrityLevelNode(JSContext context, JSBuiltin builtin, boolean frozen) {
            super(context, builtin);
            this.frozen = frozen;
        }

        @Specialization
        protected boolean testIntegrityLevel(Object thisObj) {
            if (this.isObject.profile(JSRuntime.isObject(thisObj))) {
                return JSObject.testIntegrityLevel((DynamicObject)thisObj, this.frozen);
            }
            if (this.getContext().getEcmaScriptVersion() < 6) {
                throw this.createTypeErrorCalledOnNonObject(thisObj);
            }
            return true;
        }
    }

    public static abstract class ObjectPreventExtensionsNode
    extends ObjectPrototypeBuiltins.ObjectOperation {
        public ObjectPreventExtensionsNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization(guards={"isJSObject(thisObj)"})
        protected DynamicObject preventExtensions(DynamicObject thisObj) {
            JSObject.preventExtensions(thisObj);
            return thisObj;
        }

        @Specialization(guards={"!isJSObject(thisObj)"})
        protected Object preventExtensions(Object thisObj) {
            if (this.getContext().getEcmaScriptVersion() < 6) {
                throw this.createTypeErrorCalledOnNonObject(thisObj);
            }
            return thisObj;
        }
    }

    public static abstract class ObjectIsExtensibleNode
    extends ObjectPrototypeBuiltins.ObjectOperation {
        public ObjectIsExtensibleNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization(guards={"isJSObject(thisObj)"})
        protected boolean isExtensible(DynamicObject thisObj, @Cached(value="create()") IsExtensibleNode isExtensibleNode) {
            return isExtensibleNode.executeBoolean(thisObj);
        }

        @Specialization(guards={"!isJSObject(thisObj)"})
        protected boolean isExtensible(Object thisObj) {
            if (this.getContext().getEcmaScriptVersion() < 6) {
                throw this.createTypeErrorCalledOnNonObject(thisObj);
            }
            return false;
        }
    }

    public static abstract class ObjectDefinePropertiesNode
    extends ObjectDefineOperation {
        public ObjectDefinePropertiesNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected DynamicObject defineProperties(Object thisObj, Object properties) {
            DynamicObject object = this.asObject(thisObj);
            return this.intlDefineProperties(object, this.toObject(properties));
        }
    }

    public static abstract class ObjectDefinePropertyNode
    extends ObjectDefineOperation {
        @Node.Child
        private JSToPropertyKeyNode toPropertyKeyNode = JSToPropertyKeyNode.create();

        public ObjectDefinePropertyNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected DynamicObject defineProperty(Object thisObj, Object property, Object attributes) {
            DynamicObject object = this.asObject(thisObj);
            PropertyDescriptor desc = this.toPropertyDescriptor(attributes);
            Object propertyKey = this.toPropertyKeyNode.execute(property);
            JSRuntime.definePropertyOrThrow(object, propertyKey, desc);
            return object;
        }

        @Override
        protected JavaScriptNode copyUninitialized() {
            return ObjectFunctionBuiltinsFactory.ObjectDefinePropertyNodeGen.create(this.getContext(), this.getBuiltin(), ObjectDefinePropertyNode.cloneUninitialized(this.getArguments()));
        }
    }

    public static abstract class ObjectCreateNode
    extends ObjectDefineOperation {
        @Node.Child
        private CreateObjectNode.CreateObjectWithPrototypeNode objectCreateNode;
        private final BranchProfile needDefineProperties = BranchProfile.create();

        public ObjectCreateNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization(guards={"isJSNull(prototype)"})
        protected DynamicObject createPrototypeNull(Object prototype, Object properties) {
            DynamicObject ret = JSObject.create(this.getContext(), this.getContext().getEmptyShapeNullPrototype());
            return this.objectDefineProperties(ret, properties);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"!isJSNull(prototype)", "!isJSObject(prototype)"})
        protected DynamicObject createInvalidPrototype(Object prototype, Object properties) {
            assert (prototype != null);
            throw Errors.createTypeErrorInvalidPrototype(prototype);
        }

        @Specialization(guards={"isJSObject(prototype)", "isJSObject(properties)"})
        protected DynamicObject create(VirtualFrame frame, DynamicObject prototype, DynamicObject properties) {
            DynamicObject ret = this.createObjectWithPrototype(frame, prototype);
            this.intlDefineProperties(ret, properties);
            return ret;
        }

        @Specialization(guards={"isJSObject(prototype)", "!isJSNull(properties)"})
        protected DynamicObject create(VirtualFrame frame, DynamicObject prototype, Object properties) {
            DynamicObject ret = this.createObjectWithPrototype(frame, prototype);
            return this.objectDefineProperties(ret, properties);
        }

        @Specialization(guards={"isJSObject(prototype)", "isJSNull(properties)"})
        protected DynamicObject createNull(DynamicObject prototype, Object properties) {
            throw Errors.createTypeErrorNotObjectCoercible(properties);
        }

        private DynamicObject objectDefineProperties(DynamicObject ret, Object properties) {
            if (properties != Undefined.instance) {
                this.needDefineProperties.enter();
                this.intlDefineProperties(ret, this.toObject(properties));
            }
            return ret;
        }

        private DynamicObject createObjectWithPrototype(VirtualFrame frame, DynamicObject prototype) {
            if (this.objectCreateNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.objectCreateNode = (CreateObjectNode.CreateObjectWithPrototypeNode)this.insert(CreateObjectNode.createWithPrototype(this.getContext(), null));
            }
            return this.objectCreateNode.executeDynamicObject(frame, prototype);
        }
    }

    protected static abstract class ObjectDefineOperation
    extends ObjectPrototypeBuiltins.ObjectOperation {
        @Node.Child
        private ToPropertyDescriptorNode toPropertyDescriptorNode;

        public ObjectDefineOperation(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        protected PropertyDescriptor toPropertyDescriptor(Object target) {
            if (this.toPropertyDescriptorNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.toPropertyDescriptorNode = (ToPropertyDescriptorNode)this.insert(ToPropertyDescriptorNode.create(this.getContext()));
            }
            return (PropertyDescriptor)this.toPropertyDescriptorNode.execute(target);
        }

        @CompilerDirectives.TruffleBoundary
        protected DynamicObject intlDefineProperties(DynamicObject obj, DynamicObject descs) {
            ArrayList descriptors = new ArrayList();
            JSClass descsClass = JSObject.getJSClass(descs);
            for (Object key : descsClass.ownPropertyKeys(descs)) {
                PropertyDescriptor keyDesc = descsClass.getOwnProperty(descs, key);
                if (!keyDesc.getEnumerable()) continue;
                PropertyDescriptor desc = this.toPropertyDescriptor(descsClass.get(descs, key));
                Boundaries.listAdd(descriptors, new Pair<Object, PropertyDescriptor>(key, desc));
            }
            for (Pair descPair : descriptors) {
                JSRuntime.definePropertyOrThrow(obj, descPair.getFirst(), (PropertyDescriptor)descPair.getSecond());
            }
            return obj;
        }
    }

    public static abstract class ObjectGetOwnPropertyNamesOrSymbolsNode
    extends ObjectPrototypeBuiltins.ObjectOperation {
        protected final boolean symbols;

        public ObjectGetOwnPropertyNamesOrSymbolsNode(JSContext context, JSBuiltin builtin, boolean symbols) {
            super(context, builtin);
            this.symbols = symbols;
        }

        @Specialization(guards={"isJSObject(thisObj)"})
        protected DynamicObject getJSObject(DynamicObject thisObj, @Cached @Cached.Shared(value="jsclassProfile") JSClassProfile jsclassProfile) {
            return JSArray.createLazyArray(this.getContext(), jsclassProfile.getJSClass(thisObj).getOwnPropertyKeys(thisObj, !this.symbols, this.symbols));
        }

        @Specialization(guards={"!isJSObject(thisObj)", "!isForeignObject(thisObj)"})
        protected DynamicObject getDefault(Object thisObj, @Cached @Cached.Shared(value="jsclassProfile") JSClassProfile jsclassProfile) {
            DynamicObject object = this.toOrAsObject(thisObj);
            return this.getJSObject(object, jsclassProfile);
        }

        @Specialization(guards={"isForeignObject(thisObj)", "symbols"})
        protected DynamicObject getForeignObjectSymbols(TruffleObject thisObj) {
            return JSArray.createConstantEmptyArray(this.getContext());
        }

        @Specialization(guards={"isForeignObject(thisObj)", "!symbols"}, limit="3")
        protected DynamicObject getForeignObjectNames(TruffleObject thisObj, @CachedLibrary(value="thisObj") InteropLibrary interop, @CachedLibrary(limit="3") InteropLibrary members) {
            Object[] array;
            if (interop.hasMembers((Object)thisObj)) {
                try {
                    Object keysObj = interop.getMembers((Object)thisObj);
                    long size = members.getArraySize(keysObj);
                    if (size < 0L || size >= Integer.MAX_VALUE) {
                        throw Errors.createRangeErrorInvalidArrayLength();
                    }
                    array = new Object[(int)size];
                    int i = 0;
                    while ((long)i < size) {
                        Object key = members.readArrayElement(keysObj, (long)i);
                        assert (((InteropLibrary)InteropLibrary.getFactory().getUncached()).isString(key));
                        array[i] = key;
                        ++i;
                    }
                }
                catch (InvalidArrayIndexException | UnsupportedMessageException e) {
                    array = ScriptArray.EMPTY_OBJECT_ARRAY;
                }
            } else {
                array = ScriptArray.EMPTY_OBJECT_ARRAY;
            }
            return JSArray.createConstant(this.getContext(), array);
        }
    }

    public static abstract class ObjectGetOwnPropertyDescriptorsNode
    extends ObjectPrototypeBuiltins.ObjectOperation {
        private final JSClassProfile classProfile = JSClassProfile.create();
        @Node.Child
        private JSGetOwnPropertyNode getOwnPropertyNode = JSGetOwnPropertyNode.create();

        public ObjectGetOwnPropertyDescriptorsNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization(guards={"isJSObject(thisObj)"})
        protected DynamicObject getJSObject(DynamicObject thisObj) {
            DynamicObject retObj = JSUserObject.create(this.getContext());
            Iterator<Object> iterator = Boundaries.iterator(JSObject.ownPropertyKeys(thisObj, this.classProfile));
            while (Boundaries.iteratorHasNext(iterator)) {
                Object key = Boundaries.iteratorNext(iterator);
                assert (JSRuntime.isPropertyKey(key));
                PropertyDescriptor desc = this.getOwnPropertyNode.execute(thisObj, key);
                if (desc == null) continue;
                DynamicObject propDesc = JSRuntime.fromPropertyDescriptor(desc, this.getContext());
                retObj.define(key, (Object)propDesc, JSAttributes.configurableEnumerableWritable());
            }
            return retObj;
        }

        @Specialization(guards={"isForeignObject(thisObj)"}, limit="3")
        protected DynamicObject getForeignObject(TruffleObject thisObj, @CachedLibrary(value="thisObj") InteropLibrary interop, @CachedLibrary(limit="3") InteropLibrary members, @Cached(value="create()") JSForeignToJSTypeNode toJSType) {
            DynamicObject result = JSUserObject.create(this.getContext());
            try {
                if (interop.hasMembers((Object)thisObj)) {
                    Object keysObj = interop.getMembers((Object)thisObj);
                    long size = members.getArraySize(keysObj);
                    if (size < 0L || size >= Integer.MAX_VALUE) {
                        throw Errors.createRangeErrorInvalidArrayLength();
                    }
                    int i = 0;
                    while ((long)i < size) {
                        String member = (String)members.readArrayElement(keysObj, (long)i);
                        if (interop.isMemberReadable((Object)thisObj, member)) {
                            PropertyDescriptor desc = PropertyDescriptor.createData(toJSType.executeWithTarget(interop.readMember((Object)thisObj, member)), !interop.isMemberInternal((Object)thisObj, member), interop.isMemberWritable((Object)thisObj, member), interop.isMemberRemovable((Object)thisObj, member));
                            DynamicObject propDesc = JSRuntime.fromPropertyDescriptor(desc, this.getContext());
                            result.define((Object)member, (Object)propDesc, JSAttributes.configurableEnumerableWritable());
                        }
                        ++i;
                    }
                }
                if (interop.hasArrayElements((Object)thisObj)) {
                    long size = interop.getArraySize((Object)thisObj);
                    if (size < 0L || size >= Integer.MAX_VALUE) {
                        throw Errors.createRangeErrorInvalidArrayLength();
                    }
                    for (long i = 0L; i < size; ++i) {
                        if (!interop.isArrayElementExisting((Object)thisObj, i) || !interop.isArrayElementReadable((Object)thisObj, i)) continue;
                        PropertyDescriptor desc = PropertyDescriptor.createData(toJSType.executeWithTarget(interop.readArrayElement((Object)thisObj, i)), true, interop.isArrayElementWritable((Object)thisObj, i), interop.isArrayElementRemovable((Object)thisObj, i));
                        DynamicObject propDesc = JSRuntime.fromPropertyDescriptor(desc, this.getContext());
                        result.define((Object)Boundaries.stringValueOf(i), (Object)propDesc, JSAttributes.configurableEnumerableWritable());
                    }
                }
            }
            catch (InteropException interopException) {
                // empty catch block
            }
            return result;
        }

        @Specialization(guards={"!isJSObject(thisObj)", "!isForeignObject(thisObj)"})
        protected DynamicObject getDefault(Object thisObj) {
            TruffleObject object = this.toTruffleObject(thisObj);
            assert (JSObject.isJSObject(object));
            return this.getJSObject((DynamicObject)object);
        }
    }

    public static abstract class ObjectGetOwnPropertyDescriptorNode
    extends ObjectPrototypeBuiltins.ObjectOperation {
        @Node.Child
        private JSToPropertyKeyNode toPropertyKeyNode = JSToPropertyKeyNode.create();
        @Node.Child
        private JSGetOwnPropertyNode getOwnPropertyNode = JSGetOwnPropertyNode.create();

        public ObjectGetOwnPropertyDescriptorNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization(guards={"isJSObject(thisObj)"})
        protected DynamicObject getJSObject(DynamicObject thisObj, Object property) {
            Object propertyKey = this.toPropertyKeyNode.execute(property);
            PropertyDescriptor desc = this.getOwnPropertyNode.execute(thisObj, propertyKey);
            return JSRuntime.fromPropertyDescriptor(desc, this.getContext());
        }

        @Specialization(guards={"isForeignObject(thisObj)"}, limit="3")
        protected DynamicObject getForeignObject(TruffleObject thisObj, Object property, @CachedLibrary(value="thisObj") InteropLibrary interop, @Cached(value="create()") JSForeignToJSTypeNode toJSType) {
            Object propertyKey = this.toPropertyKeyNode.execute(property);
            if (propertyKey instanceof String) {
                try {
                    String member = (String)propertyKey;
                    if (interop.hasMembers((Object)thisObj) && interop.isMemberExisting((Object)thisObj, member) && interop.isMemberReadable((Object)thisObj, member)) {
                        PropertyDescriptor desc = PropertyDescriptor.createData(toJSType.executeWithTarget(interop.readMember((Object)thisObj, member)), !interop.isMemberInternal((Object)thisObj, member), interop.isMemberWritable((Object)thisObj, member), interop.isMemberRemovable((Object)thisObj, member));
                        return JSRuntime.fromPropertyDescriptor(desc, this.getContext());
                    }
                    long index = JSRuntime.propertyNameToArrayIndex(member);
                    if (JSRuntime.isArrayIndex(index) && interop.hasArrayElements((Object)thisObj) && interop.isArrayElementExisting((Object)thisObj, index) && interop.isArrayElementReadable((Object)thisObj, index)) {
                        PropertyDescriptor desc = PropertyDescriptor.createData(toJSType.executeWithTarget(interop.readArrayElement((Object)thisObj, index)), true, interop.isArrayElementWritable((Object)thisObj, index), interop.isArrayElementRemovable((Object)thisObj, index));
                        return JSRuntime.fromPropertyDescriptor(desc, this.getContext());
                    }
                }
                catch (InteropException interopException) {
                    // empty catch block
                }
            }
            return Undefined.instance;
        }

        @Specialization(guards={"!isJSObject(thisObj)", "!isForeignObject(thisObj)"})
        protected DynamicObject getDefault(Object thisObj, Object property) {
            TruffleObject object = this.toTruffleObject(thisObj);
            assert (JSObject.isJSObject(object));
            return this.getJSObject((DynamicObject)object, property);
        }
    }

    public static abstract class ObjectGetPrototypeOfNode
    extends ObjectPrototypeBuiltins.ObjectOperation {
        @Node.Child
        private ForeignObjectPrototypeNode foreignObjectPrototypeNode;

        public ObjectGetPrototypeOfNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization(guards={"!isJSObject(object)"})
        protected DynamicObject getPrototypeOf(Object object) {
            if (this.getContext().getEcmaScriptVersion() < 6) {
                if (JSRuntime.isJSPrimitive(object)) {
                    throw Errors.createTypeErrorNotAnObject(object);
                }
                return Null.instance;
            }
            TruffleObject tobject = this.toTruffleObject(object);
            if (JSObject.isJSObject(tobject)) {
                return JSObject.getPrototype((DynamicObject)tobject);
            }
            if (this.getContext().getContextOptions().hasForeignObjectPrototype()) {
                return this.getForeignObjectPrototype(tobject);
            }
            return Null.instance;
        }

        private DynamicObject getForeignObjectPrototype(TruffleObject truffleObject) {
            assert (JSRuntime.isForeignObject(truffleObject));
            if (this.foreignObjectPrototypeNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.foreignObjectPrototypeNode = (ForeignObjectPrototypeNode)this.insert(ForeignObjectPrototypeNode.create());
            }
            return this.foreignObjectPrototypeNode.executeDynamicObject(truffleObject);
        }

        @Specialization(guards={"isJSObject(object)"})
        protected DynamicObject getPrototypeOf(DynamicObject object, @Cached(value="create()") GetPrototypeNode getPrototypeNode) {
            return getPrototypeNode.executeJSObject(object);
        }
    }

    public static enum ObjectFunction implements BuiltinEnum<ObjectFunction>
    {
        create(2),
        defineProperties(2),
        defineProperty(3),
        freeze(1),
        getOwnPropertyDescriptor(2),
        getOwnPropertyNames(1),
        getPrototypeOf(1),
        isExtensible(1),
        isFrozen(1),
        isSealed(1),
        keys(1),
        preventExtensions(1),
        seal(1),
        setPrototypeOf(2),
        is(2),
        getOwnPropertySymbols(1),
        assign(2),
        getOwnPropertyDescriptors(1),
        values(1),
        entries(1),
        fromEntries(1);

        private final int length;

        private ObjectFunction(int length) {
            this.length = length;
        }

        @Override
        public int getLength() {
            return this.length;
        }

        @Override
        public int getECMAScriptVersion() {
            if (EnumSet.of(is, getOwnPropertySymbols, assign).contains(this)) {
                return 6;
            }
            if (EnumSet.of(getOwnPropertyDescriptors, values, entries).contains(this)) {
                return 8;
            }
            if (this == fromEntries) {
                return 10;
            }
            return BuiltinEnum.super.getECMAScriptVersion();
        }
    }
}

