/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.js.builtins.JSBuiltinsContainer;
import com.oracle.truffle.js.builtins.ObjectPrototypeBuiltinsFactory;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.access.JSGetOwnPropertyNode;
import com.oracle.truffle.js.nodes.access.JSHasPropertyNode;
import com.oracle.truffle.js.nodes.access.PropertyGetNode;
import com.oracle.truffle.js.nodes.cast.JSToObjectNode;
import com.oracle.truffle.js.nodes.cast.JSToPropertyKeyNode;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.nodes.function.JSBuiltinNode;
import com.oracle.truffle.js.nodes.function.JSFunctionCallNode;
import com.oracle.truffle.js.nodes.unary.IsCallableNode;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSArguments;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSException;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.JSTruffleOptions;
import com.oracle.truffle.js.runtime.LargeInteger;
import com.oracle.truffle.js.runtime.Symbol;
import com.oracle.truffle.js.runtime.builtins.BuiltinEnum;
import com.oracle.truffle.js.runtime.builtins.JSClass;
import com.oracle.truffle.js.runtime.builtins.JSProxy;
import com.oracle.truffle.js.runtime.objects.JSLazyString;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.Null;
import com.oracle.truffle.js.runtime.objects.PropertyDescriptor;
import com.oracle.truffle.js.runtime.objects.Undefined;
import java.util.EnumSet;

public final class ObjectPrototypeBuiltins
extends JSBuiltinsContainer.SwitchEnum<ObjectPrototype> {
    protected ObjectPrototypeBuiltins() {
        super("Object.prototype", ObjectPrototype.class);
    }

    @Override
    protected Object createNode(JSContext context, JSBuiltin builtin, boolean construct, boolean newTarget, ObjectPrototype builtinEnum) {
        switch (builtinEnum) {
            case hasOwnProperty: {
                return ObjectPrototypeBuiltinsFactory.ObjectPrototypeHasOwnPropertyNodeGen.create(context, builtin, ObjectPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case isPrototypeOf: {
                return ObjectPrototypeBuiltinsFactory.ObjectPrototypeIsPrototypeOfNodeGen.create(context, builtin, ObjectPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case propertyIsEnumerable: {
                return ObjectPrototypeBuiltinsFactory.ObjectPrototypePropertyIsEnumerableNodeGen.create(context, builtin, ObjectPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case toLocaleString: {
                return ObjectPrototypeBuiltinsFactory.ObjectPrototypeToLocaleStringNodeGen.create(context, builtin, ObjectPrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
            case toString: {
                return ObjectPrototypeBuiltinsFactory.ObjectPrototypeToStringNodeGen.create(context, builtin, ObjectPrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
            case valueOf: {
                return ObjectPrototypeBuiltinsFactory.ObjectPrototypeValueOfNodeGen.create(context, builtin, ObjectPrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
            case __defineGetter__: 
            case __defineSetter__: {
                return ObjectPrototypeBuiltinsFactory.ObjectPrototypeDefineGetterOrSetterNodeGen.create(context, builtin, builtinEnum == ObjectPrototype.__defineGetter__, ObjectPrototypeBuiltins.args().withThis().fixedArgs(2).createArgumentNodes(context));
            }
            case __lookupGetter__: 
            case __lookupSetter__: {
                return ObjectPrototypeBuiltinsFactory.ObjectPrototypeLookupGetterOrSetterNodeGen.create(context, builtin, builtinEnum == ObjectPrototype.__lookupGetter__, ObjectPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
        }
        return null;
    }

    public static abstract class ObjectPrototypeLookupGetterOrSetterNode
    extends ObjectOperation {
        private final boolean getter;
        @Node.Child
        private JSToPropertyKeyNode toPropertyKeyNode = JSToPropertyKeyNode.create();
        @Node.Child
        private JSGetOwnPropertyNode getOwnPropertyNode = JSGetOwnPropertyNode.create();

        public ObjectPrototypeLookupGetterOrSetterNode(JSContext context, JSBuiltin builtin, boolean getter) {
            super(context, builtin);
            this.getter = getter;
        }

        @Specialization
        protected Object lookup(Object thisObj, Object prop) {
            DynamicObject object = this.toObject(thisObj);
            Object key = this.toPropertyKeyNode.execute(prop);
            DynamicObject current = object;
            do {
                PropertyDescriptor desc;
                if ((desc = this.getOwnPropertyNode.execute(current, key)) == null) continue;
                if (desc.isAccessorDescriptor()) {
                    return this.getter ? desc.getGet() : desc.getSet();
                }
                return Undefined.instance;
            } while ((current = JSObject.getPrototype(current)) != Null.instance);
            return Undefined.instance;
        }
    }

    public static abstract class ObjectPrototypeDefineGetterOrSetterNode
    extends ObjectOperation {
        private final boolean getter;
        @Node.Child
        private IsCallableNode isCallableNode = IsCallableNode.create();
        @Node.Child
        private JSToPropertyKeyNode toPropertyKeyNode = JSToPropertyKeyNode.create();

        public ObjectPrototypeDefineGetterOrSetterNode(JSContext context, JSBuiltin builtin, boolean getter) {
            super(context, builtin);
            this.getter = getter;
        }

        @Specialization
        protected Object define(Object thisObj, Object prop, Object getterOrSetter) {
            DynamicObject object = this.toObject(thisObj);
            if (!this.isCallableNode.executeBoolean(getterOrSetter)) {
                throw this.createTypeErrorExpectingFunction();
            }
            Object key = this.toPropertyKeyNode.execute(prop);
            PropertyDescriptor desc = PropertyDescriptor.createEmpty();
            if (this.getter) {
                desc.setGet((DynamicObject)getterOrSetter);
            } else {
                desc.setSet((DynamicObject)getterOrSetter);
            }
            desc.setEnumerable(true);
            desc.setConfigurable(true);
            JSRuntime.definePropertyOrThrow(object, key, desc);
            return Undefined.instance;
        }

        @CompilerDirectives.TruffleBoundary
        private JSException createTypeErrorExpectingFunction() {
            return Errors.createTypeErrorFormat("%s: Expecting function", this.getBuiltin().getFullName());
        }
    }

    public static abstract class ObjectPrototypeIsPrototypeOfNode
    extends ObjectOperation {
        private final ConditionProfile argIsNull = ConditionProfile.createBinaryProfile();
        private final ConditionProfile firstPrototypeFits = ConditionProfile.createBinaryProfile();

        public ObjectPrototypeIsPrototypeOfNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization(guards={"isJSObject(arg)"})
        protected boolean isPrototypeOf(Object thisObj, DynamicObject arg) {
            DynamicObject object = this.toObject(thisObj);
            if (this.argIsNull.profile(arg == null)) {
                return false;
            }
            DynamicObject pobj = JSObject.getPrototype(arg);
            if (this.firstPrototypeFits.profile(pobj == object)) {
                return true;
            }
            int counter = 0;
            do {
                if (++counter > JSTruffleOptions.MaxExpectedPrototypeChainLength) {
                    throw Errors.createRangeError("prototype chain length exceeded");
                }
                if ((pobj = JSObject.getPrototype(pobj)) != object) continue;
                return true;
            } while (pobj != Null.instance);
            return false;
        }

        @Specialization(guards={"!isJSObject(arg)"})
        protected boolean isPrototypeOfNoObject(Object thisObj, Object arg) {
            return false;
        }
    }

    public static abstract class ObjectPrototypeHasOwnPropertyNode
    extends ObjectOperation {
        @Node.Child
        private JSHasPropertyNode hasOwnPropertyNode;
        @Node.Child
        private JSToPropertyKeyNode toPropertyKeyNode;

        public ObjectPrototypeHasOwnPropertyNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization(guards={"isJSObject(thisObj)"})
        protected boolean doJSObjectStringKey(DynamicObject thisObj, String propertyName) {
            return this.getHasOwnPropertyNode().executeBoolean((Object)thisObj, propertyName);
        }

        @Specialization(guards={"isJSObject(thisObj)"})
        protected boolean doJSObjectIntKey(DynamicObject thisObj, int index) {
            return this.getHasOwnPropertyNode().executeBoolean((Object)thisObj, index);
        }

        @Specialization(guards={"isJSObject(thisObj)"}, replaces={"doJSObjectStringKey", "doJSObjectIntKey"})
        protected boolean doJSObjectAnyKey(DynamicObject thisObj, Object propName) {
            Object key = this.getToPropertyKeyNode().execute(propName);
            return this.getHasOwnPropertyNode().executeBoolean((Object)thisObj, key);
        }

        @Specialization(guards={"isNullOrUndefined(thisObj)"})
        protected boolean hasOwnPropertyNullOrUndefined(DynamicObject thisObj, Object propName) {
            this.getToPropertyKeyNode().execute(propName);
            throw Errors.createTypeErrorNotObjectCoercible(thisObj);
        }

        @Specialization
        protected boolean hasOwnPropertyLazyString(JSLazyString thisObj, Object propName) {
            return this.hasOwnPropertyPrimitive(thisObj, propName);
        }

        @Specialization(guards={"!isTruffleObject(thisObj)"})
        protected boolean hasOwnPropertyPrimitive(Object thisObj, Object propName) {
            Object key = this.getToPropertyKeyNode().execute(propName);
            DynamicObject obj = this.toObject(thisObj);
            return this.getHasOwnPropertyNode().executeBoolean((Object)obj, key);
        }

        @Specialization
        protected boolean hasOwnPropertySymbol(Symbol thisObj, Object propName) {
            return this.hasOwnPropertyPrimitive(thisObj, propName);
        }

        @Specialization
        protected boolean hasOwnPropertyLargeInteger(LargeInteger thisObj, Object propName) {
            return this.hasOwnPropertyPrimitive(thisObj, propName);
        }

        @Specialization
        protected boolean hasOwnPropertyBigInt(BigInt thisObj, Object propName) {
            return this.hasOwnPropertyPrimitive(thisObj, propName);
        }

        @Specialization(guards={"isForeignObject(thisObj)"})
        protected boolean hasOwnPropertyForeign(TruffleObject thisObj, Object propName) {
            return this.getHasOwnPropertyNode().executeBoolean((Object)thisObj, propName);
        }

        public JSHasPropertyNode getHasOwnPropertyNode() {
            if (this.hasOwnPropertyNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.hasOwnPropertyNode = (JSHasPropertyNode)this.insert(JSHasPropertyNode.create(true));
            }
            return this.hasOwnPropertyNode;
        }

        protected JSToPropertyKeyNode getToPropertyKeyNode() {
            if (this.toPropertyKeyNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.toPropertyKeyNode = (JSToPropertyKeyNode)this.insert(JSToPropertyKeyNode.create());
            }
            return this.toPropertyKeyNode;
        }
    }

    public static abstract class ObjectPrototypePropertyIsEnumerableNode
    extends ObjectOperation {
        @Node.Child
        private JSToPropertyKeyNode toPropertyKeyNode = JSToPropertyKeyNode.create();
        @Node.Child
        private JSGetOwnPropertyNode getOwnPropertyNode = JSGetOwnPropertyNode.create();
        private final ConditionProfile descNull = ConditionProfile.createBinaryProfile();

        public ObjectPrototypePropertyIsEnumerableNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected boolean propertyIsEnumerable(Object obj, Object key) {
            Object propertyKey = this.toPropertyKeyNode.execute(key);
            DynamicObject thisJSObj = this.toObject(obj);
            PropertyDescriptor desc = this.getOwnPropertyNode.execute(thisJSObj, propertyKey);
            if (this.descNull.profile(desc == null)) {
                return false;
            }
            return desc.getEnumerable();
        }
    }

    public static abstract class ObjectPrototypeToLocaleStringNode
    extends ObjectOperation {
        @Node.Child
        private PropertyGetNode getToString;
        @Node.Child
        private JSFunctionCallNode callNode;

        public ObjectPrototypeToLocaleStringNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
            this.getToString = PropertyGetNode.create("toString", false, context);
            this.callNode = JSFunctionCallNode.createCall();
        }

        @Specialization
        protected Object toLocaleString(Object obj) {
            Object objConv = obj;
            if (this.getContext().getEcmaScriptVersion() < 6 || this.getContext().isOptionV8CompatibilityMode()) {
                objConv = this.toObject(obj);
            }
            Object toStringFn = this.getToString.getValue(objConv);
            return this.callNode.executeCall(JSArguments.createZeroArg(obj, toStringFn));
        }
    }

    public static abstract class FormatCacheNode
    extends JavaScriptBaseNode {
        public abstract String execute(String var1);

        public static FormatCacheNode create() {
            return ObjectPrototypeBuiltinsFactory.FormatCacheNodeGen.create();
        }

        @Specialization(guards={"cachedName.equals(name)"}, limit="10")
        protected String executeCached(String name, @Cached(value="name") String cachedName, @Cached(value="executeUncached(name)") String cachedResult) {
            return cachedResult;
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        protected String executeUncached(String name) {
            return "[object " + name + "]";
        }
    }

    public static abstract class GetBuiltinToStringTagNode
    extends JavaScriptBaseNode {
        public abstract String execute(Object var1);

        public static GetBuiltinToStringTagNode create() {
            return ObjectPrototypeBuiltinsFactory.GetBuiltinToStringTagNodeGen.create();
        }

        @Specialization(guards={"cachedClass != null", "cachedClass.isInstance(object)"}, limit="5")
        protected static String cached(DynamicObject object, @Cached(value="getJSClassChecked(object)") JSClass cachedClass) {
            return cachedClass.getBuiltinToStringTag(object);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isJSType(object)"}, replaces={"cached"})
        protected static String uncached(DynamicObject object) {
            return JSObject.getJSClass(object).getBuiltinToStringTag(object);
        }

        @Specialization(guards={"!isJSType(object)"})
        protected static String foreign(DynamicObject object) {
            return "Foreign";
        }
    }

    public static abstract class ObjectPrototypeToStringNode
    extends ObjectOperation {
        @Node.Child
        private PropertyGetNode getStringTagNode;
        @Node.Child
        private FormatCacheNode formatCacheNode;

        public ObjectPrototypeToStringNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
            this.getStringTagNode = PropertyGetNode.create(Symbol.SYMBOL_TO_STRING_TAG, false, context);
        }

        private String formatString(String name) {
            if (this.formatCacheNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.formatCacheNode = (FormatCacheNode)this.insert(FormatCacheNode.create());
            }
            return this.formatCacheNode.execute(name);
        }

        private String getToStringTag(DynamicObject thisObj) {
            Object toStringTag;
            if (this.getContext().getEcmaScriptVersion() >= 6 && JSRuntime.isString(toStringTag = this.getStringTagNode.getValue(thisObj))) {
                return JSRuntime.toStringIsString(toStringTag);
            }
            return null;
        }

        @Specialization(guards={"isJSObject(thisObj)", "!isJSProxy(thisObj)"})
        protected String doJSObject(DynamicObject thisObj, @Cached.Shared(value="builtinTag") @Cached GetBuiltinToStringTagNode getBuiltinToStringTagNode) {
            String toString = this.getToStringTag(thisObj);
            if (toString == null) {
                toString = this.getContext().getEcmaScriptVersion() >= 6 ? getBuiltinToStringTagNode.execute(thisObj) : JSObject.getClassName(thisObj);
            }
            return this.formatString(toString);
        }

        @Specialization(guards={"isJSProxy(thisObj)"})
        protected String doJSProxy(DynamicObject thisObj, @Cached.Shared(value="builtinTag") @Cached(value="create()") GetBuiltinToStringTagNode getBuiltinToStringTagNode) {
            TruffleObject target = JSProxy.getTargetNonProxy(thisObj);
            String toString = this.getToStringTag(thisObj);
            if (toString == null) {
                toString = getBuiltinToStringTagNode.execute(target);
            }
            return this.formatString(toString);
        }

        @Specialization(guards={"isJSNull(thisObj)"})
        protected String doNull(Object thisObj) {
            return "[object Null]";
        }

        @Specialization(guards={"isUndefined(thisObj)"})
        protected String doUndefined(Object thisObj) {
            return "[object Undefined]";
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isForeignObject(thisObj)"})
        protected String doForeignObject(TruffleObject thisObj) {
            return "[foreign " + thisObj.getClass().getSimpleName() + "]";
        }

        @Specialization
        protected String doSymbol(Symbol thisObj) {
            assert (thisObj != null);
            return JSObject.defaultToString(this.toObject(thisObj));
        }

        @Specialization
        protected String doLazyString(JSLazyString thisObj) {
            return JSObject.defaultToString(this.toObject(thisObj));
        }

        @Specialization
        protected String doLargeInteger(LargeInteger thisObj) {
            return JSObject.defaultToString(this.toObject(thisObj));
        }

        @Specialization
        protected String doBigInt(BigInt thisObj) {
            return JSObject.defaultToString(this.toObject(thisObj));
        }

        @Specialization(guards={"!isTruffleObject(thisObj)"})
        protected String doObject(Object thisObj) {
            assert (thisObj != null);
            return JSObject.defaultToString(this.toObject(thisObj));
        }
    }

    public static abstract class ObjectPrototypeValueOfNode
    extends ObjectOperation {
        public ObjectPrototypeValueOfNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization(guards={"isJSType(thisObj)"})
        protected DynamicObject valueOf(DynamicObject thisObj) {
            return this.toObject(thisObj);
        }

        @Specialization
        protected DynamicObject valueOf(Symbol thisObj) {
            return this.toObject(thisObj);
        }

        @Specialization
        protected DynamicObject valueOf(JSLazyString thisObj) {
            return this.toObject(thisObj);
        }

        @Specialization
        protected DynamicObject valueOf(LargeInteger thisObj) {
            return this.toObject(thisObj);
        }

        @Specialization
        protected DynamicObject valueOf(BigInt thisObj) {
            return this.toObject(thisObj);
        }

        @Specialization(guards={"!isTruffleObject(thisObj)"})
        protected DynamicObject valueOf(Object thisObj) {
            return this.toObject(thisObj);
        }

        @Specialization(guards={"isForeignObject(thisObj)"})
        protected Object valueOf(TruffleObject thisObj, @CachedLibrary(limit="3") InteropLibrary interop) {
            if (interop.isNull((Object)thisObj)) {
                throw Errors.createTypeErrorNotObjectCoercible(thisObj);
            }
            return thisObj;
        }
    }

    public static abstract class ObjectOperation
    extends JSBuiltinNode {
        @Node.Child
        private JSToObjectNode toObjectNode;
        private final ConditionProfile isObject = ConditionProfile.createBinaryProfile();
        private final BranchProfile notAJSObjectBranch = BranchProfile.create();

        public ObjectOperation(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        protected final DynamicObject toObject(Object target) {
            return JSRuntime.expectJSObject(this.toTruffleObject(target), this.notAJSObjectBranch);
        }

        protected final TruffleObject toTruffleObject(Object target) {
            if (this.toObjectNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.toObjectNode = (JSToObjectNode)this.insert(JSToObjectNode.createToObject(this.getContext()));
            }
            return this.toObjectNode.executeTruffleObject(target);
        }

        protected final DynamicObject asObject(Object object) {
            if (this.isObject.profile(JSRuntime.isObject(object))) {
                return (DynamicObject)object;
            }
            throw this.createTypeErrorCalledOnNonObject(object);
        }

        protected final DynamicObject toOrAsObject(Object thisObj) {
            if (this.getContext().getEcmaScriptVersion() >= 6) {
                return this.toObject(thisObj);
            }
            return this.asObject(thisObj);
        }

        @CompilerDirectives.TruffleBoundary
        protected final JSException createTypeErrorCalledOnNonObject(Object value) {
            assert (!JSRuntime.isObject(value));
            return Errors.createTypeErrorFormat("Object.%s called on non-object", this.getBuiltin().getName());
        }
    }

    public static enum ObjectPrototype implements BuiltinEnum<ObjectPrototype>
    {
        hasOwnProperty(1),
        isPrototypeOf(1),
        propertyIsEnumerable(1),
        toLocaleString(0),
        toString(0),
        valueOf(0),
        __defineGetter__(2),
        __defineSetter__(2),
        __lookupGetter__(1),
        __lookupSetter__(1);

        private final int length;

        private ObjectPrototype(int length) {
            this.length = length;
        }

        @Override
        public int getLength() {
            return this.length;
        }

        @Override
        public String getName() {
            return super.name();
        }

        @Override
        public boolean isAnnexB() {
            return EnumSet.of(__defineGetter__, __defineSetter__, __lookupGetter__, __lookupSetter__).contains(this);
        }
    }
}

