/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.access;

import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.RepeatableNode;
import com.oracle.truffle.js.nodes.access.JSTargetableNode;
import com.oracle.truffle.js.nodes.access.RequireObjectCoercibleNode;

public final class SuperPropertyReferenceNode
extends JSTargetableNode
implements RepeatableNode {
    @Node.Child
    private JavaScriptNode baseValueNode;
    @Node.Child
    private JavaScriptNode thisValueNode;

    private SuperPropertyReferenceNode(JavaScriptNode baseNode, JavaScriptNode thisValueNode) {
        this.baseValueNode = baseNode;
        this.thisValueNode = thisValueNode;
    }

    public static JSTargetableNode create(JavaScriptNode baseNode, JavaScriptNode thisValueNode) {
        assert (baseNode instanceof RepeatableNode && thisValueNode instanceof RepeatableNode);
        return new SuperPropertyReferenceNode(RequireObjectCoercibleNode.RequireObjectCoercibleWrapperNode.create(baseNode), thisValueNode);
    }

    public JavaScriptNode getBaseValue() {
        return this.baseValueNode;
    }

    @Override
    public Object executeWithTarget(VirtualFrame frame, Object target) {
        return this.execute(frame);
    }

    @Override
    public Object execute(VirtualFrame frame) {
        this.thisValueNode.executeVoid(frame);
        return this.baseValueNode.execute(frame);
    }

    @Override
    public Object evaluateTarget(VirtualFrame frame) {
        return this.thisValueNode.execute(frame);
    }

    public JavaScriptNode getThisValue() {
        return this.thisValueNode;
    }

    @Override
    public JavaScriptNode getTarget() {
        return this.thisValueNode;
    }

    @Override
    protected JavaScriptNode copyUninitialized() {
        return new SuperPropertyReferenceNode(SuperPropertyReferenceNode.cloneUninitialized(this.baseValueNode), SuperPropertyReferenceNode.cloneUninitialized(this.thisValueNode));
    }
}

