/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.cast;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.cast.JSStringToNumberNode;
import com.oracle.truffle.js.nodes.cast.JSToIntegerNodeGen;
import com.oracle.truffle.js.nodes.cast.JSToNumberNode;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.Symbol;

public abstract class JSToIntegerNode
extends JavaScriptBaseNode {
    @Node.Child
    private JSToNumberNode toNumberNode;

    public static JSToIntegerNode create() {
        return JSToIntegerNodeGen.create();
    }

    public abstract int executeInt(Object var1);

    @Specialization
    protected static int doInteger(int value) {
        return value;
    }

    @Specialization
    protected static int doBoolean(boolean value) {
        return JSRuntime.booleanToNumber(value);
    }

    protected static boolean inInt32Range(double value) {
        return value <= 2.147483647E9 && value >= -2.147483648E9;
    }

    @Specialization(guards={"inInt32Range(value)"})
    protected static int doDoubleInt32Range(double value) {
        return (int)((long)value & 0xFFFFFFFFL);
    }

    @Specialization(guards={"!inInt32Range(value)"})
    protected static int doDouble(double value) {
        if (Double.isNaN(value)) {
            return 0;
        }
        if (value > 0.0) {
            return Integer.MAX_VALUE;
        }
        return Integer.MIN_VALUE;
    }

    @Specialization(guards={"isUndefined(value)"})
    protected static int doUndefined(Object value) {
        return 0;
    }

    @Specialization(guards={"isJSNull(value)"})
    protected static int doNull(Object value) {
        return 0;
    }

    @Specialization
    protected final int doSymbol(Symbol value) {
        throw Errors.createTypeErrorCannotConvertToNumber("a Symbol value", this);
    }

    @Specialization
    protected final int doBigInt(BigInt value) {
        throw Errors.createTypeErrorCannotConvertToNumber("a BigInt value", this);
    }

    @Specialization
    protected int doString(String value, @Cached(value="create()") JSToIntegerNode nestedToIntegerNode, @Cached(value="create()") JSStringToNumberNode stringToNumberNode) {
        return nestedToIntegerNode.executeInt(stringToNumberNode.executeString(value));
    }

    @Specialization(guards={"isJSObject(value)"})
    protected int doJSObject(DynamicObject value) {
        return JSRuntime.toInt32(this.getToNumberNode().executeNumber(value));
    }

    @Specialization(guards={"isForeignObject(object)"})
    protected int doForeignObject(TruffleObject object) {
        return JSRuntime.toInt32(this.getToNumberNode().executeNumber(object));
    }

    private JSToNumberNode getToNumberNode() {
        if (this.toNumberNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.toNumberNode = (JSToNumberNode)this.insert(JSToNumberNode.create());
        }
        return this.toNumberNode;
    }
}

