/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.cast;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.access.ReadElementNode;
import com.oracle.truffle.js.nodes.array.JSGetLengthNode;
import com.oracle.truffle.js.nodes.cast.JSToObjectArrayNodeGen;
import com.oracle.truffle.js.nodes.interop.JSForeignToJSTypeNode;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.JSTruffleOptions;
import com.oracle.truffle.js.runtime.array.ScriptArray;
import java.util.List;
import java.util.Objects;

public abstract class JSToObjectArrayNode
extends JavaScriptBaseNode {
    protected final JSContext context;
    protected final boolean nullOrUndefinedAsEmptyArray;

    protected JSToObjectArrayNode(JSContext context, boolean nullOrUndefinedAsEmptyArray) {
        this.context = Objects.requireNonNull(context);
        this.nullOrUndefinedAsEmptyArray = nullOrUndefinedAsEmptyArray;
    }

    public abstract Object[] executeObjectArray(Object var1);

    public static JSToObjectArrayNode create(JSContext context) {
        return JSToObjectArrayNode.create(context, false);
    }

    public static JSToObjectArrayNode create(JSContext context, boolean nullOrUndefinedAsEmptyArray) {
        return JSToObjectArrayNodeGen.create(context, nullOrUndefinedAsEmptyArray);
    }

    @Specialization(guards={"isJSObject(obj)"})
    protected static Object[] toArray(DynamicObject obj, @Cached(value="create(context)") JSGetLengthNode getLengthNode, @Cached(value="create(context)") ReadElementNode readNode) {
        long len = getLengthNode.executeLong(obj);
        if (len > (long)JSTruffleOptions.MaxApplyArgumentLength) {
            CompilerDirectives.transferToInterpreter();
            throw Errors.createRangeErrorTooManyArguments();
        }
        int iLen = (int)len;
        assert (JSRuntime.longIsRepresentableAsInt(len));
        Object[] arr = new Object[iLen];
        for (int index = 0; index < iLen; ++index) {
            Object value;
            arr[index] = value = readNode.executeWithTargetAndIndex((Object)obj, index);
        }
        return arr;
    }

    @Specialization(guards={"isUndefined(value)"})
    protected Object[] doUndefined(Object value) {
        return this.emptyArrayOrObjectError(value);
    }

    @Specialization(guards={"isJSNull(value)"})
    protected Object[] doNull(Object value) {
        return this.emptyArrayOrObjectError(value);
    }

    @Specialization
    protected static Object[] toArrayString(CharSequence value) {
        return JSToObjectArrayNode.notAnObjectError(value);
    }

    @Specialization
    protected static Object[] toArrayInt(int value) {
        return JSToObjectArrayNode.notAnObjectError(value);
    }

    @Specialization
    protected static Object[] toArrayDouble(double value) {
        return JSToObjectArrayNode.notAnObjectError(value);
    }

    @Specialization
    protected static Object[] toArrayBoolean(boolean value) {
        return JSToObjectArrayNode.notAnObjectError(value);
    }

    private Object[] emptyArrayOrObjectError(Object value) {
        if (this.nullOrUndefinedAsEmptyArray) {
            return ScriptArray.EMPTY_OBJECT_ARRAY;
        }
        return JSToObjectArrayNode.notAnObjectError(value);
    }

    private static Object[] notAnObjectError(Object value) {
        if (JSTruffleOptions.NashornCompatibilityMode) {
            throw Errors.createTypeError("Function.prototype.apply expects an Array for second argument");
        }
        throw Errors.createTypeErrorNotAnObject(value);
    }

    @Specialization
    protected static Object[] passArray(Object[] array) {
        if (array.length > JSTruffleOptions.MaxApplyArgumentLength) {
            CompilerDirectives.transferToInterpreter();
            throw Errors.createRangeErrorTooManyArguments();
        }
        return array;
    }

    @CompilerDirectives.TruffleBoundary
    @Specialization(guards={"isList(value)"})
    protected static Object[] doList(Object value) {
        List list = (List)value;
        if (list.size() > JSTruffleOptions.MaxApplyArgumentLength) {
            CompilerDirectives.transferToInterpreter();
            throw Errors.createRangeErrorTooManyArguments();
        }
        return list.toArray();
    }

    @Specialization(guards={"!isJSObject(obj)"}, limit="5")
    protected static Object[] doForeignObject(TruffleObject obj, @CachedLibrary(value="obj") InteropLibrary interop, @Cached(value="create()") BranchProfile hasPropertiesBranch, @Cached(value="create()") JSForeignToJSTypeNode foreignConvertNode) {
        try {
            if (!interop.hasArrayElements((Object)obj)) {
                throw Errors.createTypeError("foreign Object reports not to have a SIZE");
            }
            long len = interop.getArraySize((Object)obj);
            if (len > (long)JSTruffleOptions.MaxApplyArgumentLength) {
                CompilerDirectives.transferToInterpreter();
                throw Errors.createRangeErrorTooManyArguments();
            }
            int iLen = (int)len;
            Object[] arr = new Object[iLen];
            if (len > 0L) {
                hasPropertiesBranch.enter();
                for (int i = 0; i < iLen; ++i) {
                    arr[i] = foreignConvertNode.executeWithTarget(interop.readArrayElement((Object)obj, (long)i));
                }
            }
            return arr;
        }
        catch (InvalidArrayIndexException | UnsupportedMessageException e) {
            throw Errors.createTypeErrorNotAnObject(obj);
        }
    }

    @Fallback
    protected static Object[] doFallback(Object value) {
        assert (!JSRuntime.isObject(value));
        return JSToObjectArrayNode.notAnObjectError(value);
    }
}

