/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.cast;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.access.JSConstantNode;
import com.oracle.truffle.js.nodes.cast.JSStringToNumberNode;
import com.oracle.truffle.js.nodes.cast.JSToInt32Node;
import com.oracle.truffle.js.nodes.cast.JSToNumberNode;
import com.oracle.truffle.js.nodes.cast.JSToPrimitiveNode;
import com.oracle.truffle.js.nodes.cast.JSToUInt32NodeGen;
import com.oracle.truffle.js.nodes.unary.JSUnaryNode;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.LargeInteger;
import com.oracle.truffle.js.runtime.Symbol;

public abstract class JSToUInt32Node
extends JavaScriptBaseNode {
    public static JSToUInt32Node create() {
        return JSToUInt32NodeGen.create();
    }

    public abstract Object execute(Object var1);

    public final long executeLong(Object value) {
        return JSRuntime.longValue((Number)this.execute(value));
    }

    @Specialization(guards={"value >= 0"})
    protected int doInteger(int value) {
        return value;
    }

    @Specialization(guards={"value < 0"})
    protected LargeInteger doIntegerNegative(int value) {
        return LargeInteger.valueOf((long)value & 0xFFFFFFFFL);
    }

    @Specialization
    protected Object doLargeInteger(LargeInteger value) {
        long lValue = value.longValue() & 0xFFFFFFFFL;
        if (lValue > Integer.MAX_VALUE) {
            return LargeInteger.valueOf(lValue);
        }
        return (int)lValue;
    }

    @Specialization
    protected int doBoolean(boolean value) {
        return JSToUInt32Node.doBooleanStatic(value);
    }

    private static int doBooleanStatic(boolean value) {
        return JSRuntime.booleanToNumber(value);
    }

    @Specialization
    protected double doLong(long value) {
        return JSRuntime.toUInt32(value);
    }

    @Specialization(guards={"!isDoubleLargerThan2e32(value)"})
    protected double doDoubleFitsInt32Negative(double value) {
        return JSRuntime.toUInt32((long)value);
    }

    @Specialization(guards={"isDoubleLargerThan2e32(value)", "isDoubleRepresentableAsLong(value)"})
    protected double doDoubleRepresentableAsLong(double value) {
        return JSRuntime.toUInt32NoTruncate(value);
    }

    @Specialization(guards={"isDoubleLargerThan2e32(value)", "!isDoubleRepresentableAsLong(value)"})
    protected double doDouble(double value) {
        return JSRuntime.toUInt32(value);
    }

    @Specialization(guards={"isJSNull(value)"})
    protected int doNull(Object value) {
        return 0;
    }

    @Specialization(guards={"isUndefined(value)"})
    protected int doUndefined(Object value) {
        return 0;
    }

    @Specialization
    protected double doString(String value, @Cached(value="create()") JSStringToNumberNode stringToNumberNode) {
        return JSRuntime.toUInt32(stringToNumberNode.executeString(value));
    }

    private static double doStringStatic(String value) {
        return JSRuntime.toUInt32(JSRuntime.doubleValue(JSRuntime.stringToNumber(value)));
    }

    @Specialization
    protected final Number doSymbol(Symbol value) {
        throw Errors.createTypeErrorCannotConvertToNumber("a Symbol value", this);
    }

    @Specialization
    protected int doBigInt(BigInt value) {
        throw Errors.createTypeErrorCannotConvertBigIntToNumber(this);
    }

    @Specialization(guards={"isJSObject(value)"})
    protected double doJSObject(DynamicObject value, @Cached(value="create()") JSToNumberNode toNumberNode) {
        return JSRuntime.toUInt32(toNumberNode.executeNumber(value));
    }

    @Specialization(guards={"isForeignObject(object)"})
    protected static double doForeignObject(TruffleObject object, @Cached(value="createHintNumber()") JSToPrimitiveNode toPrimitiveNode, @Cached(value="create()") JSToUInt32Node toUInt32Node) {
        return ((Number)toUInt32Node.execute(toPrimitiveNode.execute(object))).doubleValue();
    }

    public static abstract class JSToUInt32WrapperNode
    extends JSUnaryNode {
        @Node.Child
        private JSToUInt32Node toUInt32Node;

        protected JSToUInt32WrapperNode(JavaScriptNode operand) {
            super(operand);
        }

        public static JavaScriptNode create(JavaScriptNode child) {
            if (child instanceof JSConstantNode.JSConstantIntegerNode) {
                int value = ((JSConstantNode.JSConstantIntegerNode)child).executeInt(null);
                if (value < 0) {
                    long lValue = JSRuntime.toUInt32(value);
                    return JSRuntime.longIsRepresentableAsInt(lValue) ? JSConstantNode.createInt((int)lValue) : JSConstantNode.createDouble(lValue);
                }
                return child;
            }
            if (child instanceof JSConstantNode.JSConstantDoubleNode) {
                double value = ((JSConstantNode.JSConstantDoubleNode)child).executeDouble(null);
                return JSConstantNode.createDouble(JSRuntime.toUInt32(value));
            }
            if (child instanceof JSConstantNode.JSConstantBooleanNode) {
                boolean value = ((JSConstantNode.JSConstantBooleanNode)child).executeBoolean(null);
                return JSConstantNode.createInt(JSToUInt32Node.doBooleanStatic(value));
            }
            if (child instanceof JSConstantNode.JSConstantUndefinedNode || child instanceof JSConstantNode.JSConstantNullNode) {
                return JSConstantNode.createInt(0);
            }
            if (child instanceof JSConstantNode.JSConstantStringNode) {
                String value = ((JSConstantNode.JSConstantStringNode)child).executeString(null);
                return JSConstantNode.createDouble(JSToUInt32Node.doStringStatic(value));
            }
            if (child instanceof JSToInt32Node) {
                JavaScriptNode operand = ((JSToInt32Node)child).getOperand();
                return JSToUInt32NodeGen.JSToUInt32WrapperNodeGen.create(operand);
            }
            return JSToUInt32NodeGen.JSToUInt32WrapperNodeGen.create(child);
        }

        @Specialization
        protected Object doDefault(Object value) {
            if (this.toUInt32Node == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.toUInt32Node = (JSToUInt32Node)this.insert(JSToUInt32Node.create());
            }
            return this.toUInt32Node.execute(value);
        }

        @Override
        protected JavaScriptNode copyUninitialized() {
            return JSToUInt32NodeGen.JSToUInt32WrapperNodeGen.create(JSToUInt32WrapperNode.cloneUninitialized(this.getOperand()));
        }
    }
}

