/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.control;

import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.InstrumentableNode;
import com.oracle.truffle.api.instrumentation.Tag;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RepeatingNode;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.access.WriteNode;
import com.oracle.truffle.js.nodes.control.AwaitNode;
import com.oracle.truffle.js.nodes.control.ResumableNode;
import com.oracle.truffle.js.nodes.instrumentation.JSTags;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.objects.Undefined;
import java.util.Set;

public final class GeneratorWrapperNode
extends JavaScriptNode
implements RepeatingNode {
    @Node.Child
    private JavaScriptNode childNode;
    @Node.Child
    private JavaScriptNode stateNode;
    @Node.Child
    private WriteNode writeStateNode;

    private GeneratorWrapperNode(JavaScriptNode childNode, JavaScriptNode stateNode, WriteNode writeStateNode) {
        assert (childNode instanceof ResumableNode) : childNode;
        this.childNode = childNode;
        this.stateNode = stateNode;
        this.writeStateNode = writeStateNode;
    }

    public static JavaScriptNode createWrapper(JavaScriptNode child, JavaScriptNode readStateNode, WriteNode writeStateNode) {
        GeneratorWrapperNode wrapper = new GeneratorWrapperNode(child, readStateNode, writeStateNode);
        if (child instanceof AwaitNode) {
            wrapper.setSourceSection(child.getSourceSection());
        }
        return wrapper;
    }

    @Override
    public boolean hasTag(Class<? extends Tag> tag) {
        if (tag == JSTags.ControlFlowBranchTag.class) {
            return true;
        }
        if (tag == JSTags.InputNodeTag.class) {
            JavaScriptNode child;
            JavaScriptNode javaScriptNode = child = this.childNode instanceof InstrumentableNode.WrapperNode ? ((InstrumentableNode.WrapperNode)this.childNode).getDelegateNode() : this.childNode;
            if (child instanceof AwaitNode) {
                return true;
            }
        }
        return super.hasTag(tag);
    }

    public Object getNodeObject() {
        return JSTags.createNodeObjectDescriptor("type", JSTags.ControlFlowBranchTag.Type.Await.name());
    }

    public InstrumentableNode materializeInstrumentableNodes(Set<Class<? extends Tag>> materializedTags) {
        if (materializedTags.contains(JSTags.ControlFlowBranchTag.class) && this.childNode instanceof AwaitNode) {
            GeneratorWrapperNode materialized = new GeneratorWrapperNode(this.childNode, this.stateNode, this.writeStateNode);
            GeneratorWrapperNode.transferSourceSection(this, materialized);
            return materialized;
        }
        return this;
    }

    @Override
    public Object execute(VirtualFrame frame) {
        JavaScriptNode child = this.childNode;
        if (child instanceof InstrumentableNode.WrapperNode) {
            child = ((InstrumentableNode.WrapperNode)child).getDelegateNode();
        }
        if (child instanceof ResumableNode) {
            return ((ResumableNode)((Object)child)).resume(frame);
        }
        assert (false) : ((Object)((Object)child)).getClass();
        throw Errors.shouldNotReachHere();
    }

    public boolean executeRepeating(VirtualFrame frame) {
        assert (this.childNode instanceof ResumableNode && this.childNode instanceof RepeatingNode) : ((Object)((Object)this.childNode)).getClass();
        return (Boolean)this.execute(frame);
    }

    public Object isResuming(VirtualFrame frame) {
        return this.stateNode.execute(frame) != Undefined.instance;
    }

    public Object getState(VirtualFrame frame) {
        return this.stateNode.execute(frame);
    }

    public int getStateAsInt(VirtualFrame frame) {
        Object value = this.stateNode.execute(frame);
        return value instanceof Integer ? (Integer)value : 0;
    }

    public void setState(VirtualFrame frame, Object resumeState) {
        this.writeStateNode.executeWrite(frame, resumeState);
    }

    public JavaScriptNode getResumableNode() {
        return this.childNode;
    }

    @Override
    protected JavaScriptNode copyUninitialized() {
        return GeneratorWrapperNode.createWrapper(GeneratorWrapperNode.cloneUninitialized(this.childNode), GeneratorWrapperNode.cloneUninitialized(this.stateNode), (WriteNode)((Object)GeneratorWrapperNode.cloneUninitialized((JavaScriptNode)((Object)this.writeStateNode))));
    }
}

