/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.unary;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.Introspection;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.unary.RequireConstructorNode;

@GeneratedBy(value=RequireConstructorNode.class)
public final class RequireConstructorNodeGen
extends RequireConstructorNode
implements Introspection.Provider {
    @CompilerDirectives.CompilationFinal
    private int state_;

    private RequireConstructorNodeGen(JavaScriptNode argumentNode) {
        super(argumentNode);
    }

    @Override
    public Object execute(VirtualFrame frameValue) {
        int state = this.state_;
        Object argumentNodeValue_ = this.argumentNode.execute(frameValue);
        boolean isConstructorNodeValue_ = this.isConstructorNode.executeBoolean(argumentNodeValue_);
        if (state != 0) {
            if ((state & 1) != 0 && isConstructorNodeValue_) {
                return RequireConstructorNode.constructor(argumentNodeValue_, isConstructorNodeValue_);
            }
            if ((state & 2) != 0 && RequireConstructorNodeGen.fallbackGuard_(state, argumentNodeValue_, isConstructorNodeValue_)) {
                return this.typeError(argumentNodeValue_, isConstructorNodeValue_);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(argumentNodeValue_, isConstructorNodeValue_);
    }

    @Override
    public void executeVoid(VirtualFrame frameValue) {
        this.execute(frameValue);
    }

    private Object executeAndSpecialize(Object argumentNodeValue, boolean isConstructorNodeValue) {
        int state = this.state_;
        if (isConstructorNodeValue) {
            this.state_ = state |= 1;
            return RequireConstructorNode.constructor(argumentNodeValue, isConstructorNodeValue);
        }
        this.state_ = state |= 2;
        return this.typeError(argumentNodeValue, isConstructorNodeValue);
    }

    public NodeCost getCost() {
        int state = this.state_;
        if (state == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state & state - 1) == 0) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    public Introspection getIntrospectionData() {
        Object[] data = new Object[3];
        data[0] = 0;
        int state = this.state_;
        Object[] s = new Object[3];
        s[0] = "constructor";
        s[1] = (state & 1) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[1] = s;
        s = new Object[3];
        s[0] = "typeError";
        s[1] = (state & 2) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[2] = s;
        return Introspection.Provider.create((Object[])data);
    }

    private static boolean fallbackGuard_(int state, Object argumentNodeValue, boolean isConstructorNodeValue) {
        return (state & 1) != 0 || !isConstructorNodeValue;
    }

    public static RequireConstructorNode create(JavaScriptNode argumentNode) {
        return new RequireConstructorNodeGen(argumentNode);
    }
}

