/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.builtins;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.api.object.LocationModifier;
import com.oracle.truffle.api.object.ObjectType;
import com.oracle.truffle.api.object.Property;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.js.runtime.Boundaries;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.JSTruffleOptions;
import com.oracle.truffle.js.runtime.Symbol;
import com.oracle.truffle.js.runtime.array.ArrayAllocationSite;
import com.oracle.truffle.js.runtime.array.ScriptArray;
import com.oracle.truffle.js.runtime.array.SparseArray;
import com.oracle.truffle.js.runtime.array.dyn.ConstantEmptyPrototypeArray;
import com.oracle.truffle.js.runtime.array.dyn.LazyRegexResultArray;
import com.oracle.truffle.js.runtime.builtins.JSArgumentsObject;
import com.oracle.truffle.js.runtime.builtins.JSArray;
import com.oracle.truffle.js.runtime.builtins.JSArrayBufferView;
import com.oracle.truffle.js.runtime.builtins.JSBuiltinObject;
import com.oracle.truffle.js.runtime.builtins.JSObjectPrototype;
import com.oracle.truffle.js.runtime.builtins.JSProxy;
import com.oracle.truffle.js.runtime.builtins.JSSlowArray;
import com.oracle.truffle.js.runtime.objects.JSAttributes;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.JSObjectUtil;
import com.oracle.truffle.js.runtime.objects.JSProperty;
import com.oracle.truffle.js.runtime.objects.JSShape;
import com.oracle.truffle.js.runtime.objects.Null;
import com.oracle.truffle.js.runtime.objects.PropertyDescriptor;
import com.oracle.truffle.js.runtime.objects.Undefined;
import com.oracle.truffle.js.runtime.util.DefinePropertyUtil;
import com.oracle.truffle.js.runtime.util.IteratorUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.TreeMap;

public abstract class JSAbstractArray
extends JSBuiltinObject {
    public static final String LENGTH = "length";
    protected static final String ARRAY_LENGTH_NOT_WRITABLE = "array length is not writable";
    private static final String LENGTH_PROPERTY_NOT_WRITABLE = "length property not writable";
    protected static final String MAKE_SLOW_ARRAY_NEVER_PART_OF_COMPILATION_MESSAGE = "do not convert to slow array from compiled code";
    public static final String ARRAY_PROTOTYPE_NO_ELEMENTS_INVALIDATION = "Array.prototype no element assumption";
    private static final HiddenKey ARRAY_ID = new HiddenKey("array");
    private static final HiddenKey ARRAY_TYPE_ID = new HiddenKey("arraytype");
    private static final HiddenKey ALLOCATION_SITE_ID = new HiddenKey("allocationSite");
    private static final HiddenKey LENGTH_ID = new HiddenKey("length");
    private static final HiddenKey USED_LENGTH_ID = new HiddenKey("usedLength");
    private static final HiddenKey INDEX_OFFSET_ID = new HiddenKey("indexOffset");
    private static final HiddenKey ARRAY_OFFSET_ID = new HiddenKey("arrayOffset");
    private static final HiddenKey HOLE_COUNT_ID = new HiddenKey("holeCount");
    public static final HiddenKey LAZY_REGEX_RESULT_ID = new HiddenKey("lazyRegexResult");
    public static final HiddenKey LAZY_REGEX_ORIGINAL_INPUT_ID = new HiddenKey("lazyRegexResultOriginalInput");
    public static final Property ARRAY_PROPERTY;
    public static final Property ARRAY_TYPE_PROPERTY;
    private static final Property ALLOCATION_SITE_PROPERTY;
    private static final Property LENGTH_PROPERTY;
    private static final Property USED_LENGTH_PROPERTY;
    private static final Property INDEX_OFFSET_PROPERTY;
    private static final Property ARRAY_OFFSET_PROPERTY;
    private static final Property HOLE_COUNT_PROPERTY;
    public static final Property LAZY_REGEX_RESULT_PROPERTY;
    public static final Property LAZY_REGEX_ORIGINAL_INPUT_PROPERTY;

    public static ScriptArray arrayGetArrayType(DynamicObject thisObj) {
        assert (JSArray.isJSArray(thisObj) || JSArgumentsObject.isJSArgumentsObject(thisObj));
        return JSAbstractArray.arrayGetArrayType(thisObj, JSArray.isJSArray(thisObj));
    }

    public static ScriptArray arrayGetArrayType(DynamicObject thisObj, boolean arrayCondition) {
        assert (JSArray.isJSArray(thisObj) || JSArgumentsObject.isJSArgumentsObject(thisObj) || JSObjectPrototype.isJSObjectPrototype(thisObj));
        return (ScriptArray)ARRAY_TYPE_PROPERTY.get(thisObj, arrayCondition);
    }

    public static long arrayGetLength(DynamicObject thisObj) {
        return JSAbstractArray.arrayGetLength(thisObj, JSArray.isJSArray(thisObj));
    }

    public static long arrayGetLength(DynamicObject thisObj, boolean arrayCondition) {
        return Integer.toUnsignedLong((Integer)LENGTH_PROPERTY.get(thisObj, arrayCondition));
    }

    public static int arrayGetUsedLength(DynamicObject thisObj) {
        return JSAbstractArray.arrayGetUsedLength(thisObj, JSArray.isJSArray(thisObj));
    }

    public static int arrayGetUsedLength(DynamicObject thisObj, boolean arrayCondition) {
        return (Integer)USED_LENGTH_PROPERTY.get(thisObj, arrayCondition);
    }

    public static long arrayGetIndexOffset(DynamicObject thisObj) {
        return JSAbstractArray.arrayGetIndexOffset(thisObj, JSArray.isJSArray(thisObj));
    }

    public static long arrayGetIndexOffset(DynamicObject thisObj, boolean arrayCondition) {
        return Integer.toUnsignedLong((Integer)INDEX_OFFSET_PROPERTY.get(thisObj, arrayCondition));
    }

    public static int arrayGetArrayOffset(DynamicObject thisObj) {
        return JSAbstractArray.arrayGetArrayOffset(thisObj, JSArray.isJSArray(thisObj));
    }

    public static int arrayGetArrayOffset(DynamicObject thisObj, boolean arrayCondition) {
        return (Integer)ARRAY_OFFSET_PROPERTY.get(thisObj, arrayCondition);
    }

    public static void arraySetArrayType(DynamicObject thisObj, ScriptArray arrayType) {
        ARRAY_TYPE_PROPERTY.setSafe(thisObj, (Object)arrayType, null);
    }

    public static void arraySetLength(DynamicObject thisObj, long length) {
        assert (JSRuntime.isRepresentableAsUnsignedInt(length));
        LENGTH_PROPERTY.setSafe(thisObj, (Object)((int)length), null);
    }

    public static void arraySetUsedLength(DynamicObject thisObj, int usedLength) {
        assert (usedLength >= 0);
        USED_LENGTH_PROPERTY.setSafe(thisObj, (Object)usedLength, null);
    }

    public static void arraySetIndexOffset(DynamicObject thisObj, long indexOffset) {
        assert (JSRuntime.isRepresentableAsUnsignedInt(indexOffset));
        INDEX_OFFSET_PROPERTY.setSafe(thisObj, (Object)((int)indexOffset), null);
    }

    public static void arraySetArrayOffset(DynamicObject thisObj, int arrayOffset) {
        assert (arrayOffset >= 0);
        ARRAY_OFFSET_PROPERTY.setSafe(thisObj, (Object)arrayOffset, null);
    }

    public static Object arrayGetArray(DynamicObject thisObj) {
        return JSAbstractArray.arrayGetArray(thisObj, JSObject.hasArray(thisObj));
    }

    public static Object arrayGetArray(DynamicObject thisObj, boolean arrayCondition) {
        assert (JSObject.hasArray(thisObj));
        return ARRAY_PROPERTY.get(thisObj, arrayCondition);
    }

    public static void arraySetArray(DynamicObject thisObj, Object array) {
        assert (JSObject.hasArray(thisObj));
        assert (array != null && (array.getClass().isArray() || array instanceof TreeMap));
        ARRAY_PROPERTY.setSafe(thisObj, array, null);
    }

    public static int arrayGetHoleCount(DynamicObject thisObj) {
        return JSAbstractArray.arrayGetHoleCount(thisObj, JSArray.isJSArray(thisObj));
    }

    public static int arrayGetHoleCount(DynamicObject thisObj, boolean arrayCondition) {
        return (Integer)HOLE_COUNT_PROPERTY.get(thisObj, arrayCondition);
    }

    public static void arraySetHoleCount(DynamicObject thisObj, int holeCount) {
        HOLE_COUNT_PROPERTY.setSafe(thisObj, (Object)holeCount, null);
    }

    public static ArrayAllocationSite arrayGetAllocationSite(DynamicObject thisObj) {
        return JSAbstractArray.arrayGetAllocationSite(thisObj, JSArray.isJSArray(thisObj));
    }

    public static ArrayAllocationSite arrayGetAllocationSite(DynamicObject thisObj, boolean arrayCondition) {
        return (ArrayAllocationSite)ALLOCATION_SITE_PROPERTY.get(thisObj, arrayCondition);
    }

    public static TruffleObject arrayGetRegexResult(DynamicObject thisObj) {
        return JSAbstractArray.arrayGetRegexResult(thisObj, JSArray.isJSArray(thisObj) && JSArray.arrayGetArrayType(thisObj) == LazyRegexResultArray.LAZY_REGEX_RESULT_ARRAY);
    }

    public static TruffleObject arrayGetRegexResult(DynamicObject thisObj, boolean arrayCondition) {
        return (TruffleObject)LAZY_REGEX_RESULT_PROPERTY.get(thisObj, arrayCondition);
    }

    public static String arrayGetRegexResultOriginalInput(DynamicObject thisObj) {
        return JSAbstractArray.arrayGetRegexResultOriginalInput(thisObj, JSArray.isJSArray(thisObj) && JSArray.arrayGetArrayType(thisObj) == LazyRegexResultArray.LAZY_REGEX_RESULT_ARRAY);
    }

    public static String arrayGetRegexResultOriginalInput(DynamicObject thisObj, boolean arrayCondition) {
        return (String)LAZY_REGEX_ORIGINAL_INPUT_PROPERTY.get(thisObj, arrayCondition);
    }

    public static void putArrayProperties(DynamicObject arrayPrototype, ScriptArray arrayType) {
        JSObjectUtil.putHiddenProperty(arrayPrototype, ARRAY_PROPERTY, ScriptArray.EMPTY_OBJECT_ARRAY);
        JSObjectUtil.putHiddenProperty(arrayPrototype, ARRAY_TYPE_PROPERTY, arrayType);
        JSObjectUtil.putHiddenProperty(arrayPrototype, ALLOCATION_SITE_PROPERTY, null);
        JSObjectUtil.putHiddenProperty(arrayPrototype, LENGTH_PROPERTY, 0);
        JSObjectUtil.putHiddenProperty(arrayPrototype, USED_LENGTH_PROPERTY, 0);
        JSObjectUtil.putHiddenProperty(arrayPrototype, INDEX_OFFSET_PROPERTY, 0);
        JSObjectUtil.putHiddenProperty(arrayPrototype, ARRAY_OFFSET_PROPERTY, 0);
        JSObjectUtil.putHiddenProperty(arrayPrototype, HOLE_COUNT_PROPERTY, 0);
    }

    protected static Shape addArrayProperties(Shape initialShape) {
        Shape shape = initialShape;
        shape = shape.addProperty(ARRAY_PROPERTY);
        shape = shape.addProperty(ARRAY_TYPE_PROPERTY);
        shape = shape.addProperty(ALLOCATION_SITE_PROPERTY);
        shape = shape.addProperty(LENGTH_PROPERTY);
        shape = shape.addProperty(USED_LENGTH_PROPERTY);
        shape = shape.addProperty(INDEX_OFFSET_PROPERTY);
        shape = shape.addProperty(ARRAY_OFFSET_PROPERTY);
        shape = shape.addProperty(HOLE_COUNT_PROPERTY);
        return shape;
    }

    protected JSAbstractArray() {
    }

    public long getLength(DynamicObject thisObj) {
        return JSAbstractArray.arrayGetArrayType(thisObj).length(thisObj);
    }

    @CompilerDirectives.TruffleBoundary
    public boolean setLength(DynamicObject thisObj, long length, boolean doThrow) {
        long minIndex;
        if (length < 0L) {
            throw Errors.createRangeErrorInvalidArrayLength();
        }
        ScriptArray array = JSAbstractArray.arrayGetArrayType(thisObj);
        if (length > Integer.MAX_VALUE && !(array instanceof SparseArray)) {
            array = SparseArray.makeSparseArray(thisObj, array);
        }
        if (array.isSealed() && length < (minIndex = array.lastElementIndex(thisObj) + 1L)) {
            array = array.setLength(thisObj, minIndex, doThrow);
            JSAbstractArray.arraySetArrayType(thisObj, array);
            return array.canDeleteElement(thisObj, minIndex - 1L, doThrow);
        }
        JSAbstractArray.arraySetArrayType(thisObj, array.setLength(thisObj, length, doThrow));
        return true;
    }

    @Override
    public String getBuiltinToStringTag(DynamicObject object) {
        return this.getClassName(object);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public final Object getOwnHelper(DynamicObject store, Object thisObj, Object key) {
        long idx = JSRuntime.propertyKeyToArrayIndex(key);
        if (JSRuntime.isArrayIndex(idx)) {
            return this.getOwnHelper(store, thisObj, idx);
        }
        return super.getOwnHelper(store, thisObj, key);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public final boolean set(DynamicObject thisObj, Object key, Object value, Object receiver, boolean isStrict) {
        long idx = JSRuntime.propertyKeyToArrayIndex(key);
        if (JSRuntime.isArrayIndex(idx)) {
            return this.set(thisObj, idx, value, receiver, isStrict);
        }
        return super.set(thisObj, key, value, receiver, isStrict);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public boolean set(DynamicObject thisObj, long index, Object value, Object receiver, boolean isStrict) {
        if (JSAbstractArray.arrayGetArrayType(thisObj).hasElement(thisObj, index)) {
            return this.setOwn(thisObj, index, value, receiver, isStrict);
        }
        return this.setPropertySlow(thisObj, index, value, receiver, isStrict);
    }

    @CompilerDirectives.TruffleBoundary
    private boolean setPropertySlow(DynamicObject thisObj, long index, Object value, Object receiver, boolean isStrict) {
        if (!JSObject.getJSContext(thisObj).getArrayPrototypeNoElementsAssumption().isValid() && JSAbstractArray.setPropertyPrototypes(thisObj, index, value, receiver, isStrict)) {
            return true;
        }
        if (!JSObject.isExtensible(thisObj)) {
            if (isStrict) {
                throw Errors.createTypeErrorNotExtensible(thisObj, Boundaries.stringValueOf(index));
            }
            return true;
        }
        return this.setOwn(thisObj, index, value, receiver, isStrict);
    }

    private static boolean setPropertyPrototypes(DynamicObject thisObj, long index, Object value, Object receiver, boolean isStrict) {
        DynamicObject current = JSObject.getPrototype(thisObj);
        String propertyName = null;
        while (current != Null.instance) {
            if (JSProxy.isProxy(current)) {
                return JSObject.setWithReceiver(current, index, value, receiver, false);
            }
            if (JSAbstractArray.canHaveReadOnlyOrAccessorProperties(current) && JSObject.hasOwnProperty(current, index)) {
                PropertyDescriptor desc;
                if (propertyName == null) {
                    propertyName = Boundaries.stringValueOf(index);
                }
                if ((desc = JSObject.getOwnProperty(current, propertyName)) != null) {
                    if (desc.isAccessorDescriptor()) {
                        JSAbstractArray.invokeAccessorPropertySetter(desc, thisObj, propertyName, value, receiver, isStrict);
                        return true;
                    }
                    if (desc.getWritable()) break;
                    if (isStrict) {
                        throw Errors.createTypeError("Cannot assign to read only property '" + index + "' of " + JSObject.defaultToString(thisObj));
                    }
                    return true;
                }
            }
            current = JSObject.getPrototype(current);
        }
        return false;
    }

    private static boolean canHaveReadOnlyOrAccessorProperties(DynamicObject current) {
        return !JSArrayBufferView.isJSArrayBufferView(current);
    }

    @Override
    public boolean setOwn(DynamicObject thisObj, long index, Object value, Object receiver, boolean isStrict) {
        JSAbstractArray.arraySetArrayType(thisObj, JSAbstractArray.arrayGetArrayType(thisObj).setElement(thisObj, index, value, isStrict));
        return true;
    }

    @Override
    public boolean delete(DynamicObject thisObj, long index, boolean isStrict) {
        ScriptArray arrayType = JSAbstractArray.arrayGetArrayType(thisObj);
        if (arrayType.canDeleteElement(thisObj, index, isStrict)) {
            JSAbstractArray.arraySetArrayType(thisObj, arrayType.deleteElement(thisObj, index, isStrict));
            return true;
        }
        return false;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public Object getOwnHelper(DynamicObject store, Object thisObj, long index) {
        ScriptArray array = JSAbstractArray.arrayGetArrayType(store);
        if (array.hasElement(store, index)) {
            return array.getElement(store, index);
        }
        return super.getOwnHelper(store, thisObj, Boundaries.stringValueOf(index));
    }

    @CompilerDirectives.TruffleBoundary
    public static Object[] toArray(DynamicObject thisObj) {
        return JSAbstractArray.arrayGetArrayType(thisObj).toArray(thisObj);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public final boolean hasOwnProperty(DynamicObject thisObj, Object key) {
        if (super.hasOwnProperty(thisObj, key)) {
            return true;
        }
        long index = JSRuntime.propertyKeyToArrayIndex(key);
        if (JSRuntime.isArrayIndex(index)) {
            return JSAbstractArray.arrayGetArrayType(thisObj).hasElement(thisObj, index);
        }
        return false;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public final boolean hasOwnProperty(DynamicObject thisObj, long index) {
        ScriptArray array = JSAbstractArray.arrayGetArrayType(thisObj);
        if (array.hasElement(thisObj, index)) {
            return true;
        }
        return super.hasOwnProperty(thisObj, Boundaries.stringValueOf(index));
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public List<Object> getOwnPropertyKeys(DynamicObject thisObj, boolean strings, boolean symbols) {
        return JSAbstractArray.ownPropertyKeysSlowArray(thisObj, strings, symbols);
    }

    @CompilerDirectives.TruffleBoundary
    protected static List<Object> ownPropertyKeysFastArray(DynamicObject thisObj, boolean strings, boolean symbols) {
        assert (JSArray.isJSFastArray(thisObj) || JSArgumentsObject.isJSFastArgumentsObject(thisObj));
        List<Object> indices = strings ? JSAbstractArray.arrayGetArrayType(thisObj).ownPropertyKeys(thisObj) : Collections.emptyList();
        List keyList = thisObj.getShape().getKeyList();
        if (keyList.isEmpty()) {
            return indices;
        }
        ArrayList list = new ArrayList(keyList.size());
        if (strings) {
            keyList.forEach(k -> {
                assert (!(k instanceof String) || !JSRuntime.isArrayIndex((String)k));
                if (k instanceof String) {
                    list.add(k);
                }
            });
        }
        if (symbols) {
            keyList.forEach(k -> {
                if (k instanceof Symbol) {
                    list.add(k);
                }
            });
        }
        return IteratorUtil.concatLists(indices, list);
    }

    @CompilerDirectives.TruffleBoundary
    protected static List<Object> ownPropertyKeysSlowArray(DynamicObject thisObj, boolean strings, boolean symbols) {
        List keyList;
        ArrayList<Object> list = new ArrayList<Object>();
        if (strings) {
            ScriptArray array = JSAbstractArray.arrayGetArrayType(thisObj);
            long currentIndex = array.firstElementIndex(thisObj);
            while (currentIndex <= array.lastElementIndex(thisObj)) {
                list.add(Boundaries.stringValueOf(currentIndex));
                currentIndex = array.nextElementIndex(thisObj, currentIndex);
            }
        }
        if (!(keyList = thisObj.getShape().getKeyList()).isEmpty()) {
            if (strings) {
                int before = list.size();
                keyList.forEach(k -> {
                    if (k instanceof String && JSRuntime.isArrayIndex((String)k)) {
                        list.add(k);
                    }
                });
                int after = list.size();
                if (after != before) {
                    Collections.sort(list, new Comparator<Object>(){

                        @Override
                        public int compare(Object o1, Object o2) {
                            long l2;
                            long l1 = JSRuntime.propertyKeyToArrayIndex(o1);
                            return l1 < (l2 = JSRuntime.propertyKeyToArrayIndex(o2)) ? -1 : (l1 == l2 ? 0 : 1);
                        }
                    });
                }
                keyList.forEach(k -> {
                    if (k instanceof String && !JSRuntime.isArrayIndex((String)k)) {
                        list.add(k);
                    }
                });
            }
            if (symbols) {
                keyList.forEach(k -> {
                    if (k instanceof Symbol) {
                        list.add(k);
                    }
                });
            }
        }
        return list;
    }

    protected static long toArrayIndexOrRangeError(Object obj) {
        Number len = JSRuntime.toNumber(obj);
        Long len32 = JSRuntime.toUInt32(len);
        return JSAbstractArray.toArrayIndexOrRangeError(len, len32);
    }

    public static long toArrayIndexOrRangeError(Number len, Number len32) {
        double d;
        double d32 = JSRuntime.doubleValue(len32);
        if (d32 == (d = JSRuntime.doubleValue(len))) {
            return len32.longValue();
        }
        if (d == 0.0) {
            return 0L;
        }
        throw Errors.createRangeErrorInvalidArrayLength();
    }

    public static long toArrayIndexOrRangeError(Number len, Number len32, BranchProfile profileError, BranchProfile profileDouble1, BranchProfile profileDouble2) {
        double d;
        double d32 = JSRuntime.doubleValue(len32, profileDouble1);
        if (d32 == (d = JSRuntime.doubleValue(len, profileDouble2))) {
            return len32.longValue();
        }
        if (d == 0.0) {
            return 0L;
        }
        profileError.enter();
        throw Errors.createRangeErrorInvalidArrayLength();
    }

    @Override
    public boolean defineOwnProperty(DynamicObject thisObj, Object key, PropertyDescriptor descriptor, boolean doThrow) {
        if (key.equals(LENGTH)) {
            return this.defineOwnPropertyLength(thisObj, key, descriptor, doThrow);
        }
        if (key instanceof String && JSRuntime.isArrayIndex((String)key)) {
            return this.defineOwnPropertyIndex(thisObj, (String)key, descriptor, doThrow);
        }
        return super.defineOwnProperty(thisObj, key, descriptor, doThrow);
    }

    private boolean defineOwnPropertyLength(DynamicObject thisObj, Object key, PropertyDescriptor descriptor, boolean doThrow) {
        if (!descriptor.hasValue()) {
            if (descriptor.hasWritable() && !descriptor.getWritable()) {
                JSAbstractArray.setLengthNotWritable(thisObj);
            }
            return DefinePropertyUtil.ordinaryDefineOwnProperty(thisObj, key, descriptor, doThrow);
        }
        Number newLenNum = JSRuntime.toNumber(descriptor.getValue());
        long newLen = JSRuntime.toUInt32(newLenNum);
        if (JSRuntime.doubleValue(newLenNum) != (double)newLen) {
            throw Errors.createRangeErrorInvalidArrayLength();
        }
        PropertyDescriptor lenDesc = this.getOwnProperty(thisObj, LENGTH);
        if (newLen >= this.getLength(thisObj)) {
            return this.definePropertyLength(thisObj, descriptor, lenDesc, newLen, doThrow);
        }
        if (!lenDesc.getWritable()) {
            return DefinePropertyUtil.reject(doThrow, ARRAY_LENGTH_NOT_WRITABLE);
        }
        long pos = this.getLength(thisObj);
        if (!this.definePropertyLength(thisObj, descriptor, lenDesc, newLen, doThrow)) {
            return false;
        }
        if (JSSlowArray.isJSSlowArray(thisObj)) {
            return this.deleteElementsAfterShortening(thisObj, descriptor, doThrow, newLen, lenDesc, pos);
        }
        return true;
    }

    private static void setLengthNotWritable(DynamicObject thisObj) {
        JSAbstractArray.arraySetArrayType(thisObj, JSAbstractArray.arrayGetArrayType(thisObj).setLengthNotWritable());
    }

    private boolean deleteElementsAfterShortening(DynamicObject thisObj, PropertyDescriptor descriptor, boolean doThrow, long newLen, PropertyDescriptor lenDesc, long startPos) {
        assert (JSRuntime.isValidArrayLength(newLen));
        long pos = startPos;
        while (pos > newLen) {
            String key;
            Property prop;
            if ((prop = DefinePropertyUtil.getPropertyByKey(thisObj, key = String.valueOf(--pos))) == null) continue;
            if (JSProperty.isConfigurable(prop)) {
                this.delete(thisObj, key, doThrow);
                continue;
            }
            long len = pos + 1L;
            descriptor.setValue(JSRuntime.longToIntOrDouble(len));
            this.definePropertyLength(thisObj, descriptor, lenDesc, len, doThrow);
            DefinePropertyUtil.ordinaryDefineOwnProperty(thisObj, LENGTH, descriptor, false);
            return DefinePropertyUtil.reject(doThrow, "cannot set the length to expected value");
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean definePropertyLength(DynamicObject thisObj, PropertyDescriptor descriptor, PropertyDescriptor currentDesc, long len, boolean doThrow) {
        assert (JSRuntime.isValidArrayLength(len));
        boolean currentWritable = currentDesc.getWritable();
        boolean currentEnumerable = currentDesc.getEnumerable();
        boolean currentConfigurable = currentDesc.getConfigurable();
        boolean newWritable = descriptor.getIfHasWritable(currentWritable);
        boolean newEnumerable = descriptor.getIfHasEnumerable(currentEnumerable);
        boolean newConfigurable = descriptor.getIfHasConfigurable(currentConfigurable);
        if (currentConfigurable) {
            if (!currentWritable && !newWritable) {
                return DefinePropertyUtil.reject(doThrow, LENGTH_PROPERTY_NOT_WRITABLE);
            }
        } else {
            if (!(currentWritable != newWritable || currentEnumerable != newEnumerable || descriptor.hasValue() && len != this.getLength(thisObj))) {
                return true;
            }
            if (!currentWritable) {
                return DefinePropertyUtil.reject(doThrow, LENGTH_PROPERTY_NOT_WRITABLE);
            }
        }
        try {
            this.setLength(thisObj, len, doThrow);
        }
        finally {
            int newAttr = JSAttributes.fromConfigurableEnumerableWritable(newConfigurable, newEnumerable, newWritable);
            JSObjectUtil.changeFlags(thisObj, (Object)LENGTH, newAttr);
        }
        return true;
    }

    protected boolean defineOwnPropertyIndex(DynamicObject thisObj, String name, PropertyDescriptor descriptor, boolean doThrow) {
        PropertyDescriptor lenDesc;
        long index = JSRuntime.toUInt32(name);
        if (index >= this.getLength(thisObj) && !(lenDesc = this.getOwnProperty(thisObj, LENGTH)).getWritable()) {
            DefinePropertyUtil.reject(doThrow, ARRAY_LENGTH_NOT_WRITABLE);
        }
        return JSObject.defineOwnProperty(this.makeSlowArray(thisObj), name, descriptor, doThrow);
    }

    protected DynamicObject makeSlowArray(DynamicObject thisObj) {
        CompilerAsserts.neverPartOfCompilation((String)MAKE_SLOW_ARRAY_NEVER_PART_OF_COMPILATION_MESSAGE);
        assert (!JSSlowArray.isJSSlowArray(thisObj));
        Shape oldShape = thisObj.getShape();
        thisObj.setShapeAndGrow(oldShape, oldShape.changeType((ObjectType)JSSlowArray.INSTANCE));
        JSContext context = JSObject.getJSContext(thisObj);
        context.getFastArrayAssumption().invalidate("create slow ArgumentsObject");
        if (JSAbstractArray.isArrayPrototype(thisObj)) {
            context.getArrayPrototypeNoElementsAssumption().invalidate("Array.prototype has no elements");
        }
        return thisObj;
    }

    private static boolean isArrayPrototype(DynamicObject thisObj) {
        return JSAbstractArray.arrayGetArrayType(thisObj) instanceof ConstantEmptyPrototypeArray;
    }

    @Override
    public boolean testIntegrityLevel(DynamicObject thisObj, boolean frozen) {
        ScriptArray array = JSAbstractArray.arrayGetArrayType(thisObj);
        boolean arrayIs = frozen ? array.isFrozen() : array.isSealed();
        return arrayIs && super.testIntegrityLevel(thisObj, frozen);
    }

    @Override
    public boolean setIntegrityLevel(DynamicObject thisObj, boolean freeze) {
        boolean result = super.setIntegrityLevel(thisObj, freeze);
        ScriptArray arr = JSAbstractArray.arrayGetArrayType(thisObj);
        JSAbstractArray.arraySetArrayType(thisObj, freeze ? arr.freeze() : arr.seal());
        assert (this.testIntegrityLevel(thisObj, freeze));
        return result;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public final boolean preventExtensions(DynamicObject thisObj) {
        boolean result = super.preventExtensions(thisObj);
        ScriptArray arr = JSAbstractArray.arrayGetArrayType(thisObj);
        JSAbstractArray.arraySetArrayType(thisObj, arr.preventExtensions());
        assert (!this.isExtensible(thisObj));
        return result;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public boolean delete(DynamicObject thisObj, Object key, boolean isStrict) {
        long index = JSRuntime.propertyKeyToArrayIndex(key);
        if (index >= 0L) {
            return this.delete(thisObj, index, isStrict);
        }
        return super.delete(thisObj, key, isStrict);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public boolean setPrototypeOf(DynamicObject thisObj, DynamicObject newPrototype) {
        JSObject.getJSContext(thisObj).getArrayPrototypeNoElementsAssumption().invalidate(ARRAY_PROTOTYPE_NO_ELEMENTS_INVALIDATION);
        return super.setPrototypeOf(thisObj, newPrototype);
    }

    @Override
    public PropertyDescriptor getOwnProperty(DynamicObject thisObj, Object key) {
        return JSAbstractArray.ordinaryGetOwnPropertyArray(thisObj, key);
    }

    @CompilerDirectives.TruffleBoundary
    public static PropertyDescriptor ordinaryGetOwnPropertyArray(DynamicObject thisObj, Object key) {
        ScriptArray array;
        assert (JSRuntime.isPropertyKey(key) || key instanceof HiddenKey);
        long idx = JSRuntime.propertyKeyToArrayIndex(key);
        if (JSRuntime.isArrayIndex(idx) && (array = JSAbstractArray.arrayGetArrayType(thisObj, false)).hasElement(thisObj, idx)) {
            Object value = array.getElement(thisObj, idx);
            return PropertyDescriptor.createData(value, true, !array.isFrozen(), !array.isSealed());
        }
        Property prop = thisObj.getShape().getProperty(key);
        if (prop == null) {
            return null;
        }
        return JSBuiltinObject.ordinaryGetOwnPropertyIntl(thisObj, key, prop);
    }

    @Override
    public String safeToString(DynamicObject obj, int depth) {
        if (JSTruffleOptions.NashornCompatibilityMode) {
            return this.defaultToString(obj);
        }
        return JSRuntime.objectToConsoleString(obj, null, depth);
    }

    @Override
    public boolean usesOrdinaryGetOwnProperty() {
        return false;
    }

    static {
        Shape.Allocator allocator = JSShape.makeAllocator(JSObject.LAYOUT);
        ARRAY_PROPERTY = JSObjectUtil.makeHiddenProperty(ARRAY_ID, allocator.locationForType(Object.class, EnumSet.of(LocationModifier.NonNull)));
        ARRAY_TYPE_PROPERTY = JSObjectUtil.makeHiddenProperty(ARRAY_TYPE_ID, allocator.locationForType(ScriptArray.class, EnumSet.of(LocationModifier.NonNull)));
        ALLOCATION_SITE_PROPERTY = JSObjectUtil.makeHiddenProperty(ALLOCATION_SITE_ID, allocator.locationForType(ArrayAllocationSite.class), false);
        LENGTH_PROPERTY = JSObjectUtil.makeHiddenProperty(LENGTH_ID, allocator.locationForType(Integer.TYPE));
        USED_LENGTH_PROPERTY = JSObjectUtil.makeHiddenProperty(USED_LENGTH_ID, allocator.locationForType(Integer.TYPE), false);
        INDEX_OFFSET_PROPERTY = JSObjectUtil.makeHiddenProperty(INDEX_OFFSET_ID, allocator.locationForType(Integer.TYPE), false);
        ARRAY_OFFSET_PROPERTY = JSObjectUtil.makeHiddenProperty(ARRAY_OFFSET_ID, allocator.locationForType(Integer.TYPE), false);
        HOLE_COUNT_PROPERTY = JSObjectUtil.makeHiddenProperty(HOLE_COUNT_ID, allocator.locationForType(Integer.TYPE), false);
        LAZY_REGEX_RESULT_PROPERTY = JSObjectUtil.makeHiddenProperty(LAZY_REGEX_RESULT_ID, allocator.locationForType(TruffleObject.class, EnumSet.of(LocationModifier.Final, LocationModifier.NonNull)));
        LAZY_REGEX_ORIGINAL_INPUT_PROPERTY = JSObjectUtil.makeHiddenProperty(LAZY_REGEX_ORIGINAL_INPUT_ID, allocator.locationForType(String.class, EnumSet.of(LocationModifier.Final, LocationModifier.NonNull)));
    }

    public static class DefaultJSArrayDoubleComparator
    implements Comparator<Object> {
        @Override
        public int compare(Object arg0, Object arg1) {
            double d2;
            double d1 = JSRuntime.doubleValue((Number)arg0);
            if (d1 == (d2 = JSRuntime.doubleValue((Number)arg1))) {
                return 0;
            }
            if (d1 <= 0.0 && d2 > 0.0) {
                return -1;
            }
            if (d2 <= 0.0 && d1 > 0.0) {
                return 1;
            }
            String str0 = JSRuntime.doubleToString(d1);
            String str1 = JSRuntime.doubleToString(d2);
            return Boundaries.stringCompareTo(str0, str1);
        }
    }

    public static class DefaultJSArrayIntegerComparator
    implements Comparator<Object> {
        @Override
        public int compare(Object arg0, Object arg1) {
            int i2;
            int i1 = (int)JSRuntime.toInteger((Number)arg0);
            if (i1 == (i2 = (int)JSRuntime.toInteger((Number)arg1))) {
                return 0;
            }
            if (i1 <= 0 && i2 > 0) {
                return -1;
            }
            if (i2 <= 0 && i1 > 0) {
                return 1;
            }
            String str0 = Integer.toString(i1);
            String str1 = Integer.toString(i2);
            return Boundaries.stringCompareTo(str0, str1);
        }
    }

    public static class DefaultJSArrayComparator
    implements Comparator<Object> {
        @Override
        public int compare(Object arg0, Object arg1) {
            if (arg0 == Undefined.instance) {
                if (arg1 == Undefined.instance) {
                    return 0;
                }
                return 1;
            }
            if (arg1 == Undefined.instance) {
                return -1;
            }
            String str0 = JSRuntime.toString(arg0);
            String str1 = JSRuntime.toString(arg1);
            if (str0 == null) {
                if (str1 == null) {
                    return 0;
                }
                return 1;
            }
            if (str1 == null) {
                return -1;
            }
            return Boundaries.stringCompareTo(str0, str1);
        }
    }
}

