/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.builtins;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.api.object.Property;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSArguments;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.JSTruffleOptions;
import com.oracle.truffle.js.runtime.Symbol;
import com.oracle.truffle.js.runtime.builtins.JSBuiltinObject;
import com.oracle.truffle.js.runtime.builtins.JSClass;
import com.oracle.truffle.js.runtime.builtins.JSUserObject;
import com.oracle.truffle.js.runtime.objects.Accessor;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.JSObjectUtil;
import com.oracle.truffle.js.runtime.objects.JSProperty;
import com.oracle.truffle.js.runtime.objects.JSShape;
import com.oracle.truffle.js.runtime.objects.Null;
import com.oracle.truffle.js.runtime.objects.PropertyDescriptor;
import com.oracle.truffle.js.runtime.objects.Undefined;
import java.util.Collections;
import java.util.List;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.MapCursor;

public final class JSDictionaryObject
extends JSBuiltinObject {
    public static final String CLASS_NAME = "Object";
    private static final HiddenKey HASHMAP_PROPERTY_NAME = new HiddenKey("%hashMap");
    private static final Property HASHMAP_PROPERTY;
    public static final JSDictionaryObject INSTANCE;

    private JSDictionaryObject() {
    }

    public static boolean isJSDictionaryObject(Object obj) {
        return JSObject.isDynamicObject(obj) && JSDictionaryObject.isJSDictionaryObject((DynamicObject)obj);
    }

    public static boolean isJSDictionaryObject(DynamicObject obj) {
        return JSDictionaryObject.isInstance(obj, (JSClass)INSTANCE);
    }

    @Override
    public String getClassName(DynamicObject object) {
        return CLASS_NAME;
    }

    @Override
    public String safeToString(DynamicObject obj, int depth) {
        return this.defaultToString(obj);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public Object getOwnHelper(DynamicObject store, Object thisObj, Object key) {
        PropertyDescriptor desc = (PropertyDescriptor)JSDictionaryObject.getHashMap(store).get(key);
        if (desc != null) {
            return JSDictionaryObject.getValue(desc, thisObj);
        }
        return super.getOwnHelper(store, thisObj, key);
    }

    public static Object getValue(PropertyDescriptor property, Object receiver) {
        if (property.isAccessorDescriptor()) {
            DynamicObject getter = (DynamicObject)property.getGet();
            if (getter != Undefined.instance) {
                return JSRuntime.call(getter, receiver, JSArguments.EMPTY_ARGUMENTS_ARRAY);
            }
            return Undefined.instance;
        }
        assert (property.isDataDescriptor());
        return property.getValue();
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public List<Object> getOwnPropertyKeys(DynamicObject thisObj, boolean strings, boolean symbols) {
        assert (JSDictionaryObject.isJSDictionaryObject(thisObj));
        List<Object> keys = JSDictionaryObject.ordinaryOwnPropertyKeysSlow(thisObj, strings, symbols);
        for (Object key : JSDictionaryObject.getHashMap(thisObj).getKeys()) {
            if (!symbols && key instanceof Symbol || !strings && key instanceof String) continue;
            keys.add(key);
        }
        Collections.sort(keys, JSRuntime::comparePropertyKeys);
        return keys;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public boolean delete(DynamicObject thisObj, Object key, boolean isStrict) {
        EconomicMap<Object, PropertyDescriptor> hashMap = JSDictionaryObject.getHashMap(thisObj);
        PropertyDescriptor desc = (PropertyDescriptor)hashMap.get(key);
        if (desc != null) {
            if (!desc.getConfigurable()) {
                if (isStrict) {
                    throw Errors.createTypeErrorNotConfigurableProperty(key);
                }
                return false;
            }
            hashMap.removeKey(key);
            return true;
        }
        return super.delete(thisObj, key, isStrict);
    }

    @Override
    public boolean delete(DynamicObject thisObj, long index, boolean isStrict) {
        return this.delete(thisObj, String.valueOf(index), isStrict);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public boolean hasOwnProperty(DynamicObject thisObj, Object key) {
        if (JSDictionaryObject.getHashMap(thisObj).containsKey(key)) {
            return true;
        }
        return super.hasOwnProperty(thisObj, key);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public boolean setOwn(DynamicObject thisObj, Object key, Object value, Object receiver, boolean isStrict) {
        EconomicMap<Object, PropertyDescriptor> hashMap = JSDictionaryObject.getHashMap(thisObj);
        PropertyDescriptor property = (PropertyDescriptor)hashMap.get(key);
        if (property != null) {
            JSDictionaryObject.setValue(key, property, thisObj, receiver, value, isStrict);
            return true;
        }
        return super.setOwn(thisObj, key, value, receiver, isStrict);
    }

    private static void setValue(Object key, PropertyDescriptor property, DynamicObject store, Object thisObj, Object value, boolean isStrict) {
        if (property.isAccessorDescriptor()) {
            DynamicObject setter = (DynamicObject)property.getSet();
            if (setter != Undefined.instance) {
                JSRuntime.call(setter, thisObj, new Object[]{value});
            } else if (isStrict) {
                throw Errors.createTypeErrorCannotSetAccessorProperty(key, store);
            }
        } else {
            assert (property.isDataDescriptor());
            if (property.getWritable()) {
                property.setValue(value);
            } else if (isStrict) {
                throw Errors.createTypeErrorNotWritableProperty(key, thisObj);
            }
        }
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public PropertyDescriptor getOwnProperty(DynamicObject thisObj, Object key) {
        assert (JSRuntime.isPropertyKey(key) || key instanceof HiddenKey);
        PropertyDescriptor prop = (PropertyDescriptor)JSDictionaryObject.getHashMap(thisObj).get(key);
        if (prop != null) {
            return prop;
        }
        return super.getOwnProperty(thisObj, key);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public boolean defineOwnProperty(DynamicObject thisObj, Object key, PropertyDescriptor desc, boolean doThrow) {
        if (!this.hasOwnProperty(thisObj, key) && JSObject.isExtensible(thisObj)) {
            JSDictionaryObject.getHashMap(thisObj).put(key, (Object)desc);
            return true;
        }
        JSDictionaryObject.makeOrdinaryObject(thisObj, "defineOwnProperty");
        return super.defineOwnProperty(thisObj, key, desc, doThrow);
    }

    static EconomicMap<Object, PropertyDescriptor> getHashMap(DynamicObject obj) {
        assert (JSDictionaryObject.isJSDictionaryObject(obj));
        Property hashMapProperty = obj.getShape().getProperty((Object)HASHMAP_PROPERTY_NAME);
        return (EconomicMap)hashMapProperty.get(obj, false);
    }

    public static void makeDictionaryObject(DynamicObject obj, String reason) {
        CompilerAsserts.neverPartOfCompilation();
        assert (JSTruffleOptions.DictionaryObject);
        if (!JSUserObject.isJSUserObject(obj)) {
            return;
        }
        if (JSTruffleOptions.TraceDictionaryObject) {
            System.out.printf("transitioning to dictionary object: %s\n%s\n", reason, obj.getShape());
        }
        Shape currentShape = obj.getShape();
        assert (!JSDictionaryObject.isJSDictionaryObject(obj) && currentShape.getProperty((Object)HASHMAP_PROPERTY_NAME) == null);
        JSContext context = JSObject.getJSContext(obj);
        Shape hashedShape = JSDictionaryObject.makeEmptyShapeForNewType(context, currentShape, INSTANCE);
        EconomicMap<Object, PropertyDescriptor> hashMap = JSDictionaryObject.newHashMap();
        List properties = currentShape.getPropertyListInternal(true);
        for (Property p : properties) {
            Object key = p.getKey();
            if (JSObject.HIDDEN_PROTO.equals(key)) {
                assert (hashedShape.hasProperty(key));
                continue;
            }
            if (p.isHidden() || p.getLocation().isValue() || JSProperty.isProxy(p)) {
                hashedShape = hashedShape.addProperty(p);
                continue;
            }
            Object value = p.get(obj, false);
            hashMap.put(key, (Object)JSDictionaryObject.toPropertyDescriptor(p, value));
            JSShape.invalidatePropertyAssumption(currentShape, key);
        }
        hashedShape = hashedShape.addProperty(JSObjectUtil.makeHiddenProperty(HASHMAP_PROPERTY_NAME, hashedShape.allocator().locationForType(hashMap.getClass()), true));
        Property hashMapProperty = hashedShape.getLastProperty();
        assert (JSDictionaryObject.isHashMapProperty(hashMapProperty));
        obj.setShapeAndResize(currentShape, hashedShape);
        hashMapProperty.setSafe(obj, hashMap, null);
        assert (JSDictionaryObject.isJSDictionaryObject(obj) && obj.getShape().getProperty((Object)HASHMAP_PROPERTY_NAME) != null);
    }

    private static Shape makeEmptyShapeForNewType(JSContext context, Shape currentShape, JSClass jsclass) {
        Property prototypeProperty = JSShape.getPrototypeProperty(currentShape);
        if (!prototypeProperty.getLocation().isConstant()) {
            return context.makeEmptyShapeWithPrototypeInObject(jsclass, prototypeProperty);
        }
        DynamicObject prototype = (DynamicObject)prototypeProperty.get(null, false);
        if (prototype == Null.instance) {
            return context.makeEmptyShapeWithNullPrototype(jsclass);
        }
        return JSObjectUtil.getProtoChildShape(prototype, jsclass, context);
    }

    private static PropertyDescriptor toPropertyDescriptor(Property p, Object value) {
        PropertyDescriptor desc;
        if (JSProperty.isAccessor(p)) {
            desc = PropertyDescriptor.createAccessor(((Accessor)value).getGetter(), ((Accessor)value).getSetter());
            desc.setConfigurable(JSProperty.isConfigurable(p));
            desc.setEnumerable(JSProperty.isEnumerable(p));
        } else {
            assert (JSProperty.isData(p));
            desc = PropertyDescriptor.createData(value, JSProperty.isEnumerable(p), JSProperty.isWritable(p), JSProperty.isConfigurable(p));
        }
        return desc;
    }

    private static void makeOrdinaryObject(DynamicObject obj, String reason) {
        CompilerAsserts.neverPartOfCompilation();
        if (JSTruffleOptions.TraceDictionaryObject) {
            System.out.printf("transitioning from dictionary object to ordinary object: %s\n", reason);
        }
        EconomicMap<Object, PropertyDescriptor> hashMap = JSDictionaryObject.getHashMap(obj);
        Shape oldShape = obj.getShape();
        JSContext context = JSObject.getJSContext(obj);
        Shape newShape = JSDictionaryObject.makeEmptyShapeForNewType(context, oldShape, JSUserObject.INSTANCE);
        List properties = oldShape.getPropertyListInternal(true);
        for (Property p : properties) {
            if (JSObject.HIDDEN_PROTO.equals(p.getKey())) {
                assert (newShape.hasProperty(p.getKey()));
                continue;
            }
            if (HASHMAP_PROPERTY_NAME.equals(p.getKey())) continue;
            newShape = newShape.addProperty(p);
        }
        obj.setShapeAndGrow(oldShape, newShape);
        MapCursor cursor = hashMap.getEntries();
        while (cursor.advance()) {
            Object key = cursor.getKey();
            PropertyDescriptor desc = (PropertyDescriptor)cursor.getValue();
            if (desc.isDataDescriptor()) {
                JSObjectUtil.defineDataProperty(obj, key, desc.getValue(), desc.getFlags());
                continue;
            }
            JSObjectUtil.defineAccessorProperty(obj, key, new Accessor((DynamicObject)desc.getGet(), (DynamicObject)desc.getSet()), desc.getFlags());
        }
        assert (JSUserObject.isJSUserObject(obj) && obj.getShape().getProperty((Object)HASHMAP_PROPERTY_NAME) == null);
    }

    private static boolean isHashMapProperty(Property property) {
        return property != null && property.getKey() == HASHMAP_PROPERTY_NAME;
    }

    public static Shape makeDictionaryShape(JSContext context, DynamicObject prototype) {
        Shape emptyShape = JSObjectUtil.getProtoChildShape(prototype, INSTANCE, context);
        return emptyShape.addProperty(HASHMAP_PROPERTY);
    }

    public static DynamicObject create(JSContext context) {
        return JSObject.create(context, context.getDictionaryObjectFactory(), JSDictionaryObject.newHashMap());
    }

    private static EconomicMap<Object, PropertyDescriptor> newHashMap() {
        return EconomicMap.create();
    }

    @Override
    public boolean usesOrdinaryGetOwnProperty() {
        return false;
    }

    static {
        INSTANCE = new JSDictionaryObject();
        Shape.Allocator allocator = JSShape.makeAllocator(JSObject.LAYOUT);
        HASHMAP_PROPERTY = JSObjectUtil.makeHiddenProperty(HASHMAP_PROPERTY_NAME, allocator.locationForType(EconomicMap.class));
    }
}

